/***************************************************************************
                          dchubprofile.cpp  -  description
                             -------------------
    begin                : Fre Sep 20 2002
    copyright            : (C) 2002 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dchubprofile.h"

#include <qpushbutton.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qinputdialog.h>
#include <qmessagebox.h>
#include <qcombobox.h>

#include "dcconfig.h"
#include "dcguiutils.h"

/** */
DCHubProfile::DCHubProfile(QWidget *parent, const char *name ) : DCDialogHubProfile(parent,name)
{
	ComboBox_REMOTE_ENCODING->insertItem(QString());
	DCGuiUtils::AddEncodings( ComboBox_REMOTE_ENCODING );
	ComboBox_REMOTE_ENCODING->setCurrentItem(0);
	
	InitDocument();
}

/** */
DCHubProfile::~DCHubProfile()
{
}

/** */
void DCHubProfile::InitDocument()
{
	ComboBox_PROFILE->clear();

 	std::list<CString> * names = g_pConfig->GetHubProfileNames();

	for ( std::list<CString>::const_iterator it = names->begin(); it != names->end(); ++it )
	{
		if ( (*it).NotEmpty() )
		{
			ComboBox_PROFILE->insertItem((*it).Data());
		}
	}
	
	delete names;

	connect( PushButton_OK, SIGNAL(clicked()), this, SLOT(slotClickedOK()) );
	connect( PushButton_CANCEL, SIGNAL(clicked()), this, SLOT(reject()) );
	connect( ComboBox_PROFILE, SIGNAL(activated( const QString & )), this, SLOT(slotProfileActiveted( const QString & )) );
	connect( PushButton_DELETE, SIGNAL(clicked()), this, SLOT(slotProfileDelete()) );

	slotProfileActiveted(QString());
}

/** */
void DCHubProfile::SaveProfile( QString profilename )
{
	DCConfigHubProfile pConfigHubProfile;

	if ( !profilename.isEmpty() )
	{
		pConfigHubProfile.m_sName        = profilename.ascii();
		pConfigHubProfile.m_sNick        = LineEdit_NICK->text().replace( " ", "\xa0").ascii();
		pConfigHubProfile.m_sPassword    = LineEdit_PASSWORD->text().ascii();
		pConfigHubProfile.m_bAutoConnect = CheckBox_AUTOCONNECT->isChecked();
		pConfigHubProfile.m_bTag         = CheckBox_DESCRIPTIONTAG->isChecked();
		pConfigHubProfile.m_bExtHubCount = CheckBox_EXT_HUB_COUNT->isChecked();
		pConfigHubProfile.m_sComment     = LineEdit_PROF_DESCRIPTION->text().ascii();
		pConfigHubProfile.m_bComment     = CheckBox_DESCRIPTION->isChecked();
		pConfigHubProfile.m_sEMail       = LineEdit_EMAIL->text().ascii();
		pConfigHubProfile.m_bEMail       = CheckBox_EMAIL->isChecked();
		pConfigHubProfile.m_bSSL         = CheckBox_SSL->isChecked();
		pConfigHubProfile.m_sSuppressedNicks = LineEdit_SUPPRESS_NICKS->text().ascii();
		pConfigHubProfile.m_sRemoteEncoding = ComboBox_REMOTE_ENCODING->currentText().ascii();
		
		g_pConfig->AddHubProfile( &pConfigHubProfile );
	}

	g_pConfig->SaveHubProfile();
}

/** */
void DCHubProfile::slotClickedOK()
{
	SaveProfile(ComboBox_PROFILE->currentText());

	accept();
}

/** */
void DCHubProfile::slotProfileActiveted( const QString & /*s*/ )
{
	DCConfigHubProfile pConfigHubProfile;

	// save old profile
	if ( !m_sOldName.isEmpty() )
	{
		if ( m_sOldName == ComboBox_PROFILE->currentText() )
		{
			return;
		}
		
		// check for changes
		if ( g_pConfig->GetHubProfile( m_sOldName.ascii(), &pConfigHubProfile ) )
		{
			if ( (pConfigHubProfile.m_sNick != LineEdit_NICK->text().replace( " ", "\xa0").ascii()) ||
			     (pConfigHubProfile.m_sPassword != LineEdit_PASSWORD->text().ascii()) ||
			     (pConfigHubProfile.m_bAutoConnect != CheckBox_AUTOCONNECT->isChecked()) ||
			     (pConfigHubProfile.m_bTag != CheckBox_DESCRIPTIONTAG->isChecked()) ||
			     (pConfigHubProfile.m_bExtHubCount != CheckBox_EXT_HUB_COUNT->isChecked()) ||
			     (pConfigHubProfile.m_sEMail != LineEdit_EMAIL->text().ascii()) ||
			     (pConfigHubProfile.m_sComment != LineEdit_PROF_DESCRIPTION->text().ascii()) ||
			     (pConfigHubProfile.m_bComment != CheckBox_DESCRIPTION->isChecked()) ||
			     (pConfigHubProfile.m_bEMail != CheckBox_EMAIL->isChecked()) ||
			     (pConfigHubProfile.m_bSSL   != CheckBox_SSL->isChecked()) ||
			     (pConfigHubProfile.m_sSuppressedNicks != LineEdit_SUPPRESS_NICKS->text().ascii()) ||
			     (pConfigHubProfile.m_sRemoteEncoding != ComboBox_REMOTE_ENCODING->currentText().ascii()) )
			{
				// ask user to save changes
				switch( QMessageBox::warning( this, tr("Save profile"),
	        			tr("Do you want to save your changes?"),
	        			tr("Save"),
					tr("Discard"),
        				tr("Cancel"), 2, 2 ) )
				{
					case 0: // save
						SaveProfile(m_sOldName);
						break;
			    		case 1: // discard
        					break;
					default: // cancel
						ComboBox_PROFILE->setCurrentText(m_sOldName);	
						return;
				}
			}
		}
	}

	// set new profile name
	m_sOldName = ComboBox_PROFILE->currentText();

	// reset values
	LineEdit_NICK->clear();
	LineEdit_PASSWORD->clear();
	CheckBox_AUTOCONNECT->setChecked(false);
	CheckBox_DESCRIPTIONTAG->setChecked(false);
	CheckBox_EXT_HUB_COUNT->setChecked(false);
	LineEdit_EMAIL->clear();
	LineEdit_PROF_DESCRIPTION->clear();
	LineEdit_SUPPRESS_NICKS->clear();
	ComboBox_REMOTE_ENCODING->setCurrentItem(0);
	
	if ( !m_sOldName.isEmpty() )
	{
		if ( g_pConfig->GetHubProfile( m_sOldName.ascii(), &pConfigHubProfile ) )
		{
			LineEdit_NICK->setText( pConfigHubProfile.m_sNick.Data() );
			LineEdit_PASSWORD->setText( pConfigHubProfile.m_sPassword.Data() );
			CheckBox_AUTOCONNECT->setChecked( pConfigHubProfile.m_bAutoConnect );
			CheckBox_DESCRIPTIONTAG->setChecked( pConfigHubProfile.m_bTag );
			CheckBox_EXT_HUB_COUNT->setChecked( pConfigHubProfile.m_bExtHubCount );
			LineEdit_EMAIL->setText( pConfigHubProfile.m_sEMail.Data() );
			CheckBox_EMAIL->setChecked( pConfigHubProfile.m_bEMail );
			LineEdit_PROF_DESCRIPTION->setText( pConfigHubProfile.m_sComment.Data() );
			CheckBox_DESCRIPTION->setChecked( pConfigHubProfile.m_bComment );
			CheckBox_SSL->setChecked(pConfigHubProfile.m_bSSL);
			LineEdit_SUPPRESS_NICKS->setText( pConfigHubProfile.m_sSuppressedNicks.Data() );
			ComboBox_REMOTE_ENCODING->setCurrentText( pConfigHubProfile.m_sRemoteEncoding.Data() );
		}
	}
}

/** Deletes the selected profile, asking for confirmation */
void DCHubProfile::slotProfileDelete()
{
	// get currently selected profile name
	CString profname = ComboBox_PROFILE->currentText().ascii();
	
	// ask for confirmation
	int ret = QMessageBox::question(this,
				    tr("Are you sure?"),
				    tr("Delete profile for ") + profname.Data(),
				    QMessageBox::Yes,
				    QMessageBox::No
				    );
	
	if (ret == QMessageBox::Yes)
	{
		// remove profile from list
		ComboBox_PROFILE->removeItem( ComboBox_PROFILE->currentItem() );
		slotProfileActiveted(QString());
		
		// delete profile
		g_pConfig->DelHubProfile(profname);
		
		// save changes (saving is also done after adding a profile)
		g_pConfig->SaveHubProfile();
	}
}
