/***************************************************************************
                          dciconloader.h  -  description
                             -------------------
    begin                : Fri Jan 23 2004
    copyright            : (C) 2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* dnx274.dyndns.org */

#ifndef DCICONLOADER_H
#define DCICONLOADER_H

#include <qmap.h>
#include <qpixmap.h>

/**
  *@author Mathias Küster
  */

typedef enum eIcons {
    eiBACK=0,
    eiBALL_GREEN,
    eiBALL_RED,
    eiBALL_YELLOW,
    eiBOOKMARK_ADD,
    eiBOOKMARK_FOLDER,
    eiCHOOSE_LANGUAGE,
    eiCONNECT,
    eiCONFIGURE,
    eiCONFIGURE_22x22,
    eiCONNECT_CREATING,
    eiCONNECT_NO,
    eiCONNECTED,
    eiGLOBE,
    eiICON_22x22,
    eiDOWN,
    eiDOWNLOAD,
    eiEDIT,
    eiEDITADD,
    eiEDITCOPY,
    eiEDITDELETE,
    eiEXIT,
    eiFILECLOSE,
    eiFILEFIND,
    eiFIND,
    eiFIND_22x22,
    eiGV,
    eiHELP,
    eiINFO,
    eiMESSAGE,
    eiNOTCONNECTED,
    eiOPEN,
    eiRELOAD,
    eiRELOAD_22x22,
    eiSAVE,
    eiSERVER,
    eiSPLASH,
    eiSPY,
    eiTRANSFER,
    eiTRANSLATE,
    eiUP,
    eiUPDATE,
    eiVIEW_SIDETREE,
    eiFOLDER_BLUE,
    eiFOLDER_BLUE_OPEN,
    eiFOLDER_RED,
    eiSSL_NO,
    eiSSL_YES,
    eiPLAYER_PLAY,
    eiPLAYER_PAUSE,
    eiUSERS,
    eiUSERS_22x22,
    eiFLAG_BRAZILIAN,
    eiFLAG_BOSNIAN,
    eiFLAG_CZECH,
    eiFLAG_DENMARK,
    eiFLAG_ENGLISH,
    eiFLAG_FINLAND,
    eiFLAG_FRANCE,
    eiFLAG_GERMANY,
    eiFLAG_GREEK,
    eiFLAG_HUNGARY,
    eiFLAG_ICELAND,
    eiFLAG_ITALY,
    eiFLAG_NETHERLAND,
    eiFLAG_NORWAY,
    eiFLAG_POLAND,
    eiFLAG_ROMANIA,
    eiFLAG_SERBIA,
    eiFLAG_SPAIN,
    eiFLAG_SWEDEN,
    eiFLAG_LATVIAN,
    eiFLAG_RUSSIA,
    eiFLAG_SLOVAK,
    eiFILETYPE_MP3,
    eiFILETYPE_ARCHIVE,
    eiFILETYPE_DOCUMENT,
    eiFILETYPE_APPLICATION,
    eiFILETYPE_PICTURE,
    eiFILETYPE_VIDEO,
    eiFILETYPE_UNKNOWN
} eIcons;

/** */
typedef QMap<enum eIcons, QPixmap> PixmapMap;

class DCIconLoader
{
public:
	/** construtor */
	DCIconLoader();
	/** destructor */
	virtual ~DCIconLoader();

	/** */
	bool Load();
	/** */
	QPixmap & GetPixmap( enum eIcons );
	
private:
	/** */
	QPixmap LoadPixmap( QString file );

	/** */
	PixmapMap m_PixmapMap;
	/** */
	bool m_bError;
};

extern DCIconLoader * g_pIconLoader;

#endif
