/***************************************************************************
                          dcoptions.cpp  -  description
                             -------------------
    begin                : Sun Feb 24 2002
    copyright            : (C) 2002 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dcoptions.h"

#include <qdir.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qlistbox.h>
#include <qtabwidget.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qfiledialog.h>
#include <qlabel.h>
#include <qmessagebox.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qspinbox.h>
#include <qstylefactory.h>
#include <qstyle.h>
#include <qapplication.h>
#include <qlistview.h>
#include <qinputdialog.h>
#include <qfontdialog.h>
#include <qlayout.h>
#include <qcolordialog.h>
#include <qtoolbutton.h>
#include <qimage.h>
#include <qcursor.h>
#include <qpopupmenu.h>
#include <qtextcodec.h>
#include <qhttp.h>
#include <qhostaddress.h>
#include <qprocess.h>

#include "cfloatspinbox.h"

#include <dclib/core/cstring.h>
#include <dclib/core/cnetaddr.h>
#include <dclib/core/cdir.h>
#include <dclib/cconfig.h>
#include <dclib/cfilemanager.h>

#include "dcmenuhandler.h"
#include "dciconloader.h"
#include "dctransferview.h"

#include "DCDialogEditSharePath.h"

#include "dcusercommandeditor.h"
#include "dcguiutils.h"

#include <dclib/dcos.h>
#include <math.h>

/* need VERSION for HTTP User-Agent */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/** */
DCOptions::DCOptions( QWidget * parent ) : DCDialogOptions( parent )
{
	/* icons moved out of .ui files so that they can be themed */
	QIconSet browsefolder( g_pIconLoader->GetPixmap(eiFOLDER_BLUE_OPEN) );
	QIconSet editadd( g_pIconLoader->GetPixmap(eiEDITADD) );
	QIconSet editdelete( g_pIconLoader->GetPixmap(eiEDITDELETE) );
	QIconSet editedit( g_pIconLoader->GetPixmap(eiEDIT) );
	QIconSet play( g_pIconLoader->GetPixmap(eiPLAYER_PLAY) );
	ToolButton_BROWSEDOWNLOADFINISHEDFOLDER->setIconSet( browsefolder );
	ToolButton_BROWSEDOWNLOADFOLDER->setIconSet( browsefolder );
	ToolButton_CREATESHARELIST->setIconSet( QIconSet( g_pIconLoader->GetPixmap(eiRELOAD) ) );
	ToolButton_BROWSEFILELIST->setIconSet( QIconSet( g_pIconLoader->GetPixmap(eiVIEW_SIDETREE) ) );
	ToolButton_SHARELISTINFO->setIconSet( QIconSet( g_pIconLoader->GetPixmap(eiINFO) ) );
	ToolButton_ADDSHAREDFOLDER->setIconSet( editadd );
	ToolButton_REMOVESHAREDFOLDER->setIconSet( editdelete );
	ToolButton_EDITSHAREDFOLDER->setIconSet( editedit );
	ToolButton_BROWSELANGUAGEFILE->setIconSet( browsefolder );
	ToolButton_SELECTLANGUAGE->setIconSet( QIconSet( g_pIconLoader->GetPixmap(eiCHOOSE_LANGUAGE) ) );
	ToolButton_BROWSEAPPFONT->setIconSet( browsefolder );
	ToolButton_BROWSEDATAFOLDER->setIconSet( browsefolder );
	ToolButton_BROWSEBROWSER->setIconSet( browsefolder );
	ToolButton_ADD_USER_MENU_COMMAND->setIconSet( editadd );
	ToolButton_EDIT_USER_MENU_COMMAND->setIconSet( editedit );
	ToolButton_REMOVE_USER_MENU_COMMAND->setIconSet( editdelete );
	ToolButton_BROWSESOUNDPLAYER->setIconSet( browsefolder );
	ToolButton_BROWSESOUNDFILEDISCONNECT->setIconSet( browsefolder );
	ToolButton_BROWSESOUNDFILESEND->setIconSet( browsefolder );
	ToolButton_BROWSESOUNDFILERECEIVE->setIconSet( browsefolder );
	ToolButton_BROWSESOUNDFILEFIRSTRECEIVE->setIconSet( browsefolder );
	ToolButton_BROWSESOUNDFILECONNECT->setIconSet( browsefolder );
	ToolButton_BROWSESOUNDFILENICKMENTIONED->setIconSet( browsefolder );
	ToolButton_PREVIEWSOUNDFILECONNECT->setIconSet( play );
	ToolButton_PREVIEWSOUNDFILEDISCONNECT->setIconSet( play );
	ToolButton_PREVIEWSOUNDFILESEND->setIconSet( play );
	ToolButton_PREVIEWSOUNDFILERECEIVE->setIconSet( play );
	ToolButton_PREVIEWSOUNDFILEFIRSTRECEIVE->setIconSet( play );
	ToolButton_PREVIEWSOUNDFILENICKMENTIONED->setIconSet( play );
	ToolButton_BROWSELOGFILE->setIconSet( browsefolder );
	ToolButton_LOGCHAT_NICKNAMEFILTER_ADD->setIconSet( editadd );
	ToolButton_LOGCHAT_NICKNAMEFILTER_DEL->setIconSet( editdelete );
	ToolButton_ADDHUBLISTURL->setIconSet( editadd );
	ToolButton_EDITHUBLISTURL->setIconSet( editedit );
	ToolButton_REMOVEHUBLISTURL->setIconSet( editdelete );
	ToolButton_BROWSETRANSFERCERT->setIconSet( browsefolder );
	ToolButton_BROWSETRANSFERKEY->setIconSet( browsefolder );
	ToolButton_BROWSE_DCLIB_PLUGIN_PATH->setIconSet( browsefolder );
	
	// set default icon
	setIcon( g_pIconLoader->GetPixmap(eiCONFIGURE) );

	m_pHttp = 0;

	InitDocument();
}

/** */
DCOptions::~DCOptions()
{
	for ( QMap<int, DC_UserMenuCommand*>::const_iterator it = usercommands.constBegin(); it != usercommands.constEnd(); ++it )
	{
		delete it.data();
	}
	usercommands.clear();
	
	if ( m_pHttp )
	{
		disconnect( m_pHttp, SIGNAL(done(bool)), this, SLOT(slotGotInternetIP(bool)) );
		m_pHttp->abort(); // emits done signal
		delete m_pHttp;
	}
}

/** */
void DCOptions::InitDocument()
{
	// insert speed
	ComboBox_SPEED->insertItem( "28.8Kbps" );
	ComboBox_SPEED->insertItem( "33.6Kbps" );
	ComboBox_SPEED->insertItem( "56Kbps" );
	ComboBox_SPEED->insertItem( "Modem" );
	ComboBox_SPEED->insertItem( "Satellite" );
	ComboBox_SPEED->insertItem( "ISDN" );
	ComboBox_SPEED->insertItem( "DSL" );
	ComboBox_SPEED->insertItem( "Cable" );
	ComboBox_SPEED->insertItem( "LAN(T1)" );
	ComboBox_SPEED->insertItem( "LAN(T3)" );
	ComboBox_SPEED->insertItem( "Microwave" );
	ComboBox_SPEED->insertItem( "Wireless" );
	ComboBox_SPEED->insertItem( "0.005" );
	ComboBox_SPEED->insertItem( "0.01" );
	ComboBox_SPEED->insertItem( "0.02" );
	ComboBox_SPEED->insertItem( "0.05" );
	ComboBox_SPEED->insertItem( "0.1" );
	ComboBox_SPEED->insertItem( "0.2" );
	ComboBox_SPEED->insertItem( "0.5" );
	ComboBox_SPEED->insertItem( "1" );
	ComboBox_SPEED->insertItem( "2" );
	ComboBox_SPEED->insertItem( "5" );
	ComboBox_SPEED->insertItem( "10" );
	ComboBox_SPEED->insertItem( "20" );
	ComboBox_SPEED->insertItem( "50" );
	ComboBox_SPEED->insertItem( "100" );
	ComboBox_SPEED->insertItem( "1000" );
	
	DCGuiUtils::AddEncodings( ComboBox_REMOTE_ENCODING );
	
	// set width mode
	ListView_OPTIONTREE->setColumnWidthMode( 0, QListView::Maximum );
	// hide the column header
	ListView_OPTIONTREE->header()->hide();
	// disable sort
	ListView_OPTIONTREE->setSorting(-1);

	// setup spin boxes
	SpinBox_MAXUPLOADRATE->setMinValue(0);
	SpinBox_MAXUPLOADRATE->setMaxValue(99999999);
	SpinBox_MAXUPLOADRATE->setSpecialValueText(tr("Unlimited"));
	SpinBox_MAXUPLOADRATE->setSuffix(tr(" KiB/s"));
	SpinBox_MAXDOWNLOADRATE->setMinValue(0);
	SpinBox_MAXDOWNLOADRATE->setMaxValue(99999999);
	SpinBox_MAXDOWNLOADRATE->setSpecialValueText(tr("Unlimited"));
	SpinBox_MAXDOWNLOADRATE->setSuffix(tr(" KiB/s"));

	// set up icons theme lists
	setupIconThemeComboBoxes();

	// setup the option tree
	plviOther = new QListViewItem( ListView_OPTIONTREE, 0 );
	plviOther->setText(0, tr( "Other" ) );
	
	plviAutoResponse = new QListViewItem( ListView_OPTIONTREE, 0 );
	plviAutoResponse->setText(0, tr( "Auto Responses" ) );
	
	plviSecurity = new QListViewItem( ListView_OPTIONTREE, 0 );
	plviSecurity->setText( 0, tr( "Security" ) );

	plviHubLists = new QListViewItem( ListView_OPTIONTREE, 0 );
	plviHubLists->setText( 0, tr( "Hub Lists" ) );

	plviLog = new QListViewItem( ListView_OPTIONTREE, 0 );
	plviLog->setText( 0, tr( "Log" ) );

	plviSound = new QListViewItem( ListView_OPTIONTREE, 0 );
	plviSound->setText( 0, tr( "Sound" ) );

	plviGUI = new QListViewItem( ListView_OPTIONTREE, 0 );
	plviGUI->setText( 0, tr( "GUI" ) );
	plviGUI->setOpen( true );
	plviGUIFilelistBrowser = new QListViewItem( plviGUI, 0 );
	plviGUIFilelistBrowser->setText(0, tr( "Filelist browser" ) );
	plviGUIIcons =  new QListViewItem( plviGUI, 0 );
	plviGUIIcons->setText(0, tr ( "Icons" ) );
	plviGUIUser = new QListViewItem( plviGUI, 0 );
	plviGUIUser->setText( 0, tr( "User" ) );
	plviGUIMenus = new QListViewItem( plviGUI, 0 );
	plviGUIMenus->setText(0, tr( "Menus" ) );
	plviGUICommands = new QListViewItem( plviGUI, 0 );
	plviGUICommands->setText( 0, tr( "Commands" ) );
	plviGUIChat = new QListViewItem( plviGUI, 0 );
	plviGUIChat->setText( 0, tr( "Chat" ) );
	plviGUITransfer = new QListViewItem( plviGUI, 0 );
	plviGUITransfer->setText( 0, tr( "Transfer" ) );
	plviGUIGeneral = new QListViewItem( plviGUI, 0 );
	plviGUIGeneral->setText( 0, tr( "General" ) );

	plviConnection = new QListViewItem( ListView_OPTIONTREE, 0 );
	plviConnection->setText( 0, tr( "Connection" ) );
	plviConnection->setOpen( true );
	plviConnectionSettings = new QListViewItem( plviConnection, 0 );
	plviConnectionSettings->setText( 0, tr( "Settings" ) );
	plviConnectionMode = new QListViewItem( plviConnection, 0 );
	plviConnectionMode->setText( 0, tr( "Mode" ) );

	plviTransfer = new QListViewItem( ListView_OPTIONTREE, 0 );
	plviTransfer->setText( 0, tr( "Transfer" ) );
	plviTransfer->setOpen( true );
	plviTransferSettings = new QListViewItem( plviTransfer, 0 );
	plviTransferSettings->setText( 0, tr( "Settings" ) );
	plviTransferUploads = new QListViewItem( plviTransfer, 0 );
	plviTransferUploads->setText( 0, tr( "Uploads" ) );
	plviTransferDownloads = new QListViewItem( plviTransfer, 0 );
	plviTransferDownloads->setText( 0, tr( "Downloads" ) );
	plviTransferShares = new QListViewItem( plviTransfer, 0 );
	plviTransferShares->setText( 0, tr( "Shares" ) );
	
	plviIdentify = new QListViewItem( ListView_OPTIONTREE, 0 );
	plviIdentify->setText( 0, tr( "Identify" ) );

	connect( ToolButton_PHOTO, SIGNAL(clicked()), this, SLOT(slotChangePhoto()) );

	connectOptionsListView();
	connect( TabWidget_DCGUI, SIGNAL(currentChanged(QWidget*)), this, SLOT(slotTabWidgetDCGUICurrentChanged(QWidget*)) );
	connect( TabWidget_TRANSFER, SIGNAL(currentChanged(QWidget*)), this, SLOT(slotTabWidgetTransferCurrentChanged(QWidget*)) );
	connect( TabWidget_CONNECTION, SIGNAL(currentChanged(QWidget*)), this, SLOT(slotTabWidgetConnectionCurrentChanged(QWidget*)) );
	connect( TabWidget_GUI, SIGNAL(currentChanged(QWidget*)), this, SLOT(slotTabWidgetGUICurrentChanged(QWidget*)) );
	
	connect( ToolButton_ADD_USER_MENU_COMMAND, SIGNAL(clicked()), this, SLOT(slotAddUserMenuCommand()) );
	connect( ToolButton_EDIT_USER_MENU_COMMAND, SIGNAL(clicked()), this, SLOT(slotEditUserMenuCommand()) );
	connect( ToolButton_REMOVE_USER_MENU_COMMAND, SIGNAL(clicked()), this, SLOT(slotRemoveUserMenuCommand()) );
	connect( ToolButton_UP_USER_MENU_COMMAND, SIGNAL(clicked()), this, SLOT(slotUpUserMenuCommand()) );
	connect( ToolButton_DOWN_USER_MENU_COMMAND, SIGNAL(clicked()), this, SLOT(slotDownUserMenuCommand()) );
	connect( listView_MENU_COMMANDS, SIGNAL(selectionChanged()), this, SLOT(slotUserMenuCommandsSelectionChanged()) );
	connect( listView_MENU_COMMANDS, SIGNAL(doubleClicked(QListViewItem *, const QPoint &, int)), this, SLOT(slotUserMenuCommandsDoubleClicked(QListViewItem *, const QPoint &, int)) );
	listView_MENU_COMMANDS->setSortColumn( -1 );
	
	connect( listView_CHAT_COMMANDS, SIGNAL(contextMenuRequested( QListViewItem *, const QPoint &, int )), this, SLOT(slotContextMenuUserChatCommands(QListViewItem *, const QPoint &, int)));
	
	connect( listView_AUTO_RESPONSES, SIGNAL(contextMenuRequested( QListViewItem *, const QPoint &, int)), this, SLOT(slotContextMenuAutoResponses(QListViewItem *, const QPoint &, int)));
	
	connect( ToolButton_BROWSESOUNDFILECONNECT, SIGNAL(clicked()), this, SLOT(slotBrowseSoundFileConnect()) );
	connect( ToolButton_BROWSESOUNDFILEDISCONNECT, SIGNAL(clicked()), this, SLOT(slotBrowseSoundFileDisconnect()) );
	connect( ToolButton_BROWSESOUNDFILESEND, SIGNAL(clicked()), this, SLOT(slotBrowseSoundFileSend()) );
	connect( ToolButton_BROWSESOUNDFILERECEIVE, SIGNAL(clicked()), this, SLOT(slotBrowseSoundFileReceive()) );
	connect( ToolButton_BROWSESOUNDFILEFIRSTRECEIVE, SIGNAL(clicked()), this, SLOT(slotBrowseSoundFileFirstReceive()) );
	connect( ToolButton_BROWSESOUNDFILENICKMENTIONED, SIGNAL(clicked()), this, SLOT(slotBrowseSoundFileNickMentioned()) );

	connect( ToolButton_PREVIEWSOUNDFILECONNECT, SIGNAL(clicked()), this, SLOT(slotPreviewSoundFileConnect()) );
	connect( ToolButton_PREVIEWSOUNDFILEDISCONNECT, SIGNAL(clicked()), this, SLOT(slotPreviewSoundFileDisconnect()) );
	connect( ToolButton_PREVIEWSOUNDFILESEND, SIGNAL(clicked()), this, SLOT(slotPreviewSoundFileSend()) );
	connect( ToolButton_PREVIEWSOUNDFILERECEIVE, SIGNAL(clicked()), this, SLOT(slotPreviewSoundFileReceive()) );
	connect( ToolButton_PREVIEWSOUNDFILEFIRSTRECEIVE, SIGNAL(clicked()), this, SLOT(slotPreviewSoundFileFirstReceive()) );
	connect( ToolButton_PREVIEWSOUNDFILENICKMENTIONED, SIGNAL(clicked()), this, SLOT(slotPreviewSoundFileNickMentioned()) );

	connect( ToolButton_BROWSESOUNDPLAYER, SIGNAL(clicked()), this, SLOT(slotBrowseSoundPlayer()) );

	// Transfer->Folder
	connect( ToolButton_BROWSEDOWNLOADFOLDER, SIGNAL(clicked()), this, SLOT(slotBrowseDownloadFolder()) );
	connect( ToolButton_BROWSEDOWNLOADFINISHEDFOLDER, SIGNAL(clicked()), this, SLOT(slotBrowseDownloadFinishedFolder()) );

	connect( ToolButton_CREATESHARELIST, SIGNAL(clicked()), this, SLOT(slotCreateShareList()) );
	connect( ToolButton_BROWSEFILELIST, SIGNAL(clicked()), this, SLOT(slotBrowseShareList()) );
	connect( ToolButton_SHARELISTINFO, SIGNAL(clicked()), this, SLOT(slotShareListInfo()) );
	connect( ToolButton_ADDSHAREDFOLDER, SIGNAL(clicked()), this, SLOT(slotAddSharedFolder()) );
	connect( ToolButton_REMOVESHAREDFOLDER, SIGNAL(clicked()), this, SLOT(slotRemoveSharedFolder()) );
	connect( ToolButton_EDITSHAREDFOLDER, SIGNAL(clicked()), this, SLOT(slotEditSharedFolder()) );
	connect( ListView_SHAREDFOLDERS, SIGNAL(doubleClicked( QListViewItem *, const QPoint &, int )), this, SLOT(slotDoubleClickedSharedFolder( QListViewItem *, const QPoint &, int )) );
	connect( ListView_SHAREDFOLDERS, SIGNAL(contextMenuRequested( QListViewItem *, const QPoint &, int )), this, SLOT(slotContextMenuSharedFolder( QListViewItem *, const QPoint &, int )) );
	connect( ListView_SHAREDFOLDERS, SIGNAL(selectionChanged()), this, SLOT(slotSharedFoldersSelectionChanged()) );
	
	connect( PushButton_TESTHOST, SIGNAL(clicked()), this, SLOT(slotTestHost()) );
	connect( PushButton_GETINTERFACE, SIGNAL(clicked()), this, SLOT(slotGetInterface()) );
	connect( PushButton_GETINTERNETIP, SIGNAL(clicked()), this, SLOT(slotGetInternetIP()) );

	// GUI->General
	connect( ToolButton_BROWSELANGUAGEFILE, SIGNAL(clicked()), this, SLOT(slotBrowseLanguageFile()) );
	connect( ToolButton_SELECTLANGUAGE, SIGNAL(clicked()), this, SLOT(slotSelectLanguage()) );
	connect( PushButton_SETTHEME, SIGNAL(clicked()), this, SLOT(slotSetTheme()) );
	connect( ToolButton_BROWSEAPPFONT, SIGNAL(clicked()), this, SLOT(slotBrowseAppFont()) );
	connect( ToolButton_BROWSEDATAFOLDER, SIGNAL(clicked()), this, SLOT(slotBrowseDataFolder()) );

	// GUI->Chat
	connect( ToolButton_BROWSEBROWSER, SIGNAL(clicked()), this, SLOT(slotBrowseBrowser()) );
	connect( CheckBox_CUSTOM_BROWSER, SIGNAL(clicked()), this, SLOT(slotCustomBrowserChecked()) );
	connect( ListBox_CHATCOLOR, SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(slotDoubleClickedChatColor(QListBoxItem *)) );
	connect( ToolButton_CHAT_BG_COLOR, SIGNAL(clicked()), this, SLOT(slotBackgroundColorDialog()) );
	connect( ToolButton_REVERSE_COLORS, SIGNAL(clicked()), this, SLOT(slotReverseChatColors()) );

	// LOG->Chat
	connect( ToolButton_LOGCHAT_NICKNAMEFILTER_ADD, SIGNAL(clicked()), this, SLOT(slotLogChatAddNickNameFilter()) );
	connect( ToolButton_LOGCHAT_NICKNAMEFILTER_DEL, SIGNAL(clicked()), this, SLOT(slotLogChatDelNickNameFilter()) );

	//
	connect( ToolButton_BROWSETRANSFERCERT, SIGNAL(clicked()), this, SLOT(slotBrowseTransferCert()) );
	connect( ToolButton_BROWSETRANSFERKEY, SIGNAL(clicked()), this, SLOT(slotBrowseTransferKey()) );
	connect( ToolButton_BROWSE_DCLIB_PLUGIN_PATH, SIGNAL(clicked()), this, SLOT(slotBrowseDclibPluginFolder()) );

	// Hub List
	connect( ToolButton_ADDHUBLISTURL, SIGNAL(clicked()), this, SLOT(slotAddHubListUrl()) );
	connect( ToolButton_EDITHUBLISTURL, SIGNAL(clicked()), this, SLOT(slotEditHubListUrl()) );
	connect( ToolButton_REMOVEHUBLISTURL, SIGNAL(clicked()), this, SLOT(slotRemoveHubListUrl()) );
	connect( ListView_HUBLISTURL, SIGNAL(doubleClicked( QListViewItem *, const QPoint &, int )), this, SLOT(slotDoubleClickedHubListUrl( QListViewItem *, const QPoint &, int )) );
	connect( ListView_HUBLISTURL, SIGNAL(contextMenuRequested( QListViewItem *, const QPoint &, int )), this, SLOT(slotContextMenuHubListUrl( QListViewItem *, const QPoint &, int )) );
	connect( ListView_HUBLISTURL, SIGNAL(selectionChanged()), this, SLOT(slotHubListUrlsSelectionChanged()) );

	connect( CheckBox_SOUNDDISABLED, SIGNAL(clicked()), this, SLOT(slotDisableSound()) );
	
	connect( ToolButton_BROWSELOGFILE, SIGNAL(clicked()), this, SLOT(slotBrowseLogFile()) );
	
	connect( PushButton_GENERATE_CERT, SIGNAL(clicked()), this, SLOT(slotGenerateKeyCert()) );
	
	// style options
	ComboBox_THEME->clear();

	if ( g_pConfig->GetThemeSupport() )
	{
		QStringList list = QStyleFactory::keys();

		if ( list.count() > 0 )
		{
			list.sort();
			ComboBox_THEME->insertStringList(list);
			list.clear();
		}
	}
	else
	{
		// disable the theme support
		ComboBox_THEME->setEnabled(false);
		PushButton_SETTHEME->setEnabled(false);
	}
}

/** */
void DCOptions::connectOptionsListView()
{
	connect( ListView_OPTIONTREE, SIGNAL(currentChanged( QListViewItem * )), this, SLOT(slotListViewOptionCurrentChanged( QListViewItem * )) );
}

/** */
void DCOptions::disconnectOptionsListView()
{
	disconnect( ListView_OPTIONTREE, SIGNAL(currentChanged( QListViewItem * )), this, SLOT(slotListViewOptionCurrentChanged( QListViewItem * )) );
}

/** */
void DCOptions::accept()
{
	if ( LineEdit_DOWNLOADFOLDER->text().isEmpty() )
	{
		QMessageBox::critical( this, "Valknut",
		tr("You must set a Download Folder!") );
		return;
	}

	if ( LineEdit_DOWNLOADFINISHEDFOLDER->text() == LineEdit_DOWNLOADFOLDER->text() )
	{
		QMessageBox::critical( this, "Valknut",
		tr("Download Finished Folder and Download Folder must be different!") );
		return;
	}

	// check active mode settings
	if ( RadioButton_ACTIVEMODE->isOn() )
	{
		// check fake host
		if ( RadioButton_IPHOSTNAME->isOn() &&
	     	     LineEdit_IP->text().isEmpty() )

		{
			QMessageBox::critical( this, "Valknut",
			tr("You must enter a valid 'Fake Host'!") );
			return;
		}

		// check interface
		if ( RadioButton_INTERFACE->isOn() &&
	     	     LineEdit_IP->text().isEmpty() )

		{
			QMessageBox::critical( this, "Valknut",
			tr("You must enter a valid interface!") );
			return;
		}

#ifndef WIN32
		if ( (SpinBox_TCPLISTENPORT->value() < 1024) || (SpinBox_CRYPTO_PORT->value() < 1024) || (SpinBox_UDPLISTENPORT->value() < 1024) )
		{
			QMessageBox::critical( this, "Valknut",
			tr("You have set Valknut to listen on a port < 1024! You can run Valknut only as root in active mode!") );
		}
#endif
	}

	// no nick is given
	if ( LineEdit_NICK->text().isEmpty() )
	{
		QMessageBox::critical( this, "Valknut",
		tr("You must enter a valid nick!") );
		return;
	}

	// no search nick is given
	if ( (LineEdit_SEARCHNICK->text().isEmpty()) || (LineEdit_SEARCHNICK->text() == "nick_search") )
	{
		QMessageBox::critical( this, "Valknut",
		tr("You must enter a valid search nick!") );
		return;
	}

	if ( SpinBox_TCPLISTENPORT->value() == SpinBox_CRYPTO_PORT->value() )
	{
		QMessageBox::critical(
			this,
			"Valknut",
			tr("Standard and encrypted port must be different.")
		);
		return;
	}

	/* Warn about using certain options */
	QString recommended, notrecommended;
	
	if ( !CheckBox_DESCRIPTION_TAG->isChecked() && g_pConfig->GetDescriptionTag() )
	{
		recommended += CheckBox_DESCRIPTION_TAG->text();
		recommended += '\n';
	}
	
	if ( !CheckBox_EXT_HUB_COUNT->isChecked() && g_pConfig->GetUseExtendedHubCount() )
	{
		recommended += CheckBox_EXT_HUB_COUNT->text();
		recommended += '\n';
	}

	if ( CheckBox_DISABLEHASHLIST->isChecked() && !g_pConfig->GetDisableHashList() )
	{
		notrecommended += CheckBox_DISABLEHASHLIST->text();
		notrecommended += '\n';
	}

	if ( CheckBox_ENABLE_ZPIPE->isChecked() && !g_pConfig->GetZPipeEnabled() )
	{
		notrecommended += CheckBox_ENABLE_ZPIPE->text();
		notrecommended += '\n';
	}

	/* possibly also check compressed and encrypted transfers, they are not very useful */
	/* the auto responder really should not have been added but it is GUI only so unlikely to break anything */

	if ( !recommended.isEmpty() || !notrecommended.isEmpty() )
	{
		QString msg;
		if ( !recommended.isEmpty() )
		{
			msg += tr("These options are recommended:\n");
			msg += recommended;
		}
		
		if ( !notrecommended.isEmpty() )
		{
			msg += "\n";
			msg += tr("These options are not recommended:\n");
			msg += notrecommended;
		}
		
		if ( QMessageBox::warning(
			this,
			tr("Settings Problems"),
			msg,
			QMessageBox::Ignore | QMessageBox::Default,
			QMessageBox::Cancel | QMessageBox::Escape
		) == QMessageBox::Cancel )
		{
			return;
		}
	}

	if ( GroupBox_APPFONT->isChecked() )
	{
		if ( (!(LineEdit_APPFONT->text().isEmpty())) && (LineEdit_APPFONT->text() != g_pConfig->GetAppFont()) )
		{
			QFont font;
			if ( font.fromString(LineEdit_APPFONT->text()) )
			{
				QApplication::setFont(font, true);
			}
		}
	}

	QDialog::accept();
}

/** */
void DCOptions::SetUserPhoto( QString filename )
{
	QImage im;

	if ( !filename.isEmpty() )
	{
		if ( im.load(filename) )
		{
			if ( (im.width() > 32) ||
			     (im.height() > 32) )
			{
				im = im.smoothScale(32,32,QImage::ScaleMin);
			}

			if ( im.depth() > 8 )
				im = im.convertDepth(8);

			if ( im.numColors() > 256 )
				im.setNumColors(256);

			if ( im.save( (g_pConfig->GetConfigPath() + "photo.png").Data(), "PNG", 0 ) == false )
			{
				QMessageBox::critical( this, "Valknut", tr("Can't save Image!") );
			}
			else
			{
				ToolButton_PHOTO->setIconSet( QIconSet(im, QIconSet::Large) );
				// ToolButton_PHOTO->setTextLabel(filename);
				ToolButton_PHOTO->setTextLabel((g_pConfig->GetConfigPath() + "photo.png").Data());
			}
		}
		else
		{
			QMessageBox::critical( this, "Valknut", tr("Can't load Image!") );
		}
	}
}

/** */
void DCOptions::slotChangePhoto()
{
	QString file = QFileDialog::getOpenFileName( ToolButton_PHOTO->textLabel(), QString(), this, "blf", tr("Select a 64x64 Photo") );

	if ( file.isEmpty() )
	{
		ToolButton_PHOTO->setIconSet( QIconSet(QPixmap(), QIconSet::Large) );
		ToolButton_PHOTO->setTextLabel( QString() );
	}
	else
	{
		SetUserPhoto(file);
	}
}

/** */
void DCOptions::slotDoubleClickedChatColor( QListBoxItem * item )
{
	QPixmap p(10,10);
	QColor color(item->pixmap()->convertToImage().pixel(0,0));
	color = QColorDialog::getColor(color);
	if ( color.isValid() )
	{
		p.fill(color);
		ListBox_CHATCOLOR->changeItem( p, item->text(), ListBox_CHATCOLOR->currentItem() );
	}
}

/** */
void DCOptions::slotBackgroundColorDialog()
{
	QPixmap pixmap = ToolButton_CHAT_BG_COLOR->iconSet().pixmap( QIconSet::Small, QIconSet::Normal );
	
	QColor color = pixmap.convertToImage().pixel(0,0);
	color = QColorDialog::getColor(color);
	
	if ( color.isValid() )
	{
		pixmap.fill(color);
		ToolButton_CHAT_BG_COLOR->setIconSet(QIconSet(pixmap));
	}
}

/** */
void DCOptions::slotReverseChatColors()
{
	QColor color;
	QPixmap p(10,10);
	
	for ( unsigned int i = 0; i < ListBox_CHATCOLOR->count(); ++i )
	{
		color = QColor(ListBox_CHATCOLOR->item(i)->pixmap()->convertToImage().pixel(0,0));
		color.setRgb( 255 - color.red(), 255 - color.green(), 255 - color.blue() );
		p.fill(color);
		ListBox_CHATCOLOR->changeItem( p, ListBox_CHATCOLOR->item(i)->text(), i );
	}
}

/** */
void DCOptions::slotLogChatAddNickNameFilter()
{
	bool ok = false;

	QString text = QInputDialog::getText(
		tr("Add new nick name filter"),
		tr("Please enter a nick" ),
		QLineEdit::Normal, QString(), &ok, this );

	if ( ok && !text.isEmpty() )
	{
		if ( ListBox_LOGCHAT_NICKNAMEFILTER_LIST->findItem(text) == NULL )
		{
			ListBox_LOGCHAT_NICKNAMEFILTER_LIST->insertItem(text);
		}
	}
}

/** */
void DCOptions::slotLogChatDelNickNameFilter()
{
	int i = ListBox_LOGCHAT_NICKNAMEFILTER_LIST->currentItem();

	if ( i >= 0 )
	{
		ListBox_LOGCHAT_NICKNAMEFILTER_LIST->removeItem(i);
	}
}

/** */
void DCOptions::slotTestHost()
{
	QString sip;
	CString errmsg;
	QString s;
	QString failmsg;

	if ( RadioButton_IPHOSTNAME->isOn() )
	{
		s = LineEdit_IP->text();
		s.remove(' ');
		LineEdit_IP->setText(s);

		if ( !s.isEmpty() )
		{
			sip = CNetAddr::GetHostI4( s.ascii(), &errmsg ).Data();
		}

		if ( sip.isEmpty() )
		{
			failmsg = tr("Can't get Host IP!");
			if ( errmsg.NotEmpty() )
			{
				failmsg += "\n\n";
				failmsg += errmsg.Data();
			}
			QMessageBox::critical( this, "Valknut", failmsg );
		}
		else
		{
			QMessageBox::information( this, "Valknut", tr("Host IP: ")+sip );
		}
	}
	else
	{
		sip = CNetAddr::GetInterfaceI4( LineEdit_IP->text().ascii(), &errmsg ).Data();

		if ( sip.isEmpty() )
		{
			failmsg = tr("Can't get interface IP!");
			if ( errmsg.NotEmpty() )
			{
				failmsg += "\n\n";
				failmsg += errmsg.Data();
			}
			QMessageBox::critical( this, "Valknut", failmsg );
		}
		else
		{
			QMessageBox::information( this, "Valknut", tr("Interface IP: ")+sip );
		}
	}
}

/** */
void DCOptions::slotGetInterface()
{
	CList<CString> interfacelist;
	CString errmsg;
	CString * s;
	QStringList lst;
	long res = CNetAddr::GetInterfaceList( &interfacelist, &errmsg );

	if ( res > 0 )
	{
		s = 0;

		while( (s=interfacelist.Next(s)) != 0 )
		{
			lst << s->Data();
		}
  
		bool ok = false;

		QString res = QInputDialog::getItem(
				tr( "Interface List" ),
				tr( "Please select an interface" ), lst, 1, true, &ok, this );

		if ( ok )
		{
			LineEdit_IP->setText(res);
		}
	}
	else
	{
		QString failmsg = tr("No interfaces found!");
		if ( (res < 0) && errmsg.NotEmpty() )
		{
			failmsg += "\n\n";
			failmsg += errmsg.Data();
		}
		QMessageBox::information( this, "Valknut", failmsg );
	}
}

/** */
void DCOptions::slotGetInternetIP()
{
	PushButton_GETINTERNETIP->setEnabled(false);
	
	QHttpRequestHeader header( "GET", "/ip.php" );
	header.setValue( "Host", "wxdcgui.sourceforge.net" );
	QString useragent = QString("Valknut/") + VERSION;
	//printf("User-Agent=%s\n", useragent.ascii());
	header.setValue( "User-Agent", useragent );
	
	m_pHttp = new QHttp();
	connect( m_pHttp, SIGNAL(done(bool)), this, SLOT(slotGotInternetIP(bool)) );
	m_pHttp->setHost( "wxdcgui.sourceforge.net" );
	m_pHttp->request( header );
}

/** */
void DCOptions::slotGotInternetIP( bool error )
{
	if ( error )
	{
		QMessageBox::warning( this,
			tr("Error getting IP"),
			m_pHttp->errorString()
		);
	}
	else
	{
		QString html = QString(m_pHttp->readAll());
		int start = html.find("&lt;ip&gt;");
		int end = html.find("&lt;/ip&gt;",start);
		
		if ( ( start == -1 ) || ( end < start ) )
		{
			QMessageBox::warning(
				this,
				tr("Get Internet IP"),
				tr("Unexpected response from ") + "http://wxdcgui.sourceforge.net"
			);
		}
		else
		{
			start += 10;
			QString ip = html.mid( start, end - start );
			
			if ( QHostAddress().setAddress(ip) )
			{
				LineEdit_IP->setText(ip);
			}
			else
			{
				QMessageBox::warning(
					this,
					tr("Get Internet IP"),
					ip + tr(" does not look valid")
				);
			}
		}
	}
	
	delete m_pHttp;
	m_pHttp = 0;
	
	PushButton_GETINTERNETIP->setEnabled(true);
}

/** */
void DCOptions::slotDisableSound()
{
	const bool b = !CheckBox_SOUNDDISABLED->isChecked();

	CheckBox_SOUNDDISABLEDAWAY->setEnabled(b);
	GroupBox_EXTERNALPLAYER->setEnabled(b);
	GroupBox_SOUND_FILES->setEnabled(b);
}

/** */
void DCOptions::slotBrowseSoundPlayer()
{
	QString file = QFileDialog::getOpenFileName( LineEdit_EXTERNALPLAYER->text(), QString(), this, "blf", tr("Select sound player") );

	if ( !file.isEmpty() )
	{
		LineEdit_EXTERNALPLAYER->setText(file);
	}
}

/** */
void DCOptions::slotBrowseTransferCert()
{
	QString file = QFileDialog::getSaveFileName( LineEdit_TRANSFERCERT->text(), QString(), this, "blf", tr("Select transfer cert") );

	if ( !file.isEmpty() )
	{
		LineEdit_TRANSFERCERT->setText(file);
	}
}

/** */
void DCOptions::slotBrowseTransferKey()
{
	QString file = QFileDialog::getSaveFileName( LineEdit_TRANSFERKEY->text(), QString(), this, "blf", tr("Select transfer key") );

	if ( !file.isEmpty() )
	{
		LineEdit_TRANSFERKEY->setText(file);
	}
}

/** */
void DCOptions::slotBrowseDclibPluginFolder()
{
	QString dir = QFileDialog::getExistingDirectory( LineEdit_DCLIB_PLUGIN_PATH->text(), this, "bdf", tr("Select plugin folder"), true );
	
	if ( !dir.isEmpty() )
	{
		LineEdit_DCLIB_PLUGIN_PATH->setText(dir);
	}
}

/** */
void DCOptions::slotBrowseBrowser()
{
	QString file = QFileDialog::getOpenFileName( LineEdit_BROWSER->text(), QString(), this, "blf", tr("Select a browser") );

	if ( !file.isEmpty() )
	{
		LineEdit_BROWSER->setText(file);
	}
}

/** */
void DCOptions::BrowseSoundFile( eUserSound usersound )
{
	QString current;
	QString filter = tr("au")        + " (*.au);;"  +
			 tr("wav")       + " (*.wav);;" +
			 tr("All Files") + " (*)";

	switch(usersound)
	{
		case eusCONNECT:
			current = LineEdit_SOUNDFILECONNECT->text();
			break;
		case eusDISCONNECT:
			current = LineEdit_SOUNDFILEDISCONNECT->text();
			break;
		case eusSEND:
			current = LineEdit_SOUNDFILESEND->text();
			break;
		case eusRECEIVE:
			current = LineEdit_SOUNDFILERECEIVE->text();
			break;
		case eusFIRSTRECEIVE:
			current = LineEdit_SOUNDFILEFIRSTRECEIVE->text();
			break;
		case eusNICKMENTIONED:
			current = LineEdit_SOUNDFILENICKMENTIONED->text();
			break;
		default:
			break;
	}

	QString file = QFileDialog::getOpenFileName( current, filter, this, "blf", tr("Select sound file") );

	if ( !file.isEmpty() )
	{
		switch(usersound)
		{
			case eusCONNECT:
				LineEdit_SOUNDFILECONNECT->setText(file);
				break;
			case eusDISCONNECT:
				LineEdit_SOUNDFILEDISCONNECT->setText(file);
				break;
			case eusSEND:
				LineEdit_SOUNDFILESEND->setText(file);
				break;
			case eusRECEIVE:
				LineEdit_SOUNDFILERECEIVE->setText(file);
				break;
			case eusFIRSTRECEIVE:
				LineEdit_SOUNDFILEFIRSTRECEIVE->setText(file);
				break;
			case eusNICKMENTIONED:
				LineEdit_SOUNDFILENICKMENTIONED->setText(file);
				break;
			default:
				break;
		}
	}
}

/** */
void DCOptions::PreviewSoundFile( eUserSound usersound )
{
	QString file;

	switch(usersound)
	{
		case eusCONNECT:
			file = LineEdit_SOUNDFILECONNECT->text();
			break;
		case eusDISCONNECT:
			file = LineEdit_SOUNDFILEDISCONNECT->text();
			break;
		case eusSEND:
			file = LineEdit_SOUNDFILESEND->text();
			break;
		case eusRECEIVE:
			file = LineEdit_SOUNDFILERECEIVE->text();
			break;
		case eusFIRSTRECEIVE:
			file = LineEdit_SOUNDFILEFIRSTRECEIVE->text();
			break;
		case eusNICKMENTIONED:
			file = LineEdit_SOUNDFILENICKMENTIONED->text();
			break;
		default:
			break;
	}

	g_pConfig->PlaySound( file );
}

/** */
void DCOptions::slotBrowseDownloadFolder()
{
	QString dir = QFileDialog::getExistingDirectory ( LineEdit_DOWNLOADFOLDER->text(), this, "bdf", tr("Select download folder"), true );

	if ( !dir.isEmpty() )
	{
		LineEdit_DOWNLOADFOLDER->setText(dir);
	}
}

/** */
void DCOptions::slotBrowseDownloadFinishedFolder()
{
	QString dir = QFileDialog::getExistingDirectory ( LineEdit_DOWNLOADFINISHEDFOLDER->text(), this, "bdf", tr("Select download finished folder"), true );

	if ( !dir.isEmpty() )
	{
		LineEdit_DOWNLOADFINISHEDFOLDER->setText(dir);
	}
}

/** */
void DCOptions::slotBrowseDataFolder()
{
	QString dir = QFileDialog::getExistingDirectory ( LineEdit_DATAFOLDER->text(), this, "bdf", tr("Select data folder"), true );

	if ( !dir.isEmpty() )
	{
		LineEdit_DATAFOLDER->setText(dir);
	}
}

/** */
void DCOptions::slotBrowseShareList()
{
	g_pTransferView->NewLocalFileBrowser(true);
}

/** */
void DCOptions::slotBrowseLogFile()
{
	QString logfile = QFileDialog::getSaveFileName ( LineEdit_LOGFILENAME->text(), QString(), this, 0, tr("Select log file") );

	if( !logfile.isEmpty() )
	{
		LineEdit_LOGFILENAME->setText(logfile);
	}
}

/** */
void DCOptions::slotAddSharedFolder()
{
	CDir di;
	CString s;
	int i;

	QString dir = QFileDialog::getExistingDirectory ( QString(), this, "bdf", tr("Select share folder"), true );

	if ( !dir.isEmpty() )
	{
		if ( ListView_SHAREDFOLDERS->findItem( dir, 0 ) == 0 )
		{
			di.SetPath(dir.ascii());
			s = di.Path();
			i = 1;

			while( ListView_SHAREDFOLDERS->findItem( di.DirName().Data(), 1 ) != 0 )
			{
				di.SetPath( s + CString::number(i) );
				i++;
			}

			new QListViewItem( ListView_SHAREDFOLDERS, dir, di.DirName().Data() );
		}
	}
}

/** */
void DCOptions::slotRemoveSharedFolder()
{
	QListViewItem * item = ListView_SHAREDFOLDERS->currentItem();

	if ( item )
	{
		delete item;
	}
}

/** */
void DCOptions::slotEditSharedFolder()
{
	editSharedFolder( ListView_SHAREDFOLDERS->currentItem() );
}

/** */
void DCOptions::editSharedFolder( QListViewItem * item )
{
	if ( item )
	{
		DCDialogEditSharePath * dlg = new DCDialogEditSharePath(this);
		
		dlg->LineEdit_PATH->setText( item->text(0) );
		dlg->LineEdit_ALIAS->setText( item->text(1) );
		
		if ( dlg->exec() == QDialog::Accepted )
		{
			item->setText(0,dlg->LineEdit_PATH->text());
			
			QString s = dlg->LineEdit_ALIAS->text();
			s.remove( '\\' );
			s.remove( '/' );
			item->setText(1,s);
		}
		
		delete dlg;
	}
}

/** */
void DCOptions::slotDoubleClickedSharedFolder( QListViewItem * item, const QPoint & /* pos */, int /* col */ )
{
	if ( item )
	{
		editSharedFolder( item );
	}
	else
	{
		slotAddSharedFolder();
	}
}

/** */
void DCOptions::slotContextMenuSharedFolder( QListViewItem * item, const QPoint & /* pos */, int /* col */ )
{
	QPopupMenu * m = new QPopupMenu(this);
	bool enabled = (item != 0);
	
	DCMenuHandler::InsertMenu( m, emiADD );
	DCMenuHandler::InsertMenu( m, emiEDIT, enabled );
	DCMenuHandler::InsertMenu( m, emiREMOVE, enabled );
	
	int id = m->exec(QCursor::pos());
	
	delete m;
	
	if ( id == -1 )
	{
		return;
	}
	else if ( id == emiADD )
	{
		slotAddSharedFolder();
	}
	else if ( id == emiEDIT )
	{
		editSharedFolder( item );
	}
	else if ( id == emiREMOVE )
	{
		delete item;
	}
}

/** */
void DCOptions::slotSharedFoldersSelectionChanged()
{
	if ( ListView_SHAREDFOLDERS->selectedItem() )
	{
		ToolButton_REMOVESHAREDFOLDER->setEnabled(true);
		ToolButton_EDITSHAREDFOLDER->setEnabled(true);
	}
	else
	{
		ToolButton_REMOVESHAREDFOLDER->setEnabled(false);
		ToolButton_EDITSHAREDFOLDER->setEnabled(false);
	}
}

/** */
void DCOptions::SetValues()
{
	int i;
	CList<DCConfigShareFolder> list;
	DCConfigShareFolder * csf;
	DC_UserMenuCommand * umc;
	QListViewItem * qlvitem;

	// identify
	LineEdit_NICK->setText(g_pConfig->GetNick().Data());
	LineEdit_SEARCHNICK->setText(g_pConfig->GetSearchNick().Data());
	LineEdit_EMAIL->setText(g_pConfig->GetEMail(true).Data());
	CheckBox_ANTISPAM->setChecked(g_pConfig->GetAntiSpam());
	LineEdit_DESCRIPTION->setText(g_pConfig->GetDescription(true).Data());
	CheckBox_DESCRIPTION_TAG->setChecked(g_pConfig->GetDescriptionTag());
	CheckBox_EXT_HUB_COUNT->setChecked(g_pConfig->GetUseExtendedHubCount());
	LineEdit_AWAYPREFIX->setText(g_pConfig->GetAwayPrefix().Data());

	SetUserPhoto(g_pConfig->GetUserPhotoFileName());

	for(i=0;i<ComboBox_SPEED->count();i++)
	{
		if ( ComboBox_SPEED->text(i) == g_pConfig->GetSpeed() )
		{
			ComboBox_SPEED->setCurrentItem(i);
			break;
		}
	}
	
	for(i=0;i<ComboBox_APPLICATION_ICONS->count();i++)
	{
		if ( ComboBox_APPLICATION_ICONS->text(i) == g_pConfig->GetApplicationIconTheme() )
		{
			ComboBox_APPLICATION_ICONS->setCurrentItem(i);
			break;
		}
	}
	
	for(i=0;i<ComboBox_EMOTICONS->count();i++)
	{
		if ( ComboBox_EMOTICONS->text(i) == g_pConfig->GetEmoticonTheme() )
		{
			ComboBox_EMOTICONS->setCurrentItem(i);
			break;
		}
	}
	
	for(i=0;i<ComboBox_USERLIST_ICONS->count();i++)
	{
		if ( ComboBox_USERLIST_ICONS->text(i) == g_pConfig->GetUserListIconTheme() )
		{
			ComboBox_USERLIST_ICONS->setCurrentItem(i);
			break;
		}
	}
	

	TextEdit_AWAYMESSAGE->setText(QString(g_pConfig->GetAwayMessage().Data()).remove( "\r" ));

	// transfer->folder
	LineEdit_DOWNLOADFOLDER->setText(g_pConfig->GetDownloadFolder().Data());
	LineEdit_DOWNLOADFINISHEDFOLDER->setText(g_pConfig->GetDownloadFinishedFolder().Data());
	SpinBox_MIN_SEG_SIZE->setValue( (int) g_pConfig->GetMinSegSize()/1048576 );

	// save shared folders
	ListView_SHAREDFOLDERS->clear();

	g_pConfig->GetSharedFolders(&list);

	csf = 0;
	while( (csf=list.Next(csf)) != 0 )	
	{
		new QListViewItem( ListView_SHAREDFOLDERS, csf->m_sPath.Data(), csf->m_sAlias.Data() );
	}
	slotSharedFoldersSelectionChanged();
	
	g_pConfig->GetUserMenuCommands(&usercommands);
	for ( i = usercommands.size() - 1; i >= 0; i-- )
	{
		umc = usercommands[i];
		new QListViewItem( listView_MENU_COMMANDS, umc->m_sName, umc->m_sCommand );
	}
	
	slotUserMenuCommandsSelectionChanged();
	
	
	QPtrList<DC_UserChatCommand> ucclist;
	ucclist.setAutoDelete(true);
	g_pConfig->GetUserChatCommands(&ucclist);
	
	for ( DC_UserChatCommand * ucc = ucclist.first(); ucc; ucc = ucclist.next() )
	{
		qlvitem = new QListViewItem( listView_CHAT_COMMANDS, ucc->m_sName, ucc->m_sCommand );
		qlvitem->setRenameEnabled(0, true);
		qlvitem->setRenameEnabled(1, true);
	}
	ucclist.clear();
	
	CheckBox_AUTORECREATESHARELIST->setChecked(g_pConfig->GetAutoRecreateShareList());
	CheckBox_DONTSHAREDOTFILES->setChecked(g_pConfig->GetDontShareDotFiles());

	// transfer->settings
	SpinBox_SAVEDOWNLOADQUEUETIME->setValue( g_pConfig->GetDownloadQueueTime() );
	SpinBox_USERUPLOADSLOTS->setValue(g_pConfig->GetUserUploadSlots());
	CheckBox_DYNAMICUPLOADRATE->setChecked(g_pConfig->GetDynamicUploadRate());
	SpinBox_MAXUPLOADRATE->setValue( floor(((10.0*g_pConfig->GetMaxUploadRate())/1024)+0.5) );
	SpinBox_MAXDOWNLOADRATE->setValue( floor(((10.0*g_pConfig->GetMaxDownloadRate())/1024)+0.5) );
	SpinBox_MAXSIMULTANEOUSUPLOADS->setValue( g_pConfig->GetMaxUpload() );
	SpinBox_TRANSFERRESENDTIMEOUT->setValue(g_pConfig->GetTransferResendTimeout());
	SpinBox_TRANSFERRESPONSETIMEOUT->setValue(g_pConfig->GetTransferResponseTimeout());
	SpinBox_AUTOSEARCHINTERVAL->setValue(g_pConfig->GetAutoSearchInterval());
	SpinBox_SMALLFILESIZE->setValue(g_pConfig->GetSmallFileSize());

	SpinBox_EXTRA_SLOTS_RATE->setValue( (int) g_pConfig->GetExtraSlotsRate()/1024 );
	SpinBox_MAX_EXTRA_SLOTS->setValue( g_pConfig->GetMaxExtraSlots() );

	switch ( g_pConfig->GetHubOfflineTransferClose() )
	{
		case ectNONE:
			RadioButton_NONE->setChecked(true);
			break;
		case ectUPLD:
			RadioButton_UPLOAD->setChecked(true);
			break;
		case ectDLD:
			RadioButton_DOWNLOAD->setChecked(true);
			break;
		case ectBOTH:
			RadioButton_BOTH->setChecked(true);
			break;
	}

	CheckBox_TRANSFERAUTOSEARCH->setChecked(g_pConfig->GetTransferAutoSearch());
	CheckBox_DISABLEHASHLIST->setChecked(g_pConfig->GetDisableHashList());
	CheckBox_COMPRESSEDTRANSFERS->setChecked(g_pConfig->GetCompressedTransfers());
	SpinBox_RECREATESHARELISTTIME->setValue(g_pConfig->GetRecreateShareListTime());

	// connection->mode
	if ( g_pConfig->GetMode(true) == ecmPASSIVE )
	{
		RadioButton_PASSIVEMODE->setChecked(true);
	}
	else
	{
		RadioButton_ACTIVEMODE->setChecked(true);
	}

	if ( g_pConfig->GetExternalIP() )
	{
		RadioButton_IPHOSTNAME->setChecked(true);
	}
	else
	{
		RadioButton_INTERFACE->setChecked(true);
	}

	LineEdit_IP->setText(g_pConfig->GetHost().Data());
	LineEdit_LISTENIP->setText(g_pConfig->GetListenHost().Data());
	SpinBox_TCPLISTENPORT->setValue( g_pConfig->GetTCPListenPort() );
	SpinBox_CRYPTO_PORT->setValue( g_pConfig->GetCryptoListenPort() );
	SpinBox_UDPLISTENPORT->setValue( g_pConfig->GetUDPListenPort() );
	CheckBox_SENDMESSAGEONACTIVEMODEREQUEST->setChecked( g_pConfig->GetSendMessageOnActiveModeRequest() );

	// connection->settings
	SpinBox_RECONNECTCOUNT->setValue(g_pConfig->GetReconnectCount());
	SpinBox_RECONNECTTIMEOUT->setValue(g_pConfig->GetReconnectTimeout());
	CheckBox_FORCEMOVEENABLED->setChecked(g_pConfig->GetForceMoveEnabled());
	
	if ( g_pConfig->GetCheckPrivateAddressSpace() )
	{
		ComboBox_PRIVATEADDRESSSPACE->setCurrentItem(1);
	}
	else if ( g_pConfig->GetPrivateAddressSpaceOnly() )
	{
		ComboBox_PRIVATEADDRESSSPACE->setCurrentItem(2);
	}
	else
	{
		ComboBox_PRIVATEADDRESSSPACE->setCurrentItem(0);
	}

	// gui->general
	LineEdit_LANGUAGEFILE->setText( g_pConfig->GetLanguageFile() );

	for(i=0;i<ComboBox_THEME->count();i++)
	{
		if ( g_pConfig->GetTheme() == ComboBox_THEME->text(i) )
		{
			ComboBox_THEME->setCurrentItem(i);
			break;
		}
	}

	// if theme not in the list, pick the current theme
	if ( ComboBox_THEME->currentText() != g_pConfig->GetTheme() )
	{
		QString themename = DCGuiUtils::DetectAppStyleKey().lower();
		
		for ( i = 0; i < ComboBox_THEME->count(); i++ )
		{
			if ( ComboBox_THEME->text(i).lower() == themename )
			{
				ComboBox_THEME->setCurrentItem(i);
				break;
			}
		}
	}

	m_sTestedTheme = ComboBox_THEME->currentText();

	switch(g_pConfig->GetUnit())
	{
		case euBYTE:
			RadioButton_UNITBYTE->setChecked(true);
			break;
		case euKBYTE:
			RadioButton_UNITKBYTE->setChecked(true);
			break;
		case euMBYTE:
			RadioButton_UNITMBYTE->setChecked(true);
			break;
		case euGBYTE:
			RadioButton_UNITGBYTE->setChecked(true);
			break;
		default:
			RadioButton_UNITAUTO->setChecked(true);
			break;
	}

	LineEdit_APPFONT->setText( g_pConfig->GetAppFont() );
	GroupBox_APPFONT->setChecked( g_pConfig->GetUseCustomFont() );
	LineEdit_DATAFOLDER->setText(g_pConfig->GetValknutDataPath());
	CheckBox_SHOWSTATUSMESSAGE->setChecked( g_pConfig->GetShowStatusMessage() );
	CheckBox_QUERYONEXIT->setChecked( g_pConfig->GetQueryOnExit() );
	CheckBox_QUERYONFILEDELETE->setChecked( g_pConfig->GetQueryOnFileDelete() );

	// gui->transfer
	CheckBox_TV_PERCENTCHUNK->setChecked(g_pConfig->GetTransferViewOptions(etvoCHUNKPERCENT));
	CheckBox_TV_PERCENTFILE->setChecked(g_pConfig->GetTransferViewOptions(etvoFILEPERCENT));
	CheckBox_TV_CHUNKSIZE->setChecked(g_pConfig->GetTransferViewOptions(etvoCHUNKSIZE));
	CheckBox_TV_FILESIZE->setChecked(g_pConfig->GetTransferViewOptions(etvoFILESIZE));
	CheckBox_TV_DOWNLOADRATESINGLE->setChecked(g_pConfig->GetTransferViewOptions(etvoDOWNLOADRATESINGLE));
	CheckBox_TV_ELAPSEDTIMESINGLE->setChecked(g_pConfig->GetTransferViewOptions(etvoELAPSEDTIMESINGLE));
	CheckBox_TV_DOWNLOADRATEMULTI->setChecked(g_pConfig->GetTransferViewOptions(etvoDOWNLOADRATEMULTI));
	CheckBox_TV_ELAPSEDTIMEMULTI->setChecked(g_pConfig->GetTransferViewOptions(etvoELAPSEDTIMEMULTI));

	// gui->chat
	CheckBox_OPENPRIVATECHATWINDOW->setChecked(g_pConfig->GetOpenPrivateChatWindow());
	CheckBox_SHOWCHATINTAB->setChecked(g_pConfig->GetShowChatInTab());
	CheckBox_SENDHIDEPRIVATECHATTOPUBLICCHAT->setChecked( g_pConfig->GetSendHidePrivateChatToPublicChat());
	CheckBox_EMOTICONS->setChecked(g_pConfig->GetEnableEmoticons());
	CheckBox_SHOWCHATSENDBUTTON->setChecked(g_pConfig->GetShowChatSendButton());
	CheckBox_CHATSHOWJOINSANDPARTS->setChecked(g_pConfig->GetChatShowJoinsAndParts());
	CheckBox_CHATSHOWJOINSANDPARTSONLYFAV->setChecked(g_pConfig->GetChatShowJoinsAndPartsOnlyFav());
	CheckBox_CHATRECVOFFLINEMESSAGES->setChecked(g_pConfig->GetChatRecvOfflineMessages());
	CheckBox_CHATSENDOFFLINEMESSAGES->setChecked(g_pConfig->GetChatSendOfflineMessages());
	SpinBox_CHATMAXPARAGRAPH->setValue(g_pConfig->GetChatMaxParagraph());
	SpinBox_CHATMESSAGEMAXLINES->setValue( g_pConfig->GetChatMessageMaxLines() );
	LineEdit_SUPPRESS_NICKS->setText( g_pConfig->GetSuppressedNicks() );
	CheckBox_SENDUNKNOWNCOMMANDS->setChecked(g_pConfig->GetSendUnknownCommandsAsChat());
	LineEdit_ALLOWED_UNKNOWN_COMMANDS->setText(g_pConfig->GetAllowedUnknownCommands());
	
	ComboBox_SENDCHAT->setCurrentItem(g_pConfig->GetSendChat());
	
	CheckBox_CUSTOM_BROWSER->setChecked(g_pConfig->GetCustomBrowser());
	LineEdit_BROWSER->setText(g_pConfig->GetBrowser());
	slotCustomBrowserChecked();

	QColor c;
	QPixmap p(10,10);

	c.setNamedColor(g_pConfig->GetChatColor(eccCHATTIMESTAMP));
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Chat Timestamp"));
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATLOCALNICK));
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Chat Local Nick"));
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATLOCALTEXT));
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Chat Local Text"));
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATREMOTENICK));
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Chat Remote Nick"));
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATREMOTETEXT));
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Chat Remote Text"));
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATSTATUSNICK));
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Chat Status Nick"));
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATSTATUSTEXT));
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Chat Status Text"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATTIMESTAMP));
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Chat Timestamp"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATLOCALNICK));
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Chat Local Nick"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATLOCALTEXT));
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Chat Local Text"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATREMOTENICK));
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Chat Remote Nick"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATREMOTETEXT));
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Chat Remote Text"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATSTATUSNICK));
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Chat Status Nick"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATSTATUSTEXT));
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Chat Status Text"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICPRIVATECHATNICK));
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Private Chat Nick"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICPRIVATECHATTEXT));
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Private Chat Text"));
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATSAY));
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Chat Say"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATMENICK));
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Chat ME Nick"));
	c.setNamedColor(g_pConfig->GetChatColor(eccOPNICK));
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Operator Nick"));
	
	CheckBox_ENABLE_CHAT_BG_COLOR->setChecked(g_pConfig->GetChatBackgroundColorEnabled());
	c.setNamedColor(g_pConfig->GetChatBackgroundColor());
	p.fill(c);
	ToolButton_CHAT_BG_COLOR->setIconSet(QIconSet(p));
	
	// gui->client
	ComboBox_OPEN_CLIENT_WINDOWS_HOW->setCurrentItem(g_pConfig->GetOpenClientWindows());
	CheckBox_USERLISTRIGHTALIGNMENT->setChecked(g_pConfig->GetUserListRightAlignment());
	CheckBox_AUTOAWAYMODE->setChecked(g_pConfig->GetAutoAwayMode());
	SpinBox_AUTOAWAYTIME->setValue(g_pConfig->GetAutoAwayTime());
	CheckBox_CLIENTCOLUMNS_COMMENT->setChecked(g_pConfig->GetClientColumn(eclcCOMMENT));
	CheckBox_CLIENTCOLUMNS_TAG->setChecked(g_pConfig->GetClientColumn(eclcTAG));
	CheckBox_CLIENTCOLUMNS_SPEED->setChecked(g_pConfig->GetClientColumn(eclcSPEED));
	CheckBox_CLIENTCOLUMNS_EMAIL->setChecked(g_pConfig->GetClientColumn(eclcEMAIL));
	CheckBox_CLIENTCOLUMNS_SHARE->setChecked(g_pConfig->GetClientColumn(eclcSHARE));
	CheckBox_CLIENTCOLUMNS_IP->setChecked(g_pConfig->GetClientColumn(eclcIP));
	CheckBox_CLIENTCOLUMNS_LOCKPK->setChecked(g_pConfig->GetClientColumn(eclcLOCKPK));
	CheckBox_CLIENTCOLUMNS_SUPPORTS->setChecked(g_pConfig->GetClientColumn(eclcSUPPORTS));
	
	ComboBox_DOUBLECLICK->setCurrentItem(g_pConfig->GetDoubleClickAction());
	
	// sound
	CheckBox_SOUNDDISABLED->setChecked(g_pConfig->GetSoundDisabled());
	CheckBox_SOUNDDISABLEDAWAY->setChecked(g_pConfig->GetSoundDisabledAway());
	GroupBox_EXTERNALPLAYER->setChecked(g_pConfig->GetExternalSoundPlayer());
	LineEdit_EXTERNALPLAYER->setText( g_pConfig->GetExternalPlayer() );
	LineEdit_SOUNDFILECONNECT->setText( g_pConfig->GetSoundFile(eusCONNECT) );
	LineEdit_SOUNDFILEDISCONNECT->setText( g_pConfig->GetSoundFile(eusDISCONNECT) );
	LineEdit_SOUNDFILESEND->setText( g_pConfig->GetSoundFile(eusSEND) );
	LineEdit_SOUNDFILERECEIVE->setText( g_pConfig->GetSoundFile(eusRECEIVE) );
	LineEdit_SOUNDFILEFIRSTRECEIVE->setText( g_pConfig->GetSoundFile(eusFIRSTRECEIVE) );
	LineEdit_SOUNDFILENICKMENTIONED->setText( g_pConfig->GetSoundFile(eusNICKMENTIONED) );
	GroupBox_SOUNDPLAYCONNECT->setChecked(g_pConfig->GetSoundEnabled(eusCONNECT));
	GroupBox_SOUNDPLAYDISCONNECT->setChecked(g_pConfig->GetSoundEnabled(eusDISCONNECT));
	GroupBox_SOUNDPLAYSEND->setChecked(g_pConfig->GetSoundEnabled(eusSEND));
	GroupBox_SOUNDPLAYRECEIVE->setChecked(g_pConfig->GetSoundEnabled(eusRECEIVE));
	GroupBox_SOUNDPLAYFIRSTRECEIVE->setChecked(g_pConfig->GetSoundEnabled(eusFIRSTRECEIVE));
	GroupBox_SOUNDPLAYNICKMENTIONED->setChecked(g_pConfig->GetSoundEnabled(eusNICKMENTIONED));

	// log
	CheckBox_LOGFILE->setChecked(g_pConfig->GetLogFile());
	CheckBox_LOGDOWNLOADS->setChecked(g_pConfig->GetLogFinishedDownloads());
	CheckBox_LOGUPLOADS->setChecked(g_pConfig->GetLogFinishedUploads());
	CheckBox_LOGDETAILS->setChecked(g_pConfig->GetLogDetails());
	LineEdit_LOGFILENAME->setText( g_pConfig->GetLogFileName().Data() );
	CheckBox_TIMESTAMPPRIVATECHAT->setChecked(g_pConfig->GetTimeStamp(etsPRIVATECHAT));
	CheckBox_TIMESTAMPHUBCHAT->setChecked(g_pConfig->GetTimeStamp(etsHUBCHAT));

	GroupBox_CHAT_LOGGING->setChecked( g_pConfig->GetLogChatOption(elcoENABLELOGGING) );
	CheckBox_LOGCHAT_APPENDDATE->setChecked( g_pConfig->GetLogChatOption(elcoAPPENDDATE) );
	CheckBox_LOGCHAT_APPENDHUBNAME->setChecked( g_pConfig->GetLogChatOption(elcoAPPENDHUBNAME) );
	CheckBox_LOGCHAT_APPENDHUBHOST->setChecked( g_pConfig->GetLogChatOption(elcoAPPENDHUBHOST) );
	CheckBox_LOGCHAT_DISABLEPUBLICCHAT->setChecked( g_pConfig->GetLogChatOption(elcoDISABLEPUBLICCHAT) );
	GroupBox_LOGNICKNAMEFILTER->setChecked( g_pConfig->GetLogChatOption(elcoENABLENICKNAMEFILTER) );
	CheckBox_LOGCHAT_NICKNAMEFILTER_ENABLELOGGING->setChecked( g_pConfig->GetLogChatOption(elcoNICKNAMEFILTER_ENABLELOGGING) );

	ListBox_LOGCHAT_NICKNAMEFILTER_LIST->clear();
	ListBox_LOGCHAT_NICKNAMEFILTER_LIST->insertStringList( g_pConfig->GetLogChatNickNameFilter() );

	// other
	CheckBox_HUBLISTSTORELOCAL->setChecked(g_pConfig->GetHubListStoreLocal());
	SpinBox_RELOADHUBLISTTIME->setValue(g_pConfig->GetReloadHubListTime());

	DCConfigHubListUrl * hublisturl = 0;

	CList<DCConfigHubListUrl> hublisturllist;
	g_pConfig->GetHubListUrlList(&hublisturllist);

	while( (hublisturl=hublisturllist.Next(hublisturl)) != 0 )
	{
		QCheckListItem * cli = new QCheckListItem( ListView_HUBLISTURL, hublisturl->sUrl.Data(), QCheckListItem::CheckBox );
		cli->setOn(hublisturl->bEnabled);
	}
	slotHubListUrlsSelectionChanged();

	// security
	SpinBox_FLOODCOUNT->setValue(g_pConfig->GetFloodCount());
	CheckBox_FLOODOPKICK->setChecked(g_pConfig->GetFloodOpKick());
	LineEdit_FLOODOPKICKMESSAGE->setText(QString(g_pConfig->GetFloodOpKickMessage().Data()).remove( "\r" ));
	LineEdit_TRANSFERCERT->setText(g_pConfig->GetTransferCert().Data());
	LineEdit_TRANSFERKEY->setText(g_pConfig->GetTransferKey().Data());
	CheckBox_OLD_DCLIB_SSL_SUPPORT->setChecked(g_pConfig->GetOldSSLSupport());
	LineEdit_DCLIB_PLUGIN_PATH->setText(g_pConfig->GetDCLibPluginPath().Data());

	// init the sound tab
	slotDisableSound();
	
	// auto response settings
	CheckBox_ENABLE_AUTO_RESPONDER->setChecked(g_pConfig->GetAutoResponderEnabled());
	CheckBox_ENABLE_AUTO_RESPONDER_FOR_PM->setChecked(g_pConfig->GetAutoResponderEnabledForPM());
	SpinBox_AUTORESPONSEDELAY->setValue(g_pConfig->GetAutoResponseDelay());
	LineEdit_AUTO_RESPONSE_IGNORE->setText(g_pConfig->GetAutoResponseIgnores());
	
	// fill auto response list box
	QPtrList<DC_AutoResponseObject> arlist;
	arlist.setAutoDelete(true);
	g_pConfig->GetAutoResponses(&arlist);
	
	for ( DC_AutoResponseObject * aro = arlist.first(); aro; aro = arlist.next() )
	{
		QString cs;
		if ( aro->m_bCaseSensitive )
		{
			cs = tr("Yes");
		}
		else
		{
			cs = tr("No");
		}
		qlvitem = new QListViewItem( listView_AUTO_RESPONSES, aro->m_sTrigger, cs, aro->m_sResponse );
		qlvitem->setRenameEnabled(0, true);
		qlvitem->setRenameEnabled(2, true);
	}
	arlist.clear();
	
	ComboBox_REMOTE_ENCODING->setCurrentText( g_pConfig->GetRemoteEncoding().Data() );
	Label_ENCODING_DISABLE_HOWTO->setText( tr("Setting remote encoding to %1 will disable most conversions.").arg(g_pConfig->GetLocalEncoding().Data()) );
	
	CheckBox_FOLDERS_RIGHT_PANE->setChecked(g_pConfig->GetFoldersInRightPane());
	CheckBox_FOLDERS_RIGHT_PANE_ON_TOP->setChecked(g_pConfig->GetFoldersInRightPaneOnTop());
	CheckBox_SIZES_LEFT_PANE->setChecked(g_pConfig->GetFolderSizesInLeftPane());
	
	CheckBox_ENABLE_USERIP2->setChecked(g_pConfig->GetUserIP2Enabled());
	CheckBox_ENABLE_ZPIPE->setChecked(g_pConfig->GetZPipeEnabled());
	
	CheckBox_ADJUST_SR->setChecked(g_pConfig->GetAdjustSearchResultHubNames());
	CheckBox_ENABLE_REMOVE_PUBLIC_HUB->setChecked(g_pConfig->GetRemovePublicHubEnabled());
	ComboBox_TAB_COMPLETE_MATCH_MODE->setCurrentItem(g_pConfig->GetTabCompleteMatchMode());
	CheckBox_TAB_COMPLETE_STRIP_TAGS->setChecked(g_pConfig->GetTabCompleteStripTags());
	
	SpinBox_READFILEBUFFERSIZE->setValue(g_pConfig->GetReadFileBufferSize());
	
	CheckBox_NO_ADCGET_WITHOUT_TTH->setChecked(g_pConfig->GetDisableADCGetWithoutTTH());
	CheckBox_NO_XMLLIST_WITHOUT_TTH->setChecked(g_pConfig->GetDisableXMLListWithoutTTH());
	CheckBox_ENABLE_OBSOLETE_EXT->setChecked( g_pConfig->GetEnableObsoleteExt() );
	CheckBox_THREADS_FOR_SHELL_COMMANDS->setChecked(g_pConfig->GetThreadsForShellCommands());
	SpinBox_SHELL_COMMAND_TIMEOUT->setValue(g_pConfig->GetShellCommandTimeout());
	CheckBox_OPEN_FOLDERS_RIGHT_PANE->setChecked(g_pConfig->GetOpenFoldersInRightPane());
	CheckBox_ENABLE_USERCOMMAND_SUPPORT->setChecked(g_pConfig->GetEnableUserCommand());
	CheckBox_USER_COMMAND_SUBMENU->setChecked(g_pConfig->GetUserCommandSubmenu());
	
	switch ( g_pConfig->GetMagnetAction(eChatMagnet) )
	{
		case eMagnetPrompt:
			ComboBox_CHAT_MAGNETS->setCurrentItem(0);
			break;
		case eMagnetSearch:
			ComboBox_CHAT_MAGNETS->setCurrentItem(1);
			break;
		case eMagnetDownload:
			/* not supported */
			break;
		case eMagnetNothing:
			ComboBox_CHAT_MAGNETS->setCurrentItem(2);
			break;
		default:
			break;
	}
}

/** */
void DCOptions::GetValues()
{
	g_pConfig->SetNick(LineEdit_NICK->text().ascii());
	g_pConfig->SetSearchNick(LineEdit_SEARCHNICK->text().ascii());
	g_pConfig->SetAwayMessage(TextEdit_AWAYMESSAGE->text().replace( "\n", "\xd\xa" ).ascii());
	g_pConfig->SetDescription(LineEdit_DESCRIPTION->text().ascii());
	g_pConfig->SetAwayPrefix(LineEdit_AWAYPREFIX->text().ascii());
	g_pConfig->SetDescriptionTag(CheckBox_DESCRIPTION_TAG->isChecked());
	g_pConfig->SetUseExtendedHubCount(CheckBox_EXT_HUB_COUNT->isChecked());
	g_pConfig->SetEMail(LineEdit_EMAIL->text().ascii());
	g_pConfig->SetAntiSpam(CheckBox_ANTISPAM->isChecked());
	
	if ( ComboBox_PRIVATEADDRESSSPACE->currentItem() == 0 )
	{
		g_pConfig->SetCheckPrivateAddressSpace(false);
		g_pConfig->SetPrivateAddressSpaceOnly(false);
	}
	else if ( ComboBox_PRIVATEADDRESSSPACE->currentItem() == 1 )
	{
		g_pConfig->SetCheckPrivateAddressSpace(true);
		g_pConfig->SetPrivateAddressSpaceOnly(false);
	}
	else if ( ComboBox_PRIVATEADDRESSSPACE->currentItem() == 2 )
	{
		g_pConfig->SetCheckPrivateAddressSpace(false);
		g_pConfig->SetPrivateAddressSpaceOnly(true);
	}
	
	g_pConfig->SetShowChatSendButton(CheckBox_SHOWCHATSENDBUTTON->isChecked());
	g_pConfig->SetCustomBrowser(CheckBox_CUSTOM_BROWSER->isChecked());
	g_pConfig->SetBrowser(LineEdit_BROWSER->text());
	g_pConfig->SetDynamicUploadRate(CheckBox_DYNAMICUPLOADRATE->isChecked());
	g_pConfig->SetShowChatInTab(CheckBox_SHOWCHATINTAB->isChecked());
	g_pConfig->SetChatMaxParagraph(SpinBox_CHATMAXPARAGRAPH->value());
	g_pConfig->SetTransferAutoSearch(CheckBox_TRANSFERAUTOSEARCH->isChecked());
	g_pConfig->SetDisableHashList(CheckBox_DISABLEHASHLIST->isChecked());
	g_pConfig->SetCompressedTransfers(CheckBox_COMPRESSEDTRANSFERS->isChecked());

	g_pConfig->SetUserPhotoFileName(ToolButton_PHOTO->textLabel());

	g_pConfig->SetSpeed(ComboBox_SPEED->currentText().ascii());
	g_pConfig->SetDownloadFolder(LineEdit_DOWNLOADFOLDER->text().ascii());
	g_pConfig->SetDownloadFinishedFolder(LineEdit_DOWNLOADFINISHEDFOLDER->text().ascii());
	g_pConfig->SetMinSegSize( ((ulonglong) SpinBox_MIN_SEG_SIZE->value()) * 1048576 );
	g_pConfig->SetValknutDataPath(LineEdit_DATAFOLDER->text());
	
	g_pConfig->SetAutoRecreateShareList(CheckBox_AUTORECREATESHARELIST->isChecked());
	g_pConfig->SetDontShareDotFiles(CheckBox_DONTSHAREDOTFILES->isChecked());
	g_pConfig->SetRecreateShareListTime(SpinBox_RECREATESHARELISTTIME->value());

	g_pConfig->SetFloodOpKickMessage(LineEdit_FLOODOPKICKMESSAGE->text().replace( "\n", "\xd\xa" ).ascii());
	g_pConfig->SetFloodCount(SpinBox_FLOODCOUNT->value());
	g_pConfig->SetFloodOpKick(CheckBox_FLOODOPKICK->isChecked());

	g_pConfig->SetTransferCert(LineEdit_TRANSFERCERT->text().ascii());
	g_pConfig->SetTransferKey(LineEdit_TRANSFERKEY->text().ascii());
	g_pConfig->SetOldSSLSupport(CheckBox_OLD_DCLIB_SSL_SUPPORT->isChecked());
	g_pConfig->SetDCLibPluginPath(LineEdit_DCLIB_PLUGIN_PATH->text().ascii());

	SaveSharedFolders();
	
	g_pConfig->SetUserMenuCommands( &usercommands );
	/* g_pConfig takes the objects and empties the map */
	
	SaveUserChatCommands();

	g_pConfig->SetAutoResponderEnabled(CheckBox_ENABLE_AUTO_RESPONDER->isChecked());
	g_pConfig->SetAutoResponderEnabledForPM(CheckBox_ENABLE_AUTO_RESPONDER_FOR_PM->isChecked());
	g_pConfig->SetAutoResponseDelay(SpinBox_AUTORESPONSEDELAY->value());
	g_pConfig->SetAutoResponseIgnores(LineEdit_AUTO_RESPONSE_IGNORE->text());
	SaveAutoResponses();

	g_pConfig->SetMaxUpload( SpinBox_MAXSIMULTANEOUSUPLOADS->value() );
	g_pConfig->SetMaxUploadRate( floor((SpinBox_MAXUPLOADRATE->cleanText().toFloat()*1024)+0.5) );
	g_pConfig->SetMaxDownloadRate( floor((SpinBox_MAXDOWNLOADRATE->cleanText().toFloat()*1024)+0.5) );
	g_pConfig->SetDownloadQueueTime(SpinBox_SAVEDOWNLOADQUEUETIME->value());
	g_pConfig->SetAutoSearchInterval(SpinBox_AUTOSEARCHINTERVAL->value());
	g_pConfig->SetSmallFileSize(SpinBox_SMALLFILESIZE->value());

	g_pConfig->SetExtraSlotsRate( 1024 * ((ulonglong) SpinBox_EXTRA_SLOTS_RATE->value()) );
	g_pConfig->SetMaxExtraSlots( SpinBox_MAX_EXTRA_SLOTS->value() );

	g_pConfig->SetTCPListenPort(SpinBox_TCPLISTENPORT->value());
	g_pConfig->SetCryptoListenPort(SpinBox_CRYPTO_PORT->value());
	g_pConfig->SetUDPListenPort(SpinBox_UDPLISTENPORT->value());
	g_pConfig->SetExternalIP(RadioButton_IPHOSTNAME->isOn());

	if ( RadioButton_ACTIVEMODE->isOn() )
		g_pConfig->SetMode(ecmACTIVE);
	else
		g_pConfig->SetMode(ecmPASSIVE);

	g_pConfig->SetHost(LineEdit_IP->text().ascii());
	g_pConfig->SetListenHost(LineEdit_LISTENIP->text().ascii());	
	g_pConfig->SetSendMessageOnActiveModeRequest(CheckBox_SENDMESSAGEONACTIVEMODEREQUEST->isChecked());

	// gui settings
	g_pConfig->SetOpenPrivateChatWindow(CheckBox_OPENPRIVATECHATWINDOW->isChecked());
	g_pConfig->SetEnableEmoticons(CheckBox_EMOTICONS->isChecked());

	if ( RadioButton_UNITBYTE->isChecked() )
		g_pConfig->SetUnit(euBYTE);
	else if ( RadioButton_UNITKBYTE->isChecked() )
		g_pConfig->SetUnit(euKBYTE);
	else if ( RadioButton_UNITMBYTE->isChecked() )
		g_pConfig->SetUnit(euMBYTE);
	else if ( RadioButton_UNITGBYTE->isChecked() )
		g_pConfig->SetUnit(euGBYTE);
	else
		g_pConfig->SetUnit(euAUTO);
	
	g_pConfig->SetTheme(ComboBox_THEME->currentText());
	g_pConfig->SetSendChat(ComboBox_SENDCHAT->currentItem());
	g_pConfig->SetLanguageFile(LineEdit_LANGUAGEFILE->text());
	g_pConfig->SetShowStatusMessage(CheckBox_SHOWSTATUSMESSAGE->isChecked());
	g_pConfig->SetQueryOnExit(CheckBox_QUERYONEXIT->isChecked());
	g_pConfig->SetQueryOnFileDelete(CheckBox_QUERYONFILEDELETE->isChecked());
	g_pConfig->SetSendHidePrivateChatToPublicChat(CheckBox_SENDHIDEPRIVATECHATTOPUBLICCHAT->isChecked());
	g_pConfig->SetChatSendOfflineMessages(CheckBox_CHATSENDOFFLINEMESSAGES->isChecked());
	g_pConfig->SetChatRecvOfflineMessages(CheckBox_CHATRECVOFFLINEMESSAGES->isChecked());
	g_pConfig->SetChatMessageMaxLines( SpinBox_CHATMESSAGEMAXLINES->value() );
	g_pConfig->SetSuppressedNicks( LineEdit_SUPPRESS_NICKS->text() );
	g_pConfig->SetSendUnknownCommandsAsChat( CheckBox_SENDUNKNOWNCOMMANDS->isChecked() );
	g_pConfig->SetAllowedUnknownCommands( LineEdit_ALLOWED_UNKNOWN_COMMANDS->text() );

	// sound settings
	g_pConfig->SetSoundDisabled(CheckBox_SOUNDDISABLED->isChecked());
	g_pConfig->SetSoundDisabledAway(CheckBox_SOUNDDISABLEDAWAY->isChecked());

	g_pConfig->SetSoundEnabled(eusCONNECT,GroupBox_SOUNDPLAYCONNECT->isChecked());
	g_pConfig->SetSoundEnabled(eusDISCONNECT,GroupBox_SOUNDPLAYDISCONNECT->isChecked());
	g_pConfig->SetSoundEnabled(eusSEND,GroupBox_SOUNDPLAYSEND->isChecked());
	g_pConfig->SetSoundEnabled(eusRECEIVE,GroupBox_SOUNDPLAYRECEIVE->isChecked());
	g_pConfig->SetSoundEnabled(eusFIRSTRECEIVE,GroupBox_SOUNDPLAYFIRSTRECEIVE->isChecked());
	g_pConfig->SetSoundEnabled(eusNICKMENTIONED,GroupBox_SOUNDPLAYNICKMENTIONED->isChecked());

	g_pConfig->SetExternalSoundPlayer(GroupBox_EXTERNALPLAYER->isChecked());
	g_pConfig->SetExternalPlayer(LineEdit_EXTERNALPLAYER->text());
	g_pConfig->SetSoundFile( eusCONNECT, LineEdit_SOUNDFILECONNECT->text());
	g_pConfig->SetSoundFile( eusDISCONNECT, LineEdit_SOUNDFILEDISCONNECT->text());
	g_pConfig->SetSoundFile( eusSEND, LineEdit_SOUNDFILESEND->text());
	g_pConfig->SetSoundFile( eusRECEIVE, LineEdit_SOUNDFILERECEIVE->text());
	g_pConfig->SetSoundFile( eusFIRSTRECEIVE, LineEdit_SOUNDFILEFIRSTRECEIVE->text());
	g_pConfig->SetSoundFile( eusNICKMENTIONED, LineEdit_SOUNDFILENICKMENTIONED->text());

	g_pConfig->SetAppFont(LineEdit_APPFONT->text());
	g_pConfig->SetUseCustomFont(GroupBox_APPFONT->isChecked());

	// gui->chat
	g_pConfig->SetChatShowJoinsAndParts(CheckBox_CHATSHOWJOINSANDPARTS->isChecked());
	g_pConfig->SetChatShowJoinsAndPartsOnlyFav(CheckBox_CHATSHOWJOINSANDPARTSONLYFAV->isChecked());
	
	// gui->client
	g_pConfig->SetOpenClientWindows(ComboBox_OPEN_CLIENT_WINDOWS_HOW->currentItem());
	g_pConfig->SetUserListRightAlignment(CheckBox_USERLISTRIGHTALIGNMENT->isChecked());
	g_pConfig->SetAutoAwayMode(CheckBox_AUTOAWAYMODE->isChecked());
	g_pConfig->SetAutoAwayTime(SpinBox_AUTOAWAYTIME->value());
	g_pConfig->SetClientColumn(eclcCOMMENT,CheckBox_CLIENTCOLUMNS_COMMENT->isChecked());
	g_pConfig->SetClientColumn(eclcTAG,CheckBox_CLIENTCOLUMNS_TAG->isChecked());
	g_pConfig->SetClientColumn(eclcSPEED,CheckBox_CLIENTCOLUMNS_SPEED->isChecked());
	g_pConfig->SetClientColumn(eclcEMAIL,CheckBox_CLIENTCOLUMNS_EMAIL->isChecked());
	g_pConfig->SetClientColumn(eclcSHARE,CheckBox_CLIENTCOLUMNS_SHARE->isChecked());
	g_pConfig->SetClientColumn(eclcIP,CheckBox_CLIENTCOLUMNS_IP->isChecked());
	g_pConfig->SetClientColumn(eclcLOCKPK,CheckBox_CLIENTCOLUMNS_LOCKPK->isChecked());
	g_pConfig->SetClientColumn(eclcSUPPORTS,CheckBox_CLIENTCOLUMNS_SUPPORTS->isChecked());
	g_pConfig->SetDoubleClickAction(ComboBox_DOUBLECLICK->currentItem());
	
	QString oldappicons = g_pConfig->GetApplicationIconTheme();
	QString oldemoticons = g_pConfig->GetEmoticonTheme();
	
	// gui->icons
	if ( ComboBox_APPLICATION_ICONS->count() > 0 )
	{
		g_pConfig->SetApplicationIconTheme(ComboBox_APPLICATION_ICONS->currentText());
	}
	if ( ComboBox_EMOTICONS->count() > 0 )
	{
		g_pConfig->SetEmoticonTheme(ComboBox_EMOTICONS->currentText());
	}
	if ( ComboBox_USERLIST_ICONS->count() > 0 )
	{
		g_pConfig->SetUserListIconTheme(ComboBox_USERLIST_ICONS->currentText());
	}
	
	if ( oldappicons != g_pConfig->GetApplicationIconTheme() )
	{
		// reload icons with new theme
		g_pIconLoader->Load();
	}
	
	// reload emoticons
	if ( g_pConfig->GetEmoticonTheme() != oldemoticons )
	{
		g_pConfig->InitMimeSourceFactory();
	}
	
	// log settings
	g_pConfig->SetLogFile(CheckBox_LOGFILE->isChecked());
	g_pConfig->SetLogFinishedDownloads(CheckBox_LOGDOWNLOADS->isChecked());
	g_pConfig->SetLogFinishedUploads(CheckBox_LOGUPLOADS->isChecked());
	g_pConfig->SetLogDetails(CheckBox_LOGDETAILS->isChecked());
	g_pConfig->SetLogFileName( LineEdit_LOGFILENAME->text().ascii() );
	g_pConfig->SetTimeStamp(etsPRIVATECHAT,CheckBox_TIMESTAMPPRIVATECHAT->isChecked());
	g_pConfig->SetTimeStamp(etsHUBCHAT,CheckBox_TIMESTAMPHUBCHAT->isChecked());

	g_pConfig->SetLogChatOption(elcoENABLELOGGING, GroupBox_CHAT_LOGGING->isChecked() );
	g_pConfig->SetLogChatOption(elcoAPPENDDATE, CheckBox_LOGCHAT_APPENDDATE->isChecked() );
	g_pConfig->SetLogChatOption(elcoAPPENDHUBNAME, CheckBox_LOGCHAT_APPENDHUBNAME->isChecked() );
	g_pConfig->SetLogChatOption(elcoAPPENDHUBHOST, CheckBox_LOGCHAT_APPENDHUBHOST->isChecked() );
	g_pConfig->SetLogChatOption(elcoDISABLEPUBLICCHAT, CheckBox_LOGCHAT_DISABLEPUBLICCHAT->isChecked() );
	g_pConfig->SetLogChatOption(elcoENABLENICKNAMEFILTER, GroupBox_LOGNICKNAMEFILTER->isChecked() );
	g_pConfig->SetLogChatOption(elcoNICKNAMEFILTER_ENABLELOGGING, CheckBox_LOGCHAT_NICKNAMEFILTER_ENABLELOGGING->isChecked() );

	unsigned int i = 0;
	QStringList nnflist;
	for ( i = 0; i < ListBox_LOGCHAT_NICKNAMEFILTER_LIST->count(); i++ )
	{
		nnflist << ListBox_LOGCHAT_NICKNAMEFILTER_LIST->text(i);
	}

	g_pConfig->SetLogChatNickNameFilter( nnflist );

	// other settings
	g_pConfig->SetHubListStoreLocal(CheckBox_HUBLISTSTORELOCAL->isChecked());
	g_pConfig->SetReconnectCount( SpinBox_RECONNECTCOUNT->value() );
	g_pConfig->SetReconnectTimeout( SpinBox_RECONNECTTIMEOUT->value() );
	g_pConfig->SetTransferResendTimeout(SpinBox_TRANSFERRESENDTIMEOUT->value());
	g_pConfig->SetTransferResponseTimeout(SpinBox_TRANSFERRESPONSETIMEOUT->value());
	g_pConfig->SetForceMoveEnabled(CheckBox_FORCEMOVEENABLED->isChecked());
	g_pConfig->SetReloadHubListTime(SpinBox_RELOADHUBLISTTIME->value());

	// transfer view settings
	g_pConfig->SetTransferViewOptions(etvoCHUNKPERCENT,CheckBox_TV_PERCENTCHUNK->isChecked());
	g_pConfig->SetTransferViewOptions(etvoFILEPERCENT,CheckBox_TV_PERCENTFILE->isChecked());
	g_pConfig->SetTransferViewOptions(etvoCHUNKSIZE,CheckBox_TV_CHUNKSIZE->isChecked());
	g_pConfig->SetTransferViewOptions(etvoFILESIZE,CheckBox_TV_FILESIZE->isChecked());
	g_pConfig->SetTransferViewOptions(etvoDOWNLOADRATESINGLE,CheckBox_TV_DOWNLOADRATESINGLE->isChecked());
	g_pConfig->SetTransferViewOptions(etvoELAPSEDTIMESINGLE,CheckBox_TV_ELAPSEDTIMESINGLE->isChecked());
	g_pConfig->SetTransferViewOptions(etvoDOWNLOADRATEMULTI,CheckBox_TV_DOWNLOADRATEMULTI->isChecked());
	g_pConfig->SetTransferViewOptions(etvoELAPSEDTIMEMULTI,CheckBox_TV_ELAPSEDTIMEMULTI->isChecked());
	g_pConfig->SetUserUploadSlots(SpinBox_USERUPLOADSLOTS->value());

        if ( RadioButton_NONE->isChecked() )
		g_pConfig->SetHubOfflineTransferClose( ectNONE );
	else if ( RadioButton_UPLOAD->isChecked() )
		g_pConfig->SetHubOfflineTransferClose( ectUPLD );
	else if ( RadioButton_DOWNLOAD->isChecked() )
		g_pConfig->SetHubOfflineTransferClose( ectDLD );
	else if ( RadioButton_BOTH->isChecked() )
		g_pConfig->SetHubOfflineTransferClose( ectBOTH );

	CList<DCConfigHubListUrl> hublisturllist;

	QCheckListItem * cli = (QCheckListItem*)ListView_HUBLISTURL->firstChild();

	while(cli)
	{
		DCConfigHubListUrl * hublisturl = new DCConfigHubListUrl();

		hublisturl->sUrl     = cli->text(0);
		hublisturl->bEnabled = cli->isOn();

		hublisturllist.Add(hublisturl);

		cli = (QCheckListItem*)cli->nextSibling();
	}

	g_pConfig->SetHubListUrlList(&hublisturllist);

	i=0;

	g_pConfig->SetChatColor(eccCHATTIMESTAMP,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccCHATLOCALNICK,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccCHATLOCALTEXT,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccCHATREMOTENICK,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccCHATREMOTETEXT,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccCHATSTATUSNICK,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccCHATSTATUSTEXT,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICCHATTIMESTAMP,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICCHATLOCALNICK,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICCHATLOCALTEXT,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICCHATREMOTENICK,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICCHATREMOTETEXT,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICCHATSTATUSNICK,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICCHATSTATUSTEXT,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICPRIVATECHATNICK,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICPRIVATECHATTEXT,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccCHATSAY,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICCHATMENICK,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccOPNICK,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name());
	
	g_pConfig->SetChatBackgroundColor( CheckBox_ENABLE_CHAT_BG_COLOR->isChecked(), QColor(ToolButton_CHAT_BG_COLOR->iconSet().pixmap( QIconSet::Small, QIconSet::Normal ).convertToImage().pixel(0,0)).name() );
	
	g_pConfig->SetRemoteEncoding(ComboBox_REMOTE_ENCODING->currentText().ascii());
	
	g_pConfig->SetFoldersInRightPane(CheckBox_FOLDERS_RIGHT_PANE->isChecked());
	g_pConfig->SetFoldersInRightPaneOnTop(CheckBox_FOLDERS_RIGHT_PANE_ON_TOP->isChecked());
	g_pConfig->SetFolderSizesInLeftPane(CheckBox_SIZES_LEFT_PANE->isChecked());
	
	g_pConfig->SetUserIP2Enabled(CheckBox_ENABLE_USERIP2->isChecked());
	g_pConfig->SetZPipeEnabled(CheckBox_ENABLE_ZPIPE->isChecked());
	g_pConfig->SetAdjustSearchResultHubNames(CheckBox_ADJUST_SR->isChecked());
	
	/* If this has been turned off, we need to save the public hub list now */
	if ( (CheckBox_ENABLE_REMOVE_PUBLIC_HUB->isChecked() == false) && g_pConfig->GetRemovePublicHubEnabled() )
	{
		g_pConfig->SaveDCPublicHub();
	}
	g_pConfig->SetRemovePublicHubEnabled(CheckBox_ENABLE_REMOVE_PUBLIC_HUB->isChecked());
	
	g_pConfig->SetTabCompleteMatchMode(ComboBox_TAB_COMPLETE_MATCH_MODE->currentItem());
	g_pConfig->SetTabCompleteStripTags(CheckBox_TAB_COMPLETE_STRIP_TAGS->isChecked());
	
	g_pConfig->SetReadFileBufferSize(SpinBox_READFILEBUFFERSIZE->value());
	
	g_pConfig->SetDisableADCGetWithoutTTH(CheckBox_NO_ADCGET_WITHOUT_TTH->isChecked());
	g_pConfig->SetDisableXMLListWithoutTTH(CheckBox_NO_XMLLIST_WITHOUT_TTH->isChecked());
	g_pConfig->SetEnableObsoleteExt( CheckBox_ENABLE_OBSOLETE_EXT->isChecked() );
	g_pConfig->SetThreadsForShellCommands(CheckBox_THREADS_FOR_SHELL_COMMANDS->isChecked());
	g_pConfig->SetShellCommandTimeout(SpinBox_SHELL_COMMAND_TIMEOUT->value());
	g_pConfig->SetOpenFoldersInRightPane(CheckBox_OPEN_FOLDERS_RIGHT_PANE->isChecked());
	g_pConfig->SetEnableUserCommand(CheckBox_ENABLE_USERCOMMAND_SUPPORT->isChecked());
	g_pConfig->SetUserCommandSubmenu(CheckBox_USER_COMMAND_SUBMENU->isChecked());
	
	switch ( ComboBox_CHAT_MAGNETS->currentItem() )
	{
		case 0:
			g_pConfig->SetMagnetAction( eMagnetPrompt, eChatMagnet );
			break;
		case 1:
			g_pConfig->SetMagnetAction( eMagnetSearch, eChatMagnet );
			break;
		case 2:
			g_pConfig->SetMagnetAction( eMagnetNothing, eChatMagnet );
			break;
		default:
			break;
	}
}

/** */
void DCOptions::SaveSharedFolders()
{
	CList<DCConfigShareFolder> sharedfolders;
	DCConfigShareFolder * csf;

	// save shared folders
	sharedfolders.Clear();

	QListViewItemIterator it( ListView_SHAREDFOLDERS );

	for ( ; it.current(); ++it )
	{
		csf = new DCConfigShareFolder();
		csf->m_sPath  = it.current()->text(0).ascii();
		csf->m_sAlias = it.current()->text(1).ascii();
		sharedfolders.Add(csf);
	}

	g_pConfig->SetSharedFolders( &sharedfolders );
}

void DCOptions::SaveUserChatCommands()
{
	QPtrList<DC_UserChatCommand> commands;
	DC_UserChatCommand * ucc;
	
	QListViewItemIterator it( listView_CHAT_COMMANDS );
	
	for ( ; it.current(); ++it )
	{
		ucc = new DC_UserChatCommand();
		ucc->m_sName    = it.current()->text(0);
		ucc->m_sCommand = it.current()->text(1);
		
		commands.append(ucc);
	}
	
	/* transfer ownership of objects to g_pConfig */
	g_pConfig->SetUserChatCommands( &commands );
}

void DCOptions::SaveAutoResponses()
{
	QPtrList<DC_AutoResponseObject> autoresponses;
	DC_AutoResponseObject * aro = 0;
	
	QListViewItemIterator it( listView_AUTO_RESPONSES );
	for ( ; it.current(); ++it )
	{
		aro = new DC_AutoResponseObject();
		aro->m_sTrigger = it.current()->text(0);
		if (it.current()->text(1) == tr("Yes"))
		{
			aro->m_bCaseSensitive = true;
		}
		else
		{
			aro->m_bCaseSensitive = false;
		}
		aro->m_sResponse = it.current()->text(2);
		
		autoresponses.append(aro);
	}
	
	/* transfer ownership of objects to g_pConfig */
	g_pConfig->SetAutoResponses( &autoresponses );
}

/** */
void DCOptions::slotCreateShareList()
{
	/* need to save these settings for them to be used during the refresh */
	g_pConfig->SetDontShareDotFiles(CheckBox_DONTSHAREDOTFILES->isChecked());
	g_pConfig->SetDisableHashList(CheckBox_DISABLEHASHLIST->isChecked());
	
	SaveSharedFolders();

	if ( CFileManager::Instance() )
	{
		CFileManager::Instance()->CreateShareList();
	}
}

/** */
void DCOptions::slotShareListInfo()
{
	QString s = tr("Compressed list size (HE3/BZ/XML): ") +
		QString().setNum(CFileManager::Instance()->GetShareBufferSize(esbtHE3)) + "/" +
		QString().setNum(CFileManager::Instance()->GetShareBufferSize(esbtBZ)) + "/" +
		QString().setNum(CFileManager::Instance()->GetShareBufferSize(esbtXMLBZ)) + " " +
		tr("bytes") + "\n" +
		tr("Total shared: ") +
		DCGuiUtils::GetSizeString(CFileManager::Instance()->GetShareSize());
	
	QMessageBox::information( this, tr("Share List Info"), s );
}

/** */
void DCOptions::slotSetTheme()
{
	if ( g_pConfig->GetThemeSupport() )
	{
		QString s = ComboBox_THEME->currentText();

		if ( !s.isEmpty() )
		{
			QApplication::setStyle(s);
			m_sTestedTheme = s;
		}
	}
}

/** */
void DCOptions::slotBrowseLanguageFile()
{
	QString file = QFileDialog::getOpenFileName( LineEdit_LANGUAGEFILE->text(), "Language File (*.qm)", this, "blf", tr("Select language file") );

	if ( !file.isEmpty() )
	{
		LineEdit_LANGUAGEFILE->setText(file);
	}
}

/** */
void DCOptions::slotSelectLanguage()
{
	QString s;

	QPopupMenu * m = new QPopupMenu(this);

	DCMenuHandler::InsertMenu( m, emiLANGUAGE_BOSNIAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_BRAZILIAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_CZECH );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_DANISH );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_DUTCH );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_ENGLISH );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_FINNISH );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_FRENCH );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_GERMAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_GREEK );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_HUNGARIAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_ICELANDIC );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_ITALIAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_LATVIAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_NORWEGIAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_POLISH );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_ROMANIAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_RUSSIAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_SERBIAN_CYRILLIC );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_SERBIAN_LATIN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_SLOVAKIAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_SPANISH );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_SWEDISH );

	int id = m->exec(QCursor::pos());

	delete m;

	if ( id == emiLANGUAGE_BOSNIAN )
		s = "valknut.bs.qm";
	else if ( id == emiLANGUAGE_BRAZILIAN )
		s = "valknut.pt_br.qm";
	else if ( id == emiLANGUAGE_CZECH )
		s = "valknut.cs.qm";
	else if ( id == emiLANGUAGE_DANISH )
		s = "valknut.da.qm";
	else if ( id == emiLANGUAGE_DUTCH )
		s = "valknut.nl.qm";
	else if ( id == emiLANGUAGE_ENGLISH )
		s = "";
	else if ( id == emiLANGUAGE_FINNISH )
		s = "valknut.fi.qm";
	else if ( id == emiLANGUAGE_FRENCH )
		s = "valknut.fr.qm";
	else if ( id == emiLANGUAGE_GERMAN )
		s = "valknut.de.qm";
	else if ( id == emiLANGUAGE_GREEK )
		s = "valknut.el.qm";
	else if ( id == emiLANGUAGE_HUNGARIAN )
		s = "valknut.hu.qm";
	else if ( id == emiLANGUAGE_ICELANDIC )
		s = "valknut.is.qm";
	else if ( id == emiLANGUAGE_ITALIAN )
		s = "valknut.it.qm";
	else if ( id == emiLANGUAGE_LATVIAN )
		s = "valknut.lv.qm";
	else if ( id == emiLANGUAGE_NORWEGIAN )
		s = "valknut.nb.qm";
	else if ( id == emiLANGUAGE_POLISH )
		s = "valknut.pl.qm";
	else if ( id == emiLANGUAGE_ROMANIAN )
		s = "valknut.ro.qm";
	else if ( id == emiLANGUAGE_RUSSIAN )
		s = "valknut.rus.qm";
	else if ( id == emiLANGUAGE_SERBIAN_CYRILLIC )
		s = "valknut.sr.qm";
	else if ( id == emiLANGUAGE_SERBIAN_LATIN )
		s = "valknut.sr@latin.qm";
	else if ( id == emiLANGUAGE_SLOVAKIAN )
		s = "valknut.sk.qm";
	else if ( id == emiLANGUAGE_SPANISH )
		s = "valknut.es.qm";
	else if ( id == emiLANGUAGE_SWEDISH )
		s = "valknut.sv.qm";

	if ( !s.isEmpty() )
	{
		LineEdit_LANGUAGEFILE->setText(LineEdit_DATAFOLDER->text()+DIRSEPARATOR+"translation"+DIRSEPARATOR+s);
	}
	else if ( id == emiLANGUAGE_ENGLISH )
	{
		LineEdit_LANGUAGEFILE->clear();
	}
}

/** */
void DCOptions::slotBrowseAppFont()
{
	bool ok;
	QFont font = QFontDialog::getFont(&ok, QApplication::font(), this);
	if ( ok )
	{
		LineEdit_APPFONT->setText(font.toString());
	}
}

/** */
void DCOptions::slotAddHubListUrl()
{
	bool ok = false;
	QString url = QInputDialog::getText(
		tr("HubList URL"),
		tr("Please enter a url"),
		QLineEdit::Normal, QString::null, &ok, this );

	if (ok)
	{
		new QCheckListItem( ListView_HUBLISTURL, url, QCheckListItem::CheckBox );
	}
}

/** */
void DCOptions::slotEditHubListUrl()
{
	editHubListUrl( ListView_HUBLISTURL->currentItem() );
}

/** */
void DCOptions::editHubListUrl( QListViewItem * item )
{
	if ( !item )
		return;

	bool ok = false;
	QString url = QInputDialog::getText(
		tr("HubList URL"),
		tr("Edit url"),
		QLineEdit::Normal, item->text(0), &ok, this );

	if (ok)
	{
		item->setText(0,url);
	}
}

/** */
void DCOptions::slotRemoveHubListUrl()
{
	QListViewItem * item = ListView_HUBLISTURL->currentItem();

	if (item)
	{
		delete item;
	}
}

/** */
void DCOptions::slotDoubleClickedHubListUrl( QListViewItem * item, const QPoint & /* pos */, int /* col */ )
{
	if ( item )
	{
		editHubListUrl( item );
	}
	else
	{
		slotAddHubListUrl();
	}
}

/** */
void DCOptions::slotContextMenuHubListUrl( QListViewItem * item, const QPoint & /* pos */, int /* col */ )
{
	QPopupMenu * m = new QPopupMenu(this);
	bool enabled = (item != 0);
	
	DCMenuHandler::InsertMenu( m, emiADD );
	DCMenuHandler::InsertMenu( m, emiEDIT, enabled );
	DCMenuHandler::InsertMenu( m, emiREMOVE, enabled );
	
	int id = m->exec(QCursor::pos());
	
	delete m;
	
	if ( id == -1 )
	{
		return;
	}
	else if ( id == emiADD )
	{
		slotAddHubListUrl();
	}
	else if ( id == emiEDIT )
	{
		editHubListUrl( item );
	}
	else if ( id == emiREMOVE )
	{
		delete item;
	}
}

/** */
void DCOptions::slotHubListUrlsSelectionChanged()
{
	if ( ListView_HUBLISTURL->selectedItem() )
	{
		ToolButton_EDITHUBLISTURL->setEnabled(true);
		ToolButton_REMOVEHUBLISTURL->setEnabled(true);
	}
	else
	{
		ToolButton_EDITHUBLISTURL->setEnabled(false);
		ToolButton_REMOVEHUBLISTURL->setEnabled(false);
	}
}

/** */
void DCOptions::slotListViewOptionCurrentChanged( QListViewItem * item )
{
	if ( item == plviIdentify )
	{
		TabWidget_DCGUI->setCurrentPage(0);
	}
	else if ( item == plviTransfer )
	{
		TabWidget_DCGUI->setCurrentPage(1);
	}
	else if ( item == plviTransferShares )
	{
		TabWidget_DCGUI->setCurrentPage(1);
		TabWidget_TRANSFER->setCurrentPage(0);
	}
	else if ( item == plviTransferDownloads )
	{
		TabWidget_DCGUI->setCurrentPage(1);
		TabWidget_TRANSFER->setCurrentPage(1);
	}
	else if ( item == plviTransferUploads )
	{
		TabWidget_DCGUI->setCurrentPage(1);
		TabWidget_TRANSFER->setCurrentPage(2);
	}
	else if ( item == plviTransferSettings )
	{
		TabWidget_DCGUI->setCurrentPage(1);
		TabWidget_TRANSFER->setCurrentPage(3);
	}
	else if ( item == plviConnection )
	{
		TabWidget_DCGUI->setCurrentPage(2);
	}
	else if ( item == plviConnectionMode )
	{
		TabWidget_DCGUI->setCurrentPage(2);
		TabWidget_CONNECTION->setCurrentPage(0);
	}
	else if ( item == plviConnectionSettings )
	{
		TabWidget_DCGUI->setCurrentPage(2);
		TabWidget_CONNECTION->setCurrentPage(1);
	}
	else if ( item == plviGUI )
	{
		TabWidget_DCGUI->setCurrentPage(3);
	}
	else if ( item == plviGUIUser )
	{
		TabWidget_DCGUI->setCurrentPage(3);
		TabWidget_GUI->setCurrentPage(5);
	}
	else if ( item == plviGUIMenus )
	{
		TabWidget_DCGUI->setCurrentPage(3);
		TabWidget_GUI->setCurrentPage(4);
	}
	else if ( item == plviGUIChat )
	{
		TabWidget_DCGUI->setCurrentPage(3);
		TabWidget_GUI->setCurrentPage(2);
	}
	else if (item == plviGUICommands )
	{
		TabWidget_DCGUI->setCurrentPage(3);
		TabWidget_GUI->setCurrentPage(3);
	}
	else if ( item == plviGUITransfer )
	{
		TabWidget_DCGUI->setCurrentPage(3);
		TabWidget_GUI->setCurrentPage(1);
	}
	else if ( item == plviGUIGeneral )
	{
		TabWidget_DCGUI->setCurrentPage(3);
		TabWidget_GUI->setCurrentPage(0);
	}
	else if ( item == plviGUIIcons )
	{
		TabWidget_DCGUI->setCurrentPage(3);
		TabWidget_GUI->setCurrentPage(6);
	}
	else if ( item == plviGUIFilelistBrowser )
	{
		TabWidget_DCGUI->setCurrentPage(3);
		TabWidget_GUI->setCurrentPage(7);
	}
	else if ( item == plviSound )
	{
		TabWidget_DCGUI->setCurrentPage(4);
	}
	else if ( item == plviLog )
	{
		TabWidget_DCGUI->setCurrentPage(5);
	}
	else if ( item == plviHubLists )
	{
		TabWidget_DCGUI->setCurrentPage(6);
	}
	else if ( item == plviSecurity )
	{
		TabWidget_DCGUI->setCurrentPage(7);
	}
	else if ( item == plviAutoResponse )
	{
		TabWidget_DCGUI->setCurrentPage(8);
	}
	else if ( item == plviOther )
	{
		TabWidget_DCGUI->setCurrentPage(9);
	}
}

/** */
void DCOptions::slotTabWidgetDCGUICurrentChanged( QWidget * widget )
{
	int index = TabWidget_DCGUI->indexOf( widget );
	
	disconnectOptionsListView();
	
	switch ( index )
	{
		case 0:
		{
			ListView_OPTIONTREE->setCurrentItem( plviIdentify );
			ListView_OPTIONTREE->setSelected( plviIdentify, true );
			break;
		}
		case 1:
		{
			slotTabWidgetTransferCurrentChanged( TabWidget_TRANSFER->currentPage() );
			break;
		}
		case 2:
		{
			slotTabWidgetConnectionCurrentChanged( TabWidget_CONNECTION->currentPage() );
			break;
		}
		case 3:
		{
			slotTabWidgetGUICurrentChanged( TabWidget_GUI->currentPage() );
			break;
		}
		case 4:
		{
			ListView_OPTIONTREE->setCurrentItem( plviSound );
			ListView_OPTIONTREE->setSelected( plviSound, true );
			break;
		}
		case 5:
		{
			ListView_OPTIONTREE->setCurrentItem( plviLog );
			ListView_OPTIONTREE->setSelected( plviLog, true);
			break;
		}
		case 6:
		{
			ListView_OPTIONTREE->setCurrentItem( plviHubLists );
			ListView_OPTIONTREE->setSelected( plviHubLists, true );
			break;
		}
		case 7:
		{
			ListView_OPTIONTREE->setCurrentItem( plviSecurity );
			ListView_OPTIONTREE->setSelected( plviSecurity, true );
			break;
		}
		case 8:
		{
			ListView_OPTIONTREE->setCurrentItem( plviAutoResponse );
			ListView_OPTIONTREE->setSelected( plviAutoResponse, true );
			break;
		}
		case 9:
		{
			ListView_OPTIONTREE->setCurrentItem( plviOther );
			ListView_OPTIONTREE->setSelected( plviOther, true );
			break;
		}
		default:
		{
			break;
		}
	}
	
	connectOptionsListView();
}

/** */
void DCOptions::slotTabWidgetTransferCurrentChanged( QWidget * widget )
{
	int index = TabWidget_TRANSFER->indexOf( widget );
	
	disconnectOptionsListView();
	
	switch ( index )
	{
		case 0:
		{
			ListView_OPTIONTREE->setCurrentItem( plviTransferShares );
			ListView_OPTIONTREE->setSelected( plviTransferShares, true );
			break;
		}
		case 1:
		{
			ListView_OPTIONTREE->setCurrentItem( plviTransferDownloads );
			ListView_OPTIONTREE->setSelected( plviTransferDownloads, true );
			break;
		}
		case 2:
		{
			ListView_OPTIONTREE->setCurrentItem( plviTransferUploads );
			ListView_OPTIONTREE->setSelected( plviTransferUploads, true );
			break;
		}
		case 3:
		{
			ListView_OPTIONTREE->setCurrentItem( plviTransferSettings );
			ListView_OPTIONTREE->setSelected( plviTransferSettings, true );
			break;
		}
		default :
		{
			break;
		}
	}
	
	connectOptionsListView();
}

/** */
void DCOptions::slotTabWidgetConnectionCurrentChanged( QWidget * widget )
{
	int index = TabWidget_CONNECTION->indexOf( widget );
	
	disconnectOptionsListView();
	
	switch ( index )
	{
		case 0:
		{
			ListView_OPTIONTREE->setCurrentItem( plviConnectionMode );
			ListView_OPTIONTREE->setSelected( plviConnectionMode, true );
			break;
		}
		case 1:
		{
			ListView_OPTIONTREE->setCurrentItem( plviConnectionSettings );
			ListView_OPTIONTREE->setSelected( plviConnectionSettings, true );
			break;
		}
		default:
		{
			break;
		}
	}
	
	connectOptionsListView();
}

/** */
void DCOptions::slotTabWidgetGUICurrentChanged( QWidget * widget )
{
	int index = TabWidget_GUI->indexOf( widget );
	
	disconnectOptionsListView();
	
	switch ( index )
	{
		case 0:
		{
			ListView_OPTIONTREE->setCurrentItem( plviGUIGeneral );
			ListView_OPTIONTREE->setSelected( plviGUIGeneral, true );
			break;
		}
		case 1:
		{
			ListView_OPTIONTREE->setCurrentItem( plviGUITransfer );
			ListView_OPTIONTREE->setSelected( plviGUITransfer, true );
			break;
		}
		case 2:
		{
			ListView_OPTIONTREE->setCurrentItem( plviGUIChat );
			ListView_OPTIONTREE->setSelected( plviGUIChat, true );
			break;
		}
		case 3:
		{
			ListView_OPTIONTREE->setCurrentItem( plviGUICommands );
			ListView_OPTIONTREE->setSelected( plviGUICommands, true );
			break;
		}
		case 4:
		{
			ListView_OPTIONTREE->setCurrentItem( plviGUIMenus );
			ListView_OPTIONTREE->setSelected( plviGUIMenus, true );
			break;
		}
		case 5:
		{
			ListView_OPTIONTREE->setCurrentItem( plviGUIUser );
			ListView_OPTIONTREE->setSelected( plviGUIUser, true );
			break;
		}
		case 6:
		{
			ListView_OPTIONTREE->setCurrentItem( plviGUIIcons );
			ListView_OPTIONTREE->setSelected( plviGUIIcons, true );
			break;
		}
		case 7:
		{
			ListView_OPTIONTREE->setCurrentItem( plviGUIFilelistBrowser );
			ListView_OPTIONTREE->setSelected( plviGUIFilelistBrowser, true );
			break;
		}
		default:
		{
			break;
		}
	}
	
	connectOptionsListView();
}

/** */
void DCOptions::slotAddUserMenuCommand()
{
	DCUserCommandEditor * editor = new DCUserCommandEditor(this);
	
	if ( editor->exec() == QDialog::Accepted )
	{
		DC_UserMenuCommand * umc = editor->GetUMC();
		usercommands[ usercommands.size() ] = umc;
		
		QListViewItem * item = new QListViewItem( listView_MENU_COMMANDS, umc->m_sName, umc->m_sCommand );
		item->moveItem( listView_MENU_COMMANDS->lastItem() );
	}
	
	delete editor;
}

/** */
void DCOptions::slotEditUserMenuCommand()
{
	QListViewItem * item = listView_MENU_COMMANDS->currentItem();
	
	if ( item == 0 )
	{
		return;
	}
	
	const int row = DCGuiUtils::FindRowForItem( listView_MENU_COMMANDS, item );
	
	if ( (row == -1) || !usercommands.contains(row) )
	{
		return;
	}
	
	DC_UserMenuCommand * umc = usercommands[row];
	
	DCUserCommandEditor * editor = new DCUserCommandEditor(this);
	editor->SetUMC(umc);
	
	if ( editor->exec() == QDialog::Accepted )
	{
		usercommands.remove(row);
		
		delete umc;
		
		umc = editor->GetUMC();
		
		usercommands[ row ] = umc;
		
		item->setText( 0, umc->m_sName );
		item->setText( 1, umc->m_sCommand );
	}
	
	delete editor;
}

/** */
void DCOptions::slotRemoveUserMenuCommand()
{
	QListViewItem * item = listView_MENU_COMMANDS->currentItem();
	
	if ( item == 0 )
	{
		return;
	}
	
	int row = DCGuiUtils::FindRowForItem( listView_MENU_COMMANDS, item );
	
	if ( row == -1 )
	{
		return;
	}
	
	int ret = QMessageBox::question(
			this,
			tr("Delete menu command?"),
			tr("Delete \"") + item->text(0) + QString("\"?"),
			QMessageBox::Yes,
			QMessageBox::No | QMessageBox::Escape
	);
	
	if ( ret == QMessageBox::Yes )
	{
		delete usercommands[ row ];
		usercommands.remove( row );
		
		delete item;
		
		// fix numbering
		QValueList<DC_UserMenuCommand*> remaining = usercommands.values();
		usercommands.clear();
		for ( unsigned int i = 0; i < remaining.size(); i++ )
		{
			usercommands[i] = remaining[i];
		}
	}
}

/** */
void DCOptions::slotUpUserMenuCommand()
{
	int row = DCGuiUtils::FindRowForItem( listView_MENU_COMMANDS, listView_MENU_COMMANDS->currentItem() );
	
	if ( row == -1 )
	{
		return;
	}
	
	if ( !usercommands.contains(row) || !usercommands.contains(row-1) )
	{
		return;
	}
	
	DC_UserMenuCommand * umc1 = usercommands[ row ];
	DC_UserMenuCommand * umc2 = usercommands[ row - 1 ];
	
	usercommands.remove( row );
	usercommands.remove( row - 1 );
	
	usercommands[ row - 1 ] = umc1;
	usercommands[ row ] = umc2;
	
	QListViewItem * item = listView_MENU_COMMANDS->currentItem()->itemAbove();
	item->moveItem( listView_MENU_COMMANDS->currentItem() );
	slotUserMenuCommandsSelectionChanged();
}

/** */
void DCOptions::slotDownUserMenuCommand()
{
	int row = DCGuiUtils::FindRowForItem( listView_MENU_COMMANDS, listView_MENU_COMMANDS->currentItem() );
	
	if ( row == -1 )
	{
		return;
	}
	
	if ( !usercommands.contains(row) || !usercommands.contains(row+1) )
	{
		return;
	}
	
	DC_UserMenuCommand * umc1 = usercommands[ row ];
	DC_UserMenuCommand * umc2 = usercommands[ row + 1 ];
	
	usercommands.remove( row );
	usercommands.remove( row + 1 );
	
	usercommands[ row + 1 ] = umc1;
	usercommands[ row ] = umc2;
	
	listView_MENU_COMMANDS->currentItem()->moveItem( listView_MENU_COMMANDS->currentItem()->itemBelow() );
	slotUserMenuCommandsSelectionChanged();
}

/** */
void DCOptions::slotUserMenuCommandsSelectionChanged()
{
	int row;
	if ( listView_MENU_COMMANDS->selectedItem() )
	{
		row = DCGuiUtils::FindRowForItem( listView_MENU_COMMANDS, listView_MENU_COMMANDS->selectedItem() );
	}
	else
	{
		row = -1;
	}
	
	if ( row == -1 )
	{
		ToolButton_EDIT_USER_MENU_COMMAND->setEnabled(false);
		ToolButton_REMOVE_USER_MENU_COMMAND->setEnabled(false);
		ToolButton_UP_USER_MENU_COMMAND->setEnabled(false);
		ToolButton_DOWN_USER_MENU_COMMAND->setEnabled(false);
	}
	else
	{
		ToolButton_EDIT_USER_MENU_COMMAND->setEnabled(true);
		ToolButton_REMOVE_USER_MENU_COMMAND->setEnabled(true);
		
		if ( row == 0 )
		{
			ToolButton_UP_USER_MENU_COMMAND->setEnabled(false);
		}
		else
		{
			ToolButton_UP_USER_MENU_COMMAND->setEnabled(true);
		}
		
		if ( row == listView_MENU_COMMANDS->childCount() - 1 )
		{
			ToolButton_DOWN_USER_MENU_COMMAND->setEnabled(false);
		}
		else
		{
			ToolButton_DOWN_USER_MENU_COMMAND->setEnabled(true);
		}
	}
}

/** */
void DCOptions::slotUserMenuCommandsDoubleClicked( QListViewItem * item, const QPoint & /* pos */, int /* col */ )
{
	if ( item )
	{
		listView_MENU_COMMANDS->setCurrentItem(item);
		slotEditUserMenuCommand();
	}
	else
	{
		slotAddUserMenuCommand();
	}
}

/** */
void DCOptions::slotContextMenuUserChatCommands( QListViewItem * item, const QPoint &, int col )
{
	bool enabled = (item != 0);
	
	QPopupMenu * m = new QPopupMenu(this);
	
	DCMenuHandler::InsertMenu( m, emiADD );
	DCMenuHandler::InsertMenu( m, emiEDIT, enabled );
	DCMenuHandler::InsertMenu( m, emiREMOVE, enabled );
	
	int id = m->exec(QCursor::pos());
	
	delete m;
	
	if ( id == -1 )
	{
		return;
	}
	else if ( id == emiADD )
	{
		QListViewItem * newitem = new QListViewItem( listView_CHAT_COMMANDS, "/s", "/sh somescript.sh" );
		newitem->setRenameEnabled(0, true);
		newitem->setRenameEnabled(1, true);
	}
	else if ( id == emiREMOVE )
	{
		delete item;
	}
	else if ( id == emiEDIT )
	{
		if ( (col == 0) || (col == 1) )
		{
			item->startRename(col);
		}
	}
}

/** */
void DCOptions::slotContextMenuAutoResponses( QListViewItem * item, const QPoint &, int col )
{
	bool enabled = (item != 0);
	
	QPopupMenu * m = new QPopupMenu(this);
	
	DCMenuHandler::InsertMenu( m, emiADD );
	DCMenuHandler::InsertMenu( m, emiEDIT, enabled );
	DCMenuHandler::InsertMenu( m, emiREMOVE, enabled );
	int cs_yes = m->insertItem(tr("Case sensitive"));
	m->setItemEnabled( cs_yes, enabled );
	int cs_no = m->insertItem(tr("Case insensitive"));
	m->setItemEnabled( cs_no, enabled );
	
	int id = m->exec(QCursor::pos());
	
	delete m;
	
	if ( id == -1)
	{
		return;
	}
	else if ( id == emiADD )
	{
		QListViewItem * newitem = new QListViewItem( listView_AUTO_RESPONSES, "-trigger", tr("No"), "response" );
		newitem->setRenameEnabled(0, true);
		newitem->setRenameEnabled(2, true);
	}
	else if ( id == emiEDIT )
	{
		if ( (col == 0) || (col == 2) )
		{
			item->startRename(col);
		}
	}
	else if ( id == emiREMOVE )
	{
		delete item;
	}
	else if ( id == cs_yes )
	{
		item->setText(1, tr("Yes"));
	}
	else if ( id == cs_no )
	{
		item->setText(1, tr("No"));
	}
}

/** */
void DCOptions::setupIconThemeComboBoxes()
{
	ComboBox_APPLICATION_ICONS->clear();
	ComboBox_USERLIST_ICONS->clear();
	ComboBox_EMOTICONS->clear();
	
	setupIconThemeComboBox( ComboBox_APPLICATION_ICONS, "appl" );
	setupIconThemeComboBox( ComboBox_USERLIST_ICONS, "user" );
	setupIconThemeComboBox( ComboBox_EMOTICONS, "emot" );
}

/** */
void DCOptions::setupIconThemeComboBox( QComboBox * box, QString icontype )
{
	QDir dir;
	dir.setPath( g_pConfig->GetValknutDataPath() + "/icons/" + icontype + "/" );
	dir.setFilter( QDir::Dirs | QDir::Readable | QDir::Executable );
	dir.setSorting( QDir::Name );
	
	const QFileInfoList * iconslist = dir.entryInfoList();
	if ( iconslist != 0 )
	{
		QFileInfoListIterator it ( *iconslist );
		QFileInfo *fi;
		
		while ( (fi = it.current()) != 0 )
		{
			if ( (fi->fileName() == ".") || (fi->fileName() == "..") )
			{
				// skip
			}
			else
			{
				box->insertItem(fi->fileName());
			}
			++it;
		}
	}	
}

/** */
void DCOptions::slotGenerateKeyCert()
{
	QProcess * proc1 = 0;
	QProcess * proc2 = 0;
	QString keyname = LineEdit_TRANSFERKEY->text();
	QString certname = LineEdit_TRANSFERCERT->text();
	QFile key;
	QFile cert;
	QDir keypath;
	QDir certpath;
	int i = 0;
	
	PushButton_GENERATE_CERT->setEnabled(false);
	
	if ( keyname.isEmpty() )
	{
		keyname = QString(g_pConfig->GetConfigPath().Data()) + QString("/ssl/valknut.key");
	}
	
	if ( certname.isEmpty() )
	{
		certname = QString(g_pConfig->GetConfigPath().Data()) + QString("/ssl/valknut.cert");
	}
	
	keyname.replace("//", "/");
	certname.replace("//", "/");
	
	key.setName(keyname);
	cert.setName(certname);
	
	if ( key.exists() || cert.exists() )
	{
		int ret = QMessageBox::question(
			this,
			tr("Overwrite?"),
			tr("Replace existing key/cert?"),
			QMessageBox::Yes,
			QMessageBox::No
		);
		
		if ( ret == QMessageBox::No )
		{
			PushButton_GENERATE_CERT->setEnabled(true);
			return;
		}
	}
	
	keypath.setPath(QFileInfo(keyname).dirPath());
	certpath.setPath(QFileInfo(certname).dirPath());
	
	if ( keypath.isRelative() )
	{
		keyname.prepend(QDir::separator());
		keyname.prepend(QDir::currentDirPath());
		keypath.setPath(QFileInfo(keyname).dirPath());
	}
	
	if ( certpath.isRelative() )
	{
		certname.prepend(QDir::separator());
		certname.prepend(QDir::currentDirPath());
		certpath.setPath(QFileInfo(certname).dirPath());
	}
	
	if (keypath.exists() == false)
	{
		if ( keypath.mkdir(keypath.path()) == false )
		{
			QMessageBox::critical(
				this,
				tr("Could not create folder for key"),
				tr("Could not create ") + keypath.path(),
				QMessageBox::Ok,
				QMessageBox::NoButton,
				QMessageBox::NoButton
			);
			PushButton_GENERATE_CERT->setEnabled(true);
			return;
		}
	}
	
	if (certpath.exists() == false)
	{
		if ( certpath.mkdir(certpath.path()) == false )
		{
			QMessageBox::critical(
				this,
				tr("Could not create folder for cert"),
				tr("Could not create ") + certpath.path(),
				QMessageBox::Ok,
				QMessageBox::NoButton,
				QMessageBox::NoButton
			);
			PushButton_GENERATE_CERT->setEnabled(true);
			return;
		}
	}
	
	proc1 = new QProcess(this);
	proc1->setWorkingDirectory(keypath);
	proc1->addArgument("openssl");
	proc1->addArgument("genrsa");
	proc1->addArgument("-out");
	proc1->addArgument(keyname);
	proc1->addArgument("2048");
	
	if ( !proc1->start() )
	{
		QMessageBox::critical(
			this,
			tr("Could not start openssl 1"),
			tr("Make sure the openssl program is in your PATH."),
			QMessageBox::Ok,
			QMessageBox::NoButton,
			QMessageBox::NoButton
		);
		delete proc1;
		PushButton_GENERATE_CERT->setEnabled(true);
		return;
	}
	
	proc1->closeStdin();
	i = 0;
	while ( proc1->isRunning() && (i < 5) )
	{
#ifdef WIN32
		Sleep(1000);
#else
		sleep(1);
#endif
		i++;
	}
	
	if ( proc1->isRunning() )
	{
		proc1->tryTerminate();
#ifdef WIN32
		Sleep(1000);
#else
		sleep(1);
#endif
		if ( proc1->isRunning() )
		{
			proc1->kill();
		}
	}
	
	if ( (proc1->normalExit() == false) || (proc1->exitStatus() != 0) )
	{
		QMessageBox::critical(
			this,
			tr("Error occurred while running openssl 1"),
			QString(proc1->readStderr()),
			QMessageBox::Ok,
			QMessageBox::NoButton,
			QMessageBox::NoButton
		);
		delete proc1;
		PushButton_GENERATE_CERT->setEnabled(true);
		return;
	}
	
	delete proc1;
	
	proc2 = new QProcess(this);
	proc2->setWorkingDirectory(certpath);
	proc2->addArgument("openssl");
	proc2->addArgument("req");
	proc2->addArgument("-x509");
	proc2->addArgument("-new");
	proc2->addArgument("-batch");
	proc2->addArgument("-days");
	proc2->addArgument("3650");
	proc2->addArgument("-key");
	proc2->addArgument(keyname);
	proc2->addArgument("-out");
	proc2->addArgument(certname);
	proc2->addArgument("-subj");
	proc2->addArgument("/CN=Valknut-" + LineEdit_NICK->text());
	
	if ( !proc2->start() )
	{
		QMessageBox::critical(
			this,
			tr("Could not start openssl 2"),
			tr("Make sure the openssl program is in your PATH."),
			QMessageBox::Ok,
			QMessageBox::NoButton,
			QMessageBox::NoButton
		);
		delete proc2;
		PushButton_GENERATE_CERT->setEnabled(true);
		return;
	}
	
	proc2->closeStdin();
	i = 0;
	while ( proc2->isRunning() && (i < 5) )
	{
#ifdef WIN32
		Sleep(1000);
#else
		sleep(1);
#endif
		i++;
	}
	
	if ( proc2->isRunning() )
	{
		proc2->tryTerminate();
#ifdef WIN32
		Sleep(1000);
#else
		sleep(1);
#endif
		if ( proc2->isRunning() )
		{
			proc2->kill();
		}
	}
	
	if ( (proc2->normalExit() == false) || (proc2->exitStatus() != 0) )
	{
		QMessageBox::critical(
			this,
			tr("Error occurred while running openssl 2"),
			QString(proc2->readStderr()),
			QMessageBox::Ok,
			QMessageBox::NoButton,
			QMessageBox::NoButton
		);
		delete proc2;
		PushButton_GENERATE_CERT->setEnabled(true);
		return;
	}
	
	delete proc2;
	
	LineEdit_TRANSFERKEY->setText(keyname);
	LineEdit_TRANSFERCERT->setText(certname);
	
	// set them even if dialog is cancelled since files have been created
	g_pConfig->SetTransferKey(keyname.ascii());
	g_pConfig->SetTransferCert(certname.ascii());
	
	PushButton_GENERATE_CERT->setEnabled(true);
}

/** */
void DCOptions::slotCustomBrowserChecked()
{
	if ( CheckBox_CUSTOM_BROWSER->isChecked() )
	{
		LineEdit_BROWSER->setEnabled(true);
		ToolButton_BROWSEBROWSER->setEnabled(true);
	}
	else
	{
		LineEdit_BROWSER->setEnabled(false);
		ToolButton_BROWSEBROWSER->setEnabled(false);
	}
}
