/***************************************************************************
                          dcoptions.h  -  description
                             -------------------
    begin                : Sun Feb 24 2002
    copyright            : (C) 2002 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCOPTIONS_H
#define DCOPTIONS_H

/**
  *@author Mathias Küster
  */

#include "dcconfig.h"
#include "DCDialogOptions.h"

#include <qmap.h>

class QHttp;
class QComboBox;

class DCOptions : public DCDialogOptions  {
Q_OBJECT

public:
	/** construtor */
	DCOptions( QWidget * parent = 0 );
	/** destructor */
	virtual ~DCOptions();

	/** */
	void InitDocument();
	/** */
	void SetValues();
	/** */
	void GetValues();
	/**
	 * Needed to reset the theme if one is tested and dialog cancelled.
	 * Or if you test some other theme, but then save the theme that's already in g_pConfig.
	 * And to avoid setting it again if it's already been set with the test button.
	 */
	QString GetTestedTheme() const { return m_sTestedTheme; };

public slots:
	/** checks/warns about various settings */
	virtual void accept();

private:
	/** */
	void BrowseSoundFile(eUserSound);
	/** */
	void PreviewSoundFile(eUserSound);
	/** */
	void SaveSharedFolders();
	/** */
	void SaveUserChatCommands();
	/** */
	void SaveAutoResponses();
	/** */
	void SetUserPhoto( QString filename );
	/** */
	void setupIconThemeComboBoxes();
	/** */
	void setupIconThemeComboBox( QComboBox * box, QString icontype );
	/** */
	void connectOptionsListView();
	/** */
	void disconnectOptionsListView();
	/** */
	void editSharedFolder( QListViewItem * item );
	/** */
	void editHubListUrl( QListViewItem * item );

	/** */
	QListViewItem * plviIdentify;
	/** */
	QListViewItem * plviConnection;
	/** */
	QListViewItem * plviConnectionMode;
	/** */
	QListViewItem * plviConnectionSettings;
	/** */
	QListViewItem * plviTransfer;
	/** */
	QListViewItem * plviTransferShares;
	/** */
	QListViewItem * plviTransferDownloads;
	/** */
	QListViewItem * plviTransferUploads;
	/** */
	QListViewItem * plviTransferSettings;
	/** */
	QListViewItem * plviGUI;
	/** */
	QListViewItem * plviGUIUser;
	/** */
	QListViewItem * plviGUIChat;
	/** */
	QListViewItem * plviGUICommands;
	/** */
	QListViewItem * plviGUIMenus;
	/** */
	QListViewItem * plviGUITransfer;
	/** */
	QListViewItem * plviGUIGeneral;
	/** */
	QListViewItem * plviGUIIcons;
	/** */
	QListViewItem * plviGUIFilelistBrowser;
	/** */
	QListViewItem * plviSound;
	/** */
	QListViewItem * plviSoundGeneral;
	/** */
	QListViewItem * plviSoundFiles;
	/** */
	QListViewItem * plviLog;
	/** */
	QListViewItem * plviHubLists;
	/** */
	QListViewItem * plviSecurity;
	/** List view item for auto responses tab */
	QListViewItem * plviAutoResponse;
	/** List view item for other tab */
	QListViewItem * plviOther;
	/** QHttp for getting external IP */
	QHttp * m_pHttp;
	/** List of user menu commands */
	QMap<int, DC_UserMenuCommand*> usercommands;
	/** Last theme tested, or configured theme if test button never used. */
	QString m_sTestedTheme;

private slots:
	/** */
	void slotBrowseSoundFileConnect();
	/** */
	void slotBrowseSoundFileDisconnect();
	/** */
	void slotBrowseSoundFileSend();
	/** */
	void slotBrowseSoundFileReceive();
	/** */
	void slotBrowseSoundFileFirstReceive();
	/** */
	void slotBrowseSoundFileNickMentioned();

	/** */
	void slotLogChatAddNickNameFilter();
	/** */
	void slotLogChatDelNickNameFilter();

	/** */
	void slotDisableSound();
	/** */
	void slotPreviewSoundFileConnect();
	/** */
	void slotPreviewSoundFileDisconnect();
	/** */
	void slotPreviewSoundFileSend();
	/** */
	void slotPreviewSoundFileReceive();
	/** */
	void slotPreviewSoundFileFirstReceive();
	/** */
	void slotPreviewSoundFileNickMentioned();

	/** */
	void slotBrowseSoundPlayer();
	/** */
	void slotBrowseDownloadFolder();
	/** */
	void slotBrowseDownloadFinishedFolder();
	/** */
	void slotBrowseShareList();
	/** */
	void slotBrowseDataFolder();
	/** */
	void slotSharedFoldersSelectionChanged();
	/** */
	void slotAddSharedFolder();
	/** */
	void slotRemoveSharedFolder();
	/** */
	void slotEditSharedFolder();
	/** */
	void slotDoubleClickedSharedFolder( QListViewItem * item, const QPoint & pos, int col );
	/** */
	void slotContextMenuSharedFolder( QListViewItem * item, const QPoint & pos, int col );
	/** */
	void slotCreateShareList();
	/** */
	void slotShareListInfo();
	/** */
	void slotTestHost();
	/** */
	void slotGetInterface();
	/** */
	void slotGetInternetIP();
	/** */
	void slotGotInternetIP( bool error );
	/** */
	void slotSetTheme();
	/** */
	void slotBrowseLanguageFile();
	/** */
	void slotSelectLanguage();
	/** */
	void slotBrowseAppFont();
	/** */
	void slotBrowseTransferCert();
	/** */
	void slotBrowseTransferKey();
	/** */
	void slotBrowseDclibPluginFolder();
	/** */
	void slotHubListUrlsSelectionChanged();
	/** */
	void slotAddHubListUrl();
	/** */
	void slotEditHubListUrl();
	/** */
	void slotRemoveHubListUrl();
	/** */
	void slotDoubleClickedHubListUrl( QListViewItem * item, const QPoint & pos, int col );
	/** */
	void slotContextMenuHubListUrl( QListViewItem * item, const QPoint & pos, int col );
	/** */
	void slotBrowseLogFile();
	/** */
	void slotBrowseBrowser();
	/** */
	void slotListViewOptionCurrentChanged( QListViewItem * item );
	/** */
	void slotTabWidgetDCGUICurrentChanged( QWidget * );
	/** */
	void slotTabWidgetTransferCurrentChanged( QWidget * );
	/** */
	void slotTabWidgetConnectionCurrentChanged( QWidget * );
	/** */
	void slotTabWidgetGUICurrentChanged( QWidget * );
	/** */
	void slotDoubleClickedChatColor(QListBoxItem *);
	/** */
	void slotChangePhoto();
	/** */
	void slotAddUserMenuCommand();
	/** */
	void slotEditUserMenuCommand();
	/** */
	void slotRemoveUserMenuCommand();
	/** */
	void slotUpUserMenuCommand();
	/** */
	void slotDownUserMenuCommand();
	/** */
	void slotUserMenuCommandsSelectionChanged();
	/** */
	void slotUserMenuCommandsDoubleClicked( QListViewItem * item, const QPoint & pos, int col );
	/** */
	void slotContextMenuUserChatCommands(QListViewItem * item, const QPoint & pos, int col);
	/** */
	void slotContextMenuAutoResponses(QListViewItem * item, const QPoint & pos, int col);
	/** Generates a new key and certificate for SSL transfers */
	void slotGenerateKeyCert();
	/** Open color dialog for background color */
	void slotBackgroundColorDialog();
	/** Reverse all chat colors */
	void slotReverseChatColors();
	/** Custom browser checkbox enabled/disabled */
	void slotCustomBrowserChecked();
};

/** */
inline void DCOptions::slotBrowseSoundFileConnect()
{ BrowseSoundFile(eusCONNECT); }
/** */
inline void DCOptions::slotBrowseSoundFileDisconnect()
{ BrowseSoundFile(eusDISCONNECT); }
/** */
inline void DCOptions::slotBrowseSoundFileSend()
{ BrowseSoundFile(eusSEND); }
/** */
inline void DCOptions::slotBrowseSoundFileReceive()
{ BrowseSoundFile(eusRECEIVE); }
/** */
inline void DCOptions::slotBrowseSoundFileFirstReceive()
{ BrowseSoundFile(eusFIRSTRECEIVE); }
/** */
inline void DCOptions::slotBrowseSoundFileNickMentioned()
{ BrowseSoundFile(eusNICKMENTIONED); }
/** */
inline void DCOptions::slotPreviewSoundFileConnect()
{ PreviewSoundFile(eusCONNECT); }
/** */
inline void DCOptions::slotPreviewSoundFileDisconnect()
{ PreviewSoundFile(eusDISCONNECT); }
/** */
inline void DCOptions::slotPreviewSoundFileSend()
{ PreviewSoundFile(eusSEND); }
/** */
inline void DCOptions::slotPreviewSoundFileReceive()
{ PreviewSoundFile(eusRECEIVE); }
/** */
inline void DCOptions::slotPreviewSoundFileFirstReceive()
{ PreviewSoundFile(eusFIRSTRECEIVE); }
/** */
inline void DCOptions::slotPreviewSoundFileNickMentioned()
{ PreviewSoundFile(eusNICKMENTIONED); }

#endif
