/***************************************************************************
  dcshellcommandrunner.cpp  -  Valknut Shell Command Runner Implementation
                             -------------------
    begin                : Wed Jul 2 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dcshellcommandrunner.h"

#include "dcevent.h"

#include <qprocess.h>
#include <qapplication.h>

/** */
DCShellCommandRunner::DCShellCommandRunner( QObject * chat, QString a ) : QThread()
{
	parent = chat;
	args = a;
	stop = false;
	succeeded = false;
}

/** */
DCShellCommandRunner::~DCShellCommandRunner()
{
	cancel();
	/* the longest total sleep in run() is 1 second */
	if ( !wait(1150) )
	{
		printf("~DCShellCommandRunner: warning not finished\n");
	}
}

/** */
void DCShellCommandRunner::run()
{
	QProcess process;
	
	/* QT3 problems, QT4 worked as expected */
	process.addArgument( "sh" );
	process.addArgument( "-c" );
	process.addArgument( args );
	
	process.setCommunication( QProcess::Stdout );
	
	if ( process.launch( QByteArray() ) )
	{
		int i = 0;
		while ( (process.isRunning()) && (i < 2400) && (stop == false) )
		{
			QThread::msleep(50);
			i++;
		}
		
		if ( stop )
		{
			process.tryTerminate();
			QThread::msleep(100);
			if ( process.isRunning() )
			{
				process.kill();
				QThread::msleep(100);
			}
			return;
		}
		
		if ( process.isRunning() )
		{
			process.tryTerminate();
			QThread::sleep(1);
			if ( process.isRunning() )
			{
				process.kill();
				QThread::msleep(100);
			}
		}
		
		if ( process.normalExit() )
		{
			int exitcode = process.exitStatus();
			if ( exitcode == 0 )
			{
				output = QString(process.readStdout()).stripWhiteSpace();
				if ( output.isEmpty() )
				{
					output = QObject::tr("Command produced no visible output.");
				}
				else
				{
					succeeded = true;
				}
			}
			else
			{
				output = QObject::tr("Process exited with status") + " " + QString::number(exitcode);
			}
		}
		else
		{
			output = QObject::tr("Process was killed or crashed.");
		}
	}
	else
	{
		output = QObject::tr("Failed to start shell command.");
	}
	
	if ( stop == false ) // stop is only set to true in DCChat destructor
	{
		QApplication::postEvent( parent, new DC_ShellCommandFinishedEvent( this ) );
	}
}

/** */
void DCShellCommandRunner::cancel()
{
	stop = true;
}

/** */
bool DCShellCommandRunner::getSucceeded()
{
	return succeeded;
}

/** */
QString DCShellCommandRunner::getOutput()
{
	return output;
}
