/***************************************************************************
      dcshellcommandrunner.h  -  Valknut Shell Command Runner Header
                             -------------------
    begin                : Wed Jul 2 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCSHELLCOMMANDRUNNER_H
#define DCSHELLCOMMANDRUNNER_H

/**
 * @author Edward Sheldrake
 *
 * DCShellCommandRunner is a QThread which starts a QProcess, waits for it
 * to finish, gets the output and then posts an event.
 */

#include <qthread.h>
#include <qstring.h>
#include <qobject.h>

class DCShellCommandRunner : public QThread {

public:
	/** constructor */
	DCShellCommandRunner( QObject * parent, QString args );
	/** destructor */
	virtual ~DCShellCommandRunner();
	
	/** the method that runs in the thread */
	virtual void run();
	
	/** Cancel the shell command e.g. if the chat is closed */
	void cancel();
	/** Tests if the command finished properly */
	bool getSucceeded();
	/** Gets the output of the shell command */
	QString getOutput();
	
private:
	/** used to cancel the thread */
	bool stop;
	/** true if the command ran OK and finished */
	bool succeeded;
	/** command to run with arguments */
	QString args;
	/** output of the shell command or error message */
	QString output;
	/** DCChat instance to post finished event to */
	QObject * parent;
};

#endif // DCSHELLCOMMANDRUNNER_H
