/***************************************************************************
         dcsigterm.h  -  Turn SIGTERM into a QCloseEvent properly
                             -------------------
    begin                : Mon Sep 08 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCSIGTERM_H
#define DCSIGTERM_H

#include <qobject.h>

class QSocketNotifier;

/**
 * @author Edward Sheldrake
 *
 * It's pretty much the QT documentation on how to handle
 * signals properly, which is required because only a
 * very small set of functions are allowed to be used
 * inside a signal handler.
 */
class DCSigTerm : public QObject {
Q_OBJECT

public:
	/**
	 * Constructor.
	 * The parent is also the target to post
	 * the close event to.
	 */
	DCSigTerm( QObject * parent );
	/** Destructor. */
	virtual ~DCSigTerm();
	
	/** unix signal handler */
	static void signal_handler( int signum );

public slots:
	/** */
	void slotSocketReadyRead( int unused );

private:
	/** socket pair fd */
	static int sigtermsfd[2];
	
	/** */
	QSocketNotifier * notifier;
};

#endif // DCSIGTERM_H
