/***************************************************************************
                          dcsplash.cpp  -  description
                             -------------------
    begin                : Fre Apr 12 2002
    copyright            : (C) 2002 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dcsplash.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qlabel.h>
#include <qpixmap.h>

#include "dciconloader.h"

#if QT_VERSION >= 0x030200
#define WSTYLE_SPLASH	Qt::WStyle_Splash
#else
#define WSTYLE_SPLASH	WStyle_NoBorder | WStyle_StaysOnTop | WStyle_Tool | WWinOwnDC | WX11BypassWM
#endif

/** */
DCSplash::DCSplash(QWidget *parent, const char *name, int /*wflags*/ ) : DCDialogSplash(parent,name,WSTYLE_SPLASH)
{
	Frame_PIXMAP->setBackgroundPixmap(g_pIconLoader->GetPixmap(eiSPLASH));

	// no tr() since translator hasn't been loaded yet
	Frame_PIXMAP->setText( QString::fromAscii("Valknut ") + QString::fromAscii(VERSION) + QString::fromAscii("\n\n\nhttp://wxdcgui.sourceforge.net") );
}

/** */
DCSplash::~DCSplash()
{
}

/** */
void DCSplash::mouseDoubleClickEvent( QMouseEvent * event )
{
	hide();
	
	QWidget::mouseDoubleClickEvent( event );    // standard event processing
}

/** */
void DCSplash::mousePressEvent( QMouseEvent * event )
{
	hide();
	
	QWidget::mousePressEvent( event );    // standard event processing
}

/** */
void DCSplash::mouseReleaseEvent( QMouseEvent * event )
{
	hide();
	
	QWidget::mouseReleaseEvent( event );    // standard event processing
}
