/***************************************************************************
         dctransferviewitems.h  -  Items used by DCTransferView
                             -------------------
    begin                : Wed Jul 2 2008
    copyright            : (C) 2002-2004 by Mathias Küster
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCTRANSFERVIEWITEMS_H
#define DCTRANSFERVIEWITEMS_H

/**
 * @author Mathias Küster, Edward Sheldrake
 *
 * These are just some things used by DCTransferView. They have been moved
 * out of dctransferview.h because other classes do not need to know about
 * them.
 */

#include <qstring.h>
#include <qmap.h>
#include <qlistview.h>

#include <dclib/dcobject.h>

#include "dcwidget.h"

/** */
class DCTransferQueueChild {
public:
	/** construtor */
	DCTransferQueueChild() {
		pObject = 0;
		pItem   = 0;
	};
	/** destructor */
	~DCTransferQueueChild() {
		delete pObject;
		pObject = 0;
		delete pItem;
		pItem = 0;
	};

	/** */
	CMessageDMFileObject * pObject;
	/** */
	QListViewItem * pItem;
};

typedef QMap<QString, DCTransferQueueChild*> QueueChildMap;

/** */
class DCTransferQueueParent {
public:
	/** constructor, set pointer to 0 */
	DCTransferQueueParent() {
		pItem = 0;
	};
	/** destructor, delete all children */
	~DCTransferQueueParent() {
		if ( !m_QueueChildMap.isEmpty() ) // normally it is deleted if the map is empty, except on valknut shutdown
		{
			for ( QueueChildMap::const_iterator it = m_QueueChildMap.constBegin(); it != m_QueueChildMap.constEnd(); ++it )
			{
				delete it.data();
			}
			m_QueueChildMap.clear();
		}
		delete pItem;
		pItem = 0;
	};
	
	/** */
	QString sHubName;
	/** */
	QString sHubHost;
	
	/** */
	QueueChildMap m_QueueChildMap;
	/** */
	QListViewItem * pItem;
};

/** */
class DCTransferListItem {
public:
	/** construtor */
	DCTransferListItem() {
		pObject = 0;
		pItem   = 0;
	};
	/** destructor */
	~DCTransferListItem() {
		delete pObject;
		pObject = 0;
		delete pItem;
		pItem = 0;
	};

	/** */
	CMessageDMTransferObject * pObject;
	/** */
	DC_QProgressListItem * pItem;
};

#endif // DCTRANSFERVIEWITEMS_H
