/***************************************************************************
                          dctranslator.h  -  description
                             -------------------
    begin                : Die Nov 19 2002
    copyright            : (C) 2002 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCTRANSLATOR_H
#define DCTRANSLATOR_H

#include <qobject.h>
#include <qhttp.h>
#include <qstringlist.h>
#include <qintdict.h>

/**
  *@author Mathias Küster
  */

class QWidget;
class DC_TranslationEvent;

class DCTranslator : public QObject  {
Q_OBJECT

public: 
	/** construtor */
	DCTranslator(QWidget *parent=0, const char *name=0);
	/** destructor */
	virtual ~DCTranslator();

	/** */
	void InitDocument();

	/** */
	QString SelectLanguage( QString lang, QWidget * parent = 0 );
	/** */
	bool Translate( QObject * sender, QString lang, QString text );

private:
	/** */
	QString GetUserAgent() const;
	/** */
	QHttp * pHttp;
	/** It maps QHttp request IDs to the DC_TranslationEvent object */
	QIntDict<DC_TranslationEvent> m_RequestDict;
	/** */
	QString m_sLanguage;
	/** */
	QString provider;
	/** */
	QStringList langs_ys;
	/** */
	QStringList langs_y;
	/** */
	QStringList langs_gs_from;
	/** */
	QStringList langs_g_from;
	/** */
	QStringList langs_gs_to;
	/** */
	QStringList langs_g_to;
	/** */
	QString m_sEncoding;

private slots:
	/** */
	void slotPostRequestFinished( int id, bool eoor );
	/** */
	void slotResponseHeader( const QHttpResponseHeader & header );
};

extern DCTranslator * g_pTranslator;
#endif
