/***************************************************************************
         dcusercommandedit.h  -  Valknut User Command Editor Dialog
                             -------------------
    begin                : Sun May 25 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dcusercommandeditor.h"

#include <qlineedit.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qmessagebox.h>

#include "dcconfig.h"

#include <dclib/core/types.h>

/** */
DCUserCommandEditor::DCUserCommandEditor( QWidget * parent ) : DCDialogUserCommandEditor ( parent )
{
	connect( RadioButton_SEPARATOR, SIGNAL(toggled(bool)), this, SLOT(slotTypeChanged(bool)) );
	connect( RadioButton_RAW, SIGNAL(toggled(bool)), this, SLOT(slotTypeChanged(bool)) );
	connect( RadioButton_CHAT, SIGNAL(toggled(bool)), this, SLOT(slotTypeChanged(bool)) );
	connect( RadioButton_PM, SIGNAL(toggled(bool)), this, SLOT(slotTypeChanged(bool)) );
	
	connect( LineEdit_COMMAND, SIGNAL(textChanged(const QString &)), this, SLOT(slotCommandChanged(const QString &)) );
	connect( LineEdit_TO, SIGNAL(textChanged(const QString &)), this, SLOT(slotCommandChanged(const QString &)) );
}

/** */
DCUserCommandEditor::~DCUserCommandEditor()
{

}

/** */
void DCUserCommandEditor::accept()
{
	if ( (RadioButton_SEPARATOR->isChecked() == false) && ((LineEdit_NAME->text().isEmpty()) || (LineEdit_COMMAND->text().isEmpty()) || (LineEdit_NAME->text().right(1) == "\\")) )
	{
		QMessageBox::information(
			this,
			tr("User Command Editor"),
			tr("Name and command must not be empty.")
		);
		return;
	}
	else
	{
		QDialog::accept();
	}
}

/** */
void DCUserCommandEditor::SetUMC( DC_UserMenuCommand * umc )
{
	if ( umc == 0 )
	{
		return;
	}
	
	/* Load values that don't need any processing */
	LineEdit_NAME->setText( umc->m_sName );
	LineEdit_HUBIP->setText( umc->m_sHubIP );
	
	if ( umc->m_nType == euctRawOnce )
	{
		CheckBox_ONCE_PER_NICK->setChecked(true);
	}
	
	/* Set context */
	if ( umc->m_nContext & euccHub )
	{
		CheckBox_CONTEXT_HUB->setChecked(true);
	}
	if ( umc->m_nContext & euccChat )
	{
		CheckBox_CONTEXT_USER->setChecked(true);
	}
	if ( umc->m_nContext & euccSearch )
	{
		CheckBox_CONTEXT_SEARCH->setChecked(true);
	}
	if ( umc->m_nContext & euccFilelist )
	{
		CheckBox_CONTEXT_FILELIST->setChecked(true);
	}
	
	QString s = umc->m_sCommand;
	
	/** Check for common NMDC public chat or private message commands */
	if ( (s.startsWith("<%[mynick]> ")) || (s.startsWith("<%[myNI]> ")) )
	{
		RadioButton_CHAT->setChecked(true);
		if ( s.startsWith("<%[mynick]> ") )
		{
			s = s.mid(12);
		}
		else
		{
			s = s.mid(10);
		}
		
		if ( s.right(1) == "|" )
		{
			s = s.left( s.length() - 1 );
		}
	}
	else if ( s.startsWith("$To: ") )
	{
		RadioButton_PM->setChecked(true);
		
		s = s.mid(5);
		int pos = s.find(" From: ");
		QString target = s.left( pos );
		if ( (target == "%[usernick]") || (target == "%[userNI]") )
		{
			// nothing
		}
		else
		{
			LineEdit_TO->setText(target);
		}
		
		pos = s.find(">");
		s = s.mid(pos+2);
		
		if ( s.right(1) == "|" )
		{
			s = s.left( s.length() - 1 );
		}
	}
	else
	{
		RadioButton_RAW->setChecked(true);
	}
	
	/* Analyse type */
	if ( umc->m_nType == euctSeparator )
	{
		RadioButton_SEPARATOR->setChecked(true);
	}
	
	LineEdit_COMMAND->setText(s);
	
	slotTypeChanged(false);
	slotCommandChanged(s);
}

/** */
DC_UserMenuCommand * DCUserCommandEditor::GetUMC()
{
	DC_UserMenuCommand * umc = new DC_UserMenuCommand();
	
	umc->m_sName   = LineEdit_NAME->text();
	umc->m_sHubIP  = LineEdit_HUBIP->text();
	
	if ( RadioButton_SEPARATOR->isChecked() )
	{
		umc->m_nType = euctSeparator;
		if ( LineEdit_NAME->text().isEmpty() )
		{
			umc->m_sName = tr("Separator");
		}
	}
	else if ( CheckBox_ONCE_PER_NICK->isChecked() )
	{
		umc->m_nType = euctRawOnce;
	}
	else
	{
		umc->m_nType = euctRaw;
	}
	
	umc->m_nContext = 0;
	if ( CheckBox_CONTEXT_HUB->isChecked() )
	{
		umc->m_nContext = umc->m_nContext | euccHub;
	}
	if ( CheckBox_CONTEXT_USER->isChecked() )
	{
		umc->m_nContext = umc->m_nContext | euccChat;
	}
	if ( CheckBox_CONTEXT_SEARCH->isChecked() )
	{
		umc->m_nContext = umc->m_nContext | euccSearch;
	}
	if ( CheckBox_CONTEXT_FILELIST->isChecked() )
	{
		umc->m_nContext = umc->m_nContext | euccFilelist;
	}
	
	slotCommandChanged(LineEdit_COMMAND->text());
	umc->m_sCommand = LineEdit_PREVIEW->text();
	
	return umc;
}

/** */
QString DCUserCommandEditor::getCurrentPrefix()
{
	if ( RadioButton_CHAT->isChecked() )
	{
		return QString("<%[myNI]> ");
	}
	else if ( RadioButton_PM->isChecked() )
	{
		if ( LineEdit_TO->text().isEmpty() )
		{
			return QString("$To: %[userNI] From: %[myNI] $<%[myNI]> ");
		}
		else
		{
			return QString("$To: ") + LineEdit_TO->text() + QString(" From: %[myNI] $<%[myNI]> ");
		}
	}
	else
	{
		return QString();
	}
}

/** */
QString DCUserCommandEditor::getCurrentSuffix()
{
	if ( RadioButton_CHAT->isChecked() || RadioButton_PM->isChecked() )
	{
		return QString("|");
	}
	else
	{
		return QString();
	}
}

/** */
void DCUserCommandEditor::slotTypeChanged( bool /* checked */ )
{
	if ( RadioButton_SEPARATOR->isChecked() )
	{
		LineEdit_COMMAND->setEnabled(false);
		LineEdit_HUBIP->setEnabled(false);
		LineEdit_TO->setEnabled(false);
		CheckBox_ONCE_PER_NICK->setEnabled(false);
	}
	else if ( RadioButton_RAW->isChecked() )
	{
		LineEdit_COMMAND->setEnabled(true);
		LineEdit_HUBIP->setEnabled(true);
		LineEdit_TO->setEnabled(false);
		CheckBox_ONCE_PER_NICK->setEnabled(true);
	}
	else if ( RadioButton_CHAT->isChecked() )
	{
		LineEdit_COMMAND->setEnabled(true);
		LineEdit_HUBIP->setEnabled(false);
		LineEdit_TO->setEnabled(false);
		CheckBox_ONCE_PER_NICK->setEnabled(true);
	}
	else if ( RadioButton_PM->isChecked() )
	{
		LineEdit_COMMAND->setEnabled(true);
		LineEdit_HUBIP->setEnabled(true);
		LineEdit_TO->setEnabled(true);
		CheckBox_ONCE_PER_NICK->setEnabled(true);
	}
	
	slotCommandChanged(LineEdit_COMMAND->text());
}

/** */
void DCUserCommandEditor::slotCommandChanged( const QString & /* text */ )
{
	if ( RadioButton_SEPARATOR->isChecked() )
	{
		LineEdit_PREVIEW->setText(QString());
		return;
	}
	
	QString s = LineEdit_COMMAND->text();
	
	if ( (RadioButton_CHAT->isChecked()) || (RadioButton_PM->isChecked()) )
	{
		s.replace("$","&#36;");
		s.replace("|","&#124;");
	}
	
	LineEdit_PREVIEW->setText( getCurrentPrefix() + s + getCurrentSuffix() );
}
