/***************************************************************************
                        dcuserslist.cpp  -  description
                             -------------------
    begin                : Thu Nov 21 2002
    copyright            : (C) 2002 by François Gannaz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dcuserslist.h"

#include <stdlib.h>

#include <qlistview.h>
#include <qpopupmenu.h>
#include <qcursor.h>
#include <qfile.h>

#include "dcconfig.h"
#include "dcevent.h"
#include "dcconnectionmanager.h"
#include "dcmenuhandler.h"
#include "dciconloader.h"

#include <dclib/core/cstring.h>
#include <dclib/core/cbytearray.h>

#include "dctransferview.h"

#include "dcguiutils.h"

DCUsersList * g_pUsersList = 0;

/** */
DCUsersList::DCUsersList(QWidget* parent, const char *name) : DCDialogUsersList(parent, name)
{
	setIcon( g_pIconLoader->GetPixmap(eiUSERS) );
	
	lastFriendsWidth = -1;
	
	// set the ColumnWidthMode to manual, we have to do this
	// because using the QListView resizeMode AllColumns means that it is
	// impossible to change the size of the last column
	for( int index = 0; index < ListView_FRIENDS->columns(); index++ )
	{
		ListView_FRIENDS->setColumnWidthMode( index, QListView::Manual );
	}
	
	InitDocument();

	g_pUsersList = this;
}

/** */
DCUsersList::~DCUsersList()
{
	g_pUsersList = NULL;

	for ( FriendMap::const_iterator it = m_FriendMap.constBegin(); it != m_FriendMap.constEnd(); ++it )
	{
		delete it.data();
	}
	
	m_FriendMap.clear();
}

/** */
void DCUsersList::show()
{
	QWidget::show();
	
	SizeColumnsPreservingRatios();
}

/** */
void DCUsersList::resizeEvent( QResizeEvent * )
{
	SizeColumnsPreservingRatios();
}

/** */
void DCUsersList::SizeColumnsPreservingRatios()
{
	if ( ListView_FRIENDS->isVisible() )
	{
		int width = ListView_FRIENDS->width();
		if ( width > 0 )
		{
			if ( lastFriendsWidth == -1 )
			{
				ListView_FRIENDS->setColumnWidth( 0, width/4 );
				ListView_FRIENDS->setColumnWidth( 1, width/4 );
				ListView_FRIENDS->setColumnWidth( 2, width/4 );
				ListView_FRIENDS->setColumnWidth( 3, width/4 );
				
				lastFriendsWidth = ListView_FRIENDS->width();
			}
			else if ( lastFriendsWidth != width )
			{
				DCGuiUtils::AdjustColumnWidths( ListView_FRIENDS, lastFriendsWidth );
				lastFriendsWidth = ListView_FRIENDS->width();
			}
		}
	}
}

/** */
void DCUsersList::InitDocument()
{
	StringMap * map;

	// restore settings
	if ( g_pConfig->GetMap("USERVIEW",map) )
	{
		if ( ((*map)["WIDTH"].toInt() > 0) && ((*map)["HEIGHT"].toInt() > 0) )
		{
			setGeometry( (*map)["X"].toInt(), (*map)["Y"].toInt(), (*map)["WIDTH"].toInt(), (*map)["HEIGHT"].toInt() );
		}
	}
	
	ListView_FRIENDS->setColumnAlignment(1,Qt::AlignRight);
	
	ListView_FRIENDS->setSelectionMode(QListView::Extended);

	connect( ListView_FRIENDS, SIGNAL(contextMenuRequested( QListViewItem *, const QPoint &, int )), this, SLOT(slotRightButtonClickedFriendList(QListViewItem*, const QPoint &, int )) );

	// load friends list
	g_pConfig->LoadDCFriendList( &m_FriendMap );

	ShowFriendsList();
}

/** */
void DCUsersList::DeInitDocument()
{
	StringMap * map;

	// save search view settings
	g_pConfig->GetMap("USERVIEW",map);

	(*map)["X"]         = QString().setNum(parentWidget()->x());
	(*map)["Y"]         = QString().setNum(parentWidget()->y());
	(*map)["WIDTH"]     = QString().setNum(width());
	(*map)["HEIGHT"]    = QString().setNum(height());
	(*map)["VISIBLE"]   = QString().setNum(isVisible());
	(*map)["MAXIMIZED"] = QString().setNum(isMaximized());
	(*map)["MINIMIZED"] = QString().setNum(isMinimized());
	(*map)["ENABLED"]   = QString().setNum(isEnabled());
}

/** friend event handler */
void DCUsersList::customEvent( QCustomEvent * event )
{
	if ( event->type() == EVENT_UPDATE_FRIEND )
	{
		DCFriendObject * FriendObject;
		eUserAwayMode awaymode;
		DC_FriendEvent * e = (DC_FriendEvent*)event;

		if ( (e->m_pFriendObject->m_sName.isEmpty()) && (g_pConnectionManager) )
		{
			// check all friends online state
			for ( FriendMap::const_iterator it = m_FriendMap.constBegin(); it != m_FriendMap.constEnd(); ++it )
			{
				FriendObject = it.data();
				CString empty;
				if ( g_pConnectionManager->IsUserOnline( FriendObject->m_sName.ascii(), empty, empty, 0 ) )
				{
					awaymode = euamONLINE;
				}
				else
				{
					awaymode = euamOFFLINE;
				}

				SetAwayMode( FriendObject, awaymode );
			}
		}
		else if ( m_FriendMap.contains(e->m_pFriendObject->m_sName) )
		{
			FriendObject = m_FriendMap[e->m_pFriendObject->m_sName];
			SetAwayMode( FriendObject, e->m_pFriendObject->m_eAwayMode );
		}
	}
	else
	{
		QWidget::customEvent( event );    // standard event processing
	}
}

/** */
void DCUsersList::ShowFriendsList()
{
	QImage im;
	DCFriendObject * FriendObject;

	for ( FriendMap::const_iterator it = m_FriendMap.constBegin(); it != m_FriendMap.constEnd(); ++it )
	{
		FriendObject = it.data();
		
		FriendObject->m_pItem = new QListViewItem( ListView_FRIENDS, FriendObject->m_sName );
		FriendObject->m_pItem->setPixmap(0,g_pIconLoader->GetPixmap(eiBALL_RED));

		if ( !(FriendObject->m_sImageFileName.isEmpty()) )
		{
			if ( im.load(FriendObject->m_sImageFileName) )
			{
				im = im.smoothScale(32,32,QImage::ScaleMin);
				FriendObject->m_pItem->setPixmap(1,im);
			}
		}
		
		if ( FriendObject->m_bPermSlot )
		{
			FriendObject->m_pItem->setText(2, tr("Permanent slot"));
		}
		else
		{
			FriendObject->m_pItem->setText(2, QString());
		}
		
		if ( FriendObject->m_bIgnore )
		{
			FriendObject->m_pItem->setText(3, tr("Ignore"));
		}
		else
		{
			FriendObject->m_pItem->setText(3, QString());
		}
	}
}

/** */
void DCUsersList::DelFriend( QString name )
{
	if ( m_FriendMap.contains(name) )
	{
		DCFriendObject * FriendObject = m_FriendMap[name];
		
		// remove slot if necessary
		if (FriendObject->m_bPermSlot)
		{
			g_pTransferView->DLM_AddUserSlot(FriendObject->m_sName.ascii(), FriendObject->m_sHubName.ascii(), 0);
		}

		delete FriendObject->m_pItem;

		// remove from list
		m_FriendMap.remove(name);
		delete FriendObject;

		// save list
		g_pConfig->SaveDCFriendList( &m_FriendMap );
	}
}

/** */
void DCUsersList::AddFriend( QString name, QString hubname, QString hubhost, QString description )
{
	if ( !(m_FriendMap.contains(name)) )
	{
		DCFriendObject * FriendObject = new DCFriendObject();

		FriendObject->m_sName        = name;
		FriendObject->m_sHubName     = hubname;
		FriendObject->m_sHubHost     = hubhost;
		FriendObject->m_sDescription = description;

		FriendObject->m_pItem = new QListViewItem( ListView_FRIENDS, FriendObject->m_sName );

		m_FriendMap.insert(name,FriendObject);

		eUserAwayMode awaymode = euamNONE;
		if ( g_pConnectionManager )
		{
			CString empty;
			if ( g_pConnectionManager->IsUserOnline( FriendObject->m_sName.ascii(), empty, empty, 0 ) )
			{
				awaymode = euamONLINE;
			}
		}

		SetAwayMode( FriendObject, awaymode );

		// add permanent slot if granted
		if (FriendObject->m_bPermSlot)
		{
			g_pTransferView->DLM_AddUserSlot( name.ascii(), hubname.ascii(), 0, true );
		}
		
		// save friendlist
		g_pConfig->SaveDCFriendList( &m_FriendMap );
	}
}

/** */
void DCUsersList::UpdateFriend( QString /*name*/, QString /*host*/, QString /*description*/ )
{
}

/** */
bool DCUsersList::AddFriendPhoto( QString name, CByteArray * data )
{
	bool res = false;
	QFile f;
	QString s;
	int i;

	if ( m_FriendMap.contains(name) )
	{
		DCFriendObject * FriendObject = m_FriendMap[name];
		s = FriendObject->m_sImageFileName;

		if ( !s.isEmpty() )
		{
			f.setName(s);
			if ( f.open( IO_Raw | IO_WriteOnly | IO_Truncate ) )
			{
				f.writeBlock((const char*)data->Data(),data->Size());
				f.close();
			}
			else
			{
				s = QString();
			}
		}

		if ( s.isEmpty() )
		{
			// create new image
			for(i=0;i<200;i++)
			{
				s = QString::fromAscii(g_pConfig->GetImagePath().Data()) + QString().setNum(i) + ".png";
				if ( f.exists(s) == false )
				{
					break;
				}
			}

			if ( i < 200 )
			{
				f.setName(s);
				if ( f.open( IO_Raw | IO_WriteOnly ) )
				{
					f.writeBlock((const char*)data->Data(),data->Size());
					f.close();

					FriendObject->m_sImageFileName = s;
				}
				else
				{
					printf("AddFriendPhoto: can't open file '%s'\n",s.ascii());
				}
			}
		}

		// save friendlist
		g_pConfig->SaveDCFriendList( &m_FriendMap );

		QImage im;

		if ( !(FriendObject->m_sImageFileName.isEmpty()) )
		{
			if ( im.load(FriendObject->m_sImageFileName) )
			{
				im = im.smoothScale(32,32,QImage::ScaleMin);
				FriendObject->m_pItem->setPixmap(1,im);
			}
		}
	}

	return res;
}

/** */
void DCUsersList::SetAwayMode( DCFriendObject * obj, eUserAwayMode e )
{
	if ( !obj || !obj->m_pItem )
	{
		return;
	}

	if ( obj->m_eAwayMode != e )
	{
		obj->m_eAwayMode = e;

		switch(obj->m_eAwayMode)
		{
			case euamNORMAL:
			case euamONLINE:
				obj->m_pItem->setPixmap(0,g_pIconLoader->GetPixmap(eiBALL_GREEN));
				// add a permanent slot for friend if granted
				if (obj->m_bPermSlot)
				{
					g_pTransferView->DLM_AddUserSlot(obj->m_sName.ascii(), obj->m_sHubName.ascii(), 0, true );
				}
				break;
			case euamAWAY:
				obj->m_pItem->setPixmap(0,g_pIconLoader->GetPixmap(eiBALL_YELLOW));
				// add a permanent slot for friend if granted
				if (obj->m_bPermSlot)
				{
					g_pTransferView->DLM_AddUserSlot(obj->m_sName.ascii(), obj->m_sHubName.ascii(), 0, true );
				}
				break;
			// case euamNONE:
			// case euamOFFLINE:
			default:
				obj->m_pItem->setPixmap(0,g_pIconLoader->GetPixmap(eiBALL_RED));
				// remove the permanent slot for the friend if one is granted
				if (obj->m_bPermSlot)
				{
					g_pTransferView->DLM_AddUserSlot(obj->m_sName.ascii(), obj->m_sHubName.ascii(), 0);
				}
				break;
		}
	}
}

/** */
void DCUsersList::slotRightButtonClickedFriendList(QListViewItem * , const QPoint &, int)
{
	int id, addSlot, removeSlot, ignore, unignore;
	QPopupMenu *m;
	QPtrList<QListViewItem> selitems;
	QListViewItem * curitem;
	DCFriendObject * FriendObject;

	if ( DCGuiUtils::SelectedItems(ListView_FRIENDS,selitems) == 0 )
	{
		return;
	}

	m = new QPopupMenu(this);

	DCMenuHandler::InsertMenu( m, emiREMOVE );
	
	addSlot = m->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDITADD) ), tr("Grant permanent slot") );
	m->setItemEnabled(addSlot, true);
	
	removeSlot = m->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDITDELETE) ), tr("Remove permanent slot") );
	m->setItemEnabled(removeSlot, true);

	ignore = m->insertItem(tr("Ignore chat messages"));
	m->setItemEnabled(ignore, true);
	
	unignore = m->insertItem(tr("Show chat messages"));
	m->setItemEnabled(unignore, true);
	
	id = m->exec(QCursor::pos());

	delete m;

	if ( id == -1 )
	{
		return;
	}

	if ( id == emiREMOVE )
	{
	        for ( curitem = selitems.first(); curitem; curitem = selitems.next() )
	        {
			DelFriend(curitem->text(0));
		}
	}
	else if ( id == addSlot )
	{
		for ( curitem = selitems.first(); curitem; curitem = selitems.next() )
		{
			if ( curitem->text(2).isEmpty() )
			{
				curitem->setText(2, tr("Permanent slot"));
				if ( m_FriendMap.contains(curitem->text(0)) )
				{
					FriendObject = m_FriendMap[curitem->text(0)];
					//printf("Adding permanment slot for %s\n", FriendObject->m_sName.ascii());
					FriendObject->m_bPermSlot = true;
					CString empty;
					if (g_pConnectionManager->IsUserOnline( FriendObject->m_sName.ascii(), empty, empty, 0 ))
					{
						g_pTransferView->DLM_AddUserSlot(FriendObject->m_sName.ascii(), FriendObject->m_sHubName.ascii(), 0, true );
					}
				}
			}
		}
		
		g_pConfig->SaveDCFriendList( &m_FriendMap );
	}
	else if ( id == removeSlot )
	{
		for ( curitem = selitems.first(); curitem; curitem = selitems.next() )
		{	
			if (curitem->text(2) == tr("Permanent slot"))
			{
				curitem->setText(2, QString());
				if ( m_FriendMap.contains(curitem->text(0)) )
				{
					FriendObject = m_FriendMap[curitem->text(0)];
					//printf("Removing permanment slot for %s\n", FriendObject->m_sName.ascii());
					FriendObject->m_bPermSlot = false;
					CString empty;
					if (g_pConnectionManager->IsUserOnline( FriendObject->m_sName.ascii(), empty, empty, 0 ))
					{
						g_pTransferView->DLM_AddUserSlot(FriendObject->m_sName.ascii(), FriendObject->m_sHubName.ascii(), 0);
					}
				}
			}
		}
		
		g_pConfig->SaveDCFriendList( &m_FriendMap );
	}
	else if ( id == ignore )
	{
		for ( curitem = selitems.first(); curitem; curitem = selitems.next() )
		{
			curitem->setText(3, tr("Ignore"));
			if ( m_FriendMap.contains(curitem->text(0)) )
			{
				FriendObject = m_FriendMap[curitem->text(0)];
				FriendObject->m_bIgnore = true;
			}
		}
		
		g_pConfig->SaveDCFriendList( &m_FriendMap );
	}
	else if ( id == unignore )
	{
		for ( curitem = selitems.first(); curitem; curitem = selitems.next() )
		{
			curitem->setText(3, QString());
			if ( m_FriendMap.contains(curitem->text(0)) )
			{
				FriendObject = m_FriendMap[curitem->text(0)];
				FriendObject->m_bIgnore = false;
			}
		}
		
		g_pConfig->SaveDCFriendList( &m_FriendMap );
	}
}

/** Returns true if the nick is in the friend list */
bool DCUsersList::isNickInList( QString name )
{
	return m_FriendMap.contains(name);
}

/** Returns true if the nick is on ignore */
bool DCUsersList::ignoreNick( QString nick )
{
	if ( m_FriendMap.contains(nick) )
	{
		DCFriendObject * FriendObject = m_FriendMap[nick];
		return FriendObject->m_bIgnore;
	}
	else
	{
		return false;
	}	
}

/** Sets the ignore status of a nick*/
void DCUsersList::setIgnore( QString nick, bool ignore )
{
	if ( m_FriendMap.contains(nick) )
	{
		DCFriendObject * FriendObject = m_FriendMap[nick];
		FriendObject->m_bIgnore = ignore;
		if ( ignore )
		{
			FriendObject->m_pItem->setText(3, tr("Ignore"));
		}
		else
		{
			FriendObject->m_pItem->setText(3, QString());
		}
		g_pConfig->SaveDCFriendList( &m_FriendMap );
	}
}
