/***************************************************************************
                          dcuserslist.h  -  description
                             -------------------
    begin                : Thu Nov 21 2002
    copyright            : (C) 2002 by François Gannaz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCUSERSLIST_H
#define DCUSERSLIST_H

/**
  *@author François Gannaz
  */

#include <dclib/dcobject.h>

#include "DCDialogUsersList.h"

#include <qevent.h>
#include <qmap.h>
#include <qstring.h>
#include <qptrlist.h>

class QListViewItem;
class CByteArray;

// stupid typedef vs forward declaration
#include "dcfriendobject.h"

class DCUsersList : public DCDialogUsersList {
Q_OBJECT

public:
	/** construtor */
	DCUsersList(QWidget* parent, const char *name);
	/** destructor */
	virtual ~DCUsersList();

	/** overridden so that the column widths are initialized on first show() */
	virtual void show();

	/** */
	void InitDocument();
	/** */
	void DeInitDocument();

	/** */
	void ShowFriendsList();

	/** */
	void AddFriend( QString name, QString hubname, QString hubhost, QString description );
	/** */
	void DelFriend( QString name );
	/** */
	void UpdateFriend( QString name, QString host, QString description );
	/** */
	bool AddFriendPhoto( QString name, CByteArray * data );
	/** Returns true if the nick is in the friend list */
	bool isNickInList( QString name );
	/** Returns true if the nick is on ignore */
	bool ignoreNick( QString nick );
	/** Sets the ignore status of a nick */
	void setIgnore( QString nick, bool b );

protected:
	/** resize event handler */
	virtual void resizeEvent( QResizeEvent * );
	/** friend event handler */
	virtual void customEvent( QCustomEvent * event );
private:
	/** */
	FriendMap m_FriendMap;

	/** */
	void SetAwayMode( DCFriendObject * obj, eUserAwayMode e );
	/** Adjust column sizes preserving user set size ratios */
	void SizeColumnsPreservingRatios();
	/** Last width the friends list was adjusted for */
	int lastFriendsWidth;

private slots:
	/** */
	void slotRightButtonClickedFriendList(QListViewItem*, const QPoint &, int );
};

/** */
extern DCUsersList * g_pUsersList;

#endif
