/***************************************************************************
                          cdialogmessage.cpp  -  description
                             -------------------
    begin                : Don Sep 18 2003
    copyright            : (C) 2003 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cdialogmessage.h"

#include <qlabel.h>
#include <qpushbutton.h>
#include <qapplication.h>
#include <qstyle.h>
#include <qcheckbox.h>

/** */
CDialogMessage::CDialogMessage( QWidget *parent,
			enum QMessageBox::Icon icon,
			QString caption,
			QString text,
			const QString & button0Text,
			const QString & button1Text,
			const QString & button2Text ) : DCDialogMessage(parent,"")
{
	setCaption(caption);
	TextLabel_TEXT->setText(text);

	if ( button0Text == QString::null )
	{
		PushButton0->hide();
	}
	else
	{
		PushButton0->setText(button0Text);
		connect( PushButton0, SIGNAL(clicked()), this, SLOT(slotPushButton0Clicked()) );
	}

	if ( button1Text == QString::null )
	{
		PushButton1->hide();
	}
	else
	{
		PushButton1->setText(button1Text);
		connect( PushButton1, SIGNAL(clicked()), this, SLOT(slotPushButton1Clicked()) );
	}

	if ( button2Text == QString::null )
	{
		PushButton2->hide();
	}
	else
	{
		PushButton2->setText(button2Text);
		connect( PushButton2, SIGNAL(clicked()), this, SLOT(slotPushButton2Clicked()) );
	}

	switch(icon)
	{
		case QMessageBox::Information:
			PixmapLabel_ICON->setPixmap(QApplication::style().stylePixmap(QStyle::SP_MessageBoxInformation));
			break;
		case QMessageBox::Warning:
			PixmapLabel_ICON->setPixmap(QApplication::style().stylePixmap(QStyle::SP_MessageBoxWarning));
			break;
		case QMessageBox::Critical:
			PixmapLabel_ICON->setPixmap(QApplication::style().stylePixmap(QStyle::SP_MessageBoxCritical));
			break;
		default:
			break;
	}

	adjustSize();
}

/** */
CDialogMessage::~CDialogMessage()
{
}

/** */
bool CDialogMessage::GetCheckBoxStatus()
{
	return CheckBox_SHOW->isChecked();
}

/** */
void CDialogMessage::slotPushButton0Clicked()
{
	done(0);
}

/** */
void CDialogMessage::slotPushButton1Clicked()
{
	done(1);
}

/** */
void CDialogMessage::slotPushButton2Clicked()
{
	done(2);
}
