/***************************************************************************
          dcqlabel.h  -  A QLabel that emits a context menu signal
                             -------------------
    begin                : Sun Aug 17 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCQLABEL_H
#define DCQLABEL_H

#include <qlabel.h>
#include <qevent.h>

/**
 * @author Edward Sheldrake
 *
 * It's a QLabel that emits a signal when it gets
 * a request for a context menu.
 */

class DCQLabel : public QLabel {
Q_OBJECT

public:
	/** Constructor */
	DCQLabel( QWidget * parent = 0, const char * name = 0, WFlags f = 0 );
	/** Destructor */
	virtual ~DCQLabel();

protected:
	/** Receive context menu event */
	virtual void contextMenuEvent( QContextMenuEvent * event );

signals:
	/** Emitted on receiving a context menu event */
	void contextMenuRequested();
};

#endif // DCQSTATUSBAR_H
