/***************************************************************************
                          dcwidget.h  -  description
                             -------------------
    begin                : Don Mai 30 2002
    copyright            : (C) 2002 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCWIDGET_H
#define DCWIDGET_H

#include <qlistview.h>
#include <qprogressbar.h>

// it's for ulonglong
#include <dclib/dcos.h>

class CDCMessage;

/**
  *@author Mathias Küster
  */

class DC_QNumericSortItem {
public:
	/** */
	int mycol;
	/** */
	ulonglong myvalue;
	/** construtor */
	DC_QNumericSortItem() { mycol=-1;myvalue=0; };
	/** destructor */
	virtual ~DC_QNumericSortItem() {};

	/** */
	int mycompare( ulonglong v1, ulonglong v2, int col, bool ascending ) const;
};

class DC_QListViewItem : public QListViewItem, public DC_QNumericSortItem {
public:
	/** construtor */
	DC_QListViewItem( QListView * parent ) : QListViewItem(parent) {};
	/** construtor */
	DC_QListViewItem( QListViewItem * parent ) : QListViewItem(parent) {};
	/** destructor */
	virtual ~DC_QListViewItem() {};

	/** */
	virtual int compare( QListViewItem * i, int col, bool ascending ) const;
	/** */
	virtual QString key( int column, bool ascending ) const;
};

class DC_QSearchListViewItem : public QListViewItem {
public:
	/** construtor */
	DC_QSearchListViewItem( QListView * parent ) : QListViewItem(parent) {
		p_msg = 0;
	};
	/** construtor */
	DC_QSearchListViewItem( QListViewItem * parent ) : QListViewItem(parent) {
		p_msg = 0;
	};
	/** destructor */
	virtual ~DC_QSearchListViewItem() {};

	/** */
	CDCMessage * p_msg;
};

class DC_ListResult : public DC_QListViewItem {
public:
        /** construtor */
        DC_ListResult ( QListView * parent ) : DC_QListViewItem (parent) { };
        /** construtor */
        DC_ListResult ( QListViewItem * parent ) : DC_QListViewItem (parent) { };
        /** destructor */
        virtual ~DC_ListResult() { };

        /** */
        void paintCell( QPainter * p, const QColorGroup & cg, int column, int width, int align );
	/** Re-implemented to fix sorting by slots */
	QString key( int n, bool ascending ) const;
};

class DC_QCheckListItem : public QCheckListItem, public DC_QNumericSortItem {
public:
	/** construtor */
	DC_QCheckListItem( QListView *parent, const QString &text, const QPixmap & );
	/** construtor */
	DC_QCheckListItem( QListView *parent, const QString &text, Type tt = Controller );
	/** destructor */
	virtual ~DC_QCheckListItem() {};

	/** */
	virtual void paintCell( QPainter * p, const QColorGroup & cg, int column, int width, int align );
	/** */
	virtual int compare( QListViewItem * i, int col, bool ascending ) const;
	/** */
	virtual QString key( int column, bool ascending ) const;
	/** */
	QColor colorText;
	/** */
	bool m_bSortTop;
};

#define USERLISTITEM_MAX_COLUMNS 1

class DC_UserListItem : public DC_QCheckListItem {
public:
	/** construtor */
	DC_UserListItem( QListView *parent, const QString &text, const QPixmap & );
	/** construtor */
	DC_UserListItem( QListView *parent, const QString &text, Type tt = Controller );
	/** destructor */
	virtual ~DC_UserListItem() {};

	/** */
	virtual void setText( int column, const QString & text );
	/** */
	virtual int compare( QListViewItem * i, int col, bool ascending ) const;

	/** */
	void setCompareValue( int column, const QString & text );
	/** */
	ulonglong m_nCompareValue[USERLISTITEM_MAX_COLUMNS];
	/** lower case nick */
	QString m_sNickLC;
	/** lower case nick with [TAGS] removed */
	QString m_sNickStripped;
};

class DC_QProgressListItem : public QListViewItem
{
public:
	/** construtor */
	DC_QProgressListItem( DC_QProgressListItem * parent, int column = 0 );
	/** construtor */
	DC_QProgressListItem( QListViewItem * parent, int column = 0 );
	/** construtor */
	DC_QProgressListItem( QListView * parent, int column = 0 );
	/** destructor */
	virtual ~DC_QProgressListItem();
	
	/** */
	virtual void paintCell( QPainter *,  const QColorGroup & cg,
			int column, int width, int alignment );
	/** */
	virtual void paintFocus( QPainter *, const QColorGroup & cg,
					const QRect & r );
	/** */
	virtual int width( const QFontMetrics&, const QListView*, int column) const;
	/** */
	virtual void setup();

	virtual int rtti() const;
	/** */
	void SetProgressEnable( bool b ) { m_bProgressEnable=b; }
	/** */
	void setProgress( int i );
	/** */
	void resetProgress();
	/** Reimplemented so sorting is by download/upload + percentage complete */
	virtual QString key( int n, bool ascending ) const;
	/** Set transfer state letter to d for download, u for upload etc. for sorting */
	void setTransferState( QString s );

private:
	/** */
	void init();
	/** */
	int m_nColumn;
	/** */
	bool m_bProgressEnable;
	/** */
	QProgressBar * m_ProgressBar;
	/** Needed for sorting transfers by upload/download */
	QString sTransferState;
};

#endif
