/***************************************************************************
                          dcconfig.h  -  description
                             -------------------
    begin                : Fri Mar 1 2002
    copyright            : (C) 2002 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCCONFIG_H
#define DCCONFIG_H

/**
  *@author Mathias Küster
  */

#include <qimage.h>
#include <qobject.h>
#include <QByteArray>
#include <QMap>
#include <QList>
#include <QStringList>

// the typedef in dcfriendobject.h prevents the forward
// declaration of "class FriendMap;" from working
#include "dcfriendobject.h"

#include <dclib/cconfig.h>

#define USERLIST_XPM_COLUMNS      9
#define USERLIST_XPM_ROWS        32
#define USERLIST_ICON_SIZE       16

/** */
typedef enum eUserSound {
	eusCONNECT,
	eusDISCONNECT,
	eusSEND,
	eusRECEIVE,
	eusFIRSTRECEIVE,
	eusNICKMENTIONED
} eUserSound;

/** */
typedef enum eTimeStamp {
	etsPRIVATECHAT,
	etsHUBCHAT
} eTimeStamp;

/** */
typedef enum eTransferViewOptions {
	etvoCHUNKPERCENT,
	etvoFILEPERCENT,
	etvoCHUNKSIZE,
	etvoFILESIZE,
	etvoDOWNLOADRATESINGLE,
	etvoELAPSEDTIMESINGLE,
	etvoDOWNLOADRATEMULTI,
	etvoELAPSEDTIMEMULTI
} eTransferViewOptions;

/** */
typedef enum eLogChatOptions {
	elcoENABLELOGGING,
	elcoAPPENDDATE,
	elcoAPPENDHUBNAME,
	elcoAPPENDHUBHOST,
	elcoDISABLEPUBLICCHAT,
	elcoENABLENICKNAMEFILTER,
	elcoNICKNAMEFILTER_ENABLELOGGING
} eLogChatOptions;

/** */
typedef enum eChatColor {
	eccCHATTIMESTAMP=0,
	eccCHATLOCALNICK,
	eccCHATLOCALTEXT,
	eccCHATREMOTENICK,
	eccCHATREMOTETEXT,
	eccCHATSTATUSNICK,
	eccCHATSTATUSTEXT,
	eccPUBLICCHATTIMESTAMP,
	eccPUBLICCHATLOCALNICK,
	eccPUBLICCHATLOCALTEXT,
	eccPUBLICCHATREMOTENICK,
	eccPUBLICCHATREMOTETEXT,
	eccPUBLICCHATSTATUSNICK,
	eccPUBLICCHATSTATUSTEXT,
	eccPUBLICPRIVATECHATNICK,
	eccPUBLICPRIVATECHATTEXT,
	eccCHATSAY,
	eccPUBLICCHATMENICK,
	eccOPNICK
} eChatColor;

/*
 * It is crazy that this does not match the default column
 * order (nick should be column 0) but changing it would break
 * restoring settings so we are stuck with it.
 */
typedef enum eClientColumn {
	eclcCOMMENT=0,
	eclcTAG,
	eclcEMAIL,
	eclcSPEED,
	eclcSHARE,
	eclcIP,
	eclcLOCKPK,
	eclcSUPPORTS,
	eclcNICK
} eClientColumn;

/* Download not supported */
typedef enum {
	eMagnetPrompt=0,
	eMagnetSearch,
	eMagnetDownload,
	eMagnetNothing
} eMagnetAction;

/* External magnet links not handled */
typedef enum {
	eChatMagnet=0,
	eExternalMagnet
} eMagnetSource;

/* Default application font. Needed from main.cpp too */
#define DEFAULT_APP_FONT	"Helvetica,12,-1,5,50,0,0,0,0,0"

class QPixmap;
class QProcess;
class QTextDocument;
class CXml;
class CMessageMyInfo;

/** */
typedef QMap<QString, QString> StringMap;
/** */
typedef QMap<QString, StringMap*> SettingMap;

/** */
class DC_EmoticonObject {
public:
	/** construtor */
	DC_EmoticonObject() {};
	/** destructor */
	~DC_EmoticonObject() {};

	/** */
	QString m_Text;
	/** */
	int left,top,right,bottom;
	/** */
	int m_nID;
};

/** */
class DC_HubFilterObject {
public:
	/** construtor */
	DC_HubFilterObject() {
		m_nUser        = 0;
		m_bName        = false;
		m_bServer      = false;
		m_bDescription = false;
	};
	/** destructor */
	~DC_HubFilterObject() {};

	/** */
	QString m_sFilterName;
	/** */
	QString m_sContains;
	/** */
	unsigned int m_nUser;
	/** */
	bool m_bName;
	/** */
	bool m_bServer;
	/** */
	bool m_bDescription;
};

/** Stores a user command for custom menus */
class DC_UserMenuCommand {
public:
	/** */
	DC_UserMenuCommand() {
		m_nContext  = 0;
		m_nType     = -1;
	};
	/** */
	~DC_UserMenuCommand() {};
	/**
	 * Command type. Separator, Raw or RawOnce.
	 */
	int m_nType;
	/** The name of the menu command */
	QString m_sName;
	/** The command to send to the hub */
	QString m_sCommand;
	/** Context is which menu(s) to put the command into */
	int m_nContext;
	/** Hub IP / DNS */
	QString m_sHubIP;
};

/** Stores a user custom chat command */
class DC_UserChatCommand {
public:
	/** */
	DC_UserChatCommand() {};
	/** */
	~DC_UserChatCommand() {};
	
	/** Name of the command */
	QString m_sName;
	/** Command string to run */
	QString m_sCommand;
};

/** Stores an auto response trigger and response pair */
class DC_AutoResponseObject {
public:
	/** */
	DC_AutoResponseObject() {
		m_bCaseSensitive = false;
	};
	/** */
	~DC_AutoResponseObject() {};
	
	/** Trigger QT regexp */
	QString m_sTrigger;
	/** Response */
	QString m_sResponse;
	/** Case sensitive or not */
	bool m_bCaseSensitive;
};

class DCConfig : public QObject, public CConfig {
Q_OBJECT

public:
	/** construtor */
	DCConfig( CString configpath = CString() );
	/** destructor */
	virtual ~DCConfig();

	/** */
	int Load();
	/** */
	int Save();

	/** */
	int LoadDCGui();
	/** */
	int SaveDCGui();
	/** */
	void ParseDCGuiConfig( CXml * xml );

	/** */
	int LoadDCHubFilter( QMap<QString, DC_HubFilterObject*> * map );
	/** */
	int SaveDCHubFilter( QMap<QString, DC_HubFilterObject*> * map );

	/** */
	int LoadDCFriendList( FriendMap * map );
	/** */
	int SaveDCFriendList( FriendMap * map );

	/** */
	bool GetOpenPrivateChatWindow() const;
	/** */
	void SetOpenPrivateChatWindow( bool b );
	/** */
	long GetChatMaxParagraph() const;
	/** */
	void SetChatMaxParagraph( long i );
	/** */
	bool GetChatShowJoinsAndParts() const;
	/** */
	void SetChatShowJoinsAndParts( bool b );
	/** */
	bool GetChatShowJoinsAndPartsOnlyFav() const;
	/** */
	void SetChatShowJoinsAndPartsOnlyFav( bool b );

	/** */
	eUnit GetUnit() const;
	/** */
	void SetUnit( eUnit unit );
	/** */
	bool GetTransferViewOptions( eTransferViewOptions e ) const;
	/** */
	void SetTransferViewOptions( eTransferViewOptions e, bool b );
	/** */
	QString GetTheme() const;
	/** */
	void SetTheme( QString theme );
	/**
	 * 0 is Ctrl + Enter
	 * 1 is Enter
	 * 2 is Alt + Enter
	 * 3 is Alt + S
	 */
	int GetSendChat() const;
	/** */
	void SetSendChat( int index );
	/** */
	QString GetLanguageFile() const;
	/** */
	void SetLanguageFile( QString languagefile );
	/** */
	bool GetTabBar() const;
	/** */
	void SetTabBar( bool b );
	/** */
	bool GetToolBar() const;
	/** */
	void SetToolBar( bool b );
	/** */
	bool GetStatusBar() const;
	/** */
	void SetStatusBar( bool b );
	/** */
	bool GetUserListRightAlignment() const;
	/** */
	void SetUserListRightAlignment( bool b );

	/** */
	QPixmap * GetUserIcon( CMessageMyInfo * myinfo );
	/** */
	void PlaySound( eUserSound usersound );
	/** */
	void PlaySound( QString file );

	/** */
	void SetAppFont( QString font );
	/** */
	QString GetAppFont() const;
	/** Set enable use of AppFont or use default font */
	void SetUseCustomFont( bool b );
	/** Get enable use of AppFont or use defaut font */
	bool GetUseCustomFont() const;

	/** */
	bool GetMap( QString name, StringMap *& map );

	/** */
	void SetAppGeometry( int width, int height );
	/** */
	void GetAppGeometry( int &width, int &height );

	/** */
	bool GetSoundDisabled() const;
	/** */
	void SetSoundDisabled( bool disabled );
	/** */
	bool GetSoundDisabledAway() const;
	/** */
	void SetSoundDisabledAway( bool disabled );
	/** */
	bool GetExternalSoundPlayer() const;
	/** */
	void SetExternalSoundPlayer( bool externalsoundplayer );
	/** */
	QString GetExternalPlayer() const;
	/** */
	void SetExternalPlayer( QString externalplayer );
	/** */
	QString GetSoundFile( eUserSound usersound );
	/** */
	void SetSoundFile( eUserSound usersound, QString soundfile );
	/** */
	bool GetSoundEnabled( eUserSound usersound );
	/** */
	void SetSoundEnabled( eUserSound usersound, bool enabled );

	/** */
	void SetTimeStamp( eTimeStamp timestamp, bool enabled );
	/** */
	bool GetTimeStamp( eTimeStamp timestamp );

	/** */
	void SetLogChatOption( eLogChatOptions elco, bool enabled );
	/** */
	bool GetLogChatOption( eLogChatOptions elco );
	/** */
	void SetLogChatNickNameFilter( QStringList list );
	/** */
	QStringList GetLogChatNickNameFilter();
	/** */
	bool CheckLogChatNickNameFilter( QString nick );

	/** */
	bool GetShowStatusMessage() const;
	/** */
	void SetShowStatusMessage( bool disabled );
	/** */
	bool GetShowTransferWin() const;
	/** */
	void SetShowTransferWin( bool disabled );

	/** */
	bool GetSendHidePrivateChatToPublicChat() const;
	/** */
	void SetSendHidePrivateChatToPublicChat( bool b );

	/** */
	bool GetEnableEmoticons() const;
	/** */
	void SetEnableEmoticons( bool b );

	/** */
	bool GetAutoAwayMode() const;
	/** */
	void SetAutoAwayMode( bool b );
	/** */
	unsigned int GetAutoAwayTime() const;
	/** */
	void SetAutoAwayTime( unsigned int n );

	/** */
	int GetChatMessageMaxLines() const;
	/** */
	void SetChatMessageMaxLines( int i );

	/** */
	int GetFloodCount() const;
	/** */
	void SetFloodCount( int i );
	/** */
	bool GetFloodOpKick() const;
	/** */
	void SetFloodOpKick( bool b );

	/** */
	bool GetThemeSupport() const;
	/** */
	void SetThemeSupport( bool b );
	/** */
	QString GetBackgroundPixmap() const;
	/** */
	void SetBackgroundPixmap( QString s );
	/** */
	QString GetBrowser() const;
	/** */
	void SetBrowser( QString s );
	/** Open the URL using the browser settings */
	void OpenURL( QString url );
	/** */
	bool GetCustomBrowser() const;
	/** */
	void SetCustomBrowser( bool b );

	/** */
	unsigned int GetDefaultDownloadMode() const;
	/** 0:ask, 1:single, 2:multi */
	void SetDefaultDownloadMode( unsigned int n, bool emitsig = false );

	/** */
	bool GetEnableTray() const;
	/** */
	void SetEnableTray( bool b );
	/** */
	bool GetQueryOnExit() const;
	/** */
	void SetQueryOnExit( bool b );
	/** */
	bool GetQueryOnFileDelete() const;
	/** */
	void SetQueryOnFileDelete( bool b );

	/** */
	bool GetShowChatSendButton() const;
	/** */
	void SetShowChatSendButton( bool b );
	/** */
	bool GetShowChatInTab() const;
	/** */
	void SetShowChatInTab( bool b );
	/** */
	QString GetChatColor( eChatColor type ) const;
	/** */
	void SetChatColor( eChatColor type, QString s );
 	/** */
	QString GetChatBackgroundColor() const;
	/** */
	bool GetChatBackgroundColorEnabled() const;
	/** */
	void SetChatBackgroundColor( bool enabled, QString color );
	/**
	 * 0 = minimized
	 * 1 = normal
	 * 2 = maximized
	 */
	int GetOpenClientWindows() const;
	/** */
	void SetOpenClientWindows( int i );

	/** */
	bool GetClientColumn( eClientColumn e );
	/** */
	void SetClientColumn( eClientColumn e, bool b );

	/** */
	int GetClientColumnWidth( eClientColumn e );
	/** */
	void SetClientColumnWidth( eClientColumn e, int i );

	/** */
	bool InitMimeSourceFactory();
	/** */
	QList<DC_EmoticonObject*> * EmoticonList();
	/** */
	QImage & GetEmoticonImage();
	/** adds emoticon resources to the text document */
	bool AddEmoticons( QTextDocument * document );

	/** */
	QString GetUserPhotoFileName() const;
	/** */
	void SetUserPhotoFileName( QString s );
	
	/** */
	QString GetValknutDataPath() const;
	/** */
	void SetValknutDataPath( QString s );
	
	/** Get the list of user chat commands, caller must delete them */
	long GetUserChatCommands( QList<DC_UserChatCommand*> * list );
	/** Set the list of user chat commands, transfers ownership of the objects to g_pConfig */
	void SetUserChatCommands( QList<DC_UserChatCommand*> * list );
	/**
	 * Instead of copying the list of commands to a DCChat and then deleting them all,
	 * send the text to g_pConfig and get the text with the commands substituted.
	 */
	QString ReplaceUserChatCommands( QString text );
	
	/** Get a copy of the list of user menu commands, caller must delete them */
	long GetUserMenuCommands( QMap<int, DC_UserMenuCommand*> * list );
	/** Get pointers to the actual user menu commands */
	long GetUserMenuCommandsDirect( QMap<int, DC_UserMenuCommand*> * list );
	/** Set the list of user menu commands, transfers ownership of the objects to g_pConfig */
	void SetUserMenuCommands( QMap<int, DC_UserMenuCommand*> * list );
	
	/** Gets the theme for application icons */
	QString GetApplicationIconTheme() const;
	/** Sets the theme for application icons */
	void SetApplicationIconTheme( QString s );
	
	/** Gets the theme for emoticons */
	QString GetEmoticonTheme() const;
	/** Sets the theme for emoticons */
	void SetEmoticonTheme( QString s );
	
	/** Gets the theme for userlist icons */
	QString GetUserListIconTheme() const;
	/**
	 * Sets the theme for userlist icons.
	 * Clears all cached pixmaps and loads the new image
	 * if the theme has changed.
	 */
	void SetUserListIconTheme( QString s );
	
	/** Gets the regexp of nicks to not open chat windows for */
	QString GetSuppressedNicks() const;
	/** Sets the regexp of nicks to not open chat windows for */
	void SetSuppressedNicks( QString s );
	
	/**
	 * Gets the action for double clicking a user
	 * 0 is private chat
	 * 1 is download filelist
	 */
	int GetDoubleClickAction() const;
	/** Sets the action for double clicking a user */
	void SetDoubleClickAction( int index );
	
	/** Gets if auto responder is enabled for main chat */
	bool GetAutoResponderEnabled() const;
	/** Enables/Disables the auto responder for main chat */
	void SetAutoResponderEnabled( bool b );
	/** Gets the list of auto response triggers and responses, the caller must delete them */
	long GetAutoResponses( QList<DC_AutoResponseObject*> * list );
	/** Sets the list of auto response triggers and responses, transfers ownership of the objects to g_pConfig */
	void SetAutoResponses( QList<DC_AutoResponseObject*> * list );
	/** Gets the minimum time between auto-responses */
	long GetAutoResponseDelay() const;
	/** Sets the minimum time between auto-responses */
	void SetAutoResponseDelay( long n );
	/** Gets list of nicks to not auto respond to */
	QString GetAutoResponseIgnores() const;
	/** Sets list of nicks to not auto respond to */
	void SetAutoResponseIgnores( QString s );
	/** Gets if the auto responder is enabled for PMs */
	bool GetAutoResponderEnabledForPM() const;
	/** Enables/Disabled the auto responder for private messages */
	void SetAutoResponderEnabledForPM( bool b );
	
	/** Gets filelist naming scheme version
	  * This is set internally so that the filelists are renamed
	  * once only when upgrading to 0.3.10.
	  * once only when upgrading to 0.3.17.
	  *
	  * 0 = 0.3.8 or earlier integers
	  * 1 = 0.3.9 base64 encoded
	  * 2 = 0.3.10 human readable nick-hubhost_port.filelist
	  * 3 = setting was abused for searchindex changes
	  * 4 = 0.3.17 human readable nick@hubhost_port.filelist
	  */
	int GetFilelistNamingSchemeVersion() const;
	/** Sets filelist naming scheme version */
	void SetFilelistNamingSchemeVersion( int i );
	/** Renames the filelists */
	void RenameStoredFilelists();
	
	/** Gets QMainWindow saved state */
	QByteArray GetQMainWindowState() const;
	/** Sets QMainWindow state */
	void SetQMainWindowState( QByteArray b );
	
	/** Get show folders in right pane of filelist browser*/
	bool GetFoldersInRightPane() const;
	/** Set show folders in right pane of filelist browser */
	void SetFoldersInRightPane( bool b );
	/** Get show subfolder sizes in left pane of filelist browser */
	bool GetFolderSizesInLeftPane() const;
	/** Set show subfolder sizes in left pane of filelist browser */
	void SetFolderSizesInLeftPane( bool b );
	/** Get sort folders in right pane on top */
	bool GetFoldersInRightPaneOnTop() const;
	/** Set sort folders in right pane on top */
	void SetFoldersInRightPaneOnTop( bool b );
	/** Get double click right pane folders opens them */
	bool GetOpenFoldersInRightPane() const;
	/** Set double click right pane folders opens them */
	void SetOpenFoldersInRightPane( bool b );
	/** Get send unknown /commands as chat */
	bool GetSendUnknownCommandsAsChat() const;
	/** Set send unknown /commands as chat */
	void SetSendUnknownCommandsAsChat( bool b );
	/** Get allowed unknown commands */
	QString GetAllowedUnknownCommands() const;
	/** Set allowed unknown commands */
	void SetAllowedUnknownCommands( QString s );
	/** Get fix hub details in search results */
	bool GetAdjustSearchResultHubNames() const;
	/** Set fix hub details in search results */
	void SetAdjustSearchResultHubNames( bool b );
	/** Get remove public hub menu item enabled */
	bool GetRemovePublicHubEnabled() const;
	/** Set remove public hub menu item enabled */
	void SetRemovePublicHubEnabled( bool b );
	
	/** Tab completion mode
	 * 0 = contains
	 * 1 = startsWith
	 */
	int GetTabCompleteMatchMode() const;
	/** And set tab completion mode */
	void SetTabCompleteMatchMode( int i );
	/** Remove [] tags from nicks */
	bool GetTabCompleteStripTags() const;
	/** Set remove [] tags from nicks */
	void SetTabCompleteStripTags( bool b );
	
	/** Get use threads for running shell commands from chat */
	bool GetThreadsForShellCommands() const;
	/** Set use threads for running shell commands from chat */
	void SetThreadsForShellCommands( bool b );
	/** Get shell command timeout (seconds) */
	int GetShellCommandTimeout() const;
	/** Set shell command timeout (seconds) */
	void SetShellCommandTimeout( int s );
	
	/** Get use submenu for user commands */
	bool GetUserCommandSubmenu() const;
	/** Set use submenu for user commands */
	void SetUserCommandSubmenu( bool b );
	
	/** Get default magnet action */
	eMagnetAction GetMagnetAction( eMagnetSource = eChatMagnet ) const;
	/** Set default magnet action */
	void SetMagnetAction( eMagnetAction act, eMagnetSource = eChatMagnet );
	
signals:
	/** emitted when the emoticon theme has changed */
	virtual void emoticonThemeChanged();
	/** emitted after chat background color settings have changed */
	virtual void chatBackgroundColorChanged();
	/** emitted after the default download mode has been changed not from the main menu */
	virtual void defaultDownloadModeChanged();
	
private:
	/** */
	QString m_sValknutDataPath;
	
	/** */
	SettingMap m_guiSettingMap;

	/** */
	bool bOpenPrivateChatWindow;
	/** */
	long m_nChatMaxParagraph;
	/** */
	bool bShowTransferWin;
	/** */
	bool bTabBar;
	/** */
	bool bToolBar;
	/** */
	bool bStatusBar;
	/** */
	bool bUserListRightAlignment;
	/** */
	eUnit m_eUnit;
	/** */
	QString sTheme;
	/** Needed to avoid removing the QT3 version's theme setting */
	QString sThemeQT3;
	/** */
	int m_nSendChat;
	/** */
	bool bThemeSupport;
	/** */
	QString sLanguageFile;
	/** Application font */
	QString sAppFont;
	/** If true, use sAppFont, if false, use system default font */
	bool m_bUseCustomFont;
	/** Application height */
	int iAppHeight;
	/** Application Width */
	int iAppWidth;
	/** */
	bool bSoundDisabled;
	/** */
	bool bSoundDisabledAway;
	/** */
	bool bSoundEnabledConnect;
	/** */
	bool bSoundEnabledDisconnect;
	/** */
	bool bSoundEnabledSend;
	/** */
	bool bSoundEnabledReceive;
	/** */
	bool bSoundEnabledFirstReceive;
	/** */
	bool bSoundEnabledNickMentioned;
	/** */
	bool bExternalSoundPlayer;
	/** */
	QString sExternalPlayer;
	/** connect sound file */
	QString sSoundFileConnect;
	/** disconnect sound file */
	QString sSoundFileDisconnect;
	/** send sound file */
	QString sSoundFileSend;
	/** receive sound file */
	QString sSoundFileReceive;
	/** first receive sound file */
	QString sSoundFileFirstReceive;
	/** nick said in public chat */
	QString sSoundFileNickMentioned;

	/** */
	bool bEnableEmoticons;
	/** */
	bool bTimeStampPrivateChat;
	/** */
	bool bTimeStampHubChat;
	/** */
	bool bShowStatusMessage;
	/** */
	bool bSendHidePrivateChatToPublicChat;
	/** */
	bool bTVChunkPercent;
	/** */	
	bool bTVFilePercent;
	/** */	
	bool bTVChunkSize;
	/** */
	bool bTVFileSize;
	/** */	
	bool bTVDownloadRateSingle;
	/** */	
	bool bTVElapsedTimeSingle;
	/** */	
	bool bTVDownloadRateMulti;
	/** */	
	bool bTVElapsedTimeMulti;
		
	/** */
	bool m_bLogChatOption_1;
	/** */
	bool m_bLogChatOption_2;
	/** */
	bool m_bLogChatOption_3;
	/** */
	bool m_bLogChatOption_4;
	/** */
	bool m_bLogChatOption_5;
	/** */
	bool m_bLogChatOption_6;
	/** */
	bool m_bLogChatOption_7;
	/** */
	QStringList m_LogChatNickNameFilter;

	/** */
	int iChatMessageMaxLines;
	
	/** */
	int iFloodCount;
	/** */
	bool m_bFloodOpKick;

	/** */
	QList<DC_EmoticonObject*> * m_pEmoticons;
	/** */
	QImage m_EmoticonImage;

	/** */
	QProcess * pProcess;

	/** */
	QPixmap * m_UserIconCache[USERLIST_XPM_COLUMNS][USERLIST_XPM_ROWS];
	/** */
	QImage m_UserIcons;

	/** 0:ask, 1:single, 2:multi */
	unsigned int iDefaultDownloadMode;
	/** */
	bool m_bAutoAwayMode;
	/** */
	unsigned int m_nAutoAwayTime;

	/** */
	bool m_bEnableTray;
	/** */
	bool bQueryOnExit;
	/** */
	bool bQueryOnFileDelete;
	/** */
	bool bShowChatSendButton;
	/** */
	QString sBackgroundPixmap;
	/** */
	QString sBrowser;
	/** true to use sBrowser, false to use QDesktopServices */
	bool m_bCustomBrowser;
	/** */
	bool bShowChatInTab;
	/** */
	QString m_sChatColor_1;
	/** */
	QString m_sChatColor_2;
	/** */
	QString m_sChatColor_3;
	/** */
	QString m_sChatColor_4;
	/** */
	QString m_sChatColor_5;
	/** */
	QString m_sChatColor_6;
	/** */
	QString m_sChatColor_7;
	/** */
	QString m_sChatColor_8;
	/** */
	QString m_sChatColor_9;
	/** */
	QString m_sChatColor_10;
	/** */
	QString m_sChatColor_11;
	/** */
	QString m_sChatColor_12;
	/** */
	QString m_sChatColor_13;
	/** */
	QString m_sChatColor_14;
	/** */
	QString m_sChatColor_15;
	/** */
	QString m_sChatColor_16;
	/** */
	QString m_sChatColor_17;
	/** */
	QString m_sChatColor_18;
	/** Colour for operator nick */
	QString m_sChatColor_19;
	/** true to use custom chat background color */
	bool m_bChatBackgroundColorEnabled;
	/** */
	QString m_sChatBackgroundColor;
	/** */
	int m_nOpenClientWindows;
	/** */
	bool m_bChatShowJoinsAndParts;
	/** */
	bool m_bChatShowJoinsAndPartsOnlyFav;

	/** */
	bool m_bClientColumnComment;
	/** */
	bool m_bClientColumnTag;
	/** */
	bool m_bClientColumnEMail;
	/** */
	bool m_bClientColumnSpeed;
	/** */
	bool m_bClientColumnShare;
	/** */
	bool m_bClientColumnIP;
	/** */
	bool m_bClientColumnLOCKPK;
	/** */
	bool m_bClientColumnSUPPORTS;

	/** */
	int iClientColumnNick;
	/** */
	int iClientColumnComment;
	/** */
	int iClientColumnTag;
	/** */
	int iClientColumnEMail;
	/** */
	int iClientColumnSpeed;
	/** */
	int iClientColumnShare;
	/** */
	int iClientColumnIP;
	/** */
	int iClientColumnLOCKPK;
	/** */
	int iClientColumnSUPPORTS;

	/** */
	QString m_sUserPhotoFileName;
	
	/** The list of user customized chat commands */
	QList<DC_UserChatCommand*> m_lUserChatCommands;

	/** The list of user customized menu commands - now in order! */
	QMap<int, DC_UserMenuCommand*> m_UserMenuCommands;
	
	/** Theme for application icons */
	QString m_sApplicationIconTheme;
	
	/** Theme for emoticons */
	QString m_sEmoticonTheme;
	
	/** Theme for userlist icons */
	QString m_sUserListIconTheme;
	
	/** Regexp of nicks to not open chat windows for */
	QString m_sSuppressedNicks;
	
	/**
	 * Action to do on double clicking a user
	 * 0 is private chat
	 * 1 is download filelist
	 */
	int m_nDoubleClickAction;
	
	/** True if auto responder is enabled for main chat */
	bool m_bAutoResponderEnabled;
	
	/** True if auto responder is enabled for private messages */
	bool m_bAutoResponderEnabledForPM;
	
	/** The list of auto response triggers and responses */
	QList<DC_AutoResponseObject*> m_lAutoResponses;
	
	/** The time between consequtive auto-responses for a user */
	long m_nAutoResponseDelay;
	
	/** A list of nicks to not auto respond to */
	QString m_sAutoResponseIgnores;
	
	/** The filelist naming scheme version.
	  * This is set internally so that the filelists are renamed
	  * once only when upgrading to 0.3.10.
	  */
	int m_nFilelistNamingSchemeVersion;
	
	/** Saved QT4 QMainWindow state */
	QByteArray m_baQMainWindowState;
	
	/** Show folders in right pane of filelist browser? */
	bool m_bFoldersInRightPane;
	/** Show subfolder sizes in left pane of filelist browser? */
	bool m_bFolderSizesInLeftPane;
	/** Sort folders in right pane on top */
	bool m_bFoldersInRightPaneOnTop;
	/** Open folders in right pane by double clicking */
	bool m_bOpenFoldersInRightPane;
	/** Send unknown /commands as chat */
	bool m_bSendUnknownCommandsAsChat;
	/** List of allowed unknown commands */
	QString m_sAllowedUnknownCommands;
	/** Adjust hub details in search results */
	bool m_bAdjustSearchResultHubNames;
	/** True if the remove public hub item is enabled */
	bool m_bRemovePublicHubEnabled;
	
	/** */
	int m_nTabCompleteMatchMode;
	/** */
	bool m_bTabCompleteStripTags;
	
	/** use threads to start shell commands and wait for them to finish */
	bool m_bThreadsForShellCommands;
	/** how long to wait for shell commands to finish when not using threads */
	int m_nShellCommandTimeout;
	
	/** if true, user commands start in a submenu */
	bool m_bUserCommandSubmenu;
	
	/** default magnet action */
	eMagnetAction m_eMagnetActionChat;
};

/** global config */
extern DCConfig * g_pConfig;

/** inline functions */

/** */
inline bool DCConfig::GetOpenPrivateChatWindow() const
{ return bOpenPrivateChatWindow; }
/** */
inline void DCConfig::SetOpenPrivateChatWindow( bool b )
{ bOpenPrivateChatWindow = b; }
/** */
inline bool DCConfig::GetTabBar() const
{ return bTabBar; }
/** */
inline void DCConfig::SetTabBar( bool b )
{ bTabBar = b; }
/** */
inline bool DCConfig::GetToolBar() const
{ return bToolBar; }
/** */
inline void DCConfig::SetToolBar( bool b )
{ bToolBar = b; }
/** */
inline bool DCConfig::GetStatusBar() const
{ return bStatusBar; }
/** */
inline void DCConfig::SetStatusBar( bool b )
{ bStatusBar = b; }
/** */
inline bool DCConfig::GetUserListRightAlignment() const
{ return bUserListRightAlignment; }
/** */
inline void DCConfig::SetUserListRightAlignment( bool b )
{ bUserListRightAlignment = b; }
/** */
inline eUnit DCConfig::GetUnit() const
{ return m_eUnit; }
/** */
inline void DCConfig::SetUnit( eUnit unit )
{ m_eUnit = unit; }
/** */
inline QString DCConfig::GetTheme() const
{ return sTheme; }
/** */
inline void DCConfig::SetTheme( QString theme )
{ sTheme = theme; }

/** */
inline int DCConfig::GetSendChat() const
{ return m_nSendChat; }
/** */
inline void DCConfig::SetSendChat( int index )
{ m_nSendChat = index; }

/** */
inline QString DCConfig::GetLanguageFile() const
{ return sLanguageFile; }
/** */
inline void DCConfig::SetLanguageFile( QString languagefile )
{ sLanguageFile = languagefile; }

inline QString DCConfig::GetAppFont() const
{ return sAppFont; }
inline void DCConfig::SetAppFont(QString font)
{ sAppFont = font; }
/** */
inline bool DCConfig::GetUseCustomFont() const
{ return m_bUseCustomFont; }
/** */
inline void DCConfig::SetUseCustomFont( bool b )
{ m_bUseCustomFont = b; }
/** */
inline void DCConfig::SetAppGeometry( int width, int height )
{ iAppWidth=width;iAppHeight=height; }
/** */
inline void DCConfig::GetAppGeometry( int &width, int &height )
{ width=iAppWidth;height=iAppHeight; }
/** */
inline bool DCConfig::GetSoundDisabled() const
{ return bSoundDisabled; }
/** */
inline void DCConfig::SetSoundDisabled( bool disabled )
{ bSoundDisabled = disabled; }
/** */
inline bool DCConfig::GetSoundDisabledAway() const
{ return bSoundDisabledAway; }
/** */
inline void DCConfig::SetSoundDisabledAway( bool disabled )
{ bSoundDisabledAway = disabled; }
/** */
inline bool DCConfig::GetExternalSoundPlayer() const
{ return bExternalSoundPlayer; }
/** */
inline void DCConfig::SetExternalSoundPlayer( bool externalsoundplayer )
{ bExternalSoundPlayer = externalsoundplayer; }
/** */
inline QString DCConfig::GetExternalPlayer() const
{ return sExternalPlayer; }
/** */
inline void DCConfig::SetExternalPlayer( QString externalplayer )
{ sExternalPlayer = externalplayer; }
/** */
inline bool DCConfig::GetShowStatusMessage() const
{ return bShowStatusMessage; }
/** */
inline void DCConfig::SetShowStatusMessage( bool b )
{ bShowStatusMessage = b; }
/** */
inline bool DCConfig::GetShowTransferWin() const
{ return bShowTransferWin; }
/** */
inline void DCConfig::SetShowTransferWin( bool b )
{ bShowTransferWin = b; }
/** */
inline bool DCConfig::GetThemeSupport() const
{ return bThemeSupport; }
/** */
inline void DCConfig::SetThemeSupport( bool b )
{ bThemeSupport = b; }
/** */
inline bool DCConfig::GetSendHidePrivateChatToPublicChat() const
{ return bSendHidePrivateChatToPublicChat; }
/** */
inline void DCConfig::SetSendHidePrivateChatToPublicChat( bool b )
{ bSendHidePrivateChatToPublicChat = b; }
/** */
inline int DCConfig::GetChatMessageMaxLines() const
{ return iChatMessageMaxLines; }
/** */
inline void DCConfig::SetChatMessageMaxLines( int i )
{ iChatMessageMaxLines = i; }
/** */
inline void DCConfig::SetFloodCount( int i )
{ iFloodCount = i; }
/** */
inline int DCConfig::GetFloodCount() const
{ return iFloodCount; }
/** */
inline void DCConfig::SetFloodOpKick( bool b )
{ m_bFloodOpKick = b; }
/** */
inline bool DCConfig::GetFloodOpKick() const
{ return m_bFloodOpKick; }
/** */
inline unsigned int DCConfig::GetDefaultDownloadMode() const
{ return iDefaultDownloadMode; }
/** */
inline bool DCConfig::GetEnableEmoticons() const
{ return bEnableEmoticons; }
/** */
inline void DCConfig::SetEnableEmoticons( bool b )
{ bEnableEmoticons = b; }
/** */
inline bool DCConfig::GetQueryOnExit() const
{ return bQueryOnExit; }
/** */
inline void DCConfig::SetQueryOnExit( bool b )
{ bQueryOnExit = b; }
/** */
inline bool DCConfig::GetEnableTray() const
{ return m_bEnableTray; }
/** */
inline void DCConfig::SetEnableTray( bool b )
{ m_bEnableTray = b; }
/** */
inline bool DCConfig::GetQueryOnFileDelete() const
{ return bQueryOnFileDelete; }
/** */
inline void DCConfig::SetQueryOnFileDelete( bool b )
{ bQueryOnFileDelete = b; }
/** */
inline bool DCConfig::GetShowChatSendButton() const
{ return bShowChatSendButton; }
/** */
inline void DCConfig::SetShowChatSendButton( bool b )
{ bShowChatSendButton = b; }
/** */
inline QString DCConfig::GetBackgroundPixmap() const
{ return sBackgroundPixmap; }
/** */
inline void DCConfig::SetBackgroundPixmap( QString s )
{ sBackgroundPixmap = s; }
/** */
inline QString DCConfig::GetBrowser() const
{ return sBrowser; }
/** */
inline void DCConfig::SetBrowser( QString s )
{ sBrowser = s; }
/** */
inline bool DCConfig::GetCustomBrowser() const
{ return m_bCustomBrowser; }
/** */
inline void DCConfig::SetCustomBrowser( bool b )
{ m_bCustomBrowser = b; }
/** */
inline bool DCConfig::GetShowChatInTab() const
{ return bShowChatInTab; }
/** */
inline void DCConfig::SetShowChatInTab( bool b )
{ bShowChatInTab = b; }
/** */
inline long DCConfig::GetChatMaxParagraph() const
{ return m_nChatMaxParagraph; }
/** */
inline void DCConfig::SetChatMaxParagraph( long i )
{ m_nChatMaxParagraph = i; }
/** */
inline int DCConfig::GetOpenClientWindows() const
{ return m_nOpenClientWindows; }
/** */
inline void DCConfig::SetOpenClientWindows( int i )
{ m_nOpenClientWindows = i; }
/** */
inline bool DCConfig::GetAutoAwayMode() const
{ return m_bAutoAwayMode; }
/** */
inline void DCConfig::SetAutoAwayMode( bool b )
{ m_bAutoAwayMode = b; }
/** */
inline unsigned int DCConfig::GetAutoAwayTime() const
{ return m_nAutoAwayTime; }
/** */
inline void DCConfig::SetAutoAwayTime( unsigned int n )
{ m_nAutoAwayTime = n; }
/** */
inline bool DCConfig::GetChatShowJoinsAndParts() const
{ return m_bChatShowJoinsAndParts; }
/** */
inline void DCConfig::SetChatShowJoinsAndParts( bool b )
{ m_bChatShowJoinsAndParts = b; }
/** */
inline bool DCConfig::GetChatShowJoinsAndPartsOnlyFav() const
{ return m_bChatShowJoinsAndPartsOnlyFav; }
/** */
inline void DCConfig::SetChatShowJoinsAndPartsOnlyFav( bool b )
{ m_bChatShowJoinsAndPartsOnlyFav = b; }
/** */
inline QString DCConfig::GetUserPhotoFileName() const
{ return m_sUserPhotoFileName; }
/** */
inline void DCConfig::SetUserPhotoFileName( QString s )
{ m_sUserPhotoFileName = s; }
/** */
inline QString DCConfig::GetValknutDataPath() const
{ return m_sValknutDataPath; }
/** */
inline void DCConfig::SetValknutDataPath( QString s )
{ m_sValknutDataPath = s; }
/** */
inline QString DCConfig::GetApplicationIconTheme() const
{ return m_sApplicationIconTheme; }
/** */
inline void DCConfig::SetApplicationIconTheme( QString s )
{ m_sApplicationIconTheme = s; }
/** */
inline QString DCConfig::GetEmoticonTheme() const
{ return m_sEmoticonTheme; }
/** */
inline void DCConfig::SetEmoticonTheme( QString s )
{ m_sEmoticonTheme = s; }
/** */
inline QString DCConfig::GetUserListIconTheme() const
{ return m_sUserListIconTheme; }
/** */
inline QString DCConfig::GetSuppressedNicks() const
{ return m_sSuppressedNicks; }
/** */
inline void DCConfig::SetSuppressedNicks( QString s )
{ m_sSuppressedNicks = s; }
/** */
inline int DCConfig::GetDoubleClickAction() const
{ return m_nDoubleClickAction; }
/** */
inline void DCConfig::SetDoubleClickAction( int index )
{ m_nDoubleClickAction = index; }
/** */
inline bool DCConfig::GetAutoResponderEnabled() const
{ return m_bAutoResponderEnabled; }
/** */
inline void DCConfig::SetAutoResponderEnabled( bool b )
{ m_bAutoResponderEnabled = b; }
/** */
inline long DCConfig::GetAutoResponseDelay() const
{ return m_nAutoResponseDelay; }
/** */
inline void DCConfig::SetAutoResponseDelay( long n )
{ m_nAutoResponseDelay = n; }
/** */
inline QString DCConfig::GetAutoResponseIgnores() const
{ return m_sAutoResponseIgnores; }
/** */
inline void DCConfig::SetAutoResponseIgnores( QString s )
{ m_sAutoResponseIgnores = s; }
/** */
inline bool DCConfig::GetAutoResponderEnabledForPM() const
{ return m_bAutoResponderEnabledForPM; }
/** */
inline void DCConfig::SetAutoResponderEnabledForPM( bool b )
{ m_bAutoResponderEnabledForPM = b; }
/** */
inline int DCConfig::GetFilelistNamingSchemeVersion() const
{ return m_nFilelistNamingSchemeVersion; }
/** */
inline void DCConfig::SetFilelistNamingSchemeVersion( int i )
{ m_nFilelistNamingSchemeVersion = i; }
/** */
inline QByteArray DCConfig::GetQMainWindowState() const
{ return m_baQMainWindowState; }
/** */
inline void DCConfig::SetQMainWindowState( QByteArray ba )
{ m_baQMainWindowState = ba; }
/** */
inline bool DCConfig::GetFoldersInRightPane() const
{ return m_bFoldersInRightPane; }
/** */
inline void DCConfig::SetFoldersInRightPane( bool b)
{ m_bFoldersInRightPane = b; }
/** */
inline bool DCConfig::GetFolderSizesInLeftPane() const
{ return m_bFolderSizesInLeftPane; }
/** */
inline void DCConfig::SetFolderSizesInLeftPane( bool b )
{ m_bFolderSizesInLeftPane = b; }
/** */
inline bool DCConfig::GetFoldersInRightPaneOnTop() const
{ return m_bFoldersInRightPaneOnTop; }
/** */
inline void DCConfig::SetFoldersInRightPaneOnTop( bool b )
{ m_bFoldersInRightPaneOnTop = b; }
/** */
inline bool DCConfig::GetOpenFoldersInRightPane() const
{ return m_bOpenFoldersInRightPane; }
/** */
inline void DCConfig::SetOpenFoldersInRightPane( bool b )
{ m_bOpenFoldersInRightPane = b; }
/** */
inline bool DCConfig::GetSendUnknownCommandsAsChat() const
{ return m_bSendUnknownCommandsAsChat; }
/** */
inline void DCConfig::SetSendUnknownCommandsAsChat( bool b )
{ m_bSendUnknownCommandsAsChat = b; }
/** */
inline QString DCConfig::GetAllowedUnknownCommands() const
{ return m_sAllowedUnknownCommands; }
/** */
inline void DCConfig::SetAllowedUnknownCommands( QString s )
{ m_sAllowedUnknownCommands = s; }
/** */
inline bool DCConfig::GetAdjustSearchResultHubNames() const
{ return m_bAdjustSearchResultHubNames; }
/** */
inline void DCConfig::SetAdjustSearchResultHubNames( bool b )
{ m_bAdjustSearchResultHubNames = b; }
/** */
inline bool DCConfig::GetRemovePublicHubEnabled() const
{ return m_bRemovePublicHubEnabled; }
/** */
inline void DCConfig::SetRemovePublicHubEnabled( bool b )
{ m_bRemovePublicHubEnabled = b; }
/** */
inline int DCConfig::GetTabCompleteMatchMode() const
{ return m_nTabCompleteMatchMode; }
/** */
inline void DCConfig::SetTabCompleteMatchMode( int i )
{ m_nTabCompleteMatchMode = i; }
/** */
inline bool DCConfig::GetTabCompleteStripTags() const
{ return m_bTabCompleteStripTags; }
/** */
inline void DCConfig::SetTabCompleteStripTags( bool b )
{ m_bTabCompleteStripTags = b; }
/** */
inline bool DCConfig::GetThreadsForShellCommands() const
{ return m_bThreadsForShellCommands; }
/** */
inline void DCConfig::SetThreadsForShellCommands( bool b )
{ m_bThreadsForShellCommands = b; }
/** */
inline int DCConfig::GetShellCommandTimeout() const
{ return m_nShellCommandTimeout; }
/** */
inline void DCConfig::SetShellCommandTimeout( int s )
{ m_nShellCommandTimeout = s; }
/** */
inline bool DCConfig::GetUserCommandSubmenu() const
{ return m_bUserCommandSubmenu; }
/** */
inline void DCConfig::SetUserCommandSubmenu( bool b )
{ m_bUserCommandSubmenu = b; }
/** */
inline bool DCConfig::GetChatBackgroundColorEnabled() const
{ return m_bChatBackgroundColorEnabled; }
/** */
inline QString DCConfig::GetChatBackgroundColor() const
{ return m_sChatBackgroundColor; }
#endif
