/***************************************************************************
         dcfilebrowseritems.cpp  -  Items used by DCFileBrowser
                             -------------------
    begin                : Thu Jul 3 2008
    copyright            : (C) 2002-2004 by Mathias Küster
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dcfilebrowseritems.h"

/** Faster than using key(), probably */
int DCFileBrowserListItem::compare( Q3ListViewItem * i, int col, bool ascending ) const
{
	if ( col == 1 )
	{
		if ( m_nBytes < ((DCFileBrowserListItem*)i)->m_nBytes )
		{
			return -1;
		}
		else if ( m_nBytes == ((DCFileBrowserListItem*)i)->m_nBytes )
		{
			return 0;
		}
		else
		{
			return 1;
		}
	}
	else
	{
		return Q3ListViewItem::compare( i, col, ascending );
	}
}

/** No longer used because compare() will be used instead */
QString DCFileBrowserListItem::key( int column, bool ascending ) const
{
	if ( column == 1 )
	{
		return QString().setNum(m_nBytes).rightJustified( 20, '0' );
	}
	else
	{
		return Q3ListViewItem::key( column, ascending );
	}
}

/** sort top parts copied from DC_UserListItem */
int DC_FBListViewItem::compare( Q3ListViewItem * i, int col, bool ascending ) const
{
	if ( m_bSortTop && !((DC_FBListViewItem*)i)->m_bSortTop )
	{
		return ascending ? -1 : 1;
	}
	else if ( !m_bSortTop && ((DC_FBListViewItem*)i)->m_bSortTop )
	{
		return ascending ? 1 : -1;
	}
	else
	{
		return DC_QListViewItem::compare( i, col, ascending );
	}
}
