/***************************************************************************
                          dcmenuhandler.cpp  -  description
                             -------------------
    begin                : Don Mai 16 2002
    copyright            : (C) 2002-2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dcmenuhandler.h"

#include <QPixmap>

#include "dciconloader.h"

DCMenuHandler::DCMenuHandler()
{
}

DCMenuHandler::~DCMenuHandler()
{
}

/** */
QAction * DCMenuHandler::addAction( QMenu * menu, eMenuItems menuitems, bool enabled, QString text )
{
	QAction * action = 0;

	if(!menu)
	{
		return 0;
	}

	switch(menuitems)
	{
		case emiSEPARATOR:
				action = menu->addSeparator();
				break;
		case emiDOWNLOAD:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiDOWNLOAD) ), QObject::tr("Download") );
				break;
		case emiDOWNLOAD_TO:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiDOWNLOAD) ), QObject::tr("Download To") );
				break;
		case emiDOWNLOAD_AS:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiDOWNLOAD) ), QObject::tr("Download As") );
				break;
		case emiDOWNLOAD_REPAIR:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiDOWNLOAD) ), QObject::tr("Repair File") );
				break;
		case emiDOWNLOAD_BIN_SECTORS:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiDOWNLOAD) ), QObject::tr("Repair BIN sectors") );
				break;
		case emiDOWNLOAD_IN:
				action = menu->addAction( QObject::tr("Add this extra source") );
				break;
		case emiDOWNLOAD_FOLDER:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiDOWNLOAD) ), QObject::tr("Download Folder") );
				break;
		case emiBROWSE_USER_FILES:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiVIEW_SIDETREE) ), QObject::tr("Browse User Files") );
				break;
		case emiCHECK_CLIENT_VERSION:
				action = menu->addAction( QObject::tr("Check client version") );
				break;
		case emiPRIVATE_CHAT:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiMESSAGE) ), QObject::tr("Private Chat") );
				break;
		case emiKICK:
				action = menu->addAction( QObject::tr("Kick") );
				break;
		case emiFORCE_MOVE:
				action = menu->addAction( QObject::tr("Force Move") );
				break;
		case emiUPDATE_USER:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiRELOAD) ), QObject::tr("Update User") );
				break;
		case emiCONNECT:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiCONNECT_CREATING) ), QObject::tr("Connect") );
				break;
		case emiDISCONNECT:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiCONNECT_NO) ), QObject::tr("Disconnect") );
				break;
		case emiRELOAD_USERLIST:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiRELOAD) ), QObject::tr("Reload Userlist") );
				break;
		case emiCONNECT_TO_HUB:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiCONNECT_CREATING) ), QObject::tr("Connect To Hub") );
				break;
		case emiCONNECT_TO_ALL_HUBS:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiCONNECT_CREATING) ), QObject::tr("Connect To All Hubs") );
				break;
		case emiADD:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiEDITADD) ), QObject::tr("Add") );
				break;
		case emiADD_BOOKMARK:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiBOOKMARK_ADD) ), QObject::tr("Add Bookmark") );
				break;
		case emiEDIT:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiEDIT) ), QObject::tr("Edit") );
				break;
		case emiEDIT_BOOKMARK:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiEDIT) ), QObject::tr("Edit Bookmark") );
				break;
		case emiREMOVE:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiEDITDELETE) ), QObject::tr("Remove") );
				break;
		case emiCLOSE_TRANSFER:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiCONNECT_NO) ), QObject::tr("Close Transfer") );
				break;
		case emiINFO:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiINFO) ), QObject::tr("Info") );
				break;
		case emiTRY_CONNECT:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiCONNECT_CREATING) ), QObject::tr("Try Connect") );
				break;
		case emiPAUSE_TRANSFER_QUEUE:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiPLAYER_PAUSE) ), QObject::tr("Pause Queue") );
				break;
		case emiRESUME_TRANSFER_QUEUE:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiPLAYER_PLAY) ), QObject::tr("Resume Queue") );
				break;
		case emiREMOVE_TRANSFER_QUEUE:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiEDITDELETE) ), QObject::tr("Remove from Queue") );
				break;
		case emiREMOVE_TRANSFER_QUEUE_COMPLETE:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiEDITDELETE) ), QObject::tr("Remove complete from Queue") );
				break;
		case emiREMOVE_TRANSFER_QUEUE_DISK:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiEDITDELETE) ), QObject::tr("Remove Transfer from Queue and Disk") );
				break;
		case emiADD_PERMANENT:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiEDITADD) ), QObject::tr("Add Permanent") );
				break;
		case emiSAVE_QUEUE:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiSAVE) ), QObject::tr("Save Queue") );
				break;
		case emiUPDATE_SERVER:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiRELOAD) ), QObject::tr("Update Server") );
				break;
		case emiUPDATE_ALL_SERVER:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiRELOAD) ), QObject::tr("Update all Server") );
				break;
		case emiCHANGE_TRANSFER_RATE:
				action = menu->addAction( QObject::tr("Change Transfer-Rate") );
				break;
		case emiCOPY_ROW_TO_CLIPBOARD:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiEDITCOPY) ), QObject::tr("Copy row to Clipboard") );
				break;
		case emiCOPY_COLUMN_TO_CLIPBOARD:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiEDITCOPY) ), QObject::tr("Copy column to Clipboard") );
				break;
		case emiFILE_INFO:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiINFO) ), QObject::tr("File Info") );
				break;
		case emiSEARCH_FILE_CLONE:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFILEFIND) ), QObject::tr("Search for clones") );
				break;
		case emiSEARCH_FILE_CLONE_TTH:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFILEFIND) ), QObject::tr("Search for clones by TTH") );
				break;				
		case emiUSER_CAPTION:
				action = menu->addAction( text );
				break;
		case emiLOAD:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiOPEN) ), QObject::tr("Load") );
				break;
		case emiSAVE:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiSAVE) ), QObject::tr("Save") );
				break;
		case emiHUB_PROFILE_EDITOR:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiEDIT) ), QObject::tr("Profile editor") );
				break;
		case emiEDIT_TRANSFER:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiEDIT) ), QObject::tr("Edit transfer") );
				break;
		case emiEDIT_FILE_PRIORITY:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiEDIT) ), QObject::tr("Edit file priority") );
				break;
		case emiTRANSLATE:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiTRANSLATE) ), QObject::tr("Translate") );
				break;
		case emiTRANSLATOR:
				action = menu->addAction( QObject::tr("Translator") );
				break;
		case emiINSERTSMILEY:
				action = menu->addAction( QObject::tr("Insert Smiley") );
				break;
		case emiADD_FRIEND:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiEDITADD) ), QObject::tr("Add Friend") );
				break;
		case emiREQUEST_SECURE_CHAT:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiSSL_YES) ), QObject::tr("Request secure chat") );
				break;
		case emiCLOSE_SECURE_CHAT:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiSSL_NO) ), QObject::tr("Close secure chat") );
				break;
		case emiDISABLE_GROUP:
				action = menu->addAction( QObject::tr("Disable group") );
				break;
		case emiGROUP_BY_FILE:
				action = menu->addAction( QObject::tr("Group by File") );
				break;
		case emiGROUP_BY_SIZE:
				action = menu->addAction( QObject::tr("Group by Size") );
				break;
		case emiGROUP_BY_NICK:
				action = menu->addAction( QObject::tr("Group by Nick") );
				break;
		case emiGROUP_BY_HASH:
				action = menu->addAction( QObject::tr("Group by Hash") );
				break;
		case emiGROUP_BY_SLOTS_FREE:
				action = menu->addAction( QObject::tr("Group by free Slots") );
				break;
		case emiGROUP_BY_SLOTS_TOTAL:
				action = menu->addAction( QObject::tr("Group by total Slots") );
				break;
		case emiGROUP_BY_HUB:
				action = menu->addAction( QObject::tr("Group by Hub") );
				break;
		case emiGROUP_BY_PATH:
				action = menu->addAction( QObject::tr("Group by Path") );
				break;
		case emiGROUP_BY_HOST:
				action = menu->addAction( QObject::tr("Group by Host") );
				break;
		case emiCOPY:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiEDITCOPY) ), QObject::tr("Copy") );
				break;
		case emiCOPYDCFILELINK:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiEDITCOPY) ), QObject::tr("Copy Link") );
				break;
		case emiCOPYMAGNETLINK:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiEDITCOPY) ), QObject::tr("Copy magnet link") );
				break;
		case emiCLEAR:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiEDITDELETE) ), QObject::tr("Clear") );
				break;
		case emiSELECT_ALL:
				action = menu->addAction( QObject::tr("Select all") );
				break;
		case emiCLOSE:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFILECLOSE) ), QObject::tr("Close") );
				break;
		case emiHIDE:
				action = menu->addAction( QObject::tr("Hide") );
				break;
		case emiREFRESH:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiRELOAD) ), QObject::tr("Refresh Filelist") );
				break;
		case emiRESET:
				action = menu->addAction( QObject::tr("Reset") );
				break;
		case emiDOCK:
				action = menu->addAction( QObject::tr("Dock") );
				break;
		case emiUNDOCK:
				action = menu->addAction( QObject::tr("Undock") );
				break;
		case emiZOOM_IN:
				action = menu->addAction( QObject::tr("Zoom in") );
				break;
		case emiZOOM_OUT:
				action = menu->addAction( QObject::tr("Zoom out") );
				break;
		// languages
		case emiLANGUAGE_BOSNIAN:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_BOSNIAN) ), QObject::tr("Bosnian") );
				break;
		case emiLANGUAGE_BRAZILIAN:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_BRAZILIAN) ), QObject::tr("Brazilian") );
				break;
		case emiLANGUAGE_CZECH:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_CZECH) ), QObject::tr("Czech") );
				break;
		case emiLANGUAGE_DANISH:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_DENMARK) ), QObject::tr("Danish") );
				break;
		case emiLANGUAGE_DUTCH:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_NETHERLAND) ), QObject::tr("Dutch") );
				break;
		case emiLANGUAGE_ENGLISH:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_ENGLISH) ), QObject::tr("English") );
				break;
		case emiLANGUAGE_FINNISH:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_FINLAND) ), QObject::tr("Finnish") );
				break;
		case emiLANGUAGE_FRENCH:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_FRANCE) ), QObject::tr("French") );
				break;
		case emiLANGUAGE_GERMAN:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_GERMANY) ), QObject::tr("German") );
				break;
		case emiLANGUAGE_GREEK:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_GREEK) ), QObject::tr("Greek") );
				break;
		case emiLANGUAGE_HUNGARIAN:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_HUNGARY) ), QObject::tr("Hungarian") );
				break;
		case emiLANGUAGE_ICELANDIC:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_ICELAND) ), QObject::tr("Icelandic") );
				break;
		case emiLANGUAGE_ITALIAN:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_ITALY) ), QObject::tr("Italian") );
				break;
		case emiLANGUAGE_LATVIAN:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_LATVIAN) ), QObject::tr("Latvian") );
				break;
		case emiLANGUAGE_NORWEGIAN:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_NORWAY) ), QObject::tr("Norwegian") );
				break;
		case emiLANGUAGE_POLISH:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_POLAND) ), QObject::tr("Polish") );
				break;
		case emiLANGUAGE_ROMANIAN:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_ROMANIA) ), QObject::tr("Romanian") );
				break;
		case emiLANGUAGE_RUSSIAN:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_RUSSIA) ), QObject::tr("Russian") );
				break;
		case emiLANGUAGE_SERBIAN_CYRILLIC:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_SERBIA) ), QObject::tr("Serbian (Cyrillic)") );
				break;
		case emiLANGUAGE_SERBIAN_LATIN:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_SERBIA) ), QObject::tr("Serbian (Latin)") );
				break;
		case emiLANGUAGE_SLOVAKIAN:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_SLOVAK) ), QObject::tr("Slovak") );
				break;
		case emiLANGUAGE_SPANISH:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_SPAIN) ), QObject::tr("Spanish") );
				break;
		case emiLANGUAGE_SWEDISH:
				action = menu->addAction( QIcon( g_pIconLoader->GetPixmap(eiFLAG_SWEDEN) ), QObject::tr("Swedish") );
				break;
		// custom user menu
		default:
				action = menu->addAction( text );
				break;
	}

	if ( action )
	{
		action->setEnabled(enabled);
	}

	return action;
}

/** */
QMenu * DCMenuHandler::addMenu( QMenu * menu, eMenuItems menuitems, bool enabled, QString text )
{
	QMenu * submenu = 0;
	
	switch ( menuitems )
	{
		// submenus
		case emisGROUP:
				submenu = menu->addMenu( QObject::tr("Group") );
				break;
		case emisCHAT_RIGHTCLICK_USER:
				submenu = menu->addMenu( QObject::tr("User: ") + text );
				break;
		case emiCUSTOM:
				submenu = menu->addMenu( QObject::tr("Custom") );
				break;
		case emiUPLOAD_SLOT:
				submenu = menu->addMenu( QObject::tr("Upload Slot") );
				break;
		case emisUSER_COMMANDS:
				submenu = menu->addMenu( QObject::tr("User Commands") );
				break;
		default:
				submenu = menu->addMenu(text);
				break;
	
	}
	
	if ( submenu )
	{
		submenu->setDisabled(!enabled);
	}
	
	return submenu;
}
