/***************************************************************************
                          dcoptions.cpp  -  description
                             -------------------
    begin                : Sun Feb 24 2002
    copyright            : (C) 2002 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dcoptions.h"

#include <qdir.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <QTextEdit>
#include <qcombobox.h>
#include <QListWidget>
#include <qtabwidget.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <QFileDialog>
#include <qlabel.h>
#include <qmessagebox.h>
#include <qspinbox.h>
#include <qstylefactory.h>
#include <qapplication.h>
#include <qinputdialog.h>
#include <qfontdialog.h>
#include <qlayout.h>
#include <qcolordialog.h>
#include <qtoolbutton.h>
#include <qimage.h>
#include <qcursor.h>
#include <qtextcodec.h>
//Added by qt3to4:
#include <QPixmap>
#include <QProcess>
#include <QHeaderView>
#include <QHttp>
#include <QHostAddress>
#include <QStyle>

#include <dclib/core/cstring.h>
#include <dclib/core/cnetaddr.h>
#include <dclib/core/cdir.h>
#include <dclib/cfilemanager.h>

#include "dcmenuhandler.h"
#include "dciconloader.h"
#include "dctransferview.h"

#include "DCDialogEditSharePath.h"

#include "dcusercommandeditor.h"
#include "dcguiutils.h"

#include <dclib/dcos.h>
#include <math.h>

/* need PACKAGE_VERSION for HTTP User-Agent */
#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#define PACKAGE_VERSION "Unknown"
#endif

/** */
DCOptions::DCOptions( QWidget * parent ) : QDialog( parent )
{
	m_pHttp = 0;

	setupUi(this);

	/* icons moved out of .ui files so that they can be themed */
	QIcon browsefolder( g_pIconLoader->GetPixmap(eiFOLDER_BLUE_OPEN) );
	QIcon editadd( g_pIconLoader->GetPixmap(eiEDITADD) );
	QIcon editdelete( g_pIconLoader->GetPixmap(eiEDITDELETE) );
	QIcon editedit( g_pIconLoader->GetPixmap(eiEDIT) );
	QIcon play( g_pIconLoader->GetPixmap(eiPLAYER_PLAY) );
	ToolButton_BROWSEDOWNLOADFINISHEDFOLDER->setIcon( browsefolder );
	ToolButton_BROWSEDOWNLOADFOLDER->setIcon( browsefolder );
	ToolButton_CREATESHARELIST->setIcon( QIcon( g_pIconLoader->GetPixmap(eiRELOAD) ) );
	ToolButton_BROWSEFILELIST->setIcon( QIcon( g_pIconLoader->GetPixmap(eiVIEW_SIDETREE) ) );
	ToolButton_SHARELISTINFO->setIcon( QIcon( g_pIconLoader->GetPixmap(eiINFO) ) );
	ToolButton_ADDSHAREDFOLDER->setIcon( editadd );
	ToolButton_REMOVESHAREDFOLDER->setIcon( editdelete );
	ToolButton_EDITSHAREDFOLDER->setIcon( editedit );
	ToolButton_BROWSELANGUAGEFILE->setIcon( browsefolder );
	ToolButton_SELECTLANGUAGE->setIcon( QIcon( g_pIconLoader->GetPixmap(eiCHOOSE_LANGUAGE) ) );
	ToolButton_BROWSEAPPFONT->setIcon( browsefolder );
	ToolButton_BROWSEDATAFOLDER->setIcon( browsefolder );
	ToolButton_BROWSEBROWSER->setIcon( browsefolder );
	ToolButton_ADD_USER_MENU_COMMAND->setIcon( editadd );
	ToolButton_EDIT_USER_MENU_COMMAND->setIcon( editedit );
	ToolButton_REMOVE_USER_MENU_COMMAND->setIcon( editdelete );
	ToolButton_BROWSESOUNDPLAYER->setIcon( browsefolder );
	ToolButton_BROWSESOUNDFILEDISCONNECT->setIcon( browsefolder );
	ToolButton_BROWSESOUNDFILESEND->setIcon( browsefolder );
	ToolButton_BROWSESOUNDFILERECEIVE->setIcon( browsefolder );
	ToolButton_BROWSESOUNDFILEFIRSTRECEIVE->setIcon( browsefolder );
	ToolButton_BROWSESOUNDFILECONNECT->setIcon( browsefolder );
	ToolButton_BROWSESOUNDFILENICKMENTIONED->setIcon( browsefolder );
	ToolButton_PREVIEWSOUNDFILECONNECT->setIcon( play );
	ToolButton_PREVIEWSOUNDFILEDISCONNECT->setIcon( play );
	ToolButton_PREVIEWSOUNDFILESEND->setIcon( play );
	ToolButton_PREVIEWSOUNDFILERECEIVE->setIcon( play );
	ToolButton_PREVIEWSOUNDFILEFIRSTRECEIVE->setIcon( play );
	ToolButton_PREVIEWSOUNDFILENICKMENTIONED->setIcon( play );
	ToolButton_BROWSELOGFILE->setIcon( browsefolder );
	ToolButton_LOGCHAT_NICKNAMEFILTER_ADD->setIcon( editadd );
	ToolButton_LOGCHAT_NICKNAMEFILTER_DEL->setIcon( editdelete );
	ToolButton_ADDHUBLISTURL->setIcon( editadd );
	ToolButton_EDITHUBLISTURL->setIcon( editedit );
	ToolButton_REMOVEHUBLISTURL->setIcon( editdelete );
	ToolButton_BROWSETRANSFERCERT->setIcon( browsefolder );
	ToolButton_BROWSETRANSFERKEY->setIcon( browsefolder );
	ToolButton_BROWSE_DCLIB_PLUGIN_PATH->setIcon( browsefolder );
	
	// set default icon
	setWindowIcon( g_pIconLoader->GetPixmap(eiCONFIGURE) );

	InitDocument();
}

/** */
DCOptions::~DCOptions()
{
	/* If they were saved, the map is empty */
	for ( QMap<int, DC_UserMenuCommand*>::const_iterator it = usercommands.constBegin(); it != usercommands.constEnd(); ++it )
	{
		delete it.value();
	}
	usercommands.clear();
	
	if ( m_pHttp )
	{
		disconnect( m_pHttp, SIGNAL(done(bool)), this, SLOT(slotGotInternetIP(bool)) );
		m_pHttp->abort(); // emits done signal
		delete m_pHttp;
	}
}

/** */
void DCOptions::InitDocument()
{
	// insert speed
	ComboBox_SPEED->addItem( "28.8Kbps" );
	ComboBox_SPEED->addItem( "33.6Kbps" );
	ComboBox_SPEED->addItem( "56Kbps" );
	ComboBox_SPEED->addItem( "Modem" );
	ComboBox_SPEED->addItem( "Satellite" );
	ComboBox_SPEED->addItem( "ISDN" );
	ComboBox_SPEED->addItem( "DSL" );
	ComboBox_SPEED->addItem( "Cable" );
	ComboBox_SPEED->addItem( "LAN(T1)" );
	ComboBox_SPEED->addItem( "LAN(T3)" );
	ComboBox_SPEED->addItem( "Microwave" );
	ComboBox_SPEED->addItem( "Wireless" );
	ComboBox_SPEED->addItem( "0.005" );
	ComboBox_SPEED->addItem( "0.01" );
	ComboBox_SPEED->addItem( "0.02" );
	ComboBox_SPEED->addItem( "0.05" );
	ComboBox_SPEED->addItem( "0.1" );
	ComboBox_SPEED->addItem( "0.2" );
	ComboBox_SPEED->addItem( "0.5" );
	ComboBox_SPEED->addItem( "1" );
	ComboBox_SPEED->addItem( "2" );
	ComboBox_SPEED->addItem( "5" );
	ComboBox_SPEED->addItem( "10" );
	ComboBox_SPEED->addItem( "20" );
	ComboBox_SPEED->addItem( "50" );
	ComboBox_SPEED->addItem( "100" );
	ComboBox_SPEED->addItem( "1000" );
	
	DCGuiUtils::AddEncodings( ComboBox_REMOTE_ENCODING );
	
	// set width mode
	// QT3 ListView_OPTIONTREE->setColumnWidthMode( 0, Q3ListView::Maximum );
	// hide the column header
	TreeWidget_OPTIONTREE->header()->hide();

	// set up icons theme lists
	setupIconThemeComboBoxes();

	// setup the option tree
	plviIdentify = new QTreeWidgetItem( TreeWidget_OPTIONTREE );
	plviIdentify->setText( 0, tr( "Identify" ) );

	plviTransfer = new QTreeWidgetItem( TreeWidget_OPTIONTREE );
	plviTransfer->setText( 0, tr( "Transfer" ) );
	plviTransfer->setExpanded( true );
	plviTransfer->setFlags( Qt::ItemIsEnabled );
	plviTransferShares = new QTreeWidgetItem( plviTransfer );
	plviTransferShares->setText( 0, tr( "Shares" ) );
	plviTransferDownloads = new QTreeWidgetItem( plviTransfer );
	plviTransferDownloads->setText( 0, tr( "Downloads" ) );
	plviTransferUploads = new QTreeWidgetItem( plviTransfer );
	plviTransferUploads->setText( 0, tr( "Uploads" ) );
	plviTransferSettings = new QTreeWidgetItem( plviTransfer );
	plviTransferSettings->setText( 0, tr( "Settings" ) );

	plviConnection = new QTreeWidgetItem( TreeWidget_OPTIONTREE );
	plviConnection->setText( 0, tr( "Connection" ) );
	plviConnection->setExpanded( true );
	plviConnection->setFlags( Qt::ItemIsEnabled );
	plviConnectionMode = new QTreeWidgetItem( plviConnection );
	plviConnectionMode->setText( 0, tr( "Mode" ) );
	plviConnectionSettings = new QTreeWidgetItem( plviConnection );
	plviConnectionSettings->setText( 0, tr( "Settings" ) );

	plviGUI = new QTreeWidgetItem( TreeWidget_OPTIONTREE );
	plviGUI->setText( 0, tr( "GUI" ) );
	plviGUI->setExpanded( true );
	plviGUI->setFlags( Qt::ItemIsEnabled );
	plviGUIGeneral = new QTreeWidgetItem( plviGUI );
	plviGUIGeneral->setText( 0, tr( "General" ) );
	plviGUITransfer = new QTreeWidgetItem( plviGUI );
	plviGUITransfer->setText( 0, tr( "Transfer" ) );
	plviGUIChat = new QTreeWidgetItem( plviGUI );
	plviGUIChat->setText( 0, tr( "Chat" ) );
	plviGUICommands = new QTreeWidgetItem( plviGUI );
	plviGUICommands->setText( 0, tr( "Commands" ) );
	plviGUIMenus = new QTreeWidgetItem( plviGUI );
	plviGUIMenus->setText(0, tr( "Menus" ) );
	plviGUIUser = new QTreeWidgetItem( plviGUI );
	plviGUIUser->setText( 0, tr( "User" ) );
	plviGUIIcons =  new QTreeWidgetItem( plviGUI );
	plviGUIIcons->setText(0, tr ( "Icons" ) );
	plviGUIFilelistBrowser = new QTreeWidgetItem( plviGUI );
	plviGUIFilelistBrowser->setText(0, tr( "Filelist browser" ) );

	plviSound = new QTreeWidgetItem( TreeWidget_OPTIONTREE );
	plviSound->setText( 0, tr( "Sound" ) );

	plviLog = new QTreeWidgetItem( TreeWidget_OPTIONTREE );
	plviLog->setText( 0, tr( "Log" ) );

	plviHubLists = new QTreeWidgetItem( TreeWidget_OPTIONTREE );
	plviHubLists->setText( 0, tr( "Hub Lists" ) );

	plviSecurity = new QTreeWidgetItem( TreeWidget_OPTIONTREE );
	plviSecurity->setText( 0, tr( "Security" ) );

	plviAutoResponse = new QTreeWidgetItem( TreeWidget_OPTIONTREE );
	plviAutoResponse->setText(0, tr( "Auto Responses" ) );

	plviOther = new QTreeWidgetItem( TreeWidget_OPTIONTREE );
	plviOther->setText(0, tr( "Other" ) );

	connect( ToolButton_PHOTO, SIGNAL(clicked()), this, SLOT(slotChangePhoto()) );

	connectOptionsTreeWidget();
	
	connect( TabWidget_DCGUI, SIGNAL(currentChanged(int)), this, SLOT(slotTabWidgetDCGUICurrentChanged(int)) );
	connect( TabWidget_TRANSFER, SIGNAL(currentChanged(int)), this, SLOT(slotTabWidgetTransferCurrentChanged(int)) );
	connect( TabWidget_CONNECTION, SIGNAL(currentChanged(int)), this, SLOT(slotTabWidgetConnectionCurrentChanged(int)) );
	connect( TabWidget_GUI, SIGNAL(currentChanged(int)), this, SLOT(slotTabWidgetGUICurrentChanged(int)) );
	
	connect( ToolButton_ADD_USER_MENU_COMMAND, SIGNAL(clicked()), this, SLOT(slotAddUserMenuCommand()) );
	connect( ToolButton_EDIT_USER_MENU_COMMAND, SIGNAL(clicked()), this, SLOT(slotEditUserMenuCommand()) );
	connect( ToolButton_REMOVE_USER_MENU_COMMAND, SIGNAL(clicked()), this, SLOT(slotRemoveUserMenuCommand()) );
	connect( ToolButton_UP_USER_MENU_COMMAND, SIGNAL(clicked()), this, SLOT(slotUpUserMenuCommand()) );
	connect( ToolButton_DOWN_USER_MENU_COMMAND, SIGNAL(clicked()), this, SLOT(slotDownUserMenuCommand()) );
	connect( TreeWidget_MENU_COMMANDS, SIGNAL(itemSelectionChanged()), this, SLOT(slotUserMenuCommandsSelectionChanged()) );
	connect( TreeWidget_MENU_COMMANDS, SIGNAL(itemDoubleClicked(QTreeWidgetItem *, int)), this, SLOT(slotUserMenuCommandsDoubleClicked(QTreeWidgetItem *, int)) );
	
	connect( TreeWidget_CHAT_COMMANDS, SIGNAL(customContextMenuRequested( const QPoint & )), this, SLOT(slotContextMenuUserChatCommands( const QPoint & )));
	
	connect( TreeWidget_AUTO_RESPONSES, SIGNAL(customContextMenuRequested( const QPoint & )), this, SLOT(slotContextMenuAutoResponses( const QPoint & )));
	
	connect( ToolButton_BROWSESOUNDFILECONNECT, SIGNAL(clicked()), this, SLOT(slotBrowseSoundFileConnect()) );
	connect( ToolButton_BROWSESOUNDFILEDISCONNECT, SIGNAL(clicked()), this, SLOT(slotBrowseSoundFileDisconnect()) );
	connect( ToolButton_BROWSESOUNDFILESEND, SIGNAL(clicked()), this, SLOT(slotBrowseSoundFileSend()) );
	connect( ToolButton_BROWSESOUNDFILERECEIVE, SIGNAL(clicked()), this, SLOT(slotBrowseSoundFileReceive()) );
	connect( ToolButton_BROWSESOUNDFILEFIRSTRECEIVE, SIGNAL(clicked()), this, SLOT(slotBrowseSoundFileFirstReceive()) );
	connect( ToolButton_BROWSESOUNDFILENICKMENTIONED, SIGNAL(clicked()), this, SLOT(slotBrowseSoundFileNickMentioned()) );

	connect( ToolButton_PREVIEWSOUNDFILECONNECT, SIGNAL(clicked()), this, SLOT(slotPreviewSoundFileConnect()) );
	connect( ToolButton_PREVIEWSOUNDFILEDISCONNECT, SIGNAL(clicked()), this, SLOT(slotPreviewSoundFileDisconnect()) );
	connect( ToolButton_PREVIEWSOUNDFILESEND, SIGNAL(clicked()), this, SLOT(slotPreviewSoundFileSend()) );
	connect( ToolButton_PREVIEWSOUNDFILERECEIVE, SIGNAL(clicked()), this, SLOT(slotPreviewSoundFileReceive()) );
	connect( ToolButton_PREVIEWSOUNDFILEFIRSTRECEIVE, SIGNAL(clicked()), this, SLOT(slotPreviewSoundFileFirstReceive()) );
	connect( ToolButton_PREVIEWSOUNDFILENICKMENTIONED, SIGNAL(clicked()), this, SLOT(slotPreviewSoundFileNickMentioned()) );

	connect( ToolButton_BROWSESOUNDPLAYER, SIGNAL(clicked()), this, SLOT(slotBrowseSoundPlayer()) );

	// Transfer->Folder
	connect( ToolButton_BROWSEDOWNLOADFOLDER, SIGNAL(clicked()), this, SLOT(slotBrowseDownloadFolder()) );
	connect( ToolButton_BROWSEDOWNLOADFINISHEDFOLDER, SIGNAL(clicked()), this, SLOT(slotBrowseDownloadFinishedFolder()) );

	connect( ToolButton_CREATESHARELIST, SIGNAL(clicked()), this, SLOT(slotCreateShareList()) );
	connect( ToolButton_BROWSEFILELIST, SIGNAL(clicked()), this, SLOT(slotBrowseShareList()) );
	connect( ToolButton_SHARELISTINFO, SIGNAL(clicked()), this, SLOT(slotShareListInfo()) );
	connect( ToolButton_ADDSHAREDFOLDER, SIGNAL(clicked()), this, SLOT(slotAddSharedFolder()) );
	connect( ToolButton_REMOVESHAREDFOLDER, SIGNAL(clicked()), this, SLOT(slotRemoveSharedFolder()) );
	connect( ToolButton_EDITSHAREDFOLDER, SIGNAL(clicked()), this, SLOT(slotEditSharedFolder()) );

	connect( TreeWidget_SHAREDFOLDERS, SIGNAL(itemDoubleClicked( QTreeWidgetItem *, int )),this, SLOT(slotDoubleClickedSharedFolder( QTreeWidgetItem *, int )) );
	connect( TreeWidget_SHAREDFOLDERS, SIGNAL(customContextMenuRequested( const QPoint & )),this, SLOT(slotContextMenuSharedFolder( const QPoint & )) );
	connect( TreeWidget_SHAREDFOLDERS, SIGNAL(itemSelectionChanged()), this, SLOT(slotSharedFoldersSelectionChanged()) );
	
	connect( PushButton_TESTHOST, SIGNAL(clicked()), this, SLOT(slotTestHost()) );
	connect( PushButton_GETINTERFACE, SIGNAL(clicked()), this, SLOT(slotGetInterface()) );
	connect( PushButton_GETINTERNETIP, SIGNAL(clicked()), this, SLOT(slotGetInternetIP()) );

	// GUI->General
	connect( ToolButton_BROWSELANGUAGEFILE, SIGNAL(clicked()), this, SLOT(slotBrowseLanguageFile()) );
	connect( ToolButton_SELECTLANGUAGE, SIGNAL(clicked()), this, SLOT(slotSelectLanguage()) );
	connect( PushButton_SETTHEME, SIGNAL(clicked()), this, SLOT(slotSetTheme()) );
	connect( ToolButton_BROWSEAPPFONT, SIGNAL(clicked()), this, SLOT(slotBrowseAppFont()) );
	connect( ToolButton_BROWSEDATAFOLDER, SIGNAL(clicked()), this, SLOT(slotBrowseDataFolder()) );

	// GUI->Chat
	connect( ToolButton_BROWSEBROWSER, SIGNAL(clicked()), this, SLOT(slotBrowseBrowser()) );
	connect( CheckBox_CUSTOM_BROWSER, SIGNAL(clicked()), this, SLOT(slotCustomBrowserChecked()) );
	connect( ListBox_CHATCOLOR, SIGNAL(itemDoubleClicked(QListWidgetItem *)), this, SLOT(slotDoubleClickedChatColor(QListWidgetItem *)) );
	connect( ToolButton_CHAT_BG_COLOR, SIGNAL(clicked()), this, SLOT(slotBackgroundColorDialog()) );
	connect( ToolButton_REVERSE_COLORS, SIGNAL(clicked()), this, SLOT(slotReverseChatColors()) );

	// LOG->Chat
	connect( ToolButton_LOGCHAT_NICKNAMEFILTER_ADD, SIGNAL(clicked()), this, SLOT(slotLogChatAddNickNameFilter()) );
	connect( ToolButton_LOGCHAT_NICKNAMEFILTER_DEL, SIGNAL(clicked()), this, SLOT(slotLogChatDelNickNameFilter()) );

	//
	connect( ToolButton_BROWSETRANSFERCERT, SIGNAL(clicked()), this, SLOT(slotBrowseTransferCert()) );
	connect( ToolButton_BROWSETRANSFERKEY, SIGNAL(clicked()), this, SLOT(slotBrowseTransferKey()) );
	connect( ToolButton_BROWSE_DCLIB_PLUGIN_PATH, SIGNAL(clicked()), this, SLOT(slotBrowseDclibPluginFolder()) );

	// Hub List
	connect( ToolButton_ADDHUBLISTURL, SIGNAL(clicked()), this, SLOT(slotAddHubListUrl()) );
	connect( ToolButton_EDITHUBLISTURL, SIGNAL(clicked()), this, SLOT(slotEditHubListUrl()) );
	connect( ToolButton_REMOVEHUBLISTURL, SIGNAL(clicked()), this, SLOT(slotRemoveHubListUrl()) );

	connect( ListWidget_HUBLISTURL, SIGNAL(itemDoubleClicked( QListWidgetItem * )), this, SLOT(slotDoubleClickedHubListUrl( QListWidgetItem * )) );
	connect( ListWidget_HUBLISTURL, SIGNAL(customContextMenuRequested( const QPoint & )), this, SLOT(slotContextMenuHubListUrl( const QPoint & )) );
	connect( ListWidget_HUBLISTURL, SIGNAL(itemSelectionChanged()), this, SLOT(slotHubListUrlsSelectionChanged()) );

	connect( CheckBox_SOUNDDISABLED, SIGNAL(clicked()), this, SLOT(slotDisableSound()) );
	
	connect( ToolButton_BROWSELOGFILE, SIGNAL(clicked()), this, SLOT(slotBrowseLogFile()) );
	
	connect( PushButton_GENERATE_CERT, SIGNAL(clicked()), this, SLOT(slotGenerateKeyCert()) );
	
	// style options
	ComboBox_THEME->clear();

	if ( g_pConfig->GetThemeSupport() )
	{
		QStringList list = QStyleFactory::keys();

		if ( list.count() > 0 )
		{
			list.sort();
			ComboBox_THEME->addItems(list);
			list.clear();
		}
	}
	else
	{
		// disable the theme support
		ComboBox_THEME->setEnabled(false);
		PushButton_SETTHEME->setEnabled(false);
	}
}

/** */
void DCOptions::connectOptionsTreeWidget()
{
	connect( TreeWidget_OPTIONTREE, SIGNAL(currentItemChanged( QTreeWidgetItem *, QTreeWidgetItem * )), this, SLOT(slotTreeWidgetOptionTreeCurrentChanged( QTreeWidgetItem *, QTreeWidgetItem * )) );
}

/** */
void DCOptions::disconnectOptionsTreeWidget()
{
	disconnect( TreeWidget_OPTIONTREE, SIGNAL(currentItemChanged( QTreeWidgetItem *, QTreeWidgetItem * )), this, SLOT(slotTreeWidgetOptionTreeCurrentChanged( QTreeWidgetItem *, QTreeWidgetItem * )) );
}

/** */
void DCOptions::accept()
{
	if ( LineEdit_DOWNLOADFOLDER->text().isEmpty() )
	{
		QMessageBox::critical( this, "Valknut",
		tr("You must set a Download Folder!"));
		return;
	}

	if ( LineEdit_DOWNLOADFINISHEDFOLDER->text() == LineEdit_DOWNLOADFOLDER->text() )
	{
		QMessageBox::critical( this, "Valknut",
		tr("Download Finished Folder and Download Folder must be different!"));
		return;
	}

	// check active mode settings
	if ( RadioButton_ACTIVEMODE->isChecked() )
	{
		// check fake host
		if ( RadioButton_IPHOSTNAME->isChecked() &&
	     	     (LineEdit_IP->text().isEmpty()) )

		{
			QMessageBox::critical( this, "Valknut",
			tr("You must enter a valid 'Fake Host'!"));
			return;
		}

		// check interface
		if ( RadioButton_INTERFACE->isChecked() &&
	     	     (LineEdit_IP->text().isEmpty()) )

		{
			QMessageBox::critical( this, "Valknut",
			tr("You must enter a valid interface!"));
			return;
		}

#ifndef WIN32
		if ( (SpinBox_TCPLISTENPORT->value() < 1024) || (SpinBox_CRYPTO_PORT->value() < 1024) || (SpinBox_UDPLISTENPORT->value() < 1024) )
		{
			QMessageBox::critical( this, "Valknut",
			tr("You have set Valknut to listen on a port < 1024! You can run Valknut only as root in active mode!"));
		}
#endif
	}

	// no nick is given
	if ( LineEdit_NICK->text().isEmpty() )
	{
		QMessageBox::critical( this, "Valknut",
		tr("You must enter a valid nick!"));
		return;
	}

	// no search nick is given
	if ( (LineEdit_SEARCHNICK->text().isEmpty()) || (LineEdit_SEARCHNICK->text() == "nick_search") )
	{
		QMessageBox::critical( this, "Valknut",
		tr("You must enter a valid search nick!"));
		return;
	}

	if ( SpinBox_TCPLISTENPORT->value() == SpinBox_CRYPTO_PORT->value() )
	{
		QMessageBox::critical(
			this,
			"Valknut",
			tr("Standard and encrypted port must be different.")
		);
		return;
	}

	/* Warn about using certain options */
	QString recommended, notrecommended;
	
	if ( !CheckBox_DESCRIPTION_TAG->isChecked() && g_pConfig->GetDescriptionTag() )
	{
		recommended += CheckBox_DESCRIPTION_TAG->text();
		recommended += '\n';
	}
	
	if ( !CheckBox_EXT_HUB_COUNT->isChecked() && g_pConfig->GetUseExtendedHubCount() )
	{
		recommended += CheckBox_EXT_HUB_COUNT->text();
		recommended += '\n';
	}

	if ( CheckBox_DISABLEHASHLIST->isChecked() && !g_pConfig->GetDisableHashList() )
	{
		notrecommended += CheckBox_DISABLEHASHLIST->text();
		notrecommended += '\n';
	}

	if ( CheckBox_ENABLE_ZPIPE->isChecked() && !g_pConfig->GetZPipeEnabled() )
	{
		notrecommended += CheckBox_ENABLE_ZPIPE->text();
		notrecommended += '\n';
	}

	/* possibly also check compressed and encrypted transfers, they are not very useful */
	/* the auto responder really should not have been added but it is GUI only so unlikely to break anything */

	if ( !recommended.isEmpty() || !notrecommended.isEmpty() )
	{
		QString msg;
		if ( !recommended.isEmpty() )
		{
			msg += tr("These options are recommended:\n");
			msg += recommended;
		}
		
		if ( !notrecommended.isEmpty() )
		{
			msg += "\n";
			msg += tr("These options are not recommended:\n");
			msg += notrecommended;
		}
		
		if ( QMessageBox::warning(
			this,
			tr("Settings Problems"),
			msg,
			QMessageBox::Ignore | QMessageBox::Cancel,
			QMessageBox::Ignore
		) == QMessageBox::Cancel )
		{
			return;
		}
	}

	if ( GroupBox_APPFONT->isChecked() )
	{
		if ( (!(LineEdit_APPFONT->text().isEmpty())) && (LineEdit_APPFONT->text() != g_pConfig->GetAppFont()) )
		{
			QFont font;
			if ( font.fromString(LineEdit_APPFONT->text()) )
			{
				QApplication::setFont(font);
			}
		}
	}

	QDialog::accept();
}

/** */
void DCOptions::SetUserPhoto( QString filename )
{
	QImage im;

	if ( !filename.isEmpty() )
	{
		if ( im.load(filename) )
		{
			if ( (im.width() > 32) ||
			     (im.height() > 32) )
			{
				im = im.scaled(32,32,Qt::KeepAspectRatio,Qt::SmoothTransformation);
			}

			if ( im.depth() > 8 )
				im = im.convertToFormat(QImage::Format_Indexed8);

			if ( im.numColors() > 256 )
				im.setNumColors(256);

			if ( im.save( (g_pConfig->GetConfigPath() + "photo.png").Data(), "PNG", 0 ) == false )
			{
				QMessageBox::critical( this, "Valknut", tr("Can't save Image!") );
			}
			else
			{
				ToolButton_PHOTO->setIcon( QIcon(QPixmap::fromImage(im)) );
				// ToolButton_PHOTO->setTextLabel(filename);
				ToolButton_PHOTO->setText((g_pConfig->GetConfigPath() + "photo.png").Data());
			}
		}
		else
		{
			QMessageBox::critical( this, "Valknut", tr("Can't load Image!") );
		}
	}
}

/** */
void DCOptions::slotChangePhoto()
{
	QString file = QFileDialog::getOpenFileName( this, tr("Select a 64x64 Photo"), ToolButton_PHOTO->text() );

	if ( file.isEmpty() )
	{
		ToolButton_PHOTO->setIcon( QIcon() );
		ToolButton_PHOTO->setText( QString() );
	}
	else
	{
		SetUserPhoto(file);
	}
}

/** */
void DCOptions::slotDoubleClickedChatColor( QListWidgetItem * item )
{
	QPixmap p(10,10);
	QColor color(item->icon().pixmap(10,10).toImage().pixel(0,0));
	color = QColorDialog::getColor(color);
	if ( color.isValid() )
	{
		p.fill(color);
		item->setIcon(p);
	}
}

/** */
void DCOptions::slotBackgroundColorDialog()
{
	QPixmap pixmap = ToolButton_CHAT_BG_COLOR->icon().pixmap( 10,10 );
	
	QColor color = pixmap.toImage().pixel(0,0);
	color = QColorDialog::getColor(color);
	
	if ( color.isValid() )
	{
		pixmap.fill(color);
		ToolButton_CHAT_BG_COLOR->setIcon(QIcon(pixmap));
	}
}

/** */
void DCOptions::slotReverseChatColors()
{
	QColor color;
	QPixmap p(10,10);
	
	for ( int i = 0; i < ListBox_CHATCOLOR->count(); ++i )
	{
		color = QColor(ListBox_CHATCOLOR->item(i)->icon().pixmap(10,10).toImage().pixel(0,0));
		color.setRed( 255 - color.red() );
		color.setGreen( 255 - color.green() );
		color.setBlue( 255 - color.blue() );
		p.fill(color);
		ListBox_CHATCOLOR->item(i)->setIcon(QIcon(p));
	}
}

/** */
void DCOptions::slotLogChatAddNickNameFilter()
{
	bool ok = false;

	QString text = QInputDialog::getText(
		this,
		tr("Add new nick name filter"),
		tr("Please enter a nick" ),
		QLineEdit::Normal,
		QString(),
		&ok
	);

	if ( ok && !text.isEmpty() )
	{
		if ( (ListBox_LOGCHAT_NICKNAMEFILTER_LIST->findItems( text, Qt::MatchExactly )).size() == 0 )
		{
			new QListWidgetItem( text, ListBox_LOGCHAT_NICKNAMEFILTER_LIST );
		}
	}
}

/** */
void DCOptions::slotLogChatDelNickNameFilter()
{
	int i = ListBox_LOGCHAT_NICKNAMEFILTER_LIST->currentRow();

	if ( i >= 0 )
	{
		QListWidgetItem * item = ListBox_LOGCHAT_NICKNAMEFILTER_LIST->takeItem(i);
		
		if ( item != 0 )
		{
			delete item;
		}
	}
}

/** */
void DCOptions::slotTestHost()
{
	QString sip;
	CString errmsg;
	QString s;
	QString failmsg;

	if ( RadioButton_IPHOSTNAME->isChecked() )
	{
		s = LineEdit_IP->text();
		s.remove(' ');
		LineEdit_IP->setText(s);

		if ( !s.isEmpty() )
		{
			sip = CNetAddr::GetHostI4( s.toAscii().constData(), &errmsg ).Data();
		}

		if ( sip.isEmpty() )
		{
			failmsg = tr("Can't get Host IP!");
			if ( errmsg.NotEmpty() )
			{
				failmsg += "\n\n";
				failmsg += errmsg.Data();
			}
			QMessageBox::critical( this, "Valknut", failmsg );
		}
		else
		{
			QMessageBox::information( this, "Valknut", tr("Host IP: ")+sip );
		}
	}
	else
	{
		sip = CNetAddr::GetInterfaceI4( LineEdit_IP->text().toAscii().constData(), &errmsg ).Data();

		if ( sip.isEmpty() )
		{
			failmsg = tr("Can't get interface IP!");
			if ( errmsg.NotEmpty() )
			{
				failmsg += "\n\n";
				failmsg += errmsg.Data();
			}
			QMessageBox::critical( this, "Valknut", failmsg );
		}
		else
		{
			QMessageBox::information( this, "Valknut", tr("Interface IP: ")+sip );
		}
	}
}

/** */
void DCOptions::slotGetInterface()
{
	CList<CString> interfacelist;
	CString errmsg;
	CString * s;
	QStringList lst;
	long res = CNetAddr::GetInterfaceList( &interfacelist, &errmsg );

	if ( res > 0 )
	{
		s = 0;

		while( (s=interfacelist.Next(s)) != 0 )
		{
			lst << s->Data();
		}
  
		bool ok = false;

		QString res = QInputDialog::getItem(
			this,
			tr( "Interface List" ),
			tr( "Please select an interface" ),
			lst,
			1,
			true,
			&ok
		);

		if ( ok )
		{
			LineEdit_IP->setText(res);
		}
	}
	else
	{
		QString failmsg = tr("No interfaces found!");
		if ( (res < 0) && errmsg.NotEmpty() )
		{
			failmsg += "\n\n";
			failmsg += errmsg.Data();
		}
		QMessageBox::information( this, "Valknut", failmsg );
	}
}

/** */
void DCOptions::slotGetInternetIP()
{
	PushButton_GETINTERNETIP->setEnabled(false);
	
	QHttpRequestHeader header( "GET", "/ip.php" );
	header.setValue( "Host", "wxdcgui.sourceforge.net" );
	QString useragent = QString("Valknut/") + PACKAGE_VERSION;
	//printf("User-Agent=%s\n", useragent.toAscii().constData());
	header.setValue( "User-Agent", useragent );
	
	m_pHttp = new QHttp();
	connect( m_pHttp, SIGNAL(done(bool)), this, SLOT(slotGotInternetIP(bool)) );
	m_pHttp->setHost( "wxdcgui.sourceforge.net" );
	m_pHttp->request( header );
}

/** */
void DCOptions::slotGotInternetIP( bool error )
{
	if ( error )
	{
		QMessageBox::warning(
			this,
			tr("Error getting IP"),
			m_pHttp->errorString()
		);
	}
	else
	{
		QString html = QString(m_pHttp->readAll());
		int start = html.indexOf("&lt;ip&gt;");
		int end = html.indexOf("&lt;/ip&gt;",start);
		
		if ( ( start == -1 ) || ( end < start ) )
		{
			QMessageBox::warning(
				this,
				tr("Get Internet IP"),
				tr("Unexpected response from ") + "http://wxdcgui.sourceforge.net"
			);
		}
		else
		{
			start += 10;
			QString ip = html.mid( start, end - start );
			
			if ( QHostAddress().setAddress(ip) )
			{
				LineEdit_IP->setText(ip);
			}
			else
			{
				QMessageBox::warning(
					this,
					tr("Get Internet IP"),
					ip + tr(" does not look valid")
				);
			}
		}

	}
	
	delete m_pHttp;
	m_pHttp = 0;
	
	PushButton_GETINTERNETIP->setEnabled(true);
}

/** */
void DCOptions::slotDisableSound()
{
	const bool b = !CheckBox_SOUNDDISABLED->isChecked();
	CheckBox_SOUNDDISABLEDAWAY->setEnabled(b);
	GroupBox_EXTERNALPLAYER->setEnabled(b);
	GroupBox_SOUND_FILES->setEnabled(b);
}

/** */
void DCOptions::slotBrowseSoundPlayer()
{
	QString file = QFileDialog::getOpenFileName( this, tr("Select sound player"), LineEdit_EXTERNALPLAYER->text() );

	if( !file.isEmpty() )
	{
		LineEdit_EXTERNALPLAYER->setText(file);
	}
}

/** */
void DCOptions::slotBrowseTransferCert()
{
	QString file = QFileDialog::getSaveFileName( this, tr("Select transfer cert"), LineEdit_TRANSFERCERT->text(), QString(), 0, QFileDialog::DontConfirmOverwrite );

	if( !file.isEmpty() )
	{
		LineEdit_TRANSFERCERT->setText(file);
	}
}

/** */
void DCOptions::slotBrowseTransferKey()
{
	QString file = QFileDialog::getSaveFileName( this, tr("Select transfer key"), LineEdit_TRANSFERKEY->text(), QString(), 0, QFileDialog::DontConfirmOverwrite );

	if( !file.isEmpty() )
	{
		LineEdit_TRANSFERKEY->setText(file);
	}
}

/** */
void DCOptions::slotBrowseDclibPluginFolder()
{
	QString dir = QFileDialog::getExistingDirectory( this, tr("Select plugin folder"), LineEdit_DCLIB_PLUGIN_PATH->text() );
	
	if ( !dir.isEmpty() )
	{
		LineEdit_DCLIB_PLUGIN_PATH->setText(dir);
	}
}

/** */
void DCOptions::slotBrowseBrowser()
{
	QString file = QFileDialog::getOpenFileName( this, tr("Select a browser"), LineEdit_BROWSER->text() );

	if( !file.isEmpty() )
	{
		LineEdit_BROWSER->setText(file);
	}
}

/** */
void DCOptions::BrowseSoundFile( eUserSound usersound )
{
	QString current;
	QString filter = tr("au")        + " (*.au);;"  +
			 tr("wav")       + " (*.wav);;" +
			 tr("All Files") + " (*)";
	
	switch(usersound)
	{
		case eusCONNECT:
			current = LineEdit_SOUNDFILECONNECT->text();
			break;
		case eusDISCONNECT:
			current = LineEdit_SOUNDFILEDISCONNECT->text();
			break;
		case eusSEND:
			current = LineEdit_SOUNDFILESEND->text();
			break;
		case eusRECEIVE:
			current = LineEdit_SOUNDFILERECEIVE->text();
			break;
		case eusFIRSTRECEIVE:
			current = LineEdit_SOUNDFILEFIRSTRECEIVE->text();
			break;
		case eusNICKMENTIONED:
			current = LineEdit_SOUNDFILENICKMENTIONED->text();
			break;
		default:
			break;
	}

	QString file = QFileDialog::getOpenFileName( this, tr("Select sound file"), current, filter  );

	if ( !file.isEmpty() )
	{
		switch(usersound)
		{
			case eusCONNECT:
				LineEdit_SOUNDFILECONNECT->setText(file);
				break;
			case eusDISCONNECT:
				LineEdit_SOUNDFILEDISCONNECT->setText(file);
				break;
			case eusSEND:
				LineEdit_SOUNDFILESEND->setText(file);
				break;
			case eusRECEIVE:
				LineEdit_SOUNDFILERECEIVE->setText(file);
				break;
			case eusFIRSTRECEIVE:
				LineEdit_SOUNDFILEFIRSTRECEIVE->setText(file);
				break;
			case eusNICKMENTIONED:
				LineEdit_SOUNDFILENICKMENTIONED->setText(file);
				break;
			default:
				break;
		}
	}
}

/** */
void DCOptions::PreviewSoundFile( eUserSound usersound )
{
	QString file;

	switch(usersound)
	{
		case eusCONNECT:
			file = LineEdit_SOUNDFILECONNECT->text();
			break;
		case eusDISCONNECT:
			file = LineEdit_SOUNDFILEDISCONNECT->text();
			break;
		case eusSEND:
			file = LineEdit_SOUNDFILESEND->text();
			break;
		case eusRECEIVE:
			file = LineEdit_SOUNDFILERECEIVE->text();
			break;
		case eusFIRSTRECEIVE:
			file = LineEdit_SOUNDFILEFIRSTRECEIVE->text();
			break;
		case eusNICKMENTIONED:
			file = LineEdit_SOUNDFILENICKMENTIONED->text();
			break;
		default:
			break;
	}

	g_pConfig->PlaySound( file );
}

/** */
void DCOptions::slotBrowseDownloadFolder()
{
	QString dir = QFileDialog::getExistingDirectory ( this, tr("Select download folder"), LineEdit_DOWNLOADFOLDER->text() );

	if ( !dir.isEmpty() )
	{
		LineEdit_DOWNLOADFOLDER->setText(dir);
	}
}

/** */
void DCOptions::slotBrowseDownloadFinishedFolder()
{
	QString dir = QFileDialog::getExistingDirectory ( this, tr("Select download finished folder"), LineEdit_DOWNLOADFINISHEDFOLDER->text() );

	if ( !dir.isEmpty() )
	{
		LineEdit_DOWNLOADFINISHEDFOLDER->setText(dir);
	}
}

/** */
void DCOptions::slotBrowseDataFolder()
{
	QString dir = QFileDialog::getExistingDirectory ( this, tr("Select data folder"), LineEdit_DATAFOLDER->text() );

	if ( !dir.isEmpty() )
	{
		LineEdit_DATAFOLDER->setText(dir);
	}
}

/** */
void DCOptions::slotBrowseShareList()
{
	g_pTransferView->NewLocalFileBrowser(true);
}

/** */
void DCOptions::slotBrowseLogFile()
{
	QString logfile = QFileDialog::getSaveFileName ( this, tr("Select log file"), LineEdit_LOGFILENAME->text() );

	if( !logfile.isEmpty() )
	{
		LineEdit_LOGFILENAME->setText(logfile);
	}
}

/** */
void DCOptions::slotAddSharedFolder()
{
	CDir di;
	CString s;
	int i;

	QString dir = QFileDialog::getExistingDirectory ( this, tr("Select share folder") );

	if ( !dir.isEmpty() )
	{
		if ( TreeWidget_SHAREDFOLDERS->findItems( dir, Qt::MatchExactly, 0 ).size() == 0 )
		{
			di.SetPath(dir.toAscii().constData());
			s = di.Path();
			i = 1;

			while( TreeWidget_SHAREDFOLDERS->findItems( di.DirName().Data(), Qt::MatchExactly, 1 ).size() != 0 )
			{
				di.SetPath( s + CString::number(i) );
				i++;
			}

			QTreeWidgetItem * item = new QTreeWidgetItem( TreeWidget_SHAREDFOLDERS );
			item->setText( 0, dir );
			item->setText( 1, di.DirName().Data() );
		}
	}
}

/** */
void DCOptions::slotRemoveSharedFolder()
{
	QTreeWidgetItem * item = TreeWidget_SHAREDFOLDERS->currentItem();

	if ( item )
	{
		TreeWidget_SHAREDFOLDERS->takeTopLevelItem( TreeWidget_SHAREDFOLDERS->indexOfTopLevelItem( item ) );
		delete item;
	}
}

/** */
void DCOptions::slotEditSharedFolder()
{
	editSharedFolder( TreeWidget_SHAREDFOLDERS->currentItem() );
}

/** */
void DCOptions::editSharedFolder( QTreeWidgetItem * item )
{
	if ( item )
	{
		QDialog * dlg = new QDialog(this);
		
		Ui::DCDialogEditSharePath ui;
		ui.setupUi(dlg);
		
		ui.LineEdit_PATH->setText( item->text(0) );
		ui.LineEdit_ALIAS->setText( item->text(1) );
		
		if ( dlg->exec() == QDialog::Accepted )
		{
			item->setText(0,ui.LineEdit_PATH->text());
			
			QString s = ui.LineEdit_ALIAS->text();
			s.remove( '\\' );
			s.remove( '/' );
			item->setText(1,s);
		}
		
		delete dlg;
	}
}

/** */
void DCOptions::slotDoubleClickedSharedFolder( QTreeWidgetItem * item, int /* column */ )
{
	if ( item ) // always true since signal is only emitted on valid items
	{
		editSharedFolder( item );
	}
	else
	{
		slotAddSharedFolder();
	}
}

/** */
void DCOptions::slotContextMenuSharedFolder( const QPoint & pos )
{
	QMenu * m = new QMenu(this);
	QTreeWidgetItem * item = TreeWidget_SHAREDFOLDERS->itemAt(pos);
	bool enabled = (item != 0);
	
	QAction * add = DCMenuHandler::addAction( m, emiADD );
	QAction * edit = DCMenuHandler::addAction( m, emiEDIT, enabled );
	QAction * remove = DCMenuHandler::addAction( m, emiREMOVE, enabled );
	
	QAction * chosen = m->exec(QCursor::pos());
	
	delete m;
	
	if ( chosen == 0 )
	{
		return;
	}
	else if ( chosen == add )
	{
		slotAddSharedFolder();
	}
	else if ( chosen == edit )
	{
		editSharedFolder( item );
	}
	else if ( chosen == remove )
	{
		delete item;
	}
}

/** */
void DCOptions::slotSharedFoldersSelectionChanged()
{
	if ( TreeWidget_SHAREDFOLDERS->selectedItems().size() == 1 )
	{
		ToolButton_REMOVESHAREDFOLDER->setEnabled(true);
		ToolButton_EDITSHAREDFOLDER->setEnabled(true);
	}
	else
	{
		ToolButton_REMOVESHAREDFOLDER->setEnabled(false);
		ToolButton_EDITSHAREDFOLDER->setEnabled(false);
	}
}

/** */
void DCOptions::SetValues()
{
	int i;
	CList<DCConfigShareFolder> list;
	DCConfigShareFolder * csf;
	QTreeWidgetItem * qtwitem;

	// identify
	LineEdit_NICK->setText(g_pConfig->GetNick().Data());
	LineEdit_SEARCHNICK->setText(g_pConfig->GetSearchNick().Data());
	LineEdit_EMAIL->setText(g_pConfig->GetEMail(true).Data());
	CheckBox_ANTISPAM->setChecked(g_pConfig->GetAntiSpam());
	LineEdit_DESCRIPTION->setText(g_pConfig->GetDescription(true).Data());
	CheckBox_DESCRIPTION_TAG->setChecked(g_pConfig->GetDescriptionTag());
	CheckBox_EXT_HUB_COUNT->setChecked(g_pConfig->GetUseExtendedHubCount());
	LineEdit_AWAYPREFIX->setText(g_pConfig->GetAwayPrefix().Data());

	SetUserPhoto(g_pConfig->GetUserPhotoFileName());

	i = ComboBox_SPEED->findText( QString::fromAscii(g_pConfig->GetSpeed().Data()) );
	if ( i != -1 )
	{
		ComboBox_SPEED->setCurrentIndex(i);
	}
	
	i = ComboBox_APPLICATION_ICONS->findText( g_pConfig->GetApplicationIconTheme() );
	if ( i != -1 )
	{
		ComboBox_APPLICATION_ICONS->setCurrentIndex(i);
	}
	
	i = ComboBox_EMOTICONS->findText( g_pConfig->GetEmoticonTheme() );
	if ( i != -1 )
	{
		ComboBox_EMOTICONS->setCurrentIndex(i);
	}
	
	i = ComboBox_USERLIST_ICONS->findText( g_pConfig->GetUserListIconTheme() );
	if ( i != -1 )
	{
		ComboBox_USERLIST_ICONS->setCurrentIndex(i);
	}
	
	TextEdit_AWAYMESSAGE->setText(QString(g_pConfig->GetAwayMessage().Data()).remove( "\r" ));

	// transfer->folder
	LineEdit_DOWNLOADFOLDER->setText(g_pConfig->GetDownloadFolder().Data());
	LineEdit_DOWNLOADFINISHEDFOLDER->setText(g_pConfig->GetDownloadFinishedFolder().Data());
	SpinBox_MIN_SEG_SIZE->setValue( (int) g_pConfig->GetMinSegSize()/1048576 );

	// save shared folders
	TreeWidget_SHAREDFOLDERS->clear();

	g_pConfig->GetSharedFolders(&list);

	csf = 0;
	while( (csf=list.Next(csf)) != 0 )	
	{
		QTreeWidgetItem * item = new QTreeWidgetItem( TreeWidget_SHAREDFOLDERS );
		item->setText( 0, csf->m_sPath.Data() );
		item->setText( 1, csf->m_sAlias.Data() );
	}
	slotSharedFoldersSelectionChanged();
	
	g_pConfig->GetUserMenuCommands(&usercommands);
	for ( QMap<int, DC_UserMenuCommand*>::const_iterator it = usercommands.constBegin(); it != usercommands.constEnd(); ++it )
	{
		qtwitem = new QTreeWidgetItem( TreeWidget_MENU_COMMANDS );
		qtwitem->setText( 0, it.value()->m_sName );
		qtwitem->setText( 1, it.value()->m_sCommand );
	}
	
	slotUserMenuCommandsSelectionChanged();
	
	QList<DC_UserChatCommand*> ucclist;
	g_pConfig->GetUserChatCommands(&ucclist);
	for ( QList<DC_UserChatCommand*>::const_iterator it = ucclist.constBegin(); it != ucclist.constEnd(); ++it )
	{
		qtwitem = new QTreeWidgetItem( TreeWidget_CHAT_COMMANDS );
		qtwitem->setText( 0, (*it)->m_sName );
		qtwitem->setText( 1, (*it)->m_sCommand );
		qtwitem->setFlags( qtwitem->flags() | Qt::ItemIsEditable );
		delete *it;
	}
	ucclist.clear();
	
	CheckBox_AUTORECREATESHARELIST->setChecked(g_pConfig->GetAutoRecreateShareList());
	CheckBox_DONTSHAREDOTFILES->setChecked(g_pConfig->GetDontShareDotFiles());

	// transfer->settings
	SpinBox_SAVEDOWNLOADQUEUETIME->setValue( g_pConfig->GetDownloadQueueTime() );
	SpinBox_USERUPLOADSLOTS->setValue(g_pConfig->GetUserUploadSlots());
	CheckBox_DYNAMICUPLOADRATE->setChecked(g_pConfig->GetDynamicUploadRate());
	SpinBox_MAXUPLOADRATE->setValue( (g_pConfig->GetMaxUploadRate())/1024.0 );
	SpinBox_MAXDOWNLOADRATE->setValue( (g_pConfig->GetMaxDownloadRate())/1024.0 );
	SpinBox_MAXSIMULTANEOUSUPLOADS->setValue( g_pConfig->GetMaxUpload() );
	SpinBox_TRANSFERRESENDTIMEOUT->setValue(g_pConfig->GetTransferResendTimeout());
	SpinBox_TRANSFERRESPONSETIMEOUT->setValue(g_pConfig->GetTransferResponseTimeout());
	SpinBox_AUTOSEARCHINTERVAL->setValue(g_pConfig->GetAutoSearchInterval());
	SpinBox_SMALLFILESIZE->setValue(g_pConfig->GetSmallFileSize());

	SpinBox_EXTRA_SLOTS_RATE->setValue( (int) g_pConfig->GetExtraSlotsRate()/1024 );
	SpinBox_MAX_EXTRA_SLOTS->setValue( g_pConfig->GetMaxExtraSlots() );

	switch ( g_pConfig->GetHubOfflineTransferClose() )
	{
		case ectNONE:
			RadioButton_NONE->setChecked(true);
			break;
		case ectUPLD:
			RadioButton_UPLOAD->setChecked(true);
			break;
		case ectDLD:
			RadioButton_DOWNLOAD->setChecked(true);
			break;
		case ectBOTH:
			RadioButton_BOTH->setChecked(true);
			break;
	}

	CheckBox_TRANSFERAUTOSEARCH->setChecked(g_pConfig->GetTransferAutoSearch());
	CheckBox_DISABLEHASHLIST->setChecked(g_pConfig->GetDisableHashList());
	CheckBox_COMPRESSEDTRANSFERS->setChecked(g_pConfig->GetCompressedTransfers());
	SpinBox_RECREATESHARELISTTIME->setValue(g_pConfig->GetRecreateShareListTime());

	// connection->mode
	if ( g_pConfig->GetMode(true) == ecmPASSIVE )
	{
		RadioButton_PASSIVEMODE->setChecked(true);
	}
	else
	{
		RadioButton_ACTIVEMODE->setChecked(true);
	}

	if ( g_pConfig->GetExternalIP() )
	{
		RadioButton_IPHOSTNAME->setChecked(true);
	}
	else
	{
		RadioButton_INTERFACE->setChecked(true);
	}

	LineEdit_IP->setText(g_pConfig->GetHost().Data());
	LineEdit_LISTENIP->setText(g_pConfig->GetListenHost().Data());
	SpinBox_TCPLISTENPORT->setValue( g_pConfig->GetTCPListenPort() );
	SpinBox_CRYPTO_PORT->setValue( g_pConfig->GetCryptoListenPort() );
	SpinBox_UDPLISTENPORT->setValue( g_pConfig->GetUDPListenPort() );
	CheckBox_SENDMESSAGEONACTIVEMODEREQUEST->setChecked( g_pConfig->GetSendMessageOnActiveModeRequest() );

	// connection->settings
	SpinBox_RECONNECTCOUNT->setValue(g_pConfig->GetReconnectCount());
	SpinBox_RECONNECTTIMEOUT->setValue(g_pConfig->GetReconnectTimeout());
	CheckBox_FORCEMOVEENABLED->setChecked(g_pConfig->GetForceMoveEnabled());
	
	if ( g_pConfig->GetCheckPrivateAddressSpace() )
	{
		ComboBox_PRIVATEADDRESSSPACE->setCurrentIndex(1);
	}
	else if ( g_pConfig->GetPrivateAddressSpaceOnly() )
	{
		ComboBox_PRIVATEADDRESSSPACE->setCurrentIndex(2);
	}
	else
	{
		ComboBox_PRIVATEADDRESSSPACE->setCurrentIndex(0);
	}

	// gui->general
	LineEdit_LANGUAGEFILE->setText( g_pConfig->GetLanguageFile() );

	i = ComboBox_THEME->findText( g_pConfig->GetTheme() );
	if ( i != -1 )
	{
		ComboBox_THEME->setCurrentIndex(i);
	}
	else
	{
		// if theme not in list, pick the current theme
#if defined(Q_OS_MACX)
		i = ComboBox_THEME->findText( "mac", Qt::MatchStartsWith );
#else
		i = ComboBox_THEME->findText( DCGuiUtils::DetectAppStyleKey() );
#endif

		if ( i != -1 )
		{
			ComboBox_THEME->setCurrentIndex(i);
		}
	}

	m_sTestedTheme = ComboBox_THEME->currentText();

	switch(g_pConfig->GetUnit())
	{
		case euBYTE:
			RadioButton_UNITBYTE->setChecked(true);
			break;
		case euKBYTE:
			RadioButton_UNITKBYTE->setChecked(true);
			break;
		case euMBYTE:
			RadioButton_UNITMBYTE->setChecked(true);
			break;
		case euGBYTE:
			RadioButton_UNITGBYTE->setChecked(true);
			break;
		default:
			RadioButton_UNITAUTO->setChecked(true);
			break;
	}

	LineEdit_APPFONT->setText( g_pConfig->GetAppFont() );
	GroupBox_APPFONT->setChecked( g_pConfig->GetUseCustomFont() );
	LineEdit_DATAFOLDER->setText(g_pConfig->GetValknutDataPath());
	CheckBox_SHOWSTATUSMESSAGE->setChecked( g_pConfig->GetShowStatusMessage() );
	CheckBox_QUERYONEXIT->setChecked( g_pConfig->GetQueryOnExit() );
	CheckBox_QUERYONFILEDELETE->setChecked( g_pConfig->GetQueryOnFileDelete() );

	// gui->transfer
	CheckBox_TV_PERCENTCHUNK->setChecked(g_pConfig->GetTransferViewOptions(etvoCHUNKPERCENT));
	CheckBox_TV_PERCENTFILE->setChecked(g_pConfig->GetTransferViewOptions(etvoFILEPERCENT));
	CheckBox_TV_CHUNKSIZE->setChecked(g_pConfig->GetTransferViewOptions(etvoCHUNKSIZE));
	CheckBox_TV_FILESIZE->setChecked(g_pConfig->GetTransferViewOptions(etvoFILESIZE));
	CheckBox_TV_DOWNLOADRATESINGLE->setChecked(g_pConfig->GetTransferViewOptions(etvoDOWNLOADRATESINGLE));
	CheckBox_TV_ELAPSEDTIMESINGLE->setChecked(g_pConfig->GetTransferViewOptions(etvoELAPSEDTIMESINGLE));
	CheckBox_TV_DOWNLOADRATEMULTI->setChecked(g_pConfig->GetTransferViewOptions(etvoDOWNLOADRATEMULTI));
	CheckBox_TV_ELAPSEDTIMEMULTI->setChecked(g_pConfig->GetTransferViewOptions(etvoELAPSEDTIMEMULTI));

	// gui->chat
	CheckBox_OPENPRIVATECHATWINDOW->setChecked(g_pConfig->GetOpenPrivateChatWindow());
	CheckBox_SHOWCHATINTAB->setChecked(g_pConfig->GetShowChatInTab());
	CheckBox_SENDHIDEPRIVATECHATTOPUBLICCHAT->setChecked( g_pConfig->GetSendHidePrivateChatToPublicChat());
	CheckBox_EMOTICONS->setChecked(g_pConfig->GetEnableEmoticons());
	CheckBox_SHOWCHATSENDBUTTON->setChecked(g_pConfig->GetShowChatSendButton());
	CheckBox_CHATSHOWJOINSANDPARTS->setChecked(g_pConfig->GetChatShowJoinsAndParts());
	CheckBox_CHATSHOWJOINSANDPARTSONLYFAV->setChecked(g_pConfig->GetChatShowJoinsAndPartsOnlyFav());
	CheckBox_CHATRECVOFFLINEMESSAGES->setChecked(g_pConfig->GetChatRecvOfflineMessages());
	CheckBox_CHATSENDOFFLINEMESSAGES->setChecked(g_pConfig->GetChatSendOfflineMessages());
	SpinBox_CHATMAXPARAGRAPH->setValue(g_pConfig->GetChatMaxParagraph());
	SpinBox_CHATMESSAGEMAXLINES->setValue( g_pConfig->GetChatMessageMaxLines() );
	LineEdit_SUPPRESS_NICKS->setText( g_pConfig->GetSuppressedNicks() );
	CheckBox_SENDUNKNOWNCOMMANDS->setChecked(g_pConfig->GetSendUnknownCommandsAsChat());
	LineEdit_ALLOWED_UNKNOWN_COMMANDS->setText(g_pConfig->GetAllowedUnknownCommands());
	
	ComboBox_SENDCHAT->setCurrentIndex(g_pConfig->GetSendChat());

	CheckBox_CUSTOM_BROWSER->setChecked(g_pConfig->GetCustomBrowser());
	LineEdit_BROWSER->setText(g_pConfig->GetBrowser());
	slotCustomBrowserChecked();

	QColor c;
	QPixmap p(10,10);

	c.setNamedColor(g_pConfig->GetChatColor(eccCHATTIMESTAMP));
	p.fill(c);
	new QListWidgetItem( QIcon(p), tr("Chat Timestamp"), ListBox_CHATCOLOR );
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATLOCALNICK));
	p.fill(c);
	new QListWidgetItem( QIcon(p), tr("Chat Local Nick"), ListBox_CHATCOLOR );
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATLOCALTEXT));
	p.fill(c);
	new QListWidgetItem( QIcon(p), tr("Chat Local Text"), ListBox_CHATCOLOR );
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATREMOTENICK));
	p.fill(c);
	new QListWidgetItem( QIcon(p), tr("Chat Remote Nick"), ListBox_CHATCOLOR );
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATREMOTETEXT));
	p.fill(c);
	new QListWidgetItem( QIcon(p), tr("Chat Remote Text"), ListBox_CHATCOLOR );
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATSTATUSNICK));
	p.fill(c);
	new QListWidgetItem( QIcon(p), tr("Chat Status Nick"), ListBox_CHATCOLOR );
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATSTATUSTEXT));
	p.fill(c);
	new QListWidgetItem( QIcon(p), tr("Chat Status Text"), ListBox_CHATCOLOR );
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATTIMESTAMP));
	p.fill(c);
	new QListWidgetItem( QIcon(p), tr("Public Chat Timestamp"), ListBox_CHATCOLOR );
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATLOCALNICK));
	p.fill(c);
	new QListWidgetItem( QIcon(p), tr("Public Chat Local Nick"), ListBox_CHATCOLOR );
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATLOCALTEXT));
	p.fill(c);
	new QListWidgetItem( QIcon(p), tr("Public Chat Local Text"), ListBox_CHATCOLOR );
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATREMOTENICK));
	p.fill(c);
	new QListWidgetItem( QIcon(p), tr("Public Chat Remote Nick"), ListBox_CHATCOLOR );
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATREMOTETEXT));
	p.fill(c);
	new QListWidgetItem( QIcon(p), tr("Public Chat Remote Text"), ListBox_CHATCOLOR );
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATSTATUSNICK));
	p.fill(c);
	new QListWidgetItem( QIcon(p), tr("Public Chat Status Nick"), ListBox_CHATCOLOR );
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATSTATUSTEXT));
	p.fill(c);
	new QListWidgetItem( QIcon(p), tr("Public Chat Status Text"), ListBox_CHATCOLOR );
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICPRIVATECHATNICK));
	p.fill(c);
	new QListWidgetItem( QIcon(p), tr("Public Private Chat Nick"), ListBox_CHATCOLOR );
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICPRIVATECHATTEXT));
	p.fill(c);
	new QListWidgetItem( QIcon(p), tr("Public Private Chat Text"), ListBox_CHATCOLOR );
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATSAY));
	p.fill(c);
	new QListWidgetItem( QIcon(p), tr("Chat Say"), ListBox_CHATCOLOR );
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATMENICK));
	p.fill(c);
	new QListWidgetItem( QIcon(p), tr("Public Chat ME Nick"), ListBox_CHATCOLOR );
	c.setNamedColor(g_pConfig->GetChatColor(eccOPNICK));
	p.fill(c);
	new QListWidgetItem( QIcon(p), tr("Operator Nick"), ListBox_CHATCOLOR );
	
	CheckBox_ENABLE_CHAT_BG_COLOR->setChecked(g_pConfig->GetChatBackgroundColorEnabled());
	c.setNamedColor(g_pConfig->GetChatBackgroundColor());
	p.fill(c);
	ToolButton_CHAT_BG_COLOR->setIcon(QIcon(p));
	
	// gui->client
	ComboBox_OPEN_CLIENT_WINDOWS_HOW->setCurrentIndex(g_pConfig->GetOpenClientWindows());
	CheckBox_USERLISTRIGHTALIGNMENT->setChecked(g_pConfig->GetUserListRightAlignment());
	CheckBox_AUTOAWAYMODE->setChecked(g_pConfig->GetAutoAwayMode());
	SpinBox_AUTOAWAYTIME->setValue(g_pConfig->GetAutoAwayTime());
	CheckBox_CLIENTCOLUMNS_COMMENT->setChecked(g_pConfig->GetClientColumn(eclcCOMMENT));
	CheckBox_CLIENTCOLUMNS_TAG->setChecked(g_pConfig->GetClientColumn(eclcTAG));
	CheckBox_CLIENTCOLUMNS_SPEED->setChecked(g_pConfig->GetClientColumn(eclcSPEED));
	CheckBox_CLIENTCOLUMNS_EMAIL->setChecked(g_pConfig->GetClientColumn(eclcEMAIL));
	CheckBox_CLIENTCOLUMNS_SHARE->setChecked(g_pConfig->GetClientColumn(eclcSHARE));
	CheckBox_CLIENTCOLUMNS_IP->setChecked(g_pConfig->GetClientColumn(eclcIP));
	CheckBox_CLIENTCOLUMNS_LOCKPK->setChecked(g_pConfig->GetClientColumn(eclcLOCKPK));
	CheckBox_CLIENTCOLUMNS_SUPPORTS->setChecked(g_pConfig->GetClientColumn(eclcSUPPORTS));
	
	ComboBox_DOUBLECLICK->setCurrentIndex(g_pConfig->GetDoubleClickAction());
	
	// sound
	CheckBox_SOUNDDISABLED->setChecked(g_pConfig->GetSoundDisabled());
	CheckBox_SOUNDDISABLEDAWAY->setChecked(g_pConfig->GetSoundDisabledAway());
	GroupBox_EXTERNALPLAYER->setChecked(g_pConfig->GetExternalSoundPlayer());
	LineEdit_EXTERNALPLAYER->setText( g_pConfig->GetExternalPlayer() );
	LineEdit_SOUNDFILECONNECT->setText( g_pConfig->GetSoundFile(eusCONNECT) );
	LineEdit_SOUNDFILEDISCONNECT->setText( g_pConfig->GetSoundFile(eusDISCONNECT) );
	LineEdit_SOUNDFILESEND->setText( g_pConfig->GetSoundFile(eusSEND) );
	LineEdit_SOUNDFILERECEIVE->setText( g_pConfig->GetSoundFile(eusRECEIVE) );
	LineEdit_SOUNDFILEFIRSTRECEIVE->setText( g_pConfig->GetSoundFile(eusFIRSTRECEIVE) );
	LineEdit_SOUNDFILENICKMENTIONED->setText( g_pConfig->GetSoundFile(eusNICKMENTIONED) );
	GroupBox_SOUNDPLAYCONNECT->setChecked(g_pConfig->GetSoundEnabled(eusCONNECT));
	GroupBox_SOUNDPLAYDISCONNECT->setChecked(g_pConfig->GetSoundEnabled(eusDISCONNECT));
	GroupBox_SOUNDPLAYSEND->setChecked(g_pConfig->GetSoundEnabled(eusSEND));
	GroupBox_SOUNDPLAYRECEIVE->setChecked(g_pConfig->GetSoundEnabled(eusRECEIVE));
	GroupBox_SOUNDPLAYFIRSTRECEIVE->setChecked(g_pConfig->GetSoundEnabled(eusFIRSTRECEIVE));
	GroupBox_SOUNDPLAYNICKMENTIONED->setChecked(g_pConfig->GetSoundEnabled(eusNICKMENTIONED));

	// log
	CheckBox_LOGFILE->setChecked(g_pConfig->GetLogFile());
	CheckBox_LOGDOWNLOADS->setChecked(g_pConfig->GetLogFinishedDownloads());
	CheckBox_LOGUPLOADS->setChecked(g_pConfig->GetLogFinishedUploads());
	CheckBox_LOGDETAILS->setChecked(g_pConfig->GetLogDetails());
	LineEdit_LOGFILENAME->setText( g_pConfig->GetLogFileName().Data() );
	CheckBox_TIMESTAMPPRIVATECHAT->setChecked(g_pConfig->GetTimeStamp(etsPRIVATECHAT));
	CheckBox_TIMESTAMPHUBCHAT->setChecked(g_pConfig->GetTimeStamp(etsHUBCHAT));

	GroupBox_CHAT_LOGGING->setChecked( g_pConfig->GetLogChatOption(elcoENABLELOGGING) );
	CheckBox_LOGCHAT_APPENDDATE->setChecked( g_pConfig->GetLogChatOption(elcoAPPENDDATE) );
	CheckBox_LOGCHAT_APPENDHUBNAME->setChecked( g_pConfig->GetLogChatOption(elcoAPPENDHUBNAME) );
	CheckBox_LOGCHAT_APPENDHUBHOST->setChecked( g_pConfig->GetLogChatOption(elcoAPPENDHUBHOST) );
	CheckBox_LOGCHAT_DISABLEPUBLICCHAT->setChecked( g_pConfig->GetLogChatOption(elcoDISABLEPUBLICCHAT) );
	GroupBox_LOGNICKNAMEFILTER->setChecked( g_pConfig->GetLogChatOption(elcoENABLENICKNAMEFILTER) );
	CheckBox_LOGCHAT_NICKNAMEFILTER_ENABLELOGGING->setChecked( g_pConfig->GetLogChatOption(elcoNICKNAMEFILTER_ENABLELOGGING) );


	ListBox_LOGCHAT_NICKNAMEFILTER_LIST->clear();
	ListBox_LOGCHAT_NICKNAMEFILTER_LIST->addItems( g_pConfig->GetLogChatNickNameFilter() );

	// other
	CheckBox_HUBLISTSTORELOCAL->setChecked(g_pConfig->GetHubListStoreLocal());
	SpinBox_RELOADHUBLISTTIME->setValue(g_pConfig->GetReloadHubListTime());

	DCConfigHubListUrl * hublisturl = 0;

	CList<DCConfigHubListUrl> hublisturllist;
	g_pConfig->GetHubListUrlList(&hublisturllist);

	while( (hublisturl=hublisturllist.Next(hublisturl)) != 0 )
	{
		QListWidgetItem * lwi = new QListWidgetItem( hublisturl->sUrl.Data(), ListWidget_HUBLISTURL );
		if ( hublisturl->bEnabled )
		{
			lwi->setCheckState( Qt::Checked );
		}
		else
		{
			lwi->setCheckState( Qt::Unchecked );
		}
	}
	slotHubListUrlsSelectionChanged();

	// security
	SpinBox_FLOODCOUNT->setValue(g_pConfig->GetFloodCount());
	CheckBox_FLOODOPKICK->setChecked(g_pConfig->GetFloodOpKick());
	LineEdit_FLOODOPKICKMESSAGE->setText(QString(g_pConfig->GetFloodOpKickMessage().Data()).remove( "\r" ));
	LineEdit_TRANSFERCERT->setText(g_pConfig->GetTransferCert().Data());
	LineEdit_TRANSFERKEY->setText(g_pConfig->GetTransferKey().Data());
	CheckBox_OLD_DCLIB_SSL_SUPPORT->setChecked(g_pConfig->GetOldSSLSupport());
	LineEdit_DCLIB_PLUGIN_PATH->setText(g_pConfig->GetDCLibPluginPath().Data());

	// init the sound tab
	slotDisableSound();
	
	// auto response settings
	CheckBox_ENABLE_AUTO_RESPONDER->setChecked(g_pConfig->GetAutoResponderEnabled());
	CheckBox_ENABLE_AUTO_RESPONDER_FOR_PM->setChecked(g_pConfig->GetAutoResponderEnabledForPM());
	SpinBox_AUTORESPONSEDELAY->setValue(g_pConfig->GetAutoResponseDelay());
	LineEdit_AUTO_RESPONSE_IGNORE->setText(g_pConfig->GetAutoResponseIgnores());
	
	// fill auto response list box
	QList<DC_AutoResponseObject*> arlist;
	g_pConfig->GetAutoResponses(&arlist);
	for ( QList<DC_AutoResponseObject*>::const_iterator it = arlist.constBegin(); it != arlist.constEnd(); ++it )
	{
		QString cs;
		DC_AutoResponseObject * aro = *it;
		if ( aro->m_bCaseSensitive )
		{
			cs = tr("Yes");
		}
		else
		{
			cs = tr("No");
		}
		qtwitem = new QTreeWidgetItem( TreeWidget_AUTO_RESPONSES );
		qtwitem->setText( 0, aro->m_sTrigger );
		qtwitem->setText( 1, cs );
		qtwitem->setText( 2, aro->m_sResponse );
		qtwitem->setFlags( qtwitem->flags() | Qt::ItemIsEditable );
		
		delete aro;
	}
	arlist.clear();
	
	ComboBox_REMOTE_ENCODING->setEditText( g_pConfig->GetRemoteEncoding().Data() );
	Label_ENCODING_DISABLE_HOWTO->setText( tr("Setting remote encoding to %1 will disable most conversions.").arg(g_pConfig->GetLocalEncoding().Data()) );
	
	CheckBox_FOLDERS_RIGHT_PANE->setChecked(g_pConfig->GetFoldersInRightPane());
	CheckBox_FOLDERS_RIGHT_PANE_ON_TOP->setChecked(g_pConfig->GetFoldersInRightPaneOnTop());
	CheckBox_SIZES_LEFT_PANE->setChecked(g_pConfig->GetFolderSizesInLeftPane());
	
	CheckBox_ENABLE_USERIP2->setChecked(g_pConfig->GetUserIP2Enabled());
	CheckBox_ENABLE_ZPIPE->setChecked(g_pConfig->GetZPipeEnabled());
	
	CheckBox_ADJUST_SR->setChecked(g_pConfig->GetAdjustSearchResultHubNames());
	CheckBox_ENABLE_REMOVE_PUBLIC_HUB->setChecked(g_pConfig->GetRemovePublicHubEnabled());
	ComboBox_TAB_COMPLETE_MATCH_MODE->setCurrentIndex(g_pConfig->GetTabCompleteMatchMode());
	CheckBox_TAB_COMPLETE_STRIP_TAGS->setChecked(g_pConfig->GetTabCompleteStripTags());
	
	SpinBox_READFILEBUFFERSIZE->setValue(g_pConfig->GetReadFileBufferSize());
	
	CheckBox_NO_ADCGET_WITHOUT_TTH->setChecked(g_pConfig->GetDisableADCGetWithoutTTH());
	CheckBox_NO_XMLLIST_WITHOUT_TTH->setChecked(g_pConfig->GetDisableXMLListWithoutTTH());
	CheckBox_ENABLE_OBSOLETE_EXT->setChecked( g_pConfig->GetEnableObsoleteExt() );
	CheckBox_THREADS_FOR_SHELL_COMMANDS->setChecked(g_pConfig->GetThreadsForShellCommands());
	SpinBox_SHELL_COMMAND_TIMEOUT->setValue(g_pConfig->GetShellCommandTimeout());
	CheckBox_OPEN_FOLDERS_RIGHT_PANE->setChecked(g_pConfig->GetOpenFoldersInRightPane());
	CheckBox_ENABLE_USERCOMMAND_SUPPORT->setChecked(g_pConfig->GetEnableUserCommand());
	CheckBox_USER_COMMAND_SUBMENU->setChecked(g_pConfig->GetUserCommandSubmenu());
	
	switch ( g_pConfig->GetMagnetAction(eChatMagnet) )
	{
		case eMagnetPrompt:
			ComboBox_CHAT_MAGNETS->setCurrentIndex(0);
			break;
		case eMagnetSearch:
			ComboBox_CHAT_MAGNETS->setCurrentIndex(1);
			break;
		case eMagnetDownload:
			/* not supported */
			break;
		case eMagnetNothing:
			ComboBox_CHAT_MAGNETS->setCurrentIndex(2);
			break;
		default:
			break;
	}
}

/** */
void DCOptions::GetValues()
{
	g_pConfig->SetNick(LineEdit_NICK->text().toAscii().constData());
	g_pConfig->SetSearchNick(LineEdit_SEARCHNICK->text().toAscii().constData());
	g_pConfig->SetAwayMessage(TextEdit_AWAYMESSAGE->toPlainText().replace( "\n", "\xd\xa" ).toAscii().constData());
	g_pConfig->SetDescription(LineEdit_DESCRIPTION->text().toAscii().constData());
	g_pConfig->SetAwayPrefix(LineEdit_AWAYPREFIX->text().toAscii().constData());
	g_pConfig->SetDescriptionTag(CheckBox_DESCRIPTION_TAG->isChecked());
	g_pConfig->SetUseExtendedHubCount(CheckBox_EXT_HUB_COUNT->isChecked());
	g_pConfig->SetEMail(LineEdit_EMAIL->text().toAscii().constData());
	g_pConfig->SetAntiSpam(CheckBox_ANTISPAM->isChecked());
	
	if ( ComboBox_PRIVATEADDRESSSPACE->currentIndex() == 0 )
	{
		g_pConfig->SetCheckPrivateAddressSpace(false);
		g_pConfig->SetPrivateAddressSpaceOnly(false);
	}
	else if ( ComboBox_PRIVATEADDRESSSPACE->currentIndex() == 1 )
	{
		g_pConfig->SetCheckPrivateAddressSpace(true);
		g_pConfig->SetPrivateAddressSpaceOnly(false);
	}
	else if ( ComboBox_PRIVATEADDRESSSPACE->currentIndex() == 2 )
	{
		g_pConfig->SetCheckPrivateAddressSpace(false);
		g_pConfig->SetPrivateAddressSpaceOnly(true);
	}
	
	g_pConfig->SetShowChatSendButton(CheckBox_SHOWCHATSENDBUTTON->isChecked());
	g_pConfig->SetCustomBrowser(CheckBox_CUSTOM_BROWSER->isChecked());
	g_pConfig->SetBrowser(LineEdit_BROWSER->text());
	g_pConfig->SetDynamicUploadRate(CheckBox_DYNAMICUPLOADRATE->isChecked());
	g_pConfig->SetShowChatInTab(CheckBox_SHOWCHATINTAB->isChecked());
	g_pConfig->SetChatMaxParagraph(SpinBox_CHATMAXPARAGRAPH->value());
	g_pConfig->SetTransferAutoSearch(CheckBox_TRANSFERAUTOSEARCH->isChecked());
	g_pConfig->SetDisableHashList(CheckBox_DISABLEHASHLIST->isChecked());
	g_pConfig->SetCompressedTransfers(CheckBox_COMPRESSEDTRANSFERS->isChecked());

	g_pConfig->SetUserPhotoFileName(ToolButton_PHOTO->text());

	g_pConfig->SetSpeed(ComboBox_SPEED->currentText().toAscii().constData());
	g_pConfig->SetDownloadFolder(LineEdit_DOWNLOADFOLDER->text().toAscii().constData());
	g_pConfig->SetDownloadFinishedFolder(LineEdit_DOWNLOADFINISHEDFOLDER->text().toAscii().constData());
	g_pConfig->SetMinSegSize( ((ulonglong) SpinBox_MIN_SEG_SIZE->value()) * 1048576 );
	g_pConfig->SetValknutDataPath(LineEdit_DATAFOLDER->text());
	
	g_pConfig->SetAutoRecreateShareList(CheckBox_AUTORECREATESHARELIST->isChecked());
	g_pConfig->SetDontShareDotFiles(CheckBox_DONTSHAREDOTFILES->isChecked());
	g_pConfig->SetRecreateShareListTime(SpinBox_RECREATESHARELISTTIME->value());

	g_pConfig->SetFloodOpKickMessage(LineEdit_FLOODOPKICKMESSAGE->text().replace( "\n", "\xd\xa" ).toAscii().constData());
	g_pConfig->SetFloodCount(SpinBox_FLOODCOUNT->value());
	g_pConfig->SetFloodOpKick(CheckBox_FLOODOPKICK->isChecked());

	g_pConfig->SetTransferCert(LineEdit_TRANSFERCERT->text().toAscii().constData());
	g_pConfig->SetTransferKey(LineEdit_TRANSFERKEY->text().toAscii().constData());
	g_pConfig->SetOldSSLSupport(CheckBox_OLD_DCLIB_SSL_SUPPORT->isChecked());
	g_pConfig->SetDCLibPluginPath(LineEdit_DCLIB_PLUGIN_PATH->text().toAscii().constData());

	SaveSharedFolders();
	
	/* ownership transferred to g_pConfig which clears the map */
	g_pConfig->SetUserMenuCommands( &usercommands );
	
	SaveUserChatCommands();

	g_pConfig->SetAutoResponderEnabled(CheckBox_ENABLE_AUTO_RESPONDER->isChecked());
	g_pConfig->SetAutoResponderEnabledForPM(CheckBox_ENABLE_AUTO_RESPONDER_FOR_PM->isChecked());
	g_pConfig->SetAutoResponseDelay(SpinBox_AUTORESPONSEDELAY->value());
	g_pConfig->SetAutoResponseIgnores(LineEdit_AUTO_RESPONSE_IGNORE->text());
	SaveAutoResponses();

	g_pConfig->SetMaxUpload( SpinBox_MAXSIMULTANEOUSUPLOADS->value() );
	g_pConfig->SetMaxUploadRate( (ulonglong) (SpinBox_MAXUPLOADRATE->value()*1024) );
	g_pConfig->SetMaxDownloadRate( (ulonglong) (SpinBox_MAXDOWNLOADRATE->value()*1024) );
	g_pConfig->SetDownloadQueueTime(SpinBox_SAVEDOWNLOADQUEUETIME->value());
	g_pConfig->SetAutoSearchInterval(SpinBox_AUTOSEARCHINTERVAL->value());
	g_pConfig->SetSmallFileSize(SpinBox_SMALLFILESIZE->value());

	g_pConfig->SetExtraSlotsRate( 1024 * ((ulonglong) SpinBox_EXTRA_SLOTS_RATE->value()) );
	g_pConfig->SetMaxExtraSlots( SpinBox_MAX_EXTRA_SLOTS->value() );

	g_pConfig->SetTCPListenPort(SpinBox_TCPLISTENPORT->value());
	g_pConfig->SetCryptoListenPort(SpinBox_CRYPTO_PORT->value());
	g_pConfig->SetUDPListenPort(SpinBox_UDPLISTENPORT->value());
	g_pConfig->SetExternalIP(RadioButton_IPHOSTNAME->isChecked());

	if ( RadioButton_ACTIVEMODE->isChecked() )
		g_pConfig->SetMode(ecmACTIVE);
	else
		g_pConfig->SetMode(ecmPASSIVE);

	g_pConfig->SetHost(LineEdit_IP->text().toAscii().constData());
	g_pConfig->SetListenHost(LineEdit_LISTENIP->text().toAscii().constData());	
	g_pConfig->SetSendMessageOnActiveModeRequest(CheckBox_SENDMESSAGEONACTIVEMODEREQUEST->isChecked());

	// gui settings
	g_pConfig->SetOpenPrivateChatWindow(CheckBox_OPENPRIVATECHATWINDOW->isChecked());
	g_pConfig->SetEnableEmoticons(CheckBox_EMOTICONS->isChecked());

	if ( RadioButton_UNITBYTE->isChecked() )
		g_pConfig->SetUnit(euBYTE);
	else if ( RadioButton_UNITKBYTE->isChecked() )
		g_pConfig->SetUnit(euKBYTE);
	else if ( RadioButton_UNITMBYTE->isChecked() )
		g_pConfig->SetUnit(euMBYTE);
	else if ( RadioButton_UNITGBYTE->isChecked() )
		g_pConfig->SetUnit(euGBYTE);
	else
		g_pConfig->SetUnit(euAUTO);
	
	g_pConfig->SetTheme(ComboBox_THEME->currentText());
	g_pConfig->SetSendChat(ComboBox_SENDCHAT->currentIndex());
	g_pConfig->SetLanguageFile(LineEdit_LANGUAGEFILE->text());
	g_pConfig->SetShowStatusMessage(CheckBox_SHOWSTATUSMESSAGE->isChecked());
	g_pConfig->SetQueryOnExit(CheckBox_QUERYONEXIT->isChecked());
	g_pConfig->SetQueryOnFileDelete(CheckBox_QUERYONFILEDELETE->isChecked());
	g_pConfig->SetSendHidePrivateChatToPublicChat(CheckBox_SENDHIDEPRIVATECHATTOPUBLICCHAT->isChecked());
	g_pConfig->SetChatSendOfflineMessages(CheckBox_CHATSENDOFFLINEMESSAGES->isChecked());
	g_pConfig->SetChatRecvOfflineMessages(CheckBox_CHATRECVOFFLINEMESSAGES->isChecked());
	g_pConfig->SetChatMessageMaxLines( SpinBox_CHATMESSAGEMAXLINES->value() );
	g_pConfig->SetSuppressedNicks( LineEdit_SUPPRESS_NICKS->text() );
	g_pConfig->SetSendUnknownCommandsAsChat( CheckBox_SENDUNKNOWNCOMMANDS->isChecked() );
	g_pConfig->SetAllowedUnknownCommands( LineEdit_ALLOWED_UNKNOWN_COMMANDS->text() );

	// sound settings
	g_pConfig->SetSoundDisabled(CheckBox_SOUNDDISABLED->isChecked());
	g_pConfig->SetSoundDisabledAway(CheckBox_SOUNDDISABLEDAWAY->isChecked());

	g_pConfig->SetSoundEnabled(eusCONNECT,GroupBox_SOUNDPLAYCONNECT->isChecked());
	g_pConfig->SetSoundEnabled(eusDISCONNECT,GroupBox_SOUNDPLAYDISCONNECT->isChecked());
	g_pConfig->SetSoundEnabled(eusSEND,GroupBox_SOUNDPLAYSEND->isChecked());
	g_pConfig->SetSoundEnabled(eusRECEIVE,GroupBox_SOUNDPLAYRECEIVE->isChecked());
	g_pConfig->SetSoundEnabled(eusFIRSTRECEIVE,GroupBox_SOUNDPLAYFIRSTRECEIVE->isChecked());
	g_pConfig->SetSoundEnabled(eusNICKMENTIONED,GroupBox_SOUNDPLAYNICKMENTIONED->isChecked());

	g_pConfig->SetExternalSoundPlayer(GroupBox_EXTERNALPLAYER->isChecked());
	g_pConfig->SetExternalPlayer(LineEdit_EXTERNALPLAYER->text());
	g_pConfig->SetSoundFile( eusCONNECT, LineEdit_SOUNDFILECONNECT->text() );
	g_pConfig->SetSoundFile( eusDISCONNECT, LineEdit_SOUNDFILEDISCONNECT->text() );
	g_pConfig->SetSoundFile( eusSEND, LineEdit_SOUNDFILESEND->text() );
	g_pConfig->SetSoundFile( eusRECEIVE, LineEdit_SOUNDFILERECEIVE->text() );
	g_pConfig->SetSoundFile( eusFIRSTRECEIVE, LineEdit_SOUNDFILEFIRSTRECEIVE->text() );
	g_pConfig->SetSoundFile( eusNICKMENTIONED, LineEdit_SOUNDFILENICKMENTIONED->text() );
 
	g_pConfig->SetAppFont(LineEdit_APPFONT->text());
	g_pConfig->SetUseCustomFont(GroupBox_APPFONT->isChecked());

	// gui->chat
	g_pConfig->SetChatShowJoinsAndParts(CheckBox_CHATSHOWJOINSANDPARTS->isChecked());
	g_pConfig->SetChatShowJoinsAndPartsOnlyFav(CheckBox_CHATSHOWJOINSANDPARTSONLYFAV->isChecked());
	
	// gui->client
	g_pConfig->SetOpenClientWindows(ComboBox_OPEN_CLIENT_WINDOWS_HOW->currentIndex());
	g_pConfig->SetUserListRightAlignment(CheckBox_USERLISTRIGHTALIGNMENT->isChecked());
	g_pConfig->SetAutoAwayMode(CheckBox_AUTOAWAYMODE->isChecked());
	g_pConfig->SetAutoAwayTime(SpinBox_AUTOAWAYTIME->value());
	g_pConfig->SetClientColumn(eclcCOMMENT,CheckBox_CLIENTCOLUMNS_COMMENT->isChecked());
	g_pConfig->SetClientColumn(eclcTAG,CheckBox_CLIENTCOLUMNS_TAG->isChecked());
	g_pConfig->SetClientColumn(eclcSPEED,CheckBox_CLIENTCOLUMNS_SPEED->isChecked());
	g_pConfig->SetClientColumn(eclcEMAIL,CheckBox_CLIENTCOLUMNS_EMAIL->isChecked());
	g_pConfig->SetClientColumn(eclcSHARE,CheckBox_CLIENTCOLUMNS_SHARE->isChecked());
	g_pConfig->SetClientColumn(eclcIP,CheckBox_CLIENTCOLUMNS_IP->isChecked());
	g_pConfig->SetClientColumn(eclcLOCKPK,CheckBox_CLIENTCOLUMNS_LOCKPK->isChecked());
	g_pConfig->SetClientColumn(eclcSUPPORTS,CheckBox_CLIENTCOLUMNS_SUPPORTS->isChecked());
	g_pConfig->SetDoubleClickAction(ComboBox_DOUBLECLICK->currentIndex());
	
	QString oldappicons = g_pConfig->GetApplicationIconTheme();
	QString oldemoticons = g_pConfig->GetEmoticonTheme();
	
	// gui->icons
	if ( ComboBox_APPLICATION_ICONS->count() > 0 )
	{
		g_pConfig->SetApplicationIconTheme(ComboBox_APPLICATION_ICONS->currentText());
	}
	if ( ComboBox_EMOTICONS->count() > 0 )
	{
		g_pConfig->SetEmoticonTheme(ComboBox_EMOTICONS->currentText());
	}
	if ( ComboBox_USERLIST_ICONS->count() > 0 )
	{
		g_pConfig->SetUserListIconTheme(ComboBox_USERLIST_ICONS->currentText());
	}
	
	if ( oldappicons != g_pConfig->GetApplicationIconTheme() )
	{
		// reload icons with new theme
		g_pIconLoader->Load();
	}
	
	// reload emoticons
	if ( g_pConfig->GetEmoticonTheme() != oldemoticons )
	{
		g_pConfig->InitMimeSourceFactory();
	}
	
	// log settings
	g_pConfig->SetLogFile(CheckBox_LOGFILE->isChecked());
	g_pConfig->SetLogFinishedDownloads(CheckBox_LOGDOWNLOADS->isChecked());
	g_pConfig->SetLogFinishedUploads(CheckBox_LOGUPLOADS->isChecked());
	g_pConfig->SetLogDetails(CheckBox_LOGDETAILS->isChecked());
	g_pConfig->SetLogFileName( LineEdit_LOGFILENAME->text().toAscii().constData() );
	g_pConfig->SetTimeStamp(etsPRIVATECHAT,CheckBox_TIMESTAMPPRIVATECHAT->isChecked());
	g_pConfig->SetTimeStamp(etsHUBCHAT,CheckBox_TIMESTAMPHUBCHAT->isChecked());

	g_pConfig->SetLogChatOption(elcoENABLELOGGING, GroupBox_CHAT_LOGGING->isChecked() );
	g_pConfig->SetLogChatOption(elcoAPPENDDATE, CheckBox_LOGCHAT_APPENDDATE->isChecked() );
	g_pConfig->SetLogChatOption(elcoAPPENDHUBNAME, CheckBox_LOGCHAT_APPENDHUBNAME->isChecked() );
	g_pConfig->SetLogChatOption(elcoAPPENDHUBHOST, CheckBox_LOGCHAT_APPENDHUBHOST->isChecked() );
	g_pConfig->SetLogChatOption(elcoDISABLEPUBLICCHAT, CheckBox_LOGCHAT_DISABLEPUBLICCHAT->isChecked() );
	g_pConfig->SetLogChatOption(elcoENABLENICKNAMEFILTER, GroupBox_LOGNICKNAMEFILTER->isChecked() );
	g_pConfig->SetLogChatOption(elcoNICKNAMEFILTER_ENABLELOGGING, CheckBox_LOGCHAT_NICKNAMEFILTER_ENABLELOGGING->isChecked() );

	int i = 0;
	QStringList nnflist;

	for( i = 0; i < ListBox_LOGCHAT_NICKNAMEFILTER_LIST->count(); i++ )
	{
		nnflist << ListBox_LOGCHAT_NICKNAMEFILTER_LIST->item(i)->text();
	}

	g_pConfig->SetLogChatNickNameFilter( nnflist );

	// other settings
	g_pConfig->SetHubListStoreLocal(CheckBox_HUBLISTSTORELOCAL->isChecked());
	g_pConfig->SetReconnectCount( SpinBox_RECONNECTCOUNT->value() );
	g_pConfig->SetReconnectTimeout( SpinBox_RECONNECTTIMEOUT->value() );
	g_pConfig->SetTransferResendTimeout(SpinBox_TRANSFERRESENDTIMEOUT->value());
	g_pConfig->SetTransferResponseTimeout(SpinBox_TRANSFERRESPONSETIMEOUT->value());
	g_pConfig->SetForceMoveEnabled(CheckBox_FORCEMOVEENABLED->isChecked());
	g_pConfig->SetReloadHubListTime(SpinBox_RELOADHUBLISTTIME->value());

	// transfer view settings
	g_pConfig->SetTransferViewOptions(etvoCHUNKPERCENT,CheckBox_TV_PERCENTCHUNK->isChecked());
	g_pConfig->SetTransferViewOptions(etvoFILEPERCENT,CheckBox_TV_PERCENTFILE->isChecked());
	g_pConfig->SetTransferViewOptions(etvoCHUNKSIZE,CheckBox_TV_CHUNKSIZE->isChecked());
	g_pConfig->SetTransferViewOptions(etvoFILESIZE,CheckBox_TV_FILESIZE->isChecked());
	g_pConfig->SetTransferViewOptions(etvoDOWNLOADRATESINGLE,CheckBox_TV_DOWNLOADRATESINGLE->isChecked());
	g_pConfig->SetTransferViewOptions(etvoELAPSEDTIMESINGLE,CheckBox_TV_ELAPSEDTIMESINGLE->isChecked());
	g_pConfig->SetTransferViewOptions(etvoDOWNLOADRATEMULTI,CheckBox_TV_DOWNLOADRATEMULTI->isChecked());
	g_pConfig->SetTransferViewOptions(etvoELAPSEDTIMEMULTI,CheckBox_TV_ELAPSEDTIMEMULTI->isChecked());
	g_pConfig->SetUserUploadSlots(SpinBox_USERUPLOADSLOTS->value());

        if ( RadioButton_NONE->isChecked() )
		g_pConfig->SetHubOfflineTransferClose( ectNONE );
	else if ( RadioButton_UPLOAD->isChecked() )
		g_pConfig->SetHubOfflineTransferClose( ectUPLD );
	else if ( RadioButton_DOWNLOAD->isChecked() )
		g_pConfig->SetHubOfflineTransferClose( ectDLD );
	else if ( RadioButton_BOTH->isChecked() )
		g_pConfig->SetHubOfflineTransferClose( ectBOTH );

	CList<DCConfigHubListUrl> hublisturllist;

	for ( i = 0; i < ListWidget_HUBLISTURL->count(); i++ )
	{
		DCConfigHubListUrl * hublisturl = new DCConfigHubListUrl();

		QListWidgetItem * item = ListWidget_HUBLISTURL->item(i);
		hublisturl->sUrl     = item->text().toAscii().constData();
		hublisturl->bEnabled = (item->checkState() == Qt::Checked);

		hublisturllist.Add(hublisturl);
	}

	g_pConfig->SetHubListUrlList(&hublisturllist);

	/* set i to start of ListBox_CHATCOLOR */
	i = 0;
	g_pConfig->SetChatColor(eccCHATTIMESTAMP,QColor(ListBox_CHATCOLOR->item(i++)->icon().pixmap(10,10).toImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccCHATLOCALNICK,QColor(ListBox_CHATCOLOR->item(i++)->icon().pixmap(10,10).toImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccCHATLOCALTEXT,QColor(ListBox_CHATCOLOR->item(i++)->icon().pixmap(10,10).toImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccCHATREMOTENICK,QColor(ListBox_CHATCOLOR->item(i++)->icon().pixmap(10,10).toImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccCHATREMOTETEXT,QColor(ListBox_CHATCOLOR->item(i++)->icon().pixmap(10,10).toImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccCHATSTATUSNICK,QColor(ListBox_CHATCOLOR->item(i++)->icon().pixmap(10,10).toImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccCHATSTATUSTEXT,QColor(ListBox_CHATCOLOR->item(i++)->icon().pixmap(10,10).toImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICCHATTIMESTAMP,QColor(ListBox_CHATCOLOR->item(i++)->icon().pixmap(10,10).toImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICCHATLOCALNICK,QColor(ListBox_CHATCOLOR->item(i++)->icon().pixmap(10,10).toImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICCHATLOCALTEXT,QColor(ListBox_CHATCOLOR->item(i++)->icon().pixmap(10,10).toImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICCHATREMOTENICK,QColor(ListBox_CHATCOLOR->item(i++)->icon().pixmap(10,10).toImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICCHATREMOTETEXT,QColor(ListBox_CHATCOLOR->item(i++)->icon().pixmap(10,10).toImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICCHATSTATUSNICK,QColor(ListBox_CHATCOLOR->item(i++)->icon().pixmap(10,10).toImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICCHATSTATUSTEXT,QColor(ListBox_CHATCOLOR->item(i++)->icon().pixmap(10,10).toImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICPRIVATECHATNICK,QColor(ListBox_CHATCOLOR->item(i++)->icon().pixmap(10,10).toImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICPRIVATECHATTEXT,QColor(ListBox_CHATCOLOR->item(i++)->icon().pixmap(10,10).toImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccCHATSAY,QColor(ListBox_CHATCOLOR->item(i++)->icon().pixmap(10,10).toImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccPUBLICCHATMENICK,QColor(ListBox_CHATCOLOR->item(i++)->icon().pixmap(10,10).toImage().pixel(0,0)).name());
	g_pConfig->SetChatColor(eccOPNICK,QColor(ListBox_CHATCOLOR->item(i++)->icon().pixmap(10,10).toImage().pixel(0,0)).name());
	
	g_pConfig->SetChatBackgroundColor( CheckBox_ENABLE_CHAT_BG_COLOR->isChecked(), QColor(ToolButton_CHAT_BG_COLOR->icon().pixmap(10,10).toImage().pixel(0,0)).name() );
	
	g_pConfig->SetRemoteEncoding(ComboBox_REMOTE_ENCODING->currentText().toAscii().constData());
	
	g_pConfig->SetFoldersInRightPane(CheckBox_FOLDERS_RIGHT_PANE->isChecked());
	g_pConfig->SetFoldersInRightPaneOnTop(CheckBox_FOLDERS_RIGHT_PANE_ON_TOP->isChecked());
	g_pConfig->SetFolderSizesInLeftPane(CheckBox_SIZES_LEFT_PANE->isChecked());
	
	g_pConfig->SetUserIP2Enabled(CheckBox_ENABLE_USERIP2->isChecked());
	g_pConfig->SetZPipeEnabled(CheckBox_ENABLE_ZPIPE->isChecked());
	g_pConfig->SetAdjustSearchResultHubNames(CheckBox_ADJUST_SR->isChecked());
	
	/* If this has been turned off, we need to save the public hub list now */
	if ( (CheckBox_ENABLE_REMOVE_PUBLIC_HUB->isChecked() == false) && g_pConfig->GetRemovePublicHubEnabled() )
	{
		g_pConfig->SaveDCPublicHub();
	}
	g_pConfig->SetRemovePublicHubEnabled(CheckBox_ENABLE_REMOVE_PUBLIC_HUB->isChecked());
	
	g_pConfig->SetTabCompleteMatchMode(ComboBox_TAB_COMPLETE_MATCH_MODE->currentIndex());
	g_pConfig->SetTabCompleteStripTags(CheckBox_TAB_COMPLETE_STRIP_TAGS->isChecked());
	
	g_pConfig->SetReadFileBufferSize(SpinBox_READFILEBUFFERSIZE->value());
	
	g_pConfig->SetDisableADCGetWithoutTTH(CheckBox_NO_ADCGET_WITHOUT_TTH->isChecked());
	g_pConfig->SetDisableXMLListWithoutTTH(CheckBox_NO_XMLLIST_WITHOUT_TTH->isChecked());
	g_pConfig->SetEnableObsoleteExt( CheckBox_ENABLE_OBSOLETE_EXT->isChecked() );
	g_pConfig->SetThreadsForShellCommands(CheckBox_THREADS_FOR_SHELL_COMMANDS->isChecked());
	g_pConfig->SetShellCommandTimeout(SpinBox_SHELL_COMMAND_TIMEOUT->value());
	g_pConfig->SetOpenFoldersInRightPane(CheckBox_OPEN_FOLDERS_RIGHT_PANE->isChecked());
	g_pConfig->SetEnableUserCommand(CheckBox_ENABLE_USERCOMMAND_SUPPORT->isChecked());
	g_pConfig->SetUserCommandSubmenu(CheckBox_USER_COMMAND_SUBMENU->isChecked());
	
	switch ( ComboBox_CHAT_MAGNETS->currentIndex() )
	{
		case 0:
			g_pConfig->SetMagnetAction( eMagnetPrompt, eChatMagnet );
			break;
		case 1:
			g_pConfig->SetMagnetAction( eMagnetSearch, eChatMagnet );
			break;
		case 2:
			g_pConfig->SetMagnetAction( eMagnetNothing, eChatMagnet );
			break;
		default:
			break;
	}
}

/** */
void DCOptions::SaveSharedFolders()
{
	CList<DCConfigShareFolder> sharedfolders;
	DCConfigShareFolder * csf;

	// save shared folders
	sharedfolders.Clear();

	QTreeWidgetItemIterator it( TreeWidget_SHAREDFOLDERS );

	for ( ; (*it); ++it )
	{
		csf = new DCConfigShareFolder();
		csf->m_sPath  = (*it)->text(0).toAscii().constData();
		csf->m_sAlias = (*it)->text(1).toAscii().constData();
		sharedfolders.Add(csf);
	}

	g_pConfig->SetSharedFolders( &sharedfolders );
}

void DCOptions::SaveUserChatCommands()
{
	QList<DC_UserChatCommand*> commands;
	DC_UserChatCommand * ucc;
	
	QTreeWidgetItemIterator it( TreeWidget_CHAT_COMMANDS );
	
	for( ; (*it); ++it )
	{
		ucc = new DC_UserChatCommand();
		ucc->m_sName    = (*it)->text(0);
		ucc->m_sCommand = (*it)->text(1);
		
		commands.append(ucc);
	}
	
	/* transfer ownership to g_pConfig */
	g_pConfig->SetUserChatCommands( &commands );
}

void DCOptions::SaveAutoResponses()
{
	QList<DC_AutoResponseObject*> autoresponses;
	DC_AutoResponseObject * aro = 0;
	
	QTreeWidgetItemIterator it( TreeWidget_AUTO_RESPONSES );
	for ( ; (*it); ++it )
	{
		aro = new DC_AutoResponseObject();
		aro->m_sTrigger = (*it)->text(0);
		if ( (*it)->text(1) == tr("Yes") )
		{
			aro->m_bCaseSensitive = true;
		}
		else
		{
			aro->m_bCaseSensitive = false;
		}
		aro->m_sResponse = (*it)->text(2);
		
		autoresponses.append(aro);
	}
	
	/* transfer ownership to g_pConfig */
	g_pConfig->SetAutoResponses( &autoresponses );
}

/** */
void DCOptions::slotCreateShareList()
{
	/* need to save these settings for them to be used during the refresh */
	g_pConfig->SetDontShareDotFiles(CheckBox_DONTSHAREDOTFILES->isChecked());
	g_pConfig->SetDisableHashList(CheckBox_DISABLEHASHLIST->isChecked());
	
	SaveSharedFolders();

	if ( CFileManager::Instance() )
	{
		CFileManager::Instance()->CreateShareList();
	}
}

/** */
void DCOptions::slotShareListInfo()
{
	QString s = tr("Compressed list size (HE3/BZ/XML): ") +
		QString().setNum(CFileManager::Instance()->GetShareBufferSize(esbtHE3)) + "/" +
		QString().setNum(CFileManager::Instance()->GetShareBufferSize(esbtBZ)) + "/" +
		QString().setNum(CFileManager::Instance()->GetShareBufferSize(esbtXMLBZ)) + " " +
		tr("bytes") + "\n" +
		tr("Total shared: ") +
		DCGuiUtils::GetSizeString(CFileManager::Instance()->GetShareSize());
	
	QMessageBox::information( this, tr("Share List Info"), s );
}

/** */
void DCOptions::slotSetTheme()
{
	if ( g_pConfig->GetThemeSupport() )
	{
		QString s = ComboBox_THEME->currentText();

		if ( !s.isEmpty() )
		{
			QApplication::setStyle(s);
			m_sTestedTheme = s;
		}
	}
}

/** */
void DCOptions::slotBrowseLanguageFile()
{
	QString file = QFileDialog::getOpenFileName( this, tr("Select language file"), LineEdit_LANGUAGEFILE->text(), "Language File (*.qm)" );

	if ( !file.isEmpty() )
	{
		LineEdit_LANGUAGEFILE->setText(file);
	}
}

/** */
void DCOptions::slotSelectLanguage()
{
	QString s;

	QMenu * m = new QMenu(this);

	QAction * bosnian = DCMenuHandler::addAction( m, emiLANGUAGE_BOSNIAN );
	QAction * brazilian = DCMenuHandler::addAction( m, emiLANGUAGE_BRAZILIAN );
	QAction * czech = DCMenuHandler::addAction( m, emiLANGUAGE_CZECH );
	QAction * danish = DCMenuHandler::addAction( m, emiLANGUAGE_DANISH );
	QAction * dutch = DCMenuHandler::addAction( m, emiLANGUAGE_DUTCH );
	QAction * english = DCMenuHandler::addAction( m, emiLANGUAGE_ENGLISH );
	QAction * finnish = DCMenuHandler::addAction( m, emiLANGUAGE_FINNISH );
	QAction * french = DCMenuHandler::addAction( m, emiLANGUAGE_FRENCH );
	QAction * german = DCMenuHandler::addAction( m, emiLANGUAGE_GERMAN );
	QAction * greek = DCMenuHandler::addAction( m, emiLANGUAGE_GREEK );
	QAction * hungarian = DCMenuHandler::addAction( m, emiLANGUAGE_HUNGARIAN );
	QAction * icelandic = DCMenuHandler::addAction( m, emiLANGUAGE_ICELANDIC );
	QAction * italian = DCMenuHandler::addAction( m, emiLANGUAGE_ITALIAN );
	QAction * latvian = DCMenuHandler::addAction( m, emiLANGUAGE_LATVIAN );
	QAction * norwegian = DCMenuHandler::addAction( m, emiLANGUAGE_NORWEGIAN );
	QAction * polish = DCMenuHandler::addAction( m, emiLANGUAGE_POLISH );
	QAction * romanian = DCMenuHandler::addAction( m, emiLANGUAGE_ROMANIAN );
	QAction * russian = DCMenuHandler::addAction( m, emiLANGUAGE_RUSSIAN );
	QAction * serbian_cyrillic = DCMenuHandler::addAction( m, emiLANGUAGE_SERBIAN_CYRILLIC );
	QAction * serbian_latin = DCMenuHandler::addAction( m, emiLANGUAGE_SERBIAN_LATIN );
	QAction * slovakian = DCMenuHandler::addAction( m, emiLANGUAGE_SLOVAKIAN );
	QAction * spanish = DCMenuHandler::addAction( m, emiLANGUAGE_SPANISH );
	QAction * swedish = DCMenuHandler::addAction( m, emiLANGUAGE_SWEDISH );

	QAction * chosen = m->exec(QCursor::pos());

	delete m;

	if ( chosen == 0 )
		return;
	else if ( chosen == bosnian )
		s = "valknut.bs.qm";
	else if ( chosen == brazilian )
		s = "valknut.pt_br.qm";
	else if ( chosen == czech )
		s = "valknut.cs.qm";
	else if ( chosen == danish )
		s = "valknut.da.qm";
	else if ( chosen == dutch )
		s = "valknut.nl.qm";
	else if ( chosen == english )
		s = "";
	else if ( chosen == finnish )
		s = "valknut.fi.qm";
	else if ( chosen == french )
		s = "valknut.fr.qm";
	else if ( chosen == german )
		s = "valknut.de.qm";
	else if ( chosen == greek )
		s = "valknut.el.qm";
	else if ( chosen == hungarian )
		s = "valknut.hu.qm";
	else if ( chosen == icelandic )
		s = "valknut.is.qm";
	else if ( chosen == italian )
		s = "valknut.it.qm";
	else if ( chosen == latvian )
		s = "valknut.lv.qm";
	else if ( chosen == norwegian )
		s = "valknut.nb.qm";
	else if ( chosen == polish )
		s = "valknut.pl.qm";
	else if ( chosen == romanian )
		s = "valknut.ro.qm";
	else if ( chosen == russian )
		s = "valknut.rus.qm";
	else if ( chosen == serbian_cyrillic )
		s = "valknut.sr.qm";
	else if ( chosen == serbian_latin )
		s = "valknut.sr@latin.qm";
	else if ( chosen == slovakian )
		s = "valknut.sk.qm";
	else if ( chosen == spanish )
		s = "valknut.es.qm";
	else if ( chosen == swedish )
		s = "valknut.sv.qm";

	if ( !s.isEmpty() )
	{
		LineEdit_LANGUAGEFILE->setText(LineEdit_DATAFOLDER->text()+QString(DIRSEPARATOR)+QString("translation")+QString(DIRSEPARATOR)+s);
	}
	else if ( chosen == english )
	{
		LineEdit_LANGUAGEFILE->clear();
	}
}

/** */
void DCOptions::slotBrowseAppFont()
{
	bool ok;
	QFont font = QFontDialog::getFont(&ok, QApplication::font(), this);
	if ( ok )
	{
		LineEdit_APPFONT->setText(font.toString());
	}
}

/** */
void DCOptions::slotAddHubListUrl()
{
	bool ok = false;
	QString url = QInputDialog::getText(
		this,
		tr("HubList URL"),
		tr("Please enter a url"),
		QLineEdit::Normal,
		QString::null,
		&ok
	);

	if (ok)
	{
		QListWidgetItem * item = new QListWidgetItem( url, ListWidget_HUBLISTURL );
		item->setCheckState( Qt::Checked );
	}
}

/** */
void DCOptions::slotEditHubListUrl()
{
	editHubListUrl( ListWidget_HUBLISTURL->currentItem() );
}

/** */
void DCOptions::editHubListUrl( QListWidgetItem * item )
{
	if ( !item )
		return;

	bool ok = false;
	QString url = QInputDialog::getText(
		this,
		tr("HubList URL"),
		tr("Edit url"),
		QLineEdit::Normal,
		item->text(),
		&ok
	);

	if (ok)
	{
		item->setText(url);
	}
}

/** */
void DCOptions::slotRemoveHubListUrl()
{
	QListWidgetItem * item = ListWidget_HUBLISTURL->currentItem();

	if ( item )
	{
		delete item;
	}
}

/** */
void DCOptions::slotDoubleClickedHubListUrl( QListWidgetItem * item )
{
	if ( item ) // always true since signal is only emitted on valid items
	{
		editHubListUrl( item );
	}
	else
	{
		slotAddHubListUrl();
	}
}

/** */
void DCOptions::slotContextMenuHubListUrl( const QPoint & pos )
{
	QMenu * m = new QMenu(this);
	QListWidgetItem * item = ListWidget_HUBLISTURL->itemAt(pos);
	bool enabled = (item != 0);
	
	QAction * add = DCMenuHandler::addAction( m, emiADD );
	QAction * edit = DCMenuHandler::addAction( m, emiEDIT, enabled );
	QAction * remove = DCMenuHandler::addAction( m, emiREMOVE, enabled );
	
	QAction * chosen = m->exec(QCursor::pos());
	
	delete m;
	
	if ( chosen == 0 )
	{
		return;
	}
	else if ( chosen == add )
	{
		slotAddHubListUrl();
	}
	else if ( chosen == edit )
	{
		editHubListUrl( item );
	}
	else if ( chosen == remove )
	{
		delete item;
	}
}

/** */
void DCOptions::slotHubListUrlsSelectionChanged()
{
	if ( ListWidget_HUBLISTURL->selectedItems().size() == 1 )
	{
		ToolButton_EDITHUBLISTURL->setEnabled(true);
		ToolButton_REMOVEHUBLISTURL->setEnabled(true);
	}
	else
	{
		ToolButton_EDITHUBLISTURL->setEnabled(false);
		ToolButton_REMOVEHUBLISTURL->setEnabled(false);
	}
}

/** */
void DCOptions::slotTreeWidgetOptionTreeCurrentChanged( QTreeWidgetItem * item, QTreeWidgetItem * /* previous */ )
{
	if ( item == plviIdentify )
	{
		TabWidget_DCGUI->setCurrentIndex(0);
	}
	else if ( item == plviTransfer )
	{
		TabWidget_DCGUI->setCurrentIndex(1);
		TabWidget_TRANSFER->setCurrentIndex(0);
	}
	else if ( item == plviTransferShares )
	{
		TabWidget_DCGUI->setCurrentIndex(1);
		TabWidget_TRANSFER->setCurrentIndex(0);
	}
	else if ( item == plviTransferDownloads )
	{
		TabWidget_DCGUI->setCurrentIndex(1);
		TabWidget_TRANSFER->setCurrentIndex(1);
	}
	else if ( item == plviTransferUploads )
	{
		TabWidget_DCGUI->setCurrentIndex(1);
		TabWidget_TRANSFER->setCurrentIndex(2);
	}
	else if ( item == plviTransferSettings )
	{
		TabWidget_DCGUI->setCurrentIndex(1);
		TabWidget_TRANSFER->setCurrentIndex(3);
	}
	else if ( item == plviConnection )
	{
		TabWidget_DCGUI->setCurrentIndex(2);
		TabWidget_CONNECTION->setCurrentIndex(0);
	}
	else if ( item == plviConnectionMode )
	{
		TabWidget_DCGUI->setCurrentIndex(2);
		TabWidget_CONNECTION->setCurrentIndex(0);
	}
	else if ( item == plviConnectionSettings )
	{
		TabWidget_DCGUI->setCurrentIndex(2);
		TabWidget_CONNECTION->setCurrentIndex(1);
	}
	else if ( item == plviGUI )
	{
		TabWidget_DCGUI->setCurrentIndex(3);
		TabWidget_GUI->setCurrentIndex(0);
	}
	else if ( item == plviGUIUser )
	{
		TabWidget_DCGUI->setCurrentIndex(3);
		TabWidget_GUI->setCurrentIndex(5);
	}
	else if ( item == plviGUIMenus )
	{
		TabWidget_DCGUI->setCurrentIndex(3);
		TabWidget_GUI->setCurrentIndex(4);
	}
	else if ( item == plviGUIChat )
	{
		TabWidget_DCGUI->setCurrentIndex(3);
		TabWidget_GUI->setCurrentIndex(2);
	}
	else if (item == plviGUICommands )
	{
		TabWidget_DCGUI->setCurrentIndex(3);
		TabWidget_GUI->setCurrentIndex(3);
	}
	else if ( item == plviGUITransfer )
	{
		TabWidget_DCGUI->setCurrentIndex(3);
		TabWidget_GUI->setCurrentIndex(1);
	}
	else if ( item == plviGUIGeneral )
	{
		TabWidget_DCGUI->setCurrentIndex(3);
		TabWidget_GUI->setCurrentIndex(0);
	}
	else if ( item == plviGUIIcons )
	{
		TabWidget_DCGUI->setCurrentIndex(3);
		TabWidget_GUI->setCurrentIndex(6);
	}
	else if ( item == plviGUIFilelistBrowser )
	{
		TabWidget_DCGUI->setCurrentIndex(3);
		TabWidget_GUI->setCurrentIndex(7);
	}
	else if ( item == plviSound )
	{
		TabWidget_DCGUI->setCurrentIndex(4);
	}
	else if ( item == plviLog )
	{
		TabWidget_DCGUI->setCurrentIndex(5);
	}
	else if ( item == plviHubLists )
	{
		TabWidget_DCGUI->setCurrentIndex(6);
	}
	else if ( item == plviSecurity )
	{
		TabWidget_DCGUI->setCurrentIndex(7);
	}
	else if ( item == plviAutoResponse )
	{
		TabWidget_DCGUI->setCurrentIndex(8);
	}
	else if ( item == plviOther )
	{
		TabWidget_DCGUI->setCurrentIndex(9);
	}
}

/** */
void DCOptions::slotTabWidgetDCGUICurrentChanged( int index )
{
	disconnectOptionsTreeWidget();
	
	switch ( index )
	{
		case 0:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviIdentify);
			break;
		}
		case 1:
		{
			slotTabWidgetTransferCurrentChanged( TabWidget_TRANSFER->currentIndex() );
			break;
		}
		case 2:
		{
			slotTabWidgetConnectionCurrentChanged( TabWidget_CONNECTION->currentIndex() );
			break;
		}
		case 3:
		{
			slotTabWidgetGUICurrentChanged( TabWidget_GUI->currentIndex() );
			break;
		}
		case 4:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviSound);
			break;
		}
		case 5:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviLog);
			break;
		}
		case 6:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviHubLists);
			break;
		}
		case 7:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviSecurity);
			break;
		}
		case 8:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviAutoResponse);
			break;
		}
		case 9:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviOther);
			break;
		}
		default:
		{
			break;
		}
	}
	
	connectOptionsTreeWidget();
}

/** */
void DCOptions::slotTabWidgetTransferCurrentChanged( int index )
{
	disconnectOptionsTreeWidget();
	
	switch ( index )
	{
		case 0:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviTransferShares);
			break;
		}
		case 1:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviTransferDownloads);
			break;
		}
		case 2:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviTransferUploads);
			break;
		}
		case 3:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviTransferSettings);
			break;
		}
		default:
		{
			break;
		}
	}
	
	connectOptionsTreeWidget();
}

/** */
void DCOptions::slotTabWidgetConnectionCurrentChanged( int index )
{
	disconnectOptionsTreeWidget();
	
	switch ( index )
	{
		case 0:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviConnectionMode);
			break;
		}
		case 1:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviConnectionSettings);
			break;
		}
		default:
		{
			break;
		}
	}
	
	connectOptionsTreeWidget();
}

/** */
void DCOptions::slotTabWidgetGUICurrentChanged( int index )
{
	disconnectOptionsTreeWidget();
	
	switch ( index )
	{
		case 0:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviGUIGeneral);
			break;
		}
		case 1:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviGUITransfer);
			break;
		}
		case 2:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviGUIChat);
			break;
		}
		case 3:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviGUICommands);
			break;
		}
		case 4:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviGUIMenus);
			break;
		}
		case 5:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviGUIUser);
			break;
		}
		case 6:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviGUIIcons);
			break;
		}
		case 7:
		{
			TreeWidget_OPTIONTREE->setCurrentItem(plviGUIFilelistBrowser);
			break;
		}
		default:
		{
			break;
		}
	}
	
	connectOptionsTreeWidget();
}

/** */
void DCOptions::slotAddUserMenuCommand()
{
	DCUserCommandEditor * editor = new DCUserCommandEditor(this);
	
	if ( editor->exec() == QDialog::Accepted )
	{
		DC_UserMenuCommand * umc = editor->GetUMC();
		usercommands[usercommands.size()] = umc;
		
		QTreeWidgetItem * item = new QTreeWidgetItem( TreeWidget_MENU_COMMANDS );
		item->setText( 0, umc->m_sName );
		item->setText( 1, umc->m_sCommand );
	}
	
	delete editor;
}

/** */
void DCOptions::slotEditUserMenuCommand()
{
	QTreeWidgetItem * item = TreeWidget_MENU_COMMANDS->currentItem();
	
	if ( item == 0 )
	{
		return;
	}
	
	QModelIndex index = TreeWidget_MENU_COMMANDS->selectionModel()->currentIndex();
	
	if ( !index.isValid() )
	{
		return;
	}
	
	const int key = index.row();
	
	DC_UserMenuCommand * umc = usercommands.value(key);
	
	if ( !umc )
	{
		return;
	}
	
	DCUserCommandEditor * editor = new DCUserCommandEditor(this);
	editor->SetUMC(umc);
	
	if ( editor->exec() == QDialog::Accepted )
	{
		usercommands.remove(key);
		
		delete umc;
		
		umc = editor->GetUMC();
				
		usercommands[ key ] = umc;
		
		item->setText( 0, umc->m_sName );
		item->setText( 1, umc->m_sCommand );
	}
	
	delete editor;
}

/** */
void DCOptions::slotRemoveUserMenuCommand()
{
	QTreeWidgetItem * item = TreeWidget_MENU_COMMANDS->currentItem();
	
	if ( item == 0 )
	{
		return;
	}
	
	QModelIndex index = TreeWidget_MENU_COMMANDS->selectionModel()->currentIndex();
	
	if ( !index.isValid() )
	{
		return;
	}
	
	int ret = QMessageBox::question(
			this,
			tr("Delete menu command?"),
			tr("Delete \"") + item->text(0) + QString("\"?"),
			QMessageBox::Yes | QMessageBox::No,
			QMessageBox::No
	);
	
	if ( ret == QMessageBox::Yes )
	{
		delete usercommands.take( index.row() );
		
		delete item;
		
		// fix numbering
		QList<DC_UserMenuCommand*> remaining = usercommands.values();
		usercommands.clear();
		for ( int i = 0; i < remaining.size(); i++ )
		{
			usercommands[i] = remaining[i];
		}
	}
}

/** */
void DCOptions::slotUpUserMenuCommand()
{
	QModelIndex index = TreeWidget_MENU_COMMANDS->selectionModel()->currentIndex();
	
	if ( !index.isValid() )
	{
		return;
	}
	
	int row = index.row();
	
	if ( row == 0 )
	{
		return;
	}
	
	if ( !usercommands.contains(row) || !usercommands.contains(row-1) )
	{
		return;
	}
	
	DC_UserMenuCommand * umc1 = usercommands.take( row );
	DC_UserMenuCommand * umc2 = usercommands.take( row - 1 );
	
	usercommands[ row - 1 ] = umc1;
	usercommands[ row ]     = umc2;
	
	QTreeWidgetItem * item1 = TreeWidget_MENU_COMMANDS->takeTopLevelItem( row );
		
	TreeWidget_MENU_COMMANDS->insertTopLevelItem( row - 1, item1 );
	TreeWidget_MENU_COMMANDS->setCurrentItem(item1);
}

/** */
void DCOptions::slotDownUserMenuCommand()
{
	QModelIndex index = TreeWidget_MENU_COMMANDS->selectionModel()->currentIndex();
	
	if ( !index.isValid() )
	{
		return;
	}
	
	int row = index.row();
	
	if ( row == TreeWidget_MENU_COMMANDS->topLevelItemCount() - 1 )
	{
		return;
	}
	
	if ( !usercommands.contains(row) || !usercommands.contains(row+1) )
	{
		return;
	}
	
	DC_UserMenuCommand * umc1 = usercommands.take( row );
	DC_UserMenuCommand * umc2 = usercommands.take( row + 1 );
	
	usercommands[ row + 1 ] = umc1;
	usercommands[ row ] = umc2;
	
	QTreeWidgetItem * item1 = TreeWidget_MENU_COMMANDS->takeTopLevelItem( row );
	
	TreeWidget_MENU_COMMANDS->insertTopLevelItem( row + 1, item1 );
	TreeWidget_MENU_COMMANDS->setCurrentItem(item1);
}

/** */
void DCOptions::slotUserMenuCommandsSelectionChanged()
{
	QList<QTreeWidgetItem*> selecteditems = TreeWidget_MENU_COMMANDS->selectedItems();
	if ( selecteditems.size() != 1 )
	{
		ToolButton_EDIT_USER_MENU_COMMAND->setEnabled(false);
		ToolButton_REMOVE_USER_MENU_COMMAND->setEnabled(false);
		ToolButton_UP_USER_MENU_COMMAND->setEnabled(false);
		ToolButton_DOWN_USER_MENU_COMMAND->setEnabled(false);
	}
	else
	{
		QTreeWidgetItem * selected = selecteditems.first();
		
		ToolButton_EDIT_USER_MENU_COMMAND->setEnabled(true);
		ToolButton_REMOVE_USER_MENU_COMMAND->setEnabled(true);
		
		int row = TreeWidget_MENU_COMMANDS->indexOfTopLevelItem(selected);
		
		if ( row == 0 )
		{
			ToolButton_UP_USER_MENU_COMMAND->setEnabled(false);
		}
		else
		{
			ToolButton_UP_USER_MENU_COMMAND->setEnabled(true);
		}
		
		if ( row == TreeWidget_MENU_COMMANDS->topLevelItemCount() - 1 )
		{
			ToolButton_DOWN_USER_MENU_COMMAND->setEnabled(false);
		}
		else
		{
			ToolButton_DOWN_USER_MENU_COMMAND->setEnabled(true);
		}
	}
}

/** */
void DCOptions::slotUserMenuCommandsDoubleClicked( QTreeWidgetItem * item, int /* column */ )
{
	if ( item )
	{
		TreeWidget_MENU_COMMANDS->setCurrentItem(item);
		slotEditUserMenuCommand();
	}
	else
	{
		slotAddUserMenuCommand();
	}
}

/** */
void DCOptions::slotContextMenuUserChatCommands( const QPoint & pos )
{
	QTreeWidgetItem * item = TreeWidget_CHAT_COMMANDS->itemAt(pos);
	bool enabled = (item != 0);
	
	QMenu * m = new QMenu(this);
	
	QAction * add = DCMenuHandler::addAction( m, emiADD );
	QAction * edit = DCMenuHandler::addAction( m, emiEDIT, enabled );
	QAction * remove = DCMenuHandler::addAction( m, emiREMOVE, enabled );
	
	QAction * chosen = m->exec(QCursor::pos());
	
	delete m;
	
	if ( chosen == 0 )
	{
		return;
	}
	else if ( chosen == add )
	{
		QTreeWidgetItem * newitem = new QTreeWidgetItem( TreeWidget_CHAT_COMMANDS );
		newitem->setText( 0, "/s" );
		newitem->setText( 1, "/sh somescript.sh" );
		newitem->setFlags( newitem->flags() | Qt::ItemIsEditable );
	}
	else if ( chosen == remove )
	{
		delete item;
	}
	else if ( chosen == edit )
	{
		TreeWidget_CHAT_COMMANDS->editItem(
			item,
			TreeWidget_CHAT_COMMANDS->columnAt( pos.x() )
		);
	}
}

/** */
void DCOptions::slotContextMenuAutoResponses( const QPoint & pos )
{
	QTreeWidgetItem * item = TreeWidget_AUTO_RESPONSES->itemAt(pos);
	bool enabled = (item != 0);
	
	QMenu * m = new QMenu(this);
	
	QAction * add = DCMenuHandler::addAction( m, emiADD );
	QAction * edit = DCMenuHandler::addAction( m, emiEDIT, enabled );
	QAction * remove = DCMenuHandler::addAction( m, emiREMOVE, enabled );
	QAction * cs_yes = m->addAction(tr("Case sensitive"));
	cs_yes->setEnabled(enabled);
	QAction * cs_no = m->addAction(tr("Case insensitive"));
	cs_no->setEnabled(enabled);
	
	QAction * chosen = m->exec(QCursor::pos());
	
	delete m;
	
	if ( chosen == 0)
	{
		return;
	}
	else if ( chosen == add )
	{
		QTreeWidgetItem * newitem = new QTreeWidgetItem( TreeWidget_AUTO_RESPONSES );
		newitem->setText( 0, tr("-trigger") );
		newitem->setText( 1, tr("No") );
		newitem->setText( 2, tr("response") );
		newitem->setFlags( newitem->flags() | Qt::ItemIsEditable );
	}
	else if ( chosen == edit )
	{
		int column = TreeWidget_AUTO_RESPONSES->columnAt( pos.x() );
		if ( (column == 0) || (column == 2) )
		{
			TreeWidget_AUTO_RESPONSES->editItem(
				item,
				column
			);
		}
	}
	else if ( chosen == remove )
	{
		delete item;
	}
	else if ( chosen == cs_yes )
	{
		item->setText(1, tr("Yes"));
	}
	else if ( chosen == cs_no )
	{
		item->setText(1, tr("No"));
	}
}

/** */
void DCOptions::setupIconThemeComboBoxes()
{
	ComboBox_APPLICATION_ICONS->clear();
	ComboBox_USERLIST_ICONS->clear();
	ComboBox_EMOTICONS->clear();
	
	setupIconThemeComboBox( ComboBox_APPLICATION_ICONS, "appl" );
	setupIconThemeComboBox( ComboBox_USERLIST_ICONS, "user" );
	setupIconThemeComboBox( ComboBox_EMOTICONS, "emot" );
}

/** */
void DCOptions::setupIconThemeComboBox( QComboBox * box, QString icontype )
{
	QDir dir;
	dir.setPath( g_pConfig->GetValknutDataPath() + "/icons/" + icontype + "/" );
	dir.setFilter( QDir::Dirs | QDir::Readable | QDir::Executable );
	dir.setSorting( QDir::Name );
	
	const QFileInfoList iconslist = dir.entryInfoList();
	if ( iconslist.size() > 0 )
	{
		for (int i = 0; i < iconslist.size(); ++i)
		{
			QFileInfo fi = iconslist.at(i);
			
			if ( (fi.fileName() == ".") || (fi.fileName() == "..") )
			{
				// skip
			}
			else
			{
				box->addItem(fi.fileName());
			}
		}
	}
}

/** */
void DCOptions::slotGenerateKeyCert()
{
	QProcess * proc1 = 0;
	QProcess * proc2 = 0;
	QStringList args1;
	QStringList args2;
	QString keyname = LineEdit_TRANSFERKEY->text();
	QString certname = LineEdit_TRANSFERCERT->text();
	QFile key;
	QFile cert;
	QDir keypath;
	QDir certpath;
	
	PushButton_GENERATE_CERT->setEnabled(false);
	
	if ( keyname.isEmpty() )
	{
		keyname = QString(g_pConfig->GetConfigPath().Data()) + QString("/ssl/valknut.key");
	}
	
	if ( certname.isEmpty() )
	{
		certname = QString(g_pConfig->GetConfigPath().Data()) + QString("/ssl/valknut.cert");
	}
	
	keyname.replace("//", "/");
	certname.replace("//", "/");
	
	key.setFileName(keyname);
	cert.setFileName(certname);
	
	if ( key.exists() || cert.exists() )
	{
		int ret = QMessageBox::question(
			this,
			tr("Overwrite?"),
			tr("Replace existing key/cert?"),
			QMessageBox::Yes | QMessageBox::No,
			QMessageBox::No
		);
		
		if ( ret == QMessageBox::No )
		{
			PushButton_GENERATE_CERT->setEnabled(true);
			return;
		}
	}
	
	keypath.setPath(QFileInfo(keyname).path());
	certpath.setPath(QFileInfo(certname).path());
	
	if ( keypath.isRelative() )
	{
		keyname.prepend(QDir::separator());
		keyname.prepend(QDir::currentPath());
		keypath.setPath(QFileInfo(keyname).absolutePath());
	}
	
	if ( certpath.isRelative() )
	{
		certname.prepend(QDir::separator());
		certname.prepend(QDir::currentPath());
		certpath.setPath(QFileInfo(certname).absolutePath());
	}
	
	if (keypath.exists() == false)
	{
		if ( keypath.mkdir(keypath.path()) == false )
		{
			QMessageBox::critical(
				this,
				tr("Could not create folder for key"),
				tr("Could not create ") + keypath.path()
			);
			PushButton_GENERATE_CERT->setEnabled(true);
			return;
		}
	}
	
	if (certpath.exists() == false)
	{
		if ( certpath.mkdir(certpath.path()) == false )
		{
			QMessageBox::critical(
				this,
				tr("Could not create folder for cert"),
				tr("Could not create ") + certpath.path()
			);
			PushButton_GENERATE_CERT->setEnabled(true);
			return;
		}
	}
	
	proc1 = new QProcess();
	proc1->setWorkingDirectory(keypath.path());
	
	args1 << "genrsa";
	args1 << "-out";
	args1 << keyname;
	args1 << "2048";
	
	proc1->start( "openssl", args1 );
	proc1->waitForFinished( 5000 );

	if ( proc1->state() != QProcess::NotRunning )
	{
		proc1->terminate();
		proc1->waitForFinished( 1000 );
		if ( proc1->state() != QProcess::NotRunning )
		{
			proc1->kill();
		}
	}
	
	if ( (proc1->exitStatus() == QProcess::CrashExit) || (proc1->exitCode() != 0) )
	{
		QMessageBox::critical(
			this,
			tr("Error occurred while running openssl 1"),
			QString(proc1->readAllStandardError()) + "\n\n" + tr("Make sure the openssl program is in your PATH.")
		);
		delete proc1;
		PushButton_GENERATE_CERT->setEnabled(true);
		return;
	}
	
	delete proc1;
	
	proc2 = new QProcess(this);
	proc2->setWorkingDirectory(certpath.path());
	
	args2 << "req";
	args2 << "-x509";
	args2 << "-new";
	args2 << "-batch";
	args2 << "-days";
	args2 << "3650";
	args2 << "-key";
	args2 << keyname;
	args2 << "-out";
	args2 << certname;
	args2 << "-subj";
	args2 << QString("/CN=Valknut-") + LineEdit_NICK->text();
	
	proc2->start( "openssl", args2 );
	proc2->waitForFinished( 5000 );
	
	if ( proc2->state() != QProcess::NotRunning )
	{
		proc2->terminate();
		proc2->waitForFinished( 1000 );
		if ( proc2->state() != QProcess::NotRunning )
		{
			proc2->kill();
		}
	}
	
	if ( (proc2->exitStatus() == QProcess::CrashExit) || (proc2->exitCode() != 0) )
	{
		QMessageBox::critical(
			this,
			tr("Error occurred while running openssl 2"),
			QString(proc2->readAllStandardError()) + "\n\n" + tr("Make sure the openssl program is in your PATH.")
		);
		delete proc2;
		PushButton_GENERATE_CERT->setEnabled(true);
		return;
	}
	
	delete proc2;
	
	LineEdit_TRANSFERKEY->setText(keyname);
	LineEdit_TRANSFERCERT->setText(certname);
	
	// set them even if dialog is cancelled since files have been created
	g_pConfig->SetTransferKey(keyname.toAscii().constData());
	g_pConfig->SetTransferCert(certname.toAscii().constData());
	
	PushButton_GENERATE_CERT->setEnabled(true);
}

/** */
void DCOptions::slotCustomBrowserChecked()
{
	if ( CheckBox_CUSTOM_BROWSER->isChecked() )
	{
		LineEdit_BROWSER->setEnabled(true);
		ToolButton_BROWSEBROWSER->setEnabled(true);
	}
	else
	{
		LineEdit_BROWSER->setEnabled(false);
		ToolButton_BROWSEBROWSER->setEnabled(false);
	}
}
