#!/bin/sh

function config() {
	NEW="$1"
	OLD="`dirname $NEW`/`basename $NEW .new`"

	# If there's no config file by that name, mv it over:
	if [ ! -r $OLD ]; then
		echo "--- Renaming $NEW to $OLD"
		mv $NEW $OLD
	elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then
		# toss the redundant copy
		echo "--- Deleting $NEW"
		rm $NEW
	else
		# Otherwise, we leave the .new copy for the admin to consider...
		echo "--- Leaving $NEW for you to replace $OLD"
	fi
	

}

FILE="/etc/xl2tpd/l2tp-secrets.new \
    /etc/xl2tpd/l2tpd.conf.new"
    
for f in $FILE ; do
    if [ -f $f ]; then
        config $f
    fi
done

echo -e "\n"
echo -e "           \|||/          "
echo -e "           (o o)          "
echo -e "--------ooO-(_)-Ooo-------"
echo -e " by Diego @ www.slacky.eu "
echo -e "\n"
