/***************************************************************************
*   Copyright (C) 2005 by Alexander Nemish  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#ifndef BOOKMARKSDLG_H
#define BOOKMARKSDLG_H

#include <qvariant.h>
#include <qdialog.h>
#include "bookmark.h"

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QTable;
class QPushButton;

class BookmarksDlg : public QDialog
{
	Q_OBJECT

public:
	BookmarksDlg(const Bookmarks& bms, QWidget* parent = 0,
	             const char* name = 0, bool modal = FALSE, WFlags fl = 0);
	~BookmarksDlg();

	const Bookmarks& bookmarks() const { return m_bookmarks; }

	QTable* bookmarksTable;
	QPushButton* addButton;
	QPushButton* deleteButton;
	QPushButton* buttonHelp;
	QPushButton* buttonOk;
	QPushButton* buttonCancel;

protected:
	QVBoxLayout* BookmarksDlgLayout;
	QHBoxLayout* layout3;
	QVBoxLayout* layout2;
	QSpacerItem* Horizontal_Spacing2_2;
	QHBoxLayout* Layout1;
	QSpacerItem* Horizontal_Spacing2;

protected slots:
	virtual void languageChange();
	void addBookmark();
	void deleteBookmark();
	void valueChanged(int row, int col);
	void updateBookmarks();
private:
	Bookmarks m_bookmarks;
};

#endif // BOOKMARKSDLG_H
