/***************************************************************************
 *   Copyright (C) 2005 by Alexandr Nemish   *
 *   atlanter@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _BOOKREADER_H_
#define _BOOKREADER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>
#include "bookwidget.h"


class KPrinter;
class KURL;
class KRecentFilesAction;
class KToggleFullScreenAction;
class KSplashScreen;

/**
 * This class serves as the main window for BookReader.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Alexandr Nemish <atlanter@gmail.com>
 */
class BookReader : public KMainWindow
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    BookReader();

    /**
     * Default Destructor
     */
    virtual ~BookReader();

    /**
     * Use this method to load whatever file/URL you have
     */
    void load(const KURL& url);
	void loadLastUrl();
    void updateBookmarks();

protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */
    virtual void dragEnterEvent(QDragEnterEvent *event);
    virtual void dropEvent(QDropEvent *event);
	virtual bool queryExit();

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    void saveProperties(KConfig *);

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    void readProperties(KConfig *);


private slots:
	void fileOpen();
	void fileSave();
	void fileSaveAs();
	void filePrint();
	void optionsPreferences();
	void slotURLSelected(const KURL &);
	void fullScreen();
	void changeStatusbar(const QString& text);
	void changeCaption(const QString& text);
	void loadSettings();
	void loaded(int);
	void gotoFirstPage();
	void nextPage();
	void prevPage();
	void gotoLastPage();
	void gotoPage();
	void loadLastURLSetPage();
	void addBookmark();
	void gotoBookmark(int index);
	void editBookmarks();
private:
	void setupAccel();
	void setupActions();
	void readSettings();
	void writeSettings();
private:
	BookWidget * m_view;
	//Actions
	KRecentFilesAction * recentFilesAction;
	KToggleFullScreenAction * m_fullScreenAction;
	QPtrList<KAction> m_bookmarkActions;
	KURL lastURL;
	KSplashScreen * m_splash;
	KPrinter * m_printer;
};

#endif // _BOOKREADER_H_

