/***************************************************************************
*   Copyright (C) 2005 by Alexander Nemish  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef BOOKWIDGET_H
#define BOOKWIDGET_H

#include <qwidget.h>
#include <qevent.h>
#include <qpixmap.h>
#include <qthread.h>
#include <qtimer.h>
#include <qfile.h>
#include <kurl.h>
#include "renderer.h"
#include "bookmark.h"

class QStringList;
class QRect;
class KProgressDialog;


/**
 */
class BookWidget : public QWidget
{
	Q_OBJECT
public:
	
	
	BookWidget(QWidget *parent = 0, const char *name = 0);
	~BookWidget();

	virtual void openURL(const KURL & url);
	virtual QString currentURL();
	void paintEvent (QPaintEvent *);
	void setFont( const QFont & );
	void setParaOffset(int offset);
	void setCurrentPage(int number);
	int  currentPage() const { return m_currentPage; };
	int  pageCount() const { return m_renderer->pageCount(); }
	void nextPage();
	void prevPage();
	void firstPage();
	void lastPage();
	QSize minimumSizeHint () const;
	void setupPageSize();
	void setEncoding(int);
	void setEncoding(const QString & a_encoding);
	void setEncodings(const QStringList & a_encodings);
	QString encoding() const { return m_encodings[m_encoding]; }
	//const TextThread * thread() const {return m_thread;}
	void addBookmark(const QString& name);
	void saveBookmarks();
	void loadBookmarks();
	void setBookmarks(const Bookmarks& bms);
	const Bookmarks & bookmarks() const { return m_bookmarks; }
signals:
	/**
	 * Use this signal to change the content of the statusbar
	 */
	void signalChangeStatusbar(const QString& text);

	/**
	 * Use this signal to change the content of the caption
	 */
	void signalChangeCaption(const QString& text);

	void loaded(int);
	void loadingFinished();
protected:
	const QRect rectLeftPage() const;
	const QRect rectRightPage() const;
	void mousePressEvent(QMouseEvent *);
	void keyPressEvent (QKeyEvent * e);
	void resizeEvent (QResizeEvent * e);
	void wheelEvent (QWheelEvent * e);
	void clearAll();
	void drawContent(QPainter& paint);
	void drawPageNumbers(QPainter& paint);
	void drawBookmark(QPainter& paint, Bookmark const& bm);
	bool modified() const { return m_modified; };

private slots:
	void loadLine();
	void cancelLoading();
	void renderingFinished();
	
private:
	KURL	m_url;
	bool m_modified;
	QPixmap m_cachePixmap;
	int m_currentPage;
	int m_left_margin;
	int m_right_margin;
	int m_top_margin;
	int m_bottom_margin;
	int m_middle_margin;
	QFile m_file;
	QTimer m_timer;
	QStringList m_encodings;
	int m_encoding;
	std::auto_ptr<Renderer> m_renderer;
	std::auto_ptr<QTextStream> m_stream;
	std::auto_ptr<QStringList> m_textLines;
	std::auto_ptr<KProgressDialog> m_progressDlg;
	Bookmarks m_bookmarks;
};

#endif
