/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef BOOKMARKPLUGIN_H
#define BOOKMARKPLUGIN_H

#include <QMenu>

class QFileSystemWatcher;


class bookmarkPlugin : public QMenu
{

    Q_OBJECT

public:
    bookmarkPlugin(QWidget* parent = 0);
    ~bookmarkPlugin();


signals:
    void editBookmarks();
    void openFile(const QString& fn);


private:
    QFileSystemWatcher* fsw;
    QString bookmark_file;
    QString iconProvider(const QString& fn, const QString& iconFile);


private slots:
    void actionTriggered();
    void init();
    void parseBookmarks();

};

#endif
