/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#include "c2b.h"

#include "c2bConfigure.h"


/**
    Global resources for the cb2Bib
*/
c2b::c2b(QWidget* main, QObject* parent) : QObject(parent)
{
    Q_ASSERT_X(!c2b_single_instance, "c2b", "cb2Bib resources already instantiated");
    c2b::c2b_single_instance = this;
    c2b_main = main;

    // Creating Bibliographic Parser
    c2b_bibparser = new c2bBibParser(this);

    // Creating cb2Bib network
    c2b_network = new c2bNetwork(main, this);

    // Creating cb2Bib network query info
    c2b_netqinf = new c2bNetworkQueryInfo(c2b_bibparser, this);

    // Creating cb2Bib metadata parser
    c2b_metapreparser = new c2bMetaPreparser(this);
}

c2b::~c2b()
{}


c2b* c2b::c2b_single_instance = 0;

void c2b::Configure()
{
    c2bConfigure* configure = new c2bConfigure();
    if (configure->exec() == QDialog::Accepted)
        showMessage(tr("Configuration Saved."));
    else
        showMessage(tr("Configure Cancelled."));
    delete configure;
}
