/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2B_H
#define C2B_H

#include "c2bBibParser.h"
#include "c2bMetaPreparser.h"
#include "c2bNetwork.h"
#include "c2bNetworkQueryInfo.h"

#include <QObject>

class QWidget;


class c2b : public QObject
{

    Q_OBJECT

public:
    c2b(QWidget* main, QObject* parent = 0);
    ~c2b();

    // Actions
    inline static void displayHelp(const QString& url)
    {
        network()->openFile(url);
    }

    inline static void openFile(const QString& fn)
    {
        network()->openFile(fn);
    }

    inline static const QString fileMetadata(const QString& fn)
    {
        return metaPreparser()->metadata(fn);
    }

    inline static const QString encodeLink(const QString& ln)
    {
        return netqinf()->encodeLink(ln);
    }

    inline static void showMessage(const QString& message)
    {
        instance()->emitMessage(message);
    }

    inline static void doSearchInFiles(const QString& string, const QString& fn)
    {
        instance()->emitSearchInFiles(string, fn);
    }

    // Pointers
    inline static c2b* instance()
    {
        Q_ASSERT_X(c2b_single_instance, "c2b", "cb2Bib resources were not instantiated");
        return c2b_single_instance;
    }

    inline static QWidget* mainWidget()
    {
        return instance()->c2b_main;
    }

    inline static c2bNetwork* network()
    {
        return instance()->c2b_network;
    }

    inline static c2bNetworkQueryInfo* netqinf()
    {
        return instance()->c2b_netqinf;
    }

    inline static c2bBibParser* bibParser()
    {
        return instance()->c2b_bibparser;
    }

    inline static c2bMetaPreparser* metaPreparser()
    {
        return instance()->c2b_metapreparser;
    }


public slots:
    static void Configure();


signals:
    void searchInFiles(const QString& string, const QString& fn);
    void statusMessage(const QString& message);


private:
    QWidget* c2b_main;
    c2bBibParser* c2b_bibparser;
    c2bMetaPreparser* c2b_metapreparser;
    c2bNetwork* c2b_network;
    c2bNetworkQueryInfo* c2b_netqinf;
    static c2b* c2b_single_instance;

    inline void emitMessage(const QString& message)
    {
        emit statusMessage(message);
    }

    inline void emitSearchInFiles(const QString& string, const QString& fn)
    {
        emit searchInFiles(string, fn);
    }

};

#endif
