/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 *
 *   Class implementation of the approximate search algorithm
 *   P. Constans. Approximate textual retrieval. arXiv:0705.0751v1, 2007.
 ***************************************************************************/
#ifndef C2BAPPROXIMATEPATTERN_H
#define C2BAPPROXIMATEPATTERN_H

#include "compositePattern.h"


class c2bApproximatePattern : public compositePattern
{

public:
    c2bApproximatePattern(const QString newPattern, Qt::CaseSensitivity newCs);
    ~c2bApproximatePattern();


private:
    QList<int> ppEnds;
    QList<int> ppStarts;
    QStringList patternPieces;
    QStringList pre;
    QStringList suf;
    const QString wordPattern(const QString& word, Qt::CaseSensitivity cs);
    const QStringList splitWord(const QString& word);
    int stretch(int piece_i, int piece_j);
    int wordCount(const QString& str);
    void setPattern();
    void splitPattern();
    void splitPattern(const QString& p, QStringList* w, QList<int>* ws, QList<int>* we) const;

};

#endif
