/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BBIBPARSER_H
#define C2BBIBPARSER_H

#include "bibParser.h"

#include "c2bLineEdit.h"
#include "journalDB.h"


class QComboBox;
class QWidget;
class c2bBibPreparser;
class c2bCiteIDMaker;
class c2bClipEdit;
class c2bHeuristicBibParser;
class c2bPreprocess;
class c2bSettings;
class journalDB;


/**
    cb2Bib interface to bibParser

    This class groups Bib Parser functionality related to GUI

    @author Pere Constans
*/
class c2bBibParser : public bibParser
{

    Q_OBJECT

public:
    c2bBibParser(QObject* parent = 0);
    ~c2bBibParser();

    QHash<QString, c2bLineEdit*> bibFields;
    QString c2bAutoRecogStr;
    QString excerpt(const QString& text, const QStringList& hints);
    QString makeBib(bool sig = true);
    QString makeBib(const bibReference& ref);
    QString parse(const QString& field, QString value);
    QString setJournalsToAbbreviated(const QString& text);
    QString setJournalsToFull(const QString& text);
    const bibReference currentReference() const;
    void clearFields();
    void connectBibWidgets(QHash<QString, c2bLineEdit*>& fields, QComboBox* types, c2bClipEdit* editor);
    void guessFields(const QString& tagged_text);
    void parse(QString text);
    void preparse(const QString& text);

    const journalDB& journals() const
    {
        return *jDB;
    }

    QString abbreviatedJournal(const QString& j) const
    {
        return jDB->retrieve(j);
    }

    QString fullJournal(const QString& j) const
    {
        return jDB->retrieveFull(j);
    }

    inline bool isAutoRecognized()
    {
        return auto_recognized;
    }


signals:
    void bibModified();
    void preparserDataAvailable(const QString& ppItem);


public slots:
    void setJournal();


private:
    QComboBox* bibTypes;
    QWidget* c2bMain;
    bool auto_recognized;
    c2bBibPreparser* prParser;
    c2bCiteIDMaker* citeIDM;
    c2bClipEdit* clipEditor;
    c2bHeuristicBibParser* heuristicParser;
    c2bPreprocess* prProc;
    c2bSettings* settings;
    const QString removeTags(const QString& text) const;
    const QString setTags(const QString& text) const;
    int countFields();
    journalDB* jDB;
    void setRefType(QString);

};

#endif
