/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#include "c2bBibPreparser.h"

#include "c2b.h"
#include "c2bBibPreparserLog.h"
#include "c2bSettings.h"
#include "c2bUtils.h"

#include <QDir>
#include <QMessageBox>
#include <QProcess>
#include <QTextStream>



c2bBibPreparser::c2bBibPreparser(QObject* parent) : QObject(parent)
{
    settings = c2bSettingsP;
    c2bMain = c2b::mainWidget();
    viewLog = new c2bBibPreparserLog(c2bMain);
    m_inp_file = settings->tmp_dir_path + "cb2bib_clipborad_inp.tmp";
    m_out_file = settings->tmp_dir_path + "cb2bib_clipborad_out.tmp";
}

c2bBibPreparser::~c2bBibPreparser()
{}


void c2bBibPreparser::preparse(const QString& cb)
{
    inp_string = cb + "\n";
    QFile file(m_inp_file);
    if (file.open(QIODevice::WriteOnly | QIODevice::Text))
    {
        QTextStream stream(&file);
        stream.setCodec("UTF-8");
        stream.setAutoDetectUnicode(true);
        stream << inp_string;
        file.close();
        process();
    }
    else
        QMessageBox::warning(c2bMain, tr("Warning - cb2Bib"),
                             tr("Unable to open the file %1 for writing.\nError: '%2'.").arg(m_inp_file).arg(file.errorString()),
                             QMessageBox::Ok);
}

void c2bBibPreparser::process()
{
    // External Preprocessing
    QStringList arguments;
    arguments.append(m_inp_file);
    arguments.append(m_out_file);
    preparser = new QProcess(this);
    preparser->start(settings->fileName("cb2Bib/PreparserBin"), arguments);
    if (!preparser->waitForFinished())
    {
        preparser->kill();
        QFile ifile(m_inp_file);
        ifile.remove();
        QFile ofile(m_out_file);
        ofile.remove();
        c2b::showMessage(tr("Failed to call %1.").arg(settings->fileName("cb2Bib/PreparserBin")));
        emit preparserDataAvailable("");
        return;
    }
    conversionEnded();
    delete preparser;
}

void c2bBibPreparser::conversionEnded()
{
    bool showLog = settings->value("cb2Bib/PreparserShowLog").toBool();
    if (showLog)
        viewLog->readLog(preparser);
    QFile ifile(m_inp_file);
    ifile.remove();
    out_string = c2bUtils::fileToString(m_out_file, true);
    if (out_string.isEmpty())
    {
        c2b::showMessage(tr("External Parsing ended. Input string remains unchanged."));
        emit preparserDataAvailable(inp_string);
    }
    else
    {
        c2b::showMessage(tr("External Parsing ended."));
        emit preparserDataAvailable(out_string);
    }
    if (showLog)
    {
        viewLog->append(tr("Input[\n%1]\n").arg(inp_string));
        viewLog->append(tr("Output[\n%1]\n").arg(out_string));
        viewLog->show();   // Don't use exec(), it could be a recursive call if clipboard changed
    }
}
