/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BBIBPREPARSER_H
#define C2BBIBPREPARSER_H

#include <QObject>


class QProcess;
class c2bBibPreparserLog;
class c2bSettings;


/**
    This class handles external processing of Bibliographic items. It's
    formally an extension of the c2bBibParser, the glue class between GUI staff
    and the cb2Bib's bibParser functionality.
*/
class c2bBibPreparser : public QObject
{

    Q_OBJECT

public:
    c2bBibPreparser(QObject* parent = 0);
    ~c2bBibPreparser();

    void preparse(const QString& cb);


signals:
    void preparserDataAvailable(const QString& ppItem);


protected slots:
    void conversionEnded();


private:
    QProcess* preparser;
    QString inp_string;
    QString m_inp_file;
    QString m_out_file;
    QString out_string;
    QWidget* c2bMain;
    c2bBibPreparserLog* viewLog;
    c2bSettings* settings;
    void process();

};

#endif
