/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#include "c2bBibPreparserLog.h"
#include "c2b.h"
#include "c2bSettings.h"

#include <QCheckBox>
#include <QCloseEvent>
#include <QProcess>
#include <QPushButton>


c2bBibPreparserLog::c2bBibPreparserLog(QWidget* parent) : QDialog(parent)
{
    ui.setupUi(this);
    setWindowTitle(tr("Clipboard Preparsing Log - cb2Bib"));
    PreparserShowLog = new QCheckBox();
    PreparserShowLog->setObjectName(QString::fromUtf8("PreparserShowLog"));
    PreparserShowLog->setLayoutDirection(Qt::RightToLeft);
    PreparserShowLog->setText(QApplication::translate("c2bBibPreparserLog", "Do not show log", 0, QApplication::UnicodeUTF8));
    ui.buttonBox->addButton(PreparserShowLog, QDialogButtonBox::ActionRole);
    connect(ui.buttonBox, SIGNAL(helpRequested()), this, SLOT(help()));
    connect(this, SIGNAL(finished(int)), this, SLOT(close()));
}

c2bBibPreparserLog::~c2bBibPreparserLog()
{}


void c2bBibPreparserLog::append(const QString& ms)
{
    ui.Log->append(ms);
}

void c2bBibPreparserLog::show()
{
    resize(c2bSettingsP->value("c2bLogWidget/size", size()).toSize());
    QDialog::show();
}

void c2bBibPreparserLog::closeEvent(QCloseEvent* ce)
{
    ui.Log->clear();
    if (PreparserShowLog->isChecked())
        c2bSettingsP->setValue("cb2Bib/PreparserShowLog", false);
    PreparserShowLog->setChecked(false);
    c2bSettingsP->setValue("c2bLogWidget/size", size());
    ce->accept();
}

void c2bBibPreparserLog::readLog(QProcess *ep)
{
    ui.Log->clear();
    ui.Log->append(QString::fromUtf8(ep->readAllStandardOutput()));
    ui.Log->append(QString::fromUtf8(ep->readAllStandardError()));
    ui.buttonBox->button(QDialogButtonBox::Close)->setFocus();
}

void c2bBibPreparserLog::help()
{
    c2b::displayHelp("http://www.molspaces.com/d_cb2bib-overview.php#keyboard");
}
