/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BBIBSEARCHERCACHE_H
#define C2BBIBSEARCHERCACHE_H

#include <QHash>
#include <QObject>

class c2bSettings;


class c2bBibSearcherCache : public QObject
{

    Q_OBJECT

public:
    c2bBibSearcherCache(QObject* parent = 0);
    ~c2bBibSearcherCache();

    const QString pdfToText(const QString& filename, int* pdfCounter, QString* logString, int* errorCounter);
    void load(const QString& filename, bool simplify_source);


private:
    bool p_simplify_source;
    c2bSettings *settings;
    int cache_size;
    QHash<QString, QByteArray> fileContents;
    QString cache_filename;
    QString load_filename;
    QString p_cache_dir;
    QString p_pdf2txt_arg;
    QString p_pdf2txt_bin;
    QString p_text_file;
    void save();

};

#endif
