/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#include "c2bCiteIDLineEdit.h"

#include "c2bUtils.h"
#include "cb2Bib_par.h"

#include <QAction>
#include <QContextMenuEvent>
#include <QMenu>


c2bCiteIDLineEdit::c2bCiteIDLineEdit(QWidget* parent) : c2bLineEdit(parent)
{
    a_author_all_initials = new QAction(this);
    a_author_first = new QAction(this);
    a_journal_initials = new QAction(this);
    a_pages_first = new QAction(this);
    a_reset = new QAction(this);
    a_volume = new QAction(this);
    a_year_abbreviated = new QAction(this);
    a_year_full = new QAction(this);

    c2bUtils::addSeparator(this);
    addAction(a_author_all_initials);
    addAction(a_author_first);
    addAction(a_journal_initials);
    addAction(a_pages_first);
    addAction(a_volume);
    addAction(a_year_abbreviated);
    addAction(a_year_full);
    c2bUtils::addSeparator(this);
    addAction(a_reset);

    a_author_all_initials->setText(tr("Insert <<author_all_initials>>"));
    a_author_first->setText(tr("Insert <<author_first>>"));
    a_author_first->setText(tr("Insert <<author_first>>"));
    a_journal_initials->setText(tr("Insert <<journal_initials>>"));
    a_pages_first->setText(tr("Insert <<pages_first>>"));
    a_reset->setText(tr("Reset CiteID Pattern"));
    a_volume->setText(tr("Insert <<volume>>"));
    a_year_abbreviated->setText(tr("Insert <<year_abbreviated>>"));
    a_year_full->setText(tr("Insert <<year_full>>"));

    connect(a_author_all_initials, SIGNAL(triggered()), this, SLOT(author_all_initials()));
    connect(a_author_first, SIGNAL(triggered()), this, SLOT(author_first()));
    connect(a_journal_initials, SIGNAL(triggered()), this, SLOT(journal_initials()));
    connect(a_pages_first, SIGNAL(triggered()), this, SLOT(pages_first()));
    connect(a_reset, SIGNAL(triggered()), this, SLOT(reset()));
    connect(a_volume, SIGNAL(triggered()), this, SLOT(volume()));
    connect(a_year_abbreviated, SIGNAL(triggered()), this, SLOT(year_abbreviated()));
    connect(a_year_full, SIGNAL(triggered()), this, SLOT(year_full()));
}

c2bCiteIDLineEdit::~c2bCiteIDLineEdit()
{}


void c2bCiteIDLineEdit::author_all_initials()
{
    insert("<<author_all_initials>>");
}

void c2bCiteIDLineEdit::author_first()
{
    insert("<<author_first>>");
}

void c2bCiteIDLineEdit::journal_initials()
{
    insert("<<journal_initials>>");
}

void c2bCiteIDLineEdit::pages_first()
{
    insert("<<pages_first>>");
}

void c2bCiteIDLineEdit::volume()
{
    insert("<<volume>>");
}

void c2bCiteIDLineEdit::year_abbreviated()
{
    insert("<<year_abbreviated>>");
}

void c2bCiteIDLineEdit::year_full()
{
    insert("<<year_full>>");
}

void c2bCiteIDLineEdit::reset()
{
    setText(C2B_CITE_ID_PATTERN);
}
