/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BCITEIDMAKER_H
#define C2BCITEIDMAKER_H

#include "c2bLineEdit.h"

#include <QObject>
#include <QHash>


/**
    @author Pere Constans
*/
class c2bCiteIDMaker : public QObject
{

    Q_OBJECT

public:
    c2bCiteIDMaker(QHash<QString, c2bLineEdit*>& fields, QObject* parent = 0);
    ~c2bCiteIDMaker();

    void makeCiteID();


private:
    QString m_author;
    QString m_citeidpattern;
    QString m_journal;
    QString m_pages;
    QString m_volume;
    QString m_year;
    QWidget* c2bMain;
    const QHash<QString, c2bLineEdit*>& bibFields;
    void setPatternConnections();


private slots:
    void loadSettings();
    void makeCiteID_author_all_initials();
    void makeCiteID_author_first();
    void makeCiteID_journal_initials();
    void makeCiteID_pages_first();
    void makeCiteID_volume();
    void makeCiteID_year_abbreviated();
    void makeCiteID_year_full();

};

#endif
