/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#include "c2bClipEdit.h"

#include "c2b.h"
#include "c2bHighlighter.h"

#include <QAction>
#include <QContextMenuEvent>
#include <QMenu>
#include <QTextCursor>


c2bClipEdit::c2bClipEdit(QWidget* parent) : QTextEdit(parent)
{
    setFrameShape(QTextEdit::StyledPanel);
    setFrameShadow(QTextEdit::Raised);
    new c2bHighlighter(this);
    setAcceptRichText(false);
    taggedViewMode = false;
    text = "";
    taggedText = "";
}

c2bClipEdit::~c2bClipEdit()
{}


void c2bClipEdit::setText(const QString& newText, const QString& newTaggedText)
{
    text = newText;
    if (newTaggedText.isEmpty())
        taggedText = newText;
    else
        taggedText = newTaggedText;
    if (taggedViewMode)
        setPlainText(taggedText);
    else
        setPlainText(text);
}

void c2bClipEdit::insertTag(const QString& tag)
{
    if (taggedViewMode)
        insertPlainText(tag);
    else
        insertPlainText("[[" + textCursor().selectedText() + "]]");
}

void c2bClipEdit::setTaggedViewMode(bool taggedView)
{
    taggedViewMode = taggedView;
    if (taggedViewMode)
    {
        text = toPlainText();
        setPlainText(taggedText);
    }
    else
    {
        taggedText = toPlainText();
        setPlainText(text);
    }
}

void c2bClipEdit::mouseReleaseEvent(QMouseEvent* event)
{
    QTextEdit::mouseReleaseEvent(event);
    if (event->button() == Qt::LeftButton)
        if (textCursor().hasSelection())
            emit userEndedSelection();
}

void c2bClipEdit::contextMenuEvent(QContextMenuEvent* event)
{
    QMenu *edit_menu = createStandardContextMenu();
    edit_menu->setTitle(tr("Edit..."));
    QList<QAction*> acts = edit_menu->actions();
    QAction* act;
    act = new QAction(tr("Clear"), edit_menu);
    act->setEnabled(acts.last()->isEnabled());  // As is Select All
    connect(act, SIGNAL(triggered()), this, SLOT(clear()));
    edit_menu->insertAction(acts.at(7), act);
    QMenu *menu = new QMenu(this);
    menu->addMenu(edit_menu);
    menu->addSeparator();
    acts = c2b::netqinf()->bookmarkActions(textCursor().selectedText());
    for (int i = 0; i < acts.count(); ++i)
        menu->addAction(acts.at(i));
    acts = actions();
    for (int i = 0; i < acts.count(); ++i)
        menu->addAction(acts.at(i));
    menu->exec(event->globalPos());
    delete edit_menu;
    delete menu;
}
