/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BCLIPEDIT_H
#define C2BCLIPEDIT_H

#include <QTextEdit>


/**
    @author Pere Constans
*/
class c2bClipEdit : public QTextEdit
{
    Q_OBJECT

public:
    c2bClipEdit(QWidget* parent = 0);
    ~c2bClipEdit();

    void setText(const QString& newText, const QString& newTaggedText = QString());
    void setTaggedViewMode(bool taggedView);
    void insertTag(const QString& field);


signals:
    void userEndedSelection();


protected:
    virtual void contextMenuEvent(QContextMenuEvent* event);
    virtual void mouseReleaseEvent(QMouseEvent* event);


private:
    QString taggedText;
    QString text;
    bool taggedViewMode;

};

#endif
