/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BCONFIGURE_H
#define C2BCONFIGURE_H

#include "c2bColors.h"
#include "ui_c2bConfigure.h"

#include <QDialog>
#include <QFontDatabase>


class c2bSettings;

class c2bConfigure : public QDialog
{

    Q_OBJECT

public:
    c2bConfigure(QWidget* parent = 0);
    ~c2bConfigure();


protected slots:
    void FindReplaceDialog_Delete();
    void FindReplaceDialog_Edit();
    void FindReplaceDialog_New();
    void accept();
    void apply();
    void changeContextColor(QTreeWidgetItem* item);
    void changePage(QListWidgetItem* current, QListWidgetItem* previous);
    void comboFamilyChanged(const QString& family);
    void comboSizeChanged(const QString& pt);
    void fontSelection();
    void getBibSearcherPdf2TextDir();
    void getBrowserCssFile();
    void getCacheDirectory();
    void getExifToolDir();
    void getFmClientCopyBin();
    void getFmClientMoveBin();
    void getFmClientOpenBin();
    void getJournalFile();
    void getNetworkFile();
    void getPdfDirectory();
    void getPdfImportPdf2TextDir();
    void getPostprocessBibTeXDir();
    void getPreparserDir();
    void getRegularExpressionFile();
    void help();
    void updateFindReplaceInputButtons();


private:
    QFont font;
    Ui::c2bConfigure ui;
    bool event(QEvent* event);
    c2bColors colors;
    c2bSettings* settings;

};

#endif
