/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BEDITOR_H
#define C2BEDITOR_H

#include "ui_c2bEditor.h"

#include "c2bBibSearcher.h"

#include <QMainWindow>
#include <QPointer>


class QDockWidget;
class QLabel;
class QStackedWidget;
class QSyntaxHighlighter;
class c2bBibParser;
class c2bReferenceList;
class c2bSettings;
class c2bTextBrowser;
class c2bTextEdit;
class findDialog;


class c2bEditor : public QMainWindow
{

    Q_OBJECT

public:
    c2bEditor(const QString& file, const QString& mode, QWidget* main, QWidget* parent = 0);
    c2bEditor(const QString& file, c2bBibSearcher* searcher, QWidget* main, QWidget* parent = 0);

    ~c2bEditor();

    QString editFileName() const;
    bool closeEditor();


signals:
    void editFileRenamed(const QString& old_name, const QString& new_name);
    void execute();
    void openBookmarks();
    void openFile(const QString& fn);
    void restartEngine();
    void restartQuery();


protected:
    virtual void closeEvent(QCloseEvent *ce);


protected slots:
    bool fileSave();
    bool fileSaveAs();
    void cursorPositionChanged();
    void exportEntries();
    void fileOpen();
    void helpCb2Bib();
    void helpEditor();
    void isModified(int position, int charsRemoved, int charsAdded);
    void journalsToAbbreviated();
    void journalsToFull();
    void load();
    void loadSettings();
    void overwriteModeChanged();
    void pasteCurrentBibTeX();
    void postProcess();
    void reload(const QString& f);
    void saveAndExecute();
    void setViewMode(bool edit_mode);
    void showMessage(const QString& ms);
    void updateMetadata();
    void viewCb2Bib();


private:
    QDockWidget* dwRList;
    QLabel* lineLabel;
    QLabel* overwriteLabel;
    QPointer<c2bBibSearcher> bibSearcher;
    QStackedWidget* stackedWidget;
    QString EFile;
    QString EditorMode;
    QString edit_reference_at_position;
    QSyntaxHighlighter* sH;
    QWidget* c2bMain;
    Ui::c2bEditor ui;
    c2bBibParser* bp;
    c2bReferenceList* RList;
    c2bSettings* settings;
    c2bTextBrowser* Browser;
    c2bTextEdit* Editor;
    findDialog* textFinder;
    void createReferenceList();
    void importActions();
    void initEditor();
    void setEditorMode();

    QMenu* createPopupMenu()  // to avoid default context menu
    {
        return 0;
    }

};

#endif
