/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#include "c2bExport.h"

#include "c2b.h"
#include "cb2Bib_par.h"


c2bExport::c2bExport(QObject* parent) : QObject(parent)
{}

c2bExport::~c2bExport()
{}


void c2bExport::exportEntries(const export_data& ed)
{
    // Note. Assume caller performs export_data validity check for files and directories.
    bibParser* bp = c2b::bibParser();
    // Prefer replacing filenames to a full BibTeX parsing: This will preserve the
    // original entry and possibly available non cb2Bib tags.
    QStringList fields;
    if (ed.copy_documents)
        fields.append("file");
    QRegExp filere("\\bfile\\s*=\\s*[\\{\"](.*)[\\}\"]", Qt::CaseInsensitive);
    filere.setMinimal(true);
    const QString bibtex_contents = c2bUtils::fileToString(ed.bibtex_fn);
    QString export_contents = "\n\n";
    QString export_log;
    bibReference ref;
    bp->initReferenceParsing(ed.bibtex_fn, fields, &ref);
    while (bp->referencesIn(bibtex_contents, &ref))
    {
        if (!ed.bibtex_keys.contains(ref.keyName, Qt::CaseSensitive))
            continue;
        if (ed.copy_documents)
        {
            QString ofn = ref.value("file");
            if (!ofn.isEmpty())
            {
                QString dfn = c2bUtils::documentAbsoluteName(ed.relative_dir, ed.export_fn, ed.documents_dir, ofn);
                QFile orig(ofn);
                if (!orig.copy(dfn))
                    export_log += tr("% Unable to copy file %1 to %2. %3.\n").arg(ofn).arg(dfn).arg(orig.errorString());
                if (QFileInfo(dfn).exists())
                {
                    int pos = filere.indexIn(ref.rawReference, 0);
                    if (pos > -1)
                    {
                        QString line = filere.cap(0);
                        QString file = filere.cap(1);
                        line.replace(file, c2bUtils::documentFileName(ed.relative_dir, ed.export_fn, ed.documents_dir, ofn));
                        ref.rawReference.replace(pos, filere.matchedLength(), line);
                    }
                }
            }
        }
        export_contents += ref.rawReference + "\n\n";
    }
    if (!export_log.isEmpty())
        export_contents = "% cb2Bib " + C2B_VERSION + " / Export Error Log\n" + export_log + export_contents;
    if (!c2bUtils::stringToFile(export_contents, ed.export_fn))
        qDebug(tr("[cb2Bib] Unable to write file %1.").arg(ed.export_fn).toLatin1());
}
