/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BEXPORTDIALOG_H
#define C2BEXPORTDIALOG_H

#include "ui_c2bExportDialog.h"

#include <QDialog>


class c2bSettings;

class c2bExportDialog : public QDialog
{

    Q_OBJECT

public:
    c2bExportDialog(const QString& fn, const QStringList& keys, QWidget* parent = 0);
    ~c2bExportDialog();

    inline const QString exportFilename() const
    {
        return ui.ExportFile->text();
    }


private:
    Ui::c2bExportDialog ui;
    c2bSettings* settings;
    const QString& _bibtex_fn;
    const QStringList& _bibtex_keys;


private slots:
    void _export();
    void getDocumentsDirectory();
    void getExportFile();
    void help();

};

#endif
