/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BFILEDIALOG_H
#define C2BFILEDIALOG_H

#include <QFileDialog>
#include <QFileIconProvider>


class c2bSettings;
class fileIconProvider;

class c2bFileDialog : public QFileDialog
{

    Q_OBJECT

public:
    static QString getFileName(QWidget* parent = 0, const QString& caption = QString(), const QString& path = QString(),
                               const QString& filter = QString(), QString* selectedFilter = 0);
    static QString getOpenFileName(QWidget* parent = 0, const QString& caption = QString(), const QString& path = QString(),
                                   const QString& filter = QString(), QString* selectedFilter = 0);
    static QStringList getOpenFileNames(QWidget* parent = 0, const QString& caption = QString(), const QString& path = QString(),
                                        const QString& filter = QString(), QString* selectedFilter = 0);
    static QString getSaveFileName(QWidget* parent = 0, const QString& caption = QString(), const QString& path = QString(),
                                   const QString& filter = QString(), QString* selectedFilter = 0);
    static QString getExistingDirectory(QWidget* parent = 0, const QString& caption = QString(), const QString& path = QString());
    static QString getSystemFileName(QWidget* parent = 0, const QString& caption = QString(), const QString& path = QString(),
                                     const QString& filter = QString(), QString* selectedFilter = 0);


private:
    c2bFileDialog(QWidget* parent, const QString& caption, const QString& path, const QString& fn);
    ~c2bFileDialog();

    c2bSettings* settings;
    const QString exec(const QString& _filter = QString(), QString* _selectedFilter = 0);
    fileIconProvider* fip;
    int _qt_version;
    static QString _filename(const QString& path);
    static QString _path(const QString& path);
    void enableSelectButton();
    void readSettings();
    void writeSettings();


private slots:
    void accept();

};


/***************************************************************************
 Class fileIconProvider
 ***************************************************************************/

class fileIconProvider : public QFileIconProvider
{

public:
    fileIconProvider();
    ~fileIconProvider();

    QIcon icon(const QFileInfo& info) const;


private:
    QIcon _exec_icon;

};

#endif
