/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BHEURISTICBIBPARSER_H
#define C2BHEURISTICBIBPARSER_H

#include "c2bLineEdit.h"

#include <QtCore>


class c2bBibParser;
class journalDB;

/**
    c2bBibParser helper class for heuristic recognition

    @author Pere Constans
*/
class c2bHeuristicBibParser
{

public:
    c2bHeuristicBibParser(c2bBibParser* parser);
    ~c2bHeuristicBibParser();

    void guessFields(const QString& clean_text, const QString& tagged_text);


private:
    QRegExp _hyphens;
    QString _hyphen_nums;
    bool _reliable_number;
    bool _reliable_pages;
    bool _reliable_volume;
    c2bBibParser* bp;
    const QHash<QString, c2bLineEdit*>& bibFields;
    const QStringList& bibFieldList;
    const journalDB& jDB;
    void guessAbstract(const QString& text);
    void guessFromMetadata(const QString& text);
    void guessISBN(const QString& text);
    void guessJournal(const QString& text);
    void guessKeywords(const QString& text);
    void guessNumber(const QString& text);
    void guessPages(const QString& text);
    void guessTitle(const QString& text);
    void guessVolume(const QString& text);
    void guessVolumePagesYear(const QString& text);
    void guessVolumeYearPages(const QString& text);
    void guessYear(const QString& text);
    void guessYearVolumePages(const QString& text);

    inline void _debug_guess(const QString&
#ifdef CB2BIB_DEBUG_HEURISTICBIBPARSER
                             procedure
#endif
                            ) const
    {
#ifdef CB2BIB_DEBUG_HEURISTICBIBPARSER
        qDebug() << "[cb2bib] " << procedure;
        for (int i = 0; i < bibFieldList.count(); ++i)
        {
            if (!bibFields[bibFieldList.at(i)]->text().isEmpty())
                qDebug() << QString("    %1:  '%2'").arg(bibFieldList.at(i)).arg(bibFields[bibFieldList.at(i)]->text());
        }
#endif
    }

};

#endif
