/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BMETAPREPARSER_H
#define C2BMETAPREPARSER_H

#include "bibParser.h"

#include <QObject>


class c2bMetaPreparser : public QObject
{

    Q_OBJECT

public:
    c2bMetaPreparser(QObject* parent = 0);
    ~c2bMetaPreparser();

    bool insertMetadata(const bibReference& ref, const QString& fn, QString* error = 0) const;
    bool metadata(const QString& fn, bibReference* ref);
    const QString metadata(const QString& fn);


private:
    QRegExp _bibtex_fields;
    QRegExp _fields;
    bibReference _ref;
    bool _has_bibtex;
    bool _has_cb2bib;
    bool _metadata(const QString& fn);
    const QString _pdfDictionary(const QByteArray& rawpdf);
    void _fuzzyParser(const QString& data);
    void _metadataXmp(const QString& fn, const QByteArray& raw_contents, QStringList* xmls);
    void _metadataXmpExifTool(const QString& fn, QStringList* xmls);
    void _miscellaneousData(const QString& fn, const QByteArray& raw_contents);

    inline QString fromQtXmlString(QString str) const
    {
        // Workaround (It will be fixed in Qt 4.5)
        // Escape toXmlString already done by ExifTool
        str.replace("%%#39;", "'");
        str.replace("%%amp;", "&");
        str.replace("%%gt;", ">");
        str.replace("%%lt;", "<");
        str.replace("%%quot;", "\"");
        return (str);
    }

    inline QString toQtXmlString(QString str) const
    {
        // Workaround (It will be fixed in Qt 4.5)
        // Escape toXmlString already done by ExifTool
        str.replace("&#39;", "%%#39;");
        str.replace("&amp;", "%%amp;");
        str.replace("&gt;", "%%gt;");
        str.replace("&lt;", "%%lt;");
        str.replace("&quot;", "%%quot;");
        return (str);
    }

    inline QString formattedAuthor(const QString& author) const
    {
        QStringList alist = author.split(" and ", QString::SkipEmptyParts);
        int na = alist.count();
        if (na <= 2)
            return author;
        QString formatted = alist.first();
        for (int i = 1; i < na - 1; ++i)
            formatted += ", " + alist.at(i);
        formatted += ", and " + alist.last();
        return formatted;
    }

};

#endif
