/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BNETWORK_H
#define C2BNETWORK_H

#include <QFile>
#include <QHttp>
#include <QObject>
#include <QProcess>


class QProgressDialog;


/**
    cb2Bib Network file copy/move

    @author Pere Constans
*/
class c2bNetwork : public QObject
{

    Q_OBJECT

public:
    c2bNetwork(QWidget* main, QObject* parent = 0);
    ~c2bNetwork();

    bool openFile(const QString& fn);
    const QString encodeUrl(const QString& url);
    void getFile(const QString& orig, const QString& dest, const QString& action = "copy", QObject* receiver = 0,
                 const char* callback = 0, const bool overwrite = false);

    inline const QString destinationFilename() const
    {
        return destFile;
    }

    inline const QString getfileErrorString() const
    {
        return c2bnetwork_getfile_error;
    }

    inline const QString openfileErrorString() const
    {
        return c2bnetwork_openfile_error;
    }

    inline const QString originalFilename() const
    {
        return origFile;
    }


signals:
    void getFileDone(bool status, const QString& error);


public slots:
    void loadSettings();


private:
    QFile* fDestFile;
    QHttp* fetcher;
    QProcess* clientP;
    QProgressDialog *progressDialog;
    QString FmClientCopyArg;
    QString FmClientCopyBin;
    QString FmClientMoveArg;
    QString FmClientMoveBin;
    QString FmClientOpenArg;
    QString FmClientOpenBin;
    QString c2bnetwork_getfile_error;
    QString c2bnetwork_openfile_error;
    QString destFile;
    QString origFile;
    bool FmClient;
    bool c2bnetwork_fetching;
    bool c2bnetwork_getfile_status;
    bool checkDest();
    bool fetcherRequestAborted;
    bool getFilePrivate(const QString& orig, const QString& dest, const QString& action);
    bool getFile_c2b(const QString& action);
    bool getFile_client(const QString& action);
    int fetcherGetId;


private slots:
    void cancelFetcher();
    void clientEnded(int exitCode, QProcess::ExitStatus exitStatus);
    void emit_getFileDone();
    void emit_getFileDone(bool status, const QString& error);
    void fetcherCleanUp();
    void fetcherEnded(int requestId, bool error);
    void updateDataReadProgress(int readBytes, int totalBytes);

};

#endif
