/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BNETWORKQUERY_H
#define C2BNETWORKQUERY_H

#include <QObject>


class c2bNetwork;
class c2bSettings;


/**
    cb2Bib Network Queries

    @author Pere Constans
*/

class c2bNetworkQuery : public QObject
{

    Q_OBJECT

public:
    c2bNetworkQuery(QObject* parent = 0);
    ~c2bNetworkQuery();

    const QString errorString();
    void submitQuery(const QString& title, const QString& jn, const QString& vol, const QString& fp, const QString& doi,
                     const QString& excerpt);


signals:
    void queryEnded(bool stat, const QString& targetPDF, const QString& targetBib);


private:
    QList<uint> m_q_numbers;
    QString DOI;
    QString Excerpt;
    QString FirstPage;
    QString JournalCode;
    QString JournalName;
    QString NetworkFile;
    QString Queryfile1;
    QString Queryfile2;
    QString Title;
    QString Volume;
    QString action;
    QString captionQ;
    QString error;
    QString pdfurl_prefix;
    QString pdfurl_sufix;
    QString referenceurl_prefix;
    QString referenceurl_sufix;
    QString targetBib;
    QString targetPDF;
    QString targetQ;
    QWidget* pWidget;
    bool AutomaticPdfDownload;
    bool KeepTmpNQFiles;
    bool m_endoffile;
    c2bNetwork* network;
    c2bSettings* settings;


private slots:
    bool areQueryParametersValid();
    bool setQueryParameters();
    void loadSettings();
    void queryDone(bool stat);
    void submitQuery1();
    void submitQuery2(bool stat);
    void updateQueryPlaceholders();

};

#endif
