/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BPDFIMPORT_H
#define C2BPDFIMPORT_H

#include "ui_c2bPdfImport.h"
#include <QDialog>


class c2bSettings;
class QProcess;

class c2bPdfImport : public QDialog
{

    Q_OBJECT

public:
    c2bPdfImport(QWidget* parent = 0);
    ~c2bPdfImport();

    QString processedFile;


public slots:
    void processNext();
    void referenceExtacted(bool status);
    void show();
    void showMessage(const QString& ms);


signals:
    void fileProcessed(const QString& fileName);
    void saveReferenceRequest();
    void setClipboardDisabled(bool disable);
    void textProcessed(const QString& text);


protected:
    bool event(QEvent* event);
    void dragEnterEvent(QDragEnterEvent* event);
    void dropEvent(QDropEvent* event);


private slots:
    void abort();
    void help();
    void loadSettings();
    void processOneFile();
    void saveSettings();
    void selectFiles();


private:
    bool c2bAutomaticQuery;
    bool m_aborted;
    c2bSettings* settings;
    QProcess *pdf2txt;
    QPushButton* buttonProcess;
    QPushButton* buttonSelectFiles;
    QString m_text_file;
    Ui::c2bPdfImport ui;
    void addToLog();
    void processEnded();

};

#endif
