/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#include "c2bPreprocess.h"
#include "c2bSettings.h"


c2bPreprocess::c2bPreprocess(QObject* parent) : QObject(parent)
{
    pObject = parent;
    loadSettings();
    connect(c2bSettingsP, SIGNAL(newSettings()), this, SLOT(loadSettings()));
}

c2bPreprocess::~c2bPreprocess()
{}


void c2bPreprocess::loadSettings()
{
    c2bSettings* settings = c2bSettingsP;
    FindReplaceInput = settings->value("cb2Bib/FindReplaceInput").toBool();
    FindReplaceInputList = settings->value("cb2Bib/FindReplaceInputList").toStringList();
}

QString& c2bPreprocess::preprocessText(QString& text)
{
    if (!FindReplaceInput)
        return text;
    QStringList::Iterator i = FindReplaceInputList.begin();
    while (i != FindReplaceInputList.end())
    {
        QStringList spLine = (*i).split("|");
        text.replace(spLine.at(0), spLine.at(1));
        ++i;
    }
    return text;
}
