/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BREFERENCELIST_H
#define C2BREFERENCELIST_H

#include "ui_c2bReferenceList.h"

#include <QWidget>

class c2bBibSearcher;
class c2bRLWebSearchSettings;
class c2bSettings;
class c2bTextBrowser;
class c2bTextEdit;


class c2bReferenceList : public QWidget
{
    Q_OBJECT

public:
    c2bReferenceList(c2bTextEdit* ed, c2bTextBrowser* br, QWidget* parent = 0);
    ~c2bReferenceList();

    QAction* citeEntry2CbAction;
    QAction* citeEntryAction;
    QAction* clearSelectionsAction;
    QAction* openAuthorsWebSearchAction;
    QAction* openDOIAction;
    QAction* openFileAction;
    QAction* openTextLocalSearchAction;
    QAction* openTextWebSearchAction;
    QAction* openTitleWebSearchAction;
    QAction* openUrlAction;
    QAction* refreshListAction;
    QAction* webSearchSettingsAction;
    QStringList selectedKeys() const;
    void goToReference(const QString& id);
    void goToReference(const int position);


public slots:
    void loadList(const QString& txt, c2bBibSearcher* bibSearcher = 0);
    void refreshList();
    void setLyxPipe();


signals:
    void hasSelectedItems(bool);
    void openFile(const QString& fn);


protected slots:
    void citeEntry();
    void citeEntry2Cb();
    void clearSelections();
    void goToReference(QTreeWidgetItem* ref);
    void itemSelectionChanged();
    void openAuthorWebSearch();
    void openDOI();
    void openFile();
    void openLink(const QUrl& ln);
    void openTextLocalSearch();
    void openTextWebSearch();
    void openTitleWebSearch();
    void openUrl();
    void scrollToReference(const QString& id);
    void webSearchSettings();


private:
    QList<int> positionList;
    QString lyxpipe;
    QString m_bib_item_html;
    QString m_filter_mode;
    QString m_references_html;
    QStringList doiList;
    QStringList fileList;
    QStringList urlList;
    Ui::c2bReferenceList ui;
    c2bSettings* settings;
    c2bTextBrowser* browserPtr;
    c2bTextEdit* editorPtr;
    int m_author_index;
    int m_id_index;
    int m_journal_index;
    int m_key_index;
    int m_title_index;
    int m_year_index;
    void setupFilterBar();


private slots:
    void blockFilterSignals();
    void filterList();
    void keepFilterPattern();
    void setFilterMode(QAction* mode);

};

#endif
