/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BSEARCHINFILES_H
#define C2BSEARCHINFILES_H

#include "ui_c2bSearchInFiles.h"
#include "ui_c2bSearchInFilesPatternEdit.h"

#include <QDialog>


class c2bBibSearcher;

class c2bSearchInFiles : public QDialog
{

    Q_OBJECT

public:
    c2bSearchInFiles(const QString& file, QWidget* parent = 0);
    ~c2bSearchInFiles();

    void setCurrentText(const QString& text);


public slots:
    void setBibTeXFile(const QString& file = QString());
    void show();


signals:
    void searchDone(const QString& filename, c2bBibSearcher* searcher);


private slots:
    void help();
    void on_addPatternB_clicked();
    void on_deletePatternB_clicked();
    void on_editPatternB_clicked();
    void searchB_clicked();
    void updateForm();


private:
    QPushButton* searchB;
    QString m_bibtex_dir;
    QString m_bibtex_file;
    QString searchLogText;
    Ui::c2bSearchInFilesPatternEdit ui_editor;
    Ui::c2bSearchInFiles ui;

};

#endif
